/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.atom.sku.impl;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.ohaotian.commodity.atom.spec.InitSkuSpecAtomService;
import com.ohaotian.commodity.dao.SkuSpecMapper;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.xls.commodity.atom.sku.XlsSkuManageService;
import com.xls.commodity.dao.XlsSkuMapper;
import com.xls.commodity.dao.po.Sku;
import com.xls.commodity.intfce.sku.bo.BaseRspBO;
import com.xls.commodity.intfce.sku.bo.SkuBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class XlsSkuManageServiceImpl
implements XlsSkuManageService {
    private static final Logger logger = LoggerFactory.getLogger(XlsSkuManageServiceImpl.class);
    @Autowired
    private XlsSkuMapper xlsSkuMapper;
    @Autowired
    private InitSkuSpecAtomService initSkuSpecAtomService;
    @Autowired
    private SkuSpecMapper skuSpecMapper;

    public BaseRspBO batchUpdate(List<SkuBO> skuBOS) {
        BaseRspBO baseRspBO = new BaseRspBO();
        ArrayList<Sku> skus = new ArrayList<Sku>();
        if (CollectionUtils.isNotEmpty(skuBOS)) {
            for (SkuBO skuBO : skuBOS) {
                Sku sku = new Sku();
                BeanUtils.copyProperties((Object)skuBO, (Object)sku);
                sku.setCountyCode(skuBO.getCountyCode());
                sku.setUpdateTime(new Date());
                skus.add(sku);
            }
        }
        if (CollectionUtils.isNotEmpty(skus)) {
            try {
                this.xlsSkuMapper.batchUpdateBySkuId(skus);
            }
            catch (Exception e) {
                throw new BusinessException("RSP_CODE_DAO_ERROR", "\u6279\u91cf\u4fee\u6539\u5546\u54c1\u5f02\u5e38", (Throwable)e);
            }
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        return baseRspBO;
    }

    public BaseRspBO batchUpdateSku(SkuBO skuBO) {
        BaseRspBO baseRspBO = new BaseRspBO();
        if (StringUtils.isNotEmpty((String)skuBO.getProvinceCode()) && StringUtils.isNotEmpty((String)skuBO.getMaterialId())) {
            try {
                logger.debug("\u66f4\u65b0\u5546\u54c1\u4fe1\u606f\u5165\u53c2" + skuBO);
                Sku sku = new Sku();
                BeanUtils.copyProperties((Object)skuBO, (Object)sku);
                this.xlsSkuMapper.batchUpdateByProvinceCodeMaterialId(sku);
            }
            catch (Exception e) {
                logger.error("\u539f\u5b50\u5c42\u66f4\u65b0sku\u4fe1\u606f\u5931\u8d25---\u5165\u53c2\u7701\u4efd\u7f16\u7801\u548c\u7269\u6599\u7f16\u7801\u4e0d\u4e3a\u7a7a");
                throw new BusinessException("RSP_CODE_DAO_ERROR", "\u6279\u91cf\u4fee\u6539\u5546\u54c1\u5f02\u5e38", (Throwable)e);
            }
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        return baseRspBO;
    }

    public void batchEnableShutdowmSkuUpdate(List<Long> provGoodsIds, Integer isDelete) {
        if (CollectionUtils.isEmpty(provGoodsIds) || 1 != isDelete && 0 != isDelete) {
            logger.error("\u66f4\u65b0\u7701\u4efd\u5546\u54c1\u72b6\u6001\u8f93\u5165\u7684\u53c2\u6570\u6709\u8bef");
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u66f4\u65b0\u7701\u4efd\u5546\u54c1\u72b6\u6001\u8f93\u5165\u7684\u53c2\u6570\u6709\u8bef");
        }
        try {
            this.xlsSkuMapper.updateSkuIsDeleteByProvGoodsID(provGoodsIds, isDelete);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u66f4\u65b0\u7701\u4efd\u5546\u54c1\u72b6\u6001\u5931\u8d25");
        }
    }
}

