/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.cgd.commodity.constant.Constant;
import com.ohaotian.commodity.dao.SkuPriceMapper;
import com.ohaotian.commodity.dao.po.SkuPrice;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.utils.RandomUtil;
import com.xls.commodity.busi.sku.BatchCreateSkuService;
import com.xls.commodity.busi.sku.bo.BatchCreateSkuReqBO;
import com.xls.commodity.busi.sku.bo.CreateSkuReqBO;
import com.xls.commodity.busi.sku.impl.SkuCreateByProvGoodsServiceImpl;
import com.xls.commodity.dao.XlsSkuMapper;
import com.xls.commodity.dao.po.Sku;
import com.xls.commodity.intfce.sku.bo.BaseRspBO;
import com.xls.commodity.util.SequenceUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BatchCreateSkuServiceImpl
implements BatchCreateSkuService {
    @Autowired
    private XlsSkuMapper xlsSkuMapper;
    @Autowired
    private SkuPriceMapper skuPriceMapper;
    private static final Logger logger = LoggerFactory.getLogger(SkuCreateByProvGoodsServiceImpl.class);

    public BaseRspBO batchCreateSku(BatchCreateSkuReqBO batchCreateSkuReqBO) {
        BaseRspBO baseRspBO = new BaseRspBO();
        List createSkuReqBOs = batchCreateSkuReqBO.getCreateSkuReqBOs();
        logger.debug("\u65b0\u589esku\u548cskuPrice\u4fe1\u606f\u5165\u53c2 createSkuReqBOs\u5927\u5c0f\u4e3a\uff1a" + batchCreateSkuReqBO.getCreateSkuReqBOs().size());
        ArrayList<SkuPrice> skuPrices = new ArrayList<SkuPrice>();
        ArrayList<Sku> skus = new ArrayList<Sku>();
        if (CollectionUtils.isNotEmpty((Collection)createSkuReqBOs)) {
            for (CreateSkuReqBO createSkuReqBO : createSkuReqBOs) {
                long skuId = createSkuReqBO.getSkuId() == null ? SequenceUtils.nextId() : createSkuReqBO.getSkuId();
                try {
                    Sku sku = new Sku();
                    BeanUtils.copyProperties((Object)createSkuReqBO, (Object)sku);
                    sku.setSkuId(skuId);
                    sku.setSkuName(createSkuReqBO.getFullName());
                    sku.setSkuLongName(createSkuReqBO.getFullName());
                    sku.setVendorId(createSkuReqBO.getVendorId());
                    sku.setVendorName(createSkuReqBO.getVendorName());
                    sku.setMfgSku(createSkuReqBO.getName());
                    sku.setCreateTime(new Date());
                    sku.setSkuCode(createSkuReqBO.getSkuCode());
                    sku.setUpdateTime(new Date());
                    sku.setCommodityTypeId(1L);
                    sku.setAttachFlag("0");
                    sku.setSkuStatus(createSkuReqBO.getSaleSrice() == null ? 4 : 1);
                    sku.setSkuLocation(0);
                    sku.setIsDelete(StringUtils.isEmpty((CharSequence)createSkuReqBO.getIsDelete()) ? Constant.IS_DELETE : Integer.valueOf(createSkuReqBO.getIsDelete()));
                    sku.setSkuPriceTagName(sku.getSkuName());
                    sku.setErpLongName(sku.getSkuLongName());
                    sku.setErpType(createSkuReqBO.getType());
                    sku.setSkuPrice(createSkuReqBO.getSaleSrice() == null ? MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal("99999")) : createSkuReqBO.getSaleSrice());
                    skus.add(sku);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                try {
                    SkuPrice skuPrice = new SkuPrice();
                    skuPrice.setSkuPriceId(Long.valueOf(skuId));
                    if (skuPrice.getCurrencyType() == null) {
                        skuPrice.setCurrencyType(Constant.CURRENCY_TYPE_RMB);
                    }
                    skuPrice.setCreateTime(new Date());
                    skuPrice.setAssessmentPrice(createSkuReqBO.getAssessmentPrice());
                    skuPrice.setAgreementPrice(createSkuReqBO.getAgreementPrice());
                    skuPrice.setPurchasePrice(createSkuReqBO.getPurchasePrice());
                    skuPrice.setSparePrice1(createSkuReqBO.getSparePrice1());
                    skuPrice.setSparePrice2(createSkuReqBO.getSparePrice2());
                    skuPrice.setMemberPrice(createSkuReqBO.getMemberPrice());
                    skuPrice.setIsDelete(Constant.IS_DELETE);
                    skuPrice.setSkuId(Long.valueOf(skuId));
                    skuPrice.setSheetId(createSkuReqBO.getSheetId());
                    skuPrice.setHasPriceSheet(createSkuReqBO.getSheetId() == null ? "0" : "1");
                    skuPrice.setSheetLevel(createSkuReqBO.getSheetLevel());
                    skuPrice.setSupplierId(createSkuReqBO.getSupplierId());
                    skuPrice.setSalePrice(createSkuReqBO.getSaleSrice() == null ? MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal("99999")) : createSkuReqBO.getSaleSrice());
                    skuPrice.setProvinceCode(createSkuReqBO.getProvinceCode());
                    skuPrices.add(skuPrice);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (CollectionUtils.isNotEmpty(skus)) {
            try {
                long startTime1 = System.currentTimeMillis();
                this.xlsSkuMapper.insertBtatch(skus);
                long a = System.currentTimeMillis();
                logger.debug(a - startTime1 + "xlsSkuMapper");
            }
            catch (Exception e) {
                throw new BusinessException("RSP_CODE_DAO_ERROR", "\u6279\u91cf\u521b\u5efa\u5546\u54c1\u5f02\u5e38", (Throwable)e);
            }
        }
        if (CollectionUtils.isNotEmpty(skuPrices)) {
            try {
                long startTime2 = System.currentTimeMillis();
                this.skuPriceMapper.insertSkuPriceBatch(skuPrices);
                long b = System.currentTimeMillis();
                logger.debug(b - startTime2 + "skuPriceMapper");
            }
            catch (Exception e) {
                throw new BusinessException("RSP_CODE_DAO_ERROR", "\u6279\u91cf\u521b\u5efa\u5355\u54c1\u4ef7\u683c\u5f02\u5e38", (Throwable)e);
            }
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        return baseRspBO;
    }

    public static void main(String[] args) {
        System.out.println(RandomUtil.randomMachineID());
    }
}

