/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.bo.RspInfoBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.toolkit.bo.InvokeInfo;
import com.tydic.newretail.toolkit.util.TKGenericServiceUtils;
import com.xls.commodity.atom.sku.DeleteSkuService;
import com.xls.commodity.busi.sku.DeleteProvGoodsService;
import com.xls.commodity.busi.sku.bo.DeleteProvGoodsBO;
import com.xls.commodity.dao.MaterialDAO;
import com.xls.commodity.dao.ProvGoodsDAO;
import com.xls.commodity.dao.ProvGoodsSupRelationDAO;
import com.xls.commodity.dao.po.ProvGoodsPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DeleteProvGoodsServiceImpl
implements DeleteProvGoodsService {
    private static final Logger logger = LoggerFactory.getLogger(DeleteProvGoodsServiceImpl.class);
    @Autowired
    private ProvGoodsDAO provGoodsDAO;
    @Autowired
    private ProvGoodsSupRelationDAO provGoodsSupRelationDAO;
    @Autowired
    private MaterialDAO materialDAO;
    @Autowired
    private DeleteSkuService deleteSkuService;
    @Value(value="${hsf.version}")
    private String hsfVersion;
    @Value(value="${hsf.group}")
    private String hsfGroup;
    @Value(value="${hsf.clientTimeout}")
    private String hsfClientTimeout;

    public RspInfoBO deleteProvGoods(DeleteProvGoodsBO provGoodsBO) {
        RspInfoBO result = new RspInfoBO();
        if (CollectionUtils.isEmpty((Collection)provGoodsBO.getProvGoodsIdS())) {
            logger.error("DeleteProvGoods\u65b9\u6cd5\u4f20\u5165\u7684\u53c2\u6570\u4e3a\u7a7a!");
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25:DeleteProvGoods\u65b9\u6cd5\u4f20\u5165\u7684\u53c2\u6570\u4e3a\u7a7a\uff01");
            return result;
        }
        List provGoodsIdS = provGoodsBO.getProvGoodsIdS();
        try {
            if (CollectionUtils.isEmpty((Collection)provGoodsIdS)) {
                logger.error("DeleteProvGoods\u65b9\u6cd5\u4f20\u5165\u7684\u7701\u4efd\u5546\u54c1id\u4e3a\u7a7a!");
                result.setRespCode("8888");
                result.setRespDesc("\u5931\u8d25:DeleteProvGoods\u65b9\u6cd5\u4f20\u5165\u7684\u7701\u4efd\u5546\u54c1id\u4e3a\u7a7a\uff01");
                return result;
            }
            List<ProvGoodsPO> provGoodsPOS = this.provGoodsDAO.selectByProvGoodsIds(provGoodsIdS);
            if (CollectionUtils.isEmpty(provGoodsPOS)) {
                logger.error("\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u7701\u4efd\u5546\u54c1\u6570\u636e  \u5220\u9664\u5931\u8d25!");
                result.setRespCode("8888");
                result.setRespDesc("\u5931\u8d25:\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u7701\u4efd\u5546\u54c1\u6570\u636e  \u5220\u9664\u5931\u8d25!");
                return result;
            }
            ArrayList<String> materialIdS = new ArrayList<String>();
            ArrayList<String> proviceCode = new ArrayList<String>();
            provGoodsPOS.stream().forEach(provGoodsPO -> {
                materialIdS.add(provGoodsPO.getMaterialId());
                proviceCode.add(provGoodsPO.getProvinceCode());
            });
            logger.debug("\u5f00\u59cb\u5220\u9664\u7701\u4efd\u5546\u54c1\u76f8\u5173\u4fe1\u606f\u3002\u3002\u3002");
            this.provGoodsDAO.deleteByProvIdS(provGoodsIdS);
            this.provGoodsSupRelationDAO.deleteByProvId(provGoodsIdS);
            this.deleteSkuService.deleteSKU(provGoodsIdS);
            this.deleteSmc(materialIdS, proviceCode);
        }
        catch (BusinessException e) {
            logger.error("\u629b\u51fa\u5f02\u5e38BusinessException\uff1a" + e.getMessage());
            throw new BusinessException(e.getMsgCode(), e.getMessage());
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u7701\u4efd\u5546\u54c1\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
            throw new BusinessException("8888", "\u5220\u9664\u7701\u4efd\u5546\u54c1\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38");
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    private void deleteSmc(List<String> materialIdS, List<String> proviceCode) {
        JSONObject param = new JSONObject();
        param.put("provIds", proviceCode);
        param.put("materialCodes", materialIdS);
        try {
            InvokeInfo invokeInfo = new InvokeInfo("com.tydic.smc.api.ability.SmcStockDeleteAbilityService", "deleteStock", "com.tydic.smc.api.ability.bo.SmcQryUnSaleCountsAbilityReqBO");
            invokeInfo.setVersion(this.hsfVersion);
            invokeInfo.setGroup(this.hsfGroup);
            invokeInfo.setClientTimeout(Integer.valueOf(this.hsfClientTimeout));
            invokeInfo.setRegisterType("2");
            JSONObject resultData = TKGenericServiceUtils.genericServiceInvoke((String)JSONObject.toJSONString((Object)param), null, (InvokeInfo)invokeInfo);
            logger.debug("deleteSmc\u8fdb\u884c\u6cdb\u5316\u8c03\u7528" + resultData);
            String respCode = resultData.getString("respCode");
            String respDesc = resultData.getString("respDesc");
            if (!Objects.equals(respCode, "0000")) {
                logger.error("\u5b58\u5728\u53ef\u552e,\u5728\u9014,\u9501\u5e93\u6216\u5df2\u552e\u6570\u91cf  \u5220\u9664\u5931\u8d25\uff1a" + respDesc);
                throw new BusinessException("9999", respDesc);
            }
        }
        catch (Exception e) {
            logger.error("\u5b58\u5728\u53ef\u552e,\u5728\u9014,\u9501\u5e93\u6216\u5df2\u552e\u6570\u91cf  \u5220\u9664\u5931\u8d25\uff1a" + e.getMessage());
            throw new BusinessException("9999", e.getMessage());
        }
    }
}

