/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cgd.commodity.dao.BrandMapper;
import com.cgd.commodity.po.Brand;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.newretail.toolkit.bo.InvokeInfo;
import com.tydic.newretail.toolkit.util.TKGenericServiceUtils;
import com.tydic.newretail.toolkit.util.TkExcelUtils;
import com.xls.commodity.atom.sku.SysParamsAtomService;
import com.xls.commodity.atom.sku.XlsSkuManageService;
import com.xls.commodity.busi.sku.AddGoodsByProvCodeService;
import com.xls.commodity.busi.sku.BatchCreateSkuService;
import com.xls.commodity.busi.sku.BrandManageService;
import com.xls.commodity.busi.sku.ImportProvGoodsService;
import com.xls.commodity.busi.sku.bo.AddProvGoodsListReqBO;
import com.xls.commodity.busi.sku.bo.BrandBO;
import com.xls.commodity.busi.sku.bo.CreateBrandReqBO;
import com.xls.commodity.busi.sku.bo.GetTempResBO;
import com.xls.commodity.busi.sku.bo.ImportBarCodeSuccessBO;
import com.xls.commodity.busi.sku.bo.ImportFaildBO;
import com.xls.commodity.busi.sku.bo.ImportProvBarCodeResBO;
import com.xls.commodity.busi.sku.bo.ImportProvGoodsBarCodeReqBO;
import com.xls.commodity.busi.sku.bo.ImportProvGoodsReqBO;
import com.xls.commodity.busi.sku.bo.ImportProvResBO;
import com.xls.commodity.busi.sku.bo.ImportSuccessBO;
import com.xls.commodity.busi.sku.bo.ProvGoodsBO;
import com.xls.commodity.busi.sku.bo.RuleRespBo;
import com.xls.commodity.busi.sku.bo.SupplierBO;
import com.xls.commodity.constants.SysParamConstant;
import com.xls.commodity.dao.MaterialDAO;
import com.xls.commodity.dao.ProvGoodsDAO;
import com.xls.commodity.dao.XlsSkuMapper;
import com.xls.commodity.dao.po.MaterialPO;
import com.xls.commodity.dao.po.ProvGoodsAndSupplierPO;
import com.xls.commodity.dao.po.ProvGoodsPO;
import com.xls.commodity.intfce.sku.DPriceSheetService;
import com.xls.commodity.intfce.sku.bo.BaseRspBO;
import com.xls.commodity.intfce.sku.bo.BasicListRspBO;
import com.xls.commodity.intfce.sku.bo.BasicRspBO;
import com.xls.commodity.thread.ImportProvGoodsThrean;
import com.xls.commodity.util.RedisUtil;
import com.xls.commodity.util.SCSOssFileUtils;
import com.xls.commodity.util.TkHttpRequestUtils;
import java.io.File;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.Jedis;

@Service
public class ImportProvGoodsServiceImpl
implements ImportProvGoodsService {
    private static final Logger logger = LoggerFactory.getLogger(ImportProvGoodsServiceImpl.class);
    @Autowired
    private AddGoodsByProvCodeService addGoodsByProvCodeService;
    @Autowired
    private XlsSkuMapper xlsSkuMapper;
    @Value(value="${getSuppiler}")
    private String suppilerUrl;
    @Autowired
    private ProvGoodsDAO provGoodsDAO;
    @Autowired
    private XlsSkuManageService xlsSkuManageService;
    @Autowired
    private BatchCreateSkuService batchCreateSkuService;
    @Autowired
    private SysParamsAtomService sysParamsAtomService;
    @Value(value="${prov.import.path}")
    private String importPath;
    @Value(value="${prov.import.temp}")
    private String importTemp;
    @Value(value="${barCode.import.path}")
    private String barCodeImportPath;
    @Autowired
    private BrandMapper brandMapper;
    @Autowired
    private MaterialDAO materialDAO;
    @Autowired
    private BrandManageService brandManageService;
    @Autowired
    private DPriceSheetService dPriceSheetService;
    @Value(value="${hsf.version}")
    private String hsfVersion;
    @Value(value="${hsf.group}")
    private String hsfGroup;
    @Value(value="${hsf.clientTimeout}")
    private String hsfClientTimeout;
    public static List<String> goodsType = Arrays.asList("\u793c\u54c1", "\u4fc3\u9500\u54c1", "\u591a\u5f62\u6001\u7ec8\u7aef", "\u884c\u4e1a\u7ec8\u7aef", "\u591a\u5f62\u6001", "\u786c\u4ef6\u667a\u80fd\u7ec8\u7aef", "\u56fa\u5b9a\u8d44\u4ea7", "\u914d\u4ef6", "\u624b\u6301\u7ec8\u7aef", "\u624b\u673a\u7ec8\u7aef", "\u65b0\u4e1a\u52a1", "\u624b\u673a", "\u53f7\u5361", "\u8bdd\u8d39", "\u865a\u62df\u5546\u54c1", "SIM\u5361", "\u79fb\u52a8\u5f85\u529e", "\u79fb\u52a8\u4e1a\u52a1", "\u6f14\u793a\u673a", "\u6837\u673a", "\u5382\u5546\u8d60\u54c1", "\u98df\u54c1", "\u751f\u6d3b\u65e5\u7528", "\u79fb\u52a8\u4e1a\u52a1", "\u65b0\u4e1a\u52a1");
    private List<ImportFaildBO> faild;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportProvResBO importComm(ImportProvGoodsReqBO reqBO) {
        File file;
        ImportProvResBO result = new ImportProvResBO();
        if (StringUtils.isEmpty((String)reqBO.getFileName())) {
            result.setRespCode("8888");
            result.setRespDesc("\u6587\u4ef6\u540d\u79f0\u4e3a\u7a7a");
            return result;
        }
        try {
            file = SCSOssFileUtils.downloadFileFromPath(this.importPath + reqBO.getFileName(), null, true);
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            result.setRespCode("8888");
            result.setRespDesc("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25");
            return result;
        }
        if (null == file || !file.exists()) {
            logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728");
            result.setRespCode("8888");
            result.setRespDesc("\u6587\u4ef6\u4e0d\u5b58\u5728");
            return result;
        }
        String suffix = TkExcelUtils.getSuffix((String)file.getPath());
        if (null != suffix) {
            suffix = suffix.toLowerCase();
        }
        Jedis jedis = RedisUtil.getJedis();
        String key = "IMPORT_PROVINCE_GOODS" + reqBO.getProvinceCode();
        String province = StringUtils.isBlank((String)reqBO.getProvinceCode()) ? reqBO.getmProvince() : reqBO.getProvinceCode();
        Map<String, String> typeMap = this.getEscape();
        ArrayList<ImportSuccessBO> rows = new ArrayList();
        try {
            rows = this.readXlsx(file.getPath(), suffix, typeMap, province, jedis);
        }
        catch (ResourceException e) {
            jedis.del(key);
            jedis.close();
            logger.error("\u89e3\u6790\u6587\u4ef6\u5f02\u5e38\uff1a" + e.getMessage());
            result.setRespCode(e.getMsgCode());
            result.setRespDesc(e.getMessage());
            return result;
        }
        catch (BusinessException businessException) {
            jedis.del(key);
            jedis.close();
            logger.error("\u67e5\u8be2\u914d\u7f6e\u8981\u8d27\u89c4\u5219\u9519\u8bef");
            result.setRespCode(businessException.getMsgCode());
            result.setRespDesc(businessException.getMessage());
            return result;
        }
        catch (Exception e) {
            jedis.del(key);
            jedis.close();
            logger.error("\u89e3\u6790\u6587\u4ef6\u5f02\u5e38\uff1a" + e.getMessage());
            result.setRespCode("8888");
            result.setRespDesc("\u89e3\u6790\u6587\u4ef6\u5f02\u5e38");
            return result;
        }
        String user = reqBO.getmLoginName();
        String userName = reqBO.getmName();
        try {
            this.createProv(rows, province, user, userName, jedis, reqBO.getmOrgPath());
        }
        catch (Exception e) {
            jedis.del(key);
            jedis.close();
            e.printStackTrace();
            logger.error("\u5546\u54c1\u521b\u5efa\u5f02\u5e38\uff1a" + e.getMessage());
            result.setRespCode("8888");
            result.setRespDesc("\u5546\u54c1\u521b\u5efa\u5f02\u5e38");
            ImportProvResBO importProvResBO = result;
            return importProvResBO;
        }
        finally {
            RedisUtil.release(jedis);
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        result.setImportFaild(this.faild);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportProvBarCodeResBO importBarCode(ImportProvGoodsBarCodeReqBO reqBO) {
        File file;
        ImportProvBarCodeResBO result = new ImportProvBarCodeResBO();
        if (StringUtils.isEmpty((String)reqBO.getFileName())) {
            result.setRespCode("8888");
            result.setRespDesc("\u6587\u4ef6\u540d\u79f0\u4e3a\u7a7a");
            return result;
        }
        try {
            file = SCSOssFileUtils.downloadFileFromPath(this.barCodeImportPath + reqBO.getFileName(), null, true);
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            result.setRespCode("8888");
            result.setRespDesc("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25");
            return result;
        }
        if (null == file || !file.exists()) {
            logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728");
            result.setRespCode("8888");
            result.setRespDesc("\u6587\u4ef6\u4e0d\u5b58\u5728");
            return result;
        }
        String suffix = TkExcelUtils.getSuffix((String)file.getPath());
        if (null != suffix) {
            suffix = suffix.toLowerCase();
        }
        Jedis jedis = RedisUtil.getJedis();
        String key = "IMPORT_PROVINCE_GOODS" + reqBO.getProvinceCode();
        String province = StringUtils.isBlank((String)reqBO.getProvinceCode()) ? reqBO.getmProvince() : reqBO.getProvinceCode();
        ArrayList<ImportBarCodeSuccessBO> rows = new ArrayList();
        try {
            rows = this.readXlsx(file.getPath(), suffix, province, jedis);
        }
        catch (ResourceException e) {
            jedis.del(key);
            jedis.close();
            logger.error("\u89e3\u6790\u6587\u4ef6\u5f02\u5e38\uff1a" + e.getMessage());
            result.setRespCode(e.getMsgCode());
            result.setRespDesc(e.getMessage());
            return result;
        }
        catch (Exception e) {
            jedis.del(key);
            jedis.close();
            logger.error("\u89e3\u6790\u6587\u4ef6\u5f02\u5e38\uff1a" + e.getMessage());
            result.setRespCode("8888");
            result.setRespDesc("\u89e3\u6790\u6587\u4ef6\u5f02\u5e38");
            return result;
        }
        try {
            this.updateBarCode(rows);
        }
        catch (Exception e) {
            jedis.del(key);
            jedis.close();
            e.printStackTrace();
            logger.error("\u6761\u7801\u66f4\u65b0\u5f02\u5e38\uff1a" + e.getMessage());
            result.setRespCode("8888");
            result.setRespDesc("\u6761\u7801\u66f4\u65b0\u5f02\u5e38");
            ImportProvBarCodeResBO importProvBarCodeResBO = result;
            return importProvBarCodeResBO;
        }
        finally {
            RedisUtil.del(key);
            RedisUtil.release(jedis);
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        result.setImportFaild(this.faild);
        return result;
    }

    public ImportProvResBO importProvincCommodityCreation(ImportProvGoodsReqBO reqBO) {
        File file;
        ImportProvResBO result = new ImportProvResBO();
        if (StringUtils.isEmpty((String)reqBO.getFileName())) {
            result.setRespCode("8888");
            result.setRespDesc("\u6587\u4ef6\u540d\u79f0\u4e3a\u7a7a");
            return result;
        }
        try {
            file = SCSOssFileUtils.downloadFileFromPath(this.importPath + reqBO.getFileName(), null, true);
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            result.setRespCode("8888");
            result.setRespDesc("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25");
            return result;
        }
        if (null == file || !file.exists()) {
            logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728");
            result.setRespCode("8888");
            result.setRespDesc("\u6587\u4ef6\u4e0d\u5b58\u5728");
            return result;
        }
        String suffix = TkExcelUtils.getSuffix((String)file.getPath());
        if (null != suffix) {
            suffix = suffix.toLowerCase();
        }
        String province = StringUtils.isBlank((String)reqBO.getProvinceCode()) ? reqBO.getmProvince() : reqBO.getProvinceCode();
        ArrayList<ImportSuccessBO> rows = new ArrayList();
        try {
            rows = this.readXlsx(file.getPath(), suffix);
        }
        catch (ResourceException e) {
            logger.error("\u89e3\u6790\u6587\u4ef6\u5f02\u5e38\uff1a" + e.getMessage());
            result.setRespCode(e.getMsgCode());
            result.setRespDesc(e.getMessage());
            return result;
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u6587\u4ef6\u5f02\u5e38\uff1a" + e.getMessage());
            result.setRespCode("8888");
            result.setRespDesc("\u89e3\u6790\u6587\u4ef6\u5f02\u5e38");
            return result;
        }
        String userName = reqBO.getmName();
        try {
            this.createProv(rows, province, userName);
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u521b\u5efa\u5f02\u5e38\uff1a" + e.getMessage());
            result.setRespCode("8888");
            result.setRespDesc("\u5546\u54c1\u521b\u5efa\u5f02\u5e38");
            return result;
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        result.setImportFaild(this.faild);
        return result;
    }

    public GetTempResBO getTemp() {
        GetTempResBO result = new GetTempResBO();
        if (StringUtils.isBlank((String)this.importTemp)) {
            result.setRespCode("8888");
            result.setRespDesc("\u672a\u914d\u7f6e\u5546\u54c1\u5bfc\u5165\u6a21\u677f\u6a21\u677f\u4e0b\u8f7d\u5730\u5740\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return result;
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        result.setData(this.importTemp);
        return result;
    }

    public void createProv(List<ImportSuccessBO> rows, String proviceCode, String user, String userName, Jedis jedis, String orgPath) throws Exception {
        ExecutorService cachedThreadPool = Executors.newCachedThreadPool();
        AddProvGoodsListReqBO reqBO = new AddProvGoodsListReqBO();
        Brand record = new Brand();
        List brands = this.brandMapper.selectAll(record);
        TreeMap<String, Object> brandMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        for (Brand brand : brands) {
            if (brandMap.containsKey(brand.getBrandName().trim())) continue;
            brandMap.put(brand.getBrandName().trim(), brand.getBrandId());
        }
        CreateBrandReqBO brandReq = new CreateBrandReqBO();
        ArrayList<BrandBO> brandBOs = new ArrayList<BrandBO>();
        ProvGoodsBO goods = null;
        BrandBO br = null;
        HashSet<String> brandSet = new HashSet<String>();
        ArrayList<ProvGoodsBO> prov = new ArrayList<ProvGoodsBO>();
        ArrayList<SupplierBO> supList = new ArrayList<SupplierBO>();
        SupplierBO supBO = null;
        for (ImportSuccessBO suBO : rows) {
            String[] supNos = suBO.getSupNo().split("\\,");
            for (int i = 0; i < supNos.length; ++i) {
                supBO = new SupplierBO();
                supBO.setSupplierName(supNos[i]);
                supList.add(supBO);
            }
            if (!StringUtils.isNotEmpty((String)suBO.getBrandName())) continue;
            brandSet.add(suBO.getBrandName().trim());
        }
        for (String brand : brandSet) {
            if (brandMap.containsKey(brand)) continue;
            br = new BrandBO();
            Long brandId = Sequence.getInstance().nextId();
            brandMap.put(brand, brandId);
            br.setBrandId(brandId);
            br.setBrandName(brand.trim());
            brandBOs.add(br);
        }
        brandReq.setBrandBOs(brandBOs);
        if (!CollectionUtils.isEmpty(brandBOs)) {
            this.brandManageService.insertBrandList(brandReq);
        }
        Map<String, SupplierBO> supMap = this.getSupplier(supList, proviceCode);
        Map<String, String> cgTypeMap = this.getCgType(rows);
        for (ImportSuccessBO suBO : rows) {
            goods = new ProvGoodsBO();
            goods = this.toBO(suBO, cgTypeMap);
            goods.setProvinceCode(proviceCode);
            goods.setProvGoodsId(Long.valueOf(Sequence.getInstance().nextId()));
            goods.setCreateUser(userName);
            goods.setCreateUsername(userName);
            ArrayList<SupplierBO> list = new ArrayList<SupplierBO>();
            String[] supNos = suBO.getSupNo().split("\\,");
            if (!CollectionUtils.isEmpty(supMap)) {
                for (int i = 0; i < supNos.length; ++i) {
                    if (!supMap.containsKey(supNos[i])) continue;
                    list.add(supMap.get(supNos[i]));
                }
            }
            goods.setSupplierBO(list);
            if (StringUtils.isNotEmpty((String)suBO.getBrandName())) {
                goods.setBrandId((Long)brandMap.get(suBO.getBrandName().trim()));
                goods.setBrandName(suBO.getBrandName().trim());
            }
            prov.add(goods);
        }
        reqBO.setReqBO(prov);
        if (CollectionUtils.isEmpty(prov)) {
            String key = "IMPORT_PROVINCE_GOODS" + proviceCode;
            logger.debug("\u6ca1\u6709\u8981\u540c\u6b65\u7684\u6570\u636e\uff0c\u6e05\u9664\u7f13\u5b58");
            jedis.del(key);
        }
        if (!CollectionUtils.isEmpty(prov)) {
            logger.debug("\u6ca1\u6709\u8981\u540c\u6b65\u7684\u6570\u636e\uff0c\u6e05\u9664\u7f13\u5b58" + JSON.toJSONString(prov));
            ImportProvGoodsThrean importProvGoodsThrean = new ImportProvGoodsThrean(reqBO, this.addGoodsByProvCodeService, this.xlsSkuMapper, this.xlsSkuManageService, this.batchCreateSkuService, this.dPriceSheetService, orgPath, this.hsfVersion, this.hsfGroup, this.hsfClientTimeout);
            logger.debug("\u5f00\u542f\u5f02\u6b65\u7ebf\u7a0b");
            cachedThreadPool.execute(importProvGoodsThrean);
            cachedThreadPool.shutdown();
        }
    }

    public void createProv(List<ImportSuccessBO> rows, String proviceCode, String userName) throws Exception {
        AddProvGoodsListReqBO reqBO = new AddProvGoodsListReqBO();
        ProvGoodsBO goods = null;
        ArrayList<SupplierBO> supList = new ArrayList<SupplierBO>();
        ArrayList<ProvGoodsBO> prov = new ArrayList<ProvGoodsBO>();
        for (ImportSuccessBO importSuccessBO : rows) {
            String[] supNos = importSuccessBO.getSupNo().split("\\,");
            for (int i = 0; i < supNos.length; ++i) {
                SupplierBO supBO = new SupplierBO();
                supBO.setSupplierName(supNos[i]);
                supList.add(supBO);
            }
        }
        Map<String, SupplierBO> supMap = this.getSupplier(supList, proviceCode);
        for (ImportSuccessBO suBO : rows) {
            goods = new ProvGoodsBO();
            goods = this.newtoBO(suBO);
            goods.setProvinceCode(proviceCode);
            goods.setCreateUser(userName);
            goods.setCreateUsername(userName);
            ArrayList<SupplierBO> list = new ArrayList<SupplierBO>();
            String[] supNos = suBO.getSupNo().split("\\,");
            if (!CollectionUtils.isEmpty(supMap)) {
                for (int i = 0; i < supNos.length; ++i) {
                    if (supMap.containsKey(supNos[i])) {
                        list.add(supMap.get(supNos[i]));
                        continue;
                    }
                    logger.debug("\u6279\u5bfc\u9519\u8bef\u6570\u636e\uff1a\u7b2c" + suBO.getRowNum() + "\u6761\uff0c\u9519\u8bef\u539f\u56e0\u4e3a \u4e0d\u5b58\u5728\u7684\u4f9b\u5e94\u5546\uff1a" + supNos[i]);
                    ImportFaildBO fbo = new ImportFaildBO();
                    fbo.setRowNum(suBO.getRowNum());
                    fbo.setDesc(supNos[i] + "  \u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\uff01");
                    this.faild.add(fbo);
                }
            }
            goods.setSupplierBO(list);
            prov.add(goods);
        }
        reqBO.setReqBO(prov);
        if (!CollectionUtils.isEmpty(prov)) {
            logger.debug("\u6ca1\u6709\u8981\u540c\u6b65\u7684\u6570\u636e\uff0c\u6e05\u9664\u7f13\u5b58" + JSON.toJSONString(prov));
            try {
                logger.debug("\u5bfc\u5165\u7701\u4efd\u5546\u54c1");
                BasicListRspBO basicListRspBO = this.addGoodsByProvCodeService.batchProvincCommodityCreation(reqBO);
                for (BasicRspBO basicRspBO : basicListRspBO.getBasicRspBOS()) {
                    if (!Objects.equals(basicRspBO.getRespCode(), "8888")) continue;
                    ImportFaildBO fbo = new ImportFaildBO();
                    fbo.setRowNum(basicRspBO.getRowNum());
                    fbo.setDesc(basicRspBO.getRespDesc());
                    logger.debug("\u6279\u5bfc\u9519\u8bef\u6570\u636e\uff1a\u7b2c" + fbo.getRowNum() + "\u6761\uff0c\u9519\u8bef\u539f\u56e0\u4e3a\uff1a" + fbo.getDesc());
                    this.faild.add(fbo);
                }
            }
            catch (Exception exception) {
                logger.error("\u5bfc\u5165\u7701\u4efd\u5546\u54c1\u51fa\u9519" + exception);
                throw new BusinessException("9999", "\u6279\u91cf\u65b0\u589e\u7701\u4efd\u5546\u54c1\u62a5\u9519" + exception.getMessage());
            }
        }
    }

    public ProvGoodsBO toBO(ImportSuccessBO req, Map<String, String> cgTypeMap) {
        ProvGoodsBO bo = new ProvGoodsBO();
        BeanUtils.copyProperties((Object)req, (Object)bo);
        bo.setReservedField1("0");
        bo.setGoodsStatus("03");
        bo.setCgType(StringUtils.isBlank((String)cgTypeMap.get(req.getMaterialId())) ? "0" : cgTypeMap.get(req.getMaterialId()));
        bo.setReservedField3("601".equals(bo.getCgType()) ? "0" : "1");
        if (StringUtils.isNotEmpty((String)req.getMaxStock())) {
            Object maxStock = new BigDecimal(req.getMaxStock());
            bo.setMaxStock(Long.valueOf(((BigDecimal)maxStock).longValue()));
        }
        switch (bo.getHasSerialNumber()) {
            case "\u6709": {
                bo.setHasSerialNumber("1");
                break;
            }
            default: {
                bo.setHasSerialNumber("0");
            }
        }
        if ("1".equals(bo.getHasSerialNumber())) {
            bo.setAllowNegativeStock("0");
        }
        if ("1".equals(bo.getHasSerialNumber())) {
            if (StringUtils.isBlank((String)req.getIsSentBoss())) {
                bo.setReservedField2("1");
            } else {
                switch (req.getIsSentBoss()) {
                    case "\u662f": {
                        bo.setReservedField2("1");
                        break;
                    }
                    case "Y": {
                        bo.setReservedField2("1");
                        break;
                    }
                    default: {
                        bo.setReservedField2("0");
                        break;
                    }
                }
            }
        } else {
            bo.setReservedField2("0");
        }
        if (StringUtils.isNotEmpty((String)req.getMinStock())) {
            BigDecimal minStock = new BigDecimal(req.getMinStock());
            bo.setMinStock(Long.valueOf(minStock.longValue()));
        }
        if (StringUtils.isNotEmpty((String)req.getAllowStockAge())) {
            BigDecimal allowStockAge = new BigDecimal(req.getAllowStockAge());
            bo.setAllowStockAge(Long.valueOf(allowStockAge.longValue()));
        }
        if (StringUtils.isNotEmpty((String)req.getSerialNumberLength())) {
            bo.setSerialNumberLength(Long.valueOf(Long.parseLong(req.getSerialNumberLength())));
        }
        if ("\u793c\u54c1".equals(bo.getErpGoodsType()) || "\u4fc3\u9500\u54c1".equals(bo.getErpGoodsType())) {
            bo.setErpGoodsType("01");
        } else if ("\u591a\u5f62\u6001\u7ec8\u7aef".equals(bo.getErpGoodsType()) || "\u884c\u4e1a\u7ec8\u7aef".equals(bo.getErpGoodsType()) || "\u591a\u5f62\u6001".equals(bo.getErpGoodsType()) || "\u786c\u4ef6\u53ea\u80fd\u7ec8\u7aef".equals(bo.getErpGoodsType())) {
            bo.setErpGoodsType("02");
        } else if ("\u56fa\u5b9a\u8d44\u4ea7".equals(bo.getErpGoodsType())) {
            bo.setErpGoodsType("03");
        } else if ("\u914d\u4ef6".equals(bo.getErpGoodsType())) {
            bo.setErpGoodsType("04");
        } else if ("\u624b\u6301\u7ec8\u7aef".equals(bo.getErpGoodsType()) || "\u624b\u673a\u7ec8\u7aef".equals(bo.getErpGoodsType()) || "\u624b\u673a".equals(bo.getErpGoodsType())) {
            bo.setErpGoodsType("05");
        } else if ("\u865a\u62df\u5546\u54c1".equals(bo.getErpGoodsType()) || "\u79fb\u52a8\u5f85\u529e".equals(bo.getErpGoodsType()) || "SIM\u5361".equals(bo.getErpGoodsType()) || "\u8bdd\u8d39".equals(bo.getErpGoodsType()) || "\u53f7\u5361".equals(bo.getErpGoodsType()) || "\u65b0\u4e1a\u52a1".equals(bo.getErpGoodsType()) || "\u79fb\u52a8\u4e1a\u52a1".equals(bo.getErpGoodsType())) {
            bo.setErpGoodsType("06");
        } else if ("\u6f14\u793a\u673a".equals(bo.getErpGoodsType()) || "\u6837\u673a".equals(bo.getErpGoodsType())) {
            bo.setErpGoodsType("07");
        } else if ("\u5382\u5546\u8d60\u54c1".equals(bo.getErpGoodsType())) {
            bo.setErpGoodsType("08");
        } else if ("\u98df\u54c1".equals(bo.getErpGoodsType())) {
            bo.setErpGoodsType("09");
        } else if ("\u751f\u6d3b\u65e5\u7528".equals(bo.getErpGoodsType())) {
            bo.setErpGoodsType("10");
        } else if ("\u79fb\u52a8\u4e1a\u52a1".equals(bo.getErpGoodsType())) {
            bo.setErpGoodsType("11");
        } else if ("\u65b0\u4e1a\u52a1".equals(bo.getErpGoodsType())) {
            bo.setErpGoodsType("12");
        }
        if (!StringUtils.isBlank((String)bo.getGoodsStalls())) {
            switch (bo.getGoodsStalls()) {
                case "\u901a\u7528\u5185\u5b58\u5355\u7535\u5355\u5145": {
                    bo.setGoodsStalls("01");
                    break;
                }
                case "\u901a\u7528\u5185\u5b58\u65e0\u7535\u65e0\u5145": {
                    bo.setGoodsStalls("02");
                    break;
                }
                case "16G\u5355\u7535\u5355\u5145": {
                    bo.setGoodsStalls("03");
                    break;
                }
                case "32G\u5355\u7535\u5355\u5145": {
                    bo.setGoodsStalls("04");
                    break;
                }
                default: {
                    bo.setGoodsStalls(null);
                }
            }
        }
        if (!StringUtils.isBlank((String)bo.getScreenType())) {
            switch (bo.getScreenType()) {
                case "\u666e\u901a\u5c4f": {
                    bo.setScreenType("1");
                    break;
                }
                case "\u5218\u6d77\u5c4f": {
                    bo.setScreenType("2");
                    break;
                }
                default: {
                    bo.setScreenType(null);
                }
            }
        }
        if (!StringUtils.isBlank((String)bo.getWhetherInvoice())) {
            switch (bo.getWhetherInvoice()) {
                case "\u662f": {
                    bo.setWhetherInvoice("1");
                    break;
                }
                case "\u5426": {
                    bo.setWhetherInvoice("0");
                    break;
                }
                default: {
                    bo.setWhetherInvoice(null);
                }
            }
        }
        switch (bo.getPurchaseType()) {
            case "\u81ea\u6709": {
                bo.setPurchaseType("1");
                break;
            }
            case "\u53d7\u6258": {
                bo.setPurchaseType("2");
                break;
            }
            case "1": {
                bo.setPurchaseType("1");
                break;
            }
            case "2": {
                bo.setPurchaseType("2");
            }
        }
        if (StringUtils.isNotEmpty((String)bo.getIsAfterInput())) {
            switch (bo.getIsAfterInput()) {
                case "Y": {
                    bo.setIsAfterInput("1");
                    break;
                }
                case "\u662f": {
                    bo.setIsAfterInput("1");
                    break;
                }
                default: {
                    bo.setIsAfterInput("0");
                }
            }
        }
        if (StringUtils.isNotEmpty((String)bo.getAllowNegativeStock())) {
            switch (bo.getAllowNegativeStock()) {
                case "Y": {
                    bo.setAllowNegativeStock("1");
                    break;
                }
                case "\u662f": {
                    bo.setAllowNegativeStock("1");
                    break;
                }
                default: {
                    bo.setAllowNegativeStock("0");
                }
            }
        }
        if (StringUtils.isNotEmpty((String)bo.getHasPrice())) {
            switch (bo.getHasPrice()) {
                case "Y": {
                    bo.setHasPrice("1");
                    break;
                }
                case "\u662f": {
                    bo.setHasPrice("1");
                    break;
                }
                default: {
                    bo.setHasPrice("0");
                }
            }
        }
        if (StringUtils.isNotEmpty((String)bo.getIsSendScmSale())) {
            switch (bo.getIsSendScmSale()) {
                case "\u662f": {
                    bo.setIsSendScmSale("1");
                    break;
                }
                case "Y": {
                    bo.setIsSendScmSale("1");
                    break;
                }
                default: {
                    bo.setIsSendScmSale("0");
                }
            }
        }
        if (StringUtils.isNotEmpty((String)bo.getIsScmDistribute())) {
            switch (bo.getIsScmDistribute()) {
                case "\u662f": {
                    bo.setIsScmDistribute("1");
                    break;
                }
                case "Y": {
                    bo.setIsScmDistribute("1");
                    break;
                }
                default: {
                    bo.setIsScmDistribute("0");
                }
            }
        }
        if (StringUtils.isNotEmpty((String)bo.getIsSendScmStock())) {
            switch (bo.getIsSendScmStock()) {
                case "\u662f": {
                    bo.setIsSendScmStock("1");
                    break;
                }
                case "Y": {
                    bo.setIsSendScmStock("1");
                    break;
                }
                default: {
                    bo.setIsSendScmStock("0");
                }
            }
        }
        return bo;
    }

    public ProvGoodsBO newtoBO(ImportSuccessBO req) {
        ProvGoodsBO bo = new ProvGoodsBO();
        BeanUtils.copyProperties((Object)req, (Object)bo);
        if (StringUtils.isNotEmpty((String)req.getMaxStock())) {
            Object maxStock = new BigDecimal(req.getMaxStock());
            bo.setMaxStock(Long.valueOf(((BigDecimal)maxStock).longValue()));
        }
        switch (bo.getHasSerialNumber()) {
            case "\u6709": {
                bo.setHasSerialNumber("1");
                break;
            }
            default: {
                bo.setHasSerialNumber("0");
            }
        }
        if ("1".equals(bo.getHasSerialNumber())) {
            bo.setAllowNegativeStock("0");
        }
        if ("1".equals(bo.getHasSerialNumber())) {
            if (StringUtils.isBlank((String)req.getIsSentBoss())) {
                bo.setReservedField2("1");
            } else {
                switch (req.getIsSentBoss()) {
                    case "\u662f": {
                        bo.setReservedField2("1");
                        break;
                    }
                    case "Y": {
                        bo.setReservedField2("1");
                        break;
                    }
                    default: {
                        bo.setReservedField2("0");
                        break;
                    }
                }
            }
        } else {
            bo.setReservedField2("0");
        }
        if (StringUtils.isNotEmpty((String)req.getMinStock())) {
            BigDecimal minStock = new BigDecimal(req.getMinStock());
            bo.setMinStock(Long.valueOf(minStock.longValue()));
        }
        if (StringUtils.isNotEmpty((String)req.getAllowStockAge())) {
            BigDecimal allowStockAge = new BigDecimal(req.getAllowStockAge());
            bo.setAllowStockAge(Long.valueOf(allowStockAge.longValue()));
        }
        if (StringUtils.isNotEmpty((String)req.getSerialNumberLength())) {
            bo.setSerialNumberLength(Long.valueOf(Long.parseLong(req.getSerialNumberLength())));
        }
        if ("\u793c\u54c1".equals(bo.getErpGoodsType()) || "\u4fc3\u9500\u54c1".equals(bo.getErpGoodsType())) {
            bo.setErpGoodsType("01");
        } else if ("\u591a\u5f62\u6001\u7ec8\u7aef".equals(bo.getErpGoodsType()) || "\u884c\u4e1a\u7ec8\u7aef".equals(bo.getErpGoodsType()) || "\u591a\u5f62\u6001".equals(bo.getErpGoodsType()) || "\u786c\u4ef6\u53ea\u80fd\u7ec8\u7aef".equals(bo.getErpGoodsType())) {
            bo.setErpGoodsType("02");
        } else if ("\u56fa\u5b9a\u8d44\u4ea7".equals(bo.getErpGoodsType())) {
            bo.setErpGoodsType("03");
        } else if ("\u914d\u4ef6".equals(bo.getErpGoodsType())) {
            bo.setErpGoodsType("04");
        } else if ("\u624b\u6301\u7ec8\u7aef".equals(bo.getErpGoodsType()) || "\u624b\u673a\u7ec8\u7aef".equals(bo.getErpGoodsType()) || "\u624b\u673a".equals(bo.getErpGoodsType())) {
            bo.setErpGoodsType("05");
        } else if ("\u865a\u62df\u5546\u54c1".equals(bo.getErpGoodsType()) || "\u79fb\u52a8\u5f85\u529e".equals(bo.getErpGoodsType()) || "SIM\u5361".equals(bo.getErpGoodsType()) || "\u8bdd\u8d39".equals(bo.getErpGoodsType()) || "\u53f7\u5361".equals(bo.getErpGoodsType()) || "\u65b0\u4e1a\u52a1".equals(bo.getErpGoodsType()) || "\u79fb\u52a8\u4e1a\u52a1".equals(bo.getErpGoodsType())) {
            bo.setErpGoodsType("06");
        } else if ("\u6f14\u793a\u673a".equals(bo.getErpGoodsType()) || "\u6837\u673a".equals(bo.getErpGoodsType())) {
            bo.setErpGoodsType("07");
        } else if ("\u5382\u5546\u8d60\u54c1".equals(bo.getErpGoodsType())) {
            bo.setErpGoodsType("08");
        } else if ("\u98df\u54c1".equals(bo.getErpGoodsType())) {
            bo.setErpGoodsType("09");
        } else if ("\u751f\u6d3b\u65e5\u7528".equals(bo.getErpGoodsType())) {
            bo.setErpGoodsType("10");
        } else if ("\u79fb\u52a8\u4e1a\u52a1".equals(bo.getErpGoodsType())) {
            bo.setErpGoodsType("11");
        } else if ("\u65b0\u4e1a\u52a1".equals(bo.getErpGoodsType())) {
            bo.setErpGoodsType("12");
        }
        if (!StringUtils.isBlank((String)bo.getGoodsStalls())) {
            switch (bo.getGoodsStalls()) {
                case "\u901a\u7528\u5185\u5b58\u5355\u7535\u5355\u5145": {
                    bo.setGoodsStalls("01");
                    break;
                }
                case "\u901a\u7528\u5185\u5b58\u65e0\u7535\u65e0\u5145": {
                    bo.setGoodsStalls("02");
                    break;
                }
                case "16G\u5355\u7535\u5355\u5145": {
                    bo.setGoodsStalls("03");
                    break;
                }
                case "32G\u5355\u7535\u5355\u5145": {
                    bo.setGoodsStalls("04");
                    break;
                }
                default: {
                    bo.setGoodsStalls(null);
                }
            }
        }
        if (!StringUtils.isBlank((String)bo.getScreenType())) {
            switch (bo.getScreenType()) {
                case "\u666e\u901a\u5c4f": {
                    bo.setScreenType("1");
                    break;
                }
                case "\u5218\u6d77\u5c4f": {
                    bo.setScreenType("2");
                    break;
                }
                default: {
                    bo.setScreenType(null);
                }
            }
        }
        if (!StringUtils.isBlank((String)bo.getWhetherInvoice())) {
            switch (bo.getWhetherInvoice()) {
                case "\u662f": {
                    bo.setWhetherInvoice("1");
                    break;
                }
                case "\u5426": {
                    bo.setWhetherInvoice("0");
                    break;
                }
                default: {
                    bo.setWhetherInvoice(null);
                }
            }
        }
        switch (bo.getPurchaseType()) {
            case "\u81ea\u6709": {
                bo.setPurchaseType("1");
                break;
            }
            case "\u53d7\u6258": {
                bo.setPurchaseType("2");
                break;
            }
            case "1": {
                bo.setPurchaseType("1");
                break;
            }
            case "2": {
                bo.setPurchaseType("2");
            }
        }
        if (StringUtils.isNotEmpty((String)bo.getIsAfterInput())) {
            switch (bo.getIsAfterInput()) {
                case "Y": {
                    bo.setIsAfterInput("1");
                    break;
                }
                case "\u662f": {
                    bo.setIsAfterInput("1");
                    break;
                }
                default: {
                    bo.setIsAfterInput("0");
                }
            }
        }
        if (StringUtils.isNotEmpty((String)bo.getAllowNegativeStock())) {
            switch (bo.getAllowNegativeStock()) {
                case "Y": {
                    bo.setAllowNegativeStock("1");
                    break;
                }
                case "\u662f": {
                    bo.setAllowNegativeStock("1");
                    break;
                }
                default: {
                    bo.setAllowNegativeStock("0");
                }
            }
        }
        if (StringUtils.isNotEmpty((String)bo.getHasPrice())) {
            switch (bo.getHasPrice()) {
                case "Y": {
                    bo.setHasPrice("1");
                    break;
                }
                case "\u662f": {
                    bo.setHasPrice("1");
                    break;
                }
                default: {
                    bo.setHasPrice("0");
                }
            }
        }
        if (StringUtils.isNotEmpty((String)bo.getIsSendScmSale())) {
            switch (bo.getIsSendScmSale()) {
                case "\u662f": {
                    bo.setIsSendScmSale("1");
                    break;
                }
                case "Y": {
                    bo.setIsSendScmSale("1");
                    break;
                }
                default: {
                    bo.setIsSendScmSale("0");
                }
            }
        }
        if (StringUtils.isNotEmpty((String)bo.getIsScmDistribute())) {
            switch (bo.getIsScmDistribute()) {
                case "\u662f": {
                    bo.setIsScmDistribute("1");
                    break;
                }
                case "Y": {
                    bo.setIsScmDistribute("1");
                    break;
                }
                default: {
                    bo.setIsScmDistribute("0");
                }
            }
        }
        if (StringUtils.isNotEmpty((String)bo.getIsSendScmStock())) {
            switch (bo.getIsSendScmStock()) {
                case "\u662f": {
                    bo.setIsSendScmStock("1");
                    break;
                }
                case "Y": {
                    bo.setIsSendScmStock("1");
                    break;
                }
                default: {
                    bo.setIsSendScmStock("0");
                }
            }
        }
        return bo;
    }

    public List<ImportSuccessBO> readXlsx(String path, String suffix, Map<String, String> typeMap, String proviceCode, Jedis jedis) throws Exception {
        ArrayList rows = null;
        if ("xls".equals(suffix)) {
            List hssfRows = TkExcelUtils.readXls((String)path, (int)0, (int)2);
            rows = new ArrayList(hssfRows);
        } else if ("xlsx".equals(suffix)) {
            List xssfRows = TkExcelUtils.readXlsx((String)path, (int)0, (int)2);
            rows = new ArrayList(xssfRows);
        } else {
            logger.error("\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff1a\u4ec5\u652f\u6301xls\u53caxlsx\u683c\u5f0f");
            throw new ResourceException("0007", "\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff1a\u4ec5\u652f\u6301xls\u53caxlsx\u683c\u5f0f");
        }
        if (CollectionUtils.isEmpty(rows)) {
            logger.error("\u672a\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9");
            throw new ResourceException("0016", "\u672a\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9");
        }
        this.faild = new ArrayList<ImportFaildBO>(rows.size());
        logger.debug("\u8bfb\u53d6\u7801\u8868");
        boolean isDecimal = false;
        ArrayList<String> material = new ArrayList<String>();
        ArrayList<String> scmMaterial = new ArrayList<String>();
        ArrayList<ImportSuccessBO> list = new ArrayList<ImportSuccessBO>(rows.size());
        ArrayList<SupplierBO> supList = new ArrayList<SupplierBO>();
        SupplierBO supBO = null;
        for (Row suBO : rows) {
            if (!StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)suBO.getCell(2), (Boolean)isDecimal))) {
                scmMaterial.add(TkExcelUtils.changeCellToString((Cell)suBO.getCell(2), (Boolean)isDecimal).trim());
            }
            if (StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)suBO.getCell(12), (Boolean)isDecimal))) continue;
            String[] supNos = TkExcelUtils.changeCellToString((Cell)suBO.getCell(12), (Boolean)isDecimal).split("\\,");
            for (int i = 0; i < supNos.length; ++i) {
                supBO = new SupplierBO();
                supBO.setSupplierName(supNos[i]);
                supList.add(supBO);
            }
        }
        Map<String, MaterialPO> scmMaterialMap = this.getScm(scmMaterial);
        Map<String, SupplierBO> supMap = this.getSupplier(supList, proviceCode);
        ImportSuccessBO bo = null;
        LinkedHashSet<String> brands = new LinkedHashSet<String>();
        block14: for (Row row : rows) {
            ImportFaildBO fbo;
            String invoiceTaxRate;
            bo = new ImportSuccessBO();
            String extGoodsNo = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(0), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(0), (Boolean)isDecimal).trim();
            Iterator<RuleRespBo> goodsNo = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(1), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(1), (Boolean)isDecimal).trim();
            String materialId = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(2), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(2), (Boolean)isDecimal).trim();
            String brandName = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(3), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(3), (Boolean)isDecimal).trim();
            String goodsModel = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(4), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(4), (Boolean)isDecimal).trim();
            String screenType = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(5), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(5), (Boolean)isDecimal).trim();
            String goodsStalls = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(6), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(6), (Boolean)isDecimal).trim();
            String colorName = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(7), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(7), (Boolean)isDecimal).trim();
            String memoryName = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(8), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(8), (Boolean)isDecimal).trim();
            String versionName = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(9), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(9), (Boolean)isDecimal).trim();
            String goodsLongName = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(10), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(10), (Boolean)isDecimal).trim();
            String erpGoodsType = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(11), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(11), (Boolean)isDecimal).trim();
            String supNo = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(12), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(12), (Boolean)isDecimal).trim();
            String goodsAttr = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(13), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(13), (Boolean)isDecimal).trim();
            String hasSerialNumber = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(14), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(14), (Boolean)isDecimal).trim();
            String serialNumberLength = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(15), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(15), (Boolean)isDecimal).trim();
            String purchaseType = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(16), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(16), (Boolean)isDecimal).trim();
            String isAfterInput = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(17), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(17), (Boolean)isDecimal).trim();
            String hasPrice = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(18), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(18), (Boolean)isDecimal).trim();
            String allowNegativeStock = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(19), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(19), (Boolean)isDecimal).trim();
            String network = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(20), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(20), (Boolean)isDecimal).trim();
            String operateSystem = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(21), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(21), (Boolean)isDecimal).trim();
            String describe = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(22), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(22), (Boolean)isDecimal).trim();
            String remark = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(23), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(23), (Boolean)isDecimal).trim();
            String maxStock = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(24), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(24), (Boolean)isDecimal).trim();
            String minStock = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(25), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(25), (Boolean)isDecimal).trim();
            String allowStockAge = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(26), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(26), (Boolean)isDecimal).trim();
            String standardSystem = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(29), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(29), (Boolean)isDecimal).trim();
            String scmGoodsLongName = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(30), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(30), (Boolean)isDecimal).trim();
            String taxTypeCode = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(31), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(31), (Boolean)isDecimal).trim();
            String isSendScmStock = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(32), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(32), (Boolean)isDecimal).trim();
            String isSendScmSale = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(33), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(33), (Boolean)isDecimal).trim();
            String isScmDistribute = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(34), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(34), (Boolean)isDecimal).trim();
            String cgType = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(35), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(35), (Boolean)isDecimal).trim();
            String measureName = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(36), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(36), (Boolean)isDecimal).trim();
            String bossColor = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(38), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(38), (Boolean)isDecimal).trim();
            String bossCode = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(37), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(37), (Boolean)isDecimal).trim();
            String isSentBoss = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(39), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(39), (Boolean)isDecimal).trim();
            String whetherInvoice = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(40), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(40), (Boolean)isDecimal).trim();
            String modelCommonName = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(41), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(41), (Boolean)isDecimal).trim();
            String barCode = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(42), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(42), (Boolean)isDecimal).trim();
            String string = invoiceTaxRate = StringUtils.isBlank((String)this.changeCellToStringDouble(row.getCell(43), true)) ? null : this.changeCellToStringDouble(row.getCell(43), true).trim();
            if (material.contains(materialId)) {
                ImportFaildBO fbo2 = new ImportFaildBO();
                logger.debug("\u7269\u6599\u7f16\u7801\u91cd\u590d");
                fbo2.setRowNum(Integer.valueOf(row.getRowNum() + 1));
                fbo2.setDesc("\u7269\u6599\u7f16" + materialId + "\u7801\u91cd\u590d");
                this.faild.add(fbo2);
                continue;
            }
            Pattern pattern = Pattern.compile("[0-9]{1,}");
            Matcher matcher = pattern.matcher(materialId);
            boolean result = matcher.matches();
            String substring = materialId.substring(0, 2);
            if (result) {
                if (18 != materialId.length() || !"00".equals(substring)) {
                    fbo = new ImportFaildBO();
                    logger.debug("\u7269\u6599\u7f16\u7801\u957f\u5ea6\u4e0d\u8db318\u4f4d");
                    fbo.setRowNum(Integer.valueOf(row.getRowNum() + 1));
                    fbo.setDesc("\u7eaf\u6570\u5b57\u7684\u7269\u6599\u7f16\u7801\u957f\u5ea6\u4e0d\u8db318\u4f4d\u6216\u4e0d\u662f\u4ee500\u5f00\u5934" + materialId);
                    this.faild.add(fbo);
                    continue;
                }
            } else if (16 != materialId.length()) {
                fbo = new ImportFaildBO();
                logger.debug("\u5e26\u82f1\u6587\u7684\u7269\u6599\u7f16\u7801\u957f\u5ea6\u4e0d\u8db316\u4f4d");
                fbo.setRowNum(Integer.valueOf(row.getRowNum() + 1));
                fbo.setDesc("\u5e26\u82f1\u6587\u7684\u7269\u6599\u7f16\u7801\u957f\u5ea6\u4e0d\u8db316\u4f4d" + materialId);
                this.faild.add(fbo);
                continue;
            }
            material.add(materialId);
            String check = this.check(row.getRowNum(), erpGoodsType, hasSerialNumber, purchaseType, isAfterInput, allowNegativeStock, isSendScmStock, isSendScmSale, isScmDistribute, goodsLongName, goodsModel, supNo, materialId, brandName, proviceCode, jedis, whetherInvoice, taxTypeCode, invoiceTaxRate);
            if (null != check) continue;
            String[] supNos = TkExcelUtils.changeCellToString((Cell)row.getCell(12), (Boolean)isDecimal).split("\\,");
            for (int i = 0; i < supNos.length; ++i) {
                if (supMap.containsKey(supNos[i])) continue;
                ImportFaildBO fbo3 = new ImportFaildBO();
                logger.debug("\u4e0d\u5b58\u5728\u7684\u4f9b\u5e94\u5546" + supNos[i]);
                fbo3.setRowNum(Integer.valueOf(row.getRowNum() + 1));
                fbo3.setDesc("\u4e0d\u5b58\u5728\u7684\u4f9b\u5e94\u5546" + supNos[i]);
                this.faild.add(fbo3);
                continue block14;
            }
            if (!CollectionUtils.isEmpty(scmMaterialMap) && scmMaterialMap.containsKey(materialId)) {
                bo.setGoodsSource("01");
                bo.setGoodsModel(StringUtils.isBlank((String)scmMaterialMap.get(materialId).getMarqueName()) ? goodsModel : scmMaterialMap.get(materialId).getMarqueName());
                bo.setColorName(StringUtils.isBlank((String)scmMaterialMap.get(materialId).getColorName()) ? colorName : scmMaterialMap.get(materialId).getColorName());
                bo.setBrandName(StringUtils.isBlank((String)scmMaterialMap.get(materialId).getBrandName()) ? brandName : scmMaterialMap.get(materialId).getBrandName());
                bo.setVersionName(StringUtils.isBlank((String)scmMaterialMap.get(materialId).getVersionName()) ? versionName : scmMaterialMap.get(materialId).getVersionName());
                bo.setScmGoodsLongName(scmMaterialMap.get(materialId).getMaterialDesc());
                if (scmMaterialMap.containsKey(materialId) && !StringUtils.isBlank((String)scmMaterialMap.get(materialId).getGoodsTypeName())) {
                    switch (scmMaterialMap.get(materialId).getGoodsTypeName()) {
                        case "\u7ec8\u7aef": {
                            bo.setGoodsType("01");
                            break;
                        }
                        case "\u914d\u4ef6": {
                            bo.setGoodsType("02");
                            break;
                        }
                        case "\u4fc3\u9500\u54c1": {
                            bo.setGoodsType("03");
                            break;
                        }
                    }
                }
            } else {
                bo.setGoodsSource("00");
                bo.setColorName(colorName);
                bo.setBrandName(brandName);
                bo.setVersionName(versionName);
                bo.setScmGoodsLongName(scmGoodsLongName);
                bo.setGoodsModel(goodsModel);
            }
            if (StringUtils.isBlank((String)invoiceTaxRate)) {
                bo.setInvoiceTaxRate(SysParamConstant.INVOICE_TAX_RATE_DEFAULT);
            } else {
                bo.setInvoiceTaxRate(Double.valueOf(invoiceTaxRate));
            }
            bo.setRowNum(Integer.valueOf(row.getRowNum() + 1));
            bo.setAllowNegativeStock(allowNegativeStock);
            bo.setAllowStockAge(allowStockAge);
            bo.setSupNo(supNo);
            bo.setGoodsNo(goodsNo);
            bo.setCgType("0");
            bo.setGoodsAttr(goodsAttr);
            bo.setErpGoodsType(erpGoodsType);
            bo.setGoodsLongName(goodsLongName);
            bo.setGoodsStalls(goodsStalls);
            bo.setHasPrice(hasPrice);
            bo.setHasSerialNumber(hasSerialNumber);
            bo.setIsAfterInput(isAfterInput);
            bo.setIsScmDistribute(isScmDistribute);
            bo.setDescribe(describe);
            bo.setIsSendScmSale(isSendScmSale);
            bo.setIsSendScmStock(isSendScmStock);
            bo.setMaterialId(materialId);
            bo.setMaterialId(StringUtils.isBlank((String)materialId) ? null : materialId.trim());
            bo.setExtGoodsNo(extGoodsNo);
            bo.setMaxStock(maxStock);
            bo.setMinStock(minStock);
            bo.setMeasureName(measureName);
            bo.setMemoryName(memoryName);
            bo.setNetwork(network);
            bo.setPurchaseType(purchaseType);
            bo.setRemark(remark);
            bo.setTaxTypeCode(taxTypeCode);
            bo.setIsSentBoss(isSentBoss);
            bo.setStandardSystem(standardSystem);
            bo.setOperateSystem(operateSystem);
            bo.setScreenType(screenType);
            bo.setSerialNumberLength(serialNumberLength);
            bo.setBossCode(bossCode);
            bo.setBossColor(bossColor);
            bo.setWhetherInvoice(whetherInvoice);
            bo.setModelCommonName(modelCommonName);
            bo.setBarCode(barCode);
            list.add(bo);
            brands.add(bo.getBrandName());
        }
        if (proviceCode.equals("240000") && brands.size() > 0) {
            try {
                ArrayList<String> brandsList = new ArrayList<String>(brands);
                List<RuleRespBo> rules = this.getRules(brandsList);
                HashMap<String, String> map = new HashMap<String, String>();
                for (RuleRespBo ruleRespBo : rules) {
                    map.put(ruleRespBo.getBrandName(), ruleRespBo.getIsExistRule());
                    if (!Objects.equals(ruleRespBo.getIsExistRule(), "0")) continue;
                    ImportFaildBO fbo = new ImportFaildBO();
                    logger.debug("\u8be5\u5546\u54c1\u6682\u672a\u914d\u7f6e\u8981\u8d27\u89c4\u5219");
                    fbo.setDesc("\u8be5\u5546\u54c1\u54c1\u724c[" + bo.getBrandName() + "]\u6682\u672a\u914d\u7f6e\u8981\u8d27\u5ba1\u6279\u89c4\u5219\uff0c\u8bf7\u5148\u914d\u7f6e\u8981\u8d27\u5ba1\u6279\u89c4\u5219\u6216\u8005\u66f4\u6539\u5546\u54c1\u54c1\u724c");
                    this.faild.add(fbo);
                }
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ImportSuccessBO importSuccessBO = (ImportSuccessBO)iterator.next();
                    if (!Objects.equals(map.get(importSuccessBO.getBrandName()), "0")) continue;
                    iterator.remove();
                }
                logger.debug("\u6279\u5bfc\u5217\u8868\u5927\u5c0f" + list.size());
            }
            catch (Exception e) {
                logger.error("\u914d\u7f6e\u8981\u8d27\u89c4\u5219\u62a5\u9519");
                throw new BusinessException("9999", "\u914d\u7f6e\u8981\u8d27\u89c4\u5219\u62a5\u9519" + e.getMessage());
            }
        }
        return list;
    }

    public List<ImportBarCodeSuccessBO> readXlsx(String path, String suffix, String proviceCode, Jedis jedis) throws Exception {
        ArrayList rows = null;
        if ("xls".equals(suffix)) {
            List hssfRows = TkExcelUtils.readXls((String)path, (int)0, (int)2);
            rows = new ArrayList(hssfRows);
        } else if ("xlsx".equals(suffix)) {
            List xssfRows = TkExcelUtils.readXlsx((String)path, (int)0, (int)2);
            rows = new ArrayList(xssfRows);
        } else {
            logger.error("\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff1a\u4ec5\u652f\u6301xls\u53caxlsx\u683c\u5f0f");
            throw new ResourceException("0007", "\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff1a\u4ec5\u652f\u6301xls\u53caxlsx\u683c\u5f0f");
        }
        if (CollectionUtils.isEmpty(rows)) {
            logger.error("\u672a\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9");
            throw new ResourceException("0016", "\u672a\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9");
        }
        this.faild = new ArrayList<ImportFaildBO>(rows.size());
        logger.debug("\u8bfb\u53d6\u7801\u8868");
        boolean isDecimal = false;
        ArrayList<String> material = new ArrayList<String>();
        ArrayList<ImportBarCodeSuccessBO> list = new ArrayList<ImportBarCodeSuccessBO>(rows.size());
        for (Row suBO : rows) {
            if (StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)suBO.getCell(0), (Boolean)isDecimal))) continue;
            material.add(TkExcelUtils.changeCellToString((Cell)suBO.getCell(0), (Boolean)isDecimal).trim());
        }
        Map<String, ProvGoodsPO> materialMap = this.getMaterial(proviceCode, material);
        ImportBarCodeSuccessBO bo = null;
        for (Row row : rows) {
            String barCode;
            bo = new ImportBarCodeSuccessBO();
            String materialId = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(0), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(0), (Boolean)isDecimal).trim();
            String string = barCode = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(1), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(1), (Boolean)isDecimal).trim();
            if (!materialMap.containsKey(materialId)) {
                ImportFaildBO fbo = new ImportFaildBO();
                logger.debug("\u7269\u6599\u7701\u4efd\u5546\u54c1\u4e0d\u5b58\u5728");
                fbo.setRowNum(Integer.valueOf(row.getRowNum() + 1));
                fbo.setDesc("\u7269\u6599\u7f16\u7801\u7701\u4efd\u5546\u54c1" + materialId + "\u4e0d\u5b58\u5728");
                this.faild.add(fbo);
                continue;
            }
            String check = this.check(row.getRowNum(), materialId, barCode, proviceCode, jedis);
            if (null != check) continue;
            bo.setRowNum(Integer.valueOf(row.getRowNum() + 1));
            bo.setBarCode(barCode);
            bo.setMaterialId(materialId);
            bo.setProvinceCode(proviceCode);
            list.add(bo);
        }
        return list;
    }

    public List<ImportSuccessBO> readXlsx(String path, String suffix) throws Exception {
        ArrayList rows = null;
        if ("xls".equals(suffix)) {
            List hssfRows = TkExcelUtils.readXls((String)path, (int)0, (int)2);
            rows = new ArrayList(hssfRows);
        } else if ("xlsx".equals(suffix)) {
            List xssfRows = TkExcelUtils.readXlsx((String)path, (int)0, (int)2);
            rows = new ArrayList(xssfRows);
        } else {
            logger.error("\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff1a\u4ec5\u652f\u6301xls\u53caxlsx\u683c\u5f0f");
            throw new ResourceException("0007", "\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff1a\u4ec5\u652f\u6301xls\u53caxlsx\u683c\u5f0f");
        }
        if (CollectionUtils.isEmpty(rows)) {
            logger.error("\u672a\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9");
            throw new ResourceException("0016", "\u672a\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9");
        }
        this.faild = new ArrayList<ImportFaildBO>(rows.size());
        logger.debug("\u8bfb\u53d6\u7801\u8868");
        boolean isDecimal = false;
        ArrayList<ImportSuccessBO> list = new ArrayList<ImportSuccessBO>(rows.size());
        ImportSuccessBO bo = null;
        for (Row row : rows) {
            String invoiceTaxRate;
            bo = new ImportSuccessBO();
            String extGoodsNo = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(0), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(0), (Boolean)isDecimal).trim();
            String goodsNo = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(1), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(1), (Boolean)isDecimal).trim();
            String materialId = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(2), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(2), (Boolean)isDecimal).trim();
            String brandName = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(3), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(3), (Boolean)isDecimal).trim();
            String goodsModel = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(4), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(4), (Boolean)isDecimal).trim();
            String screenType = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(5), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(5), (Boolean)isDecimal).trim();
            String goodsStalls = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(6), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(6), (Boolean)isDecimal).trim();
            String colorName = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(7), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(7), (Boolean)isDecimal).trim();
            String memoryName = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(8), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(8), (Boolean)isDecimal).trim();
            String versionName = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(9), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(9), (Boolean)isDecimal).trim();
            String goodsLongName = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(10), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(10), (Boolean)isDecimal).trim();
            String erpGoodsType = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(11), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(11), (Boolean)isDecimal).trim();
            String supNo = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(12), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(12), (Boolean)isDecimal).trim();
            String goodsAttr = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(13), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(13), (Boolean)isDecimal).trim();
            String hasSerialNumber = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(14), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(14), (Boolean)isDecimal).trim();
            String serialNumberLength = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(15), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(15), (Boolean)isDecimal).trim();
            String purchaseType = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(16), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(16), (Boolean)isDecimal).trim();
            String isAfterInput = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(17), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(17), (Boolean)isDecimal).trim();
            String hasPrice = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(18), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(18), (Boolean)isDecimal).trim();
            String allowNegativeStock = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(19), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(19), (Boolean)isDecimal).trim();
            String network = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(20), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(20), (Boolean)isDecimal).trim();
            String operateSystem = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(21), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(21), (Boolean)isDecimal).trim();
            String describe = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(22), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(22), (Boolean)isDecimal).trim();
            String remark = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(23), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(23), (Boolean)isDecimal).trim();
            String maxStock = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(24), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(24), (Boolean)isDecimal).trim();
            String minStock = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(25), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(25), (Boolean)isDecimal).trim();
            String allowStockAge = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(26), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(26), (Boolean)isDecimal).trim();
            String standardSystem = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(29), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(29), (Boolean)isDecimal).trim();
            String scmGoodsLongName = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(30), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(30), (Boolean)isDecimal).trim();
            String taxTypeCode = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(31), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(31), (Boolean)isDecimal).trim();
            String isSendScmStock = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(32), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(32), (Boolean)isDecimal).trim();
            String isSendScmSale = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(33), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(33), (Boolean)isDecimal).trim();
            String isScmDistribute = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(34), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(34), (Boolean)isDecimal).trim();
            String measureName = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(36), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(36), (Boolean)isDecimal).trim();
            String bossColor = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(38), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(38), (Boolean)isDecimal).trim();
            String bossCode = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(37), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(37), (Boolean)isDecimal).trim();
            String isSentBoss = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(39), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(39), (Boolean)isDecimal).trim();
            String whetherInvoice = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(40), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(40), (Boolean)isDecimal).trim();
            String modelCommonName = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(41), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(41), (Boolean)isDecimal).trim();
            String barCode = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(42), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(42), (Boolean)isDecimal).trim();
            String string = invoiceTaxRate = StringUtils.isBlank((String)this.changeCellToStringDouble(row.getCell(43), true)) ? null : this.changeCellToStringDouble(row.getCell(43), true).trim();
            if (StringUtils.isBlank(invoiceTaxRate)) {
                bo.setInvoiceTaxRate(SysParamConstant.INVOICE_TAX_RATE_DEFAULT);
            } else {
                bo.setInvoiceTaxRate(Double.valueOf(invoiceTaxRate));
            }
            bo.setGoodsSource("00");
            bo.setColorName(colorName);
            bo.setBrandName(brandName);
            bo.setVersionName(versionName);
            bo.setScmGoodsLongName(scmGoodsLongName);
            bo.setGoodsModel(goodsModel);
            bo.setRowNum(Integer.valueOf(row.getRowNum() + 1));
            bo.setAllowNegativeStock(allowNegativeStock);
            bo.setAllowStockAge(allowStockAge);
            bo.setSupNo(supNo);
            bo.setGoodsNo(goodsNo);
            bo.setCgType("0");
            bo.setGoodsAttr(goodsAttr);
            bo.setErpGoodsType(erpGoodsType);
            bo.setGoodsLongName(goodsLongName);
            bo.setGoodsStalls(goodsStalls);
            bo.setHasPrice(hasPrice);
            bo.setHasSerialNumber(hasSerialNumber);
            bo.setIsAfterInput(isAfterInput);
            bo.setIsScmDistribute(isScmDistribute);
            bo.setDescribe(describe);
            bo.setIsSendScmSale(isSendScmSale);
            bo.setIsSendScmStock(isSendScmStock);
            bo.setMaterialId(materialId);
            bo.setExtGoodsNo(extGoodsNo);
            bo.setMaxStock(maxStock);
            bo.setMinStock(minStock);
            bo.setMeasureName(measureName);
            bo.setMemoryName(memoryName);
            bo.setNetwork(network);
            bo.setPurchaseType(purchaseType);
            bo.setRemark(remark);
            bo.setTaxTypeCode(taxTypeCode);
            bo.setIsSentBoss(isSentBoss);
            bo.setStandardSystem(standardSystem);
            bo.setOperateSystem(operateSystem);
            bo.setScreenType(screenType);
            bo.setSerialNumberLength(serialNumberLength);
            bo.setBossCode(bossCode);
            bo.setBossColor(bossColor);
            bo.setWhetherInvoice(whetherInvoice);
            bo.setModelCommonName(modelCommonName);
            bo.setBarCode(barCode);
            list.add(bo);
        }
        return list;
    }

    public List<RuleRespBo> getRules(List<String> brands) throws Exception {
        ArrayList<RuleRespBo> ruleRespBos = new ArrayList<RuleRespBo>();
        JSONObject param = new JSONObject();
        param.put("provinceCode", (Object)"240000");
        param.fluentPut("list", brands);
        param.put("flag", (Object)false);
        logger.debug(param.toString());
        InvokeInfo invokeInfo = new InvokeInfo("com.tydic.newpurchase.api.approvalRule.service.CheckSkuBrandReviewRulesService", "checkSkuBrandReviewRulesService", "com.tydic.newpurchase.api.approvalRule.bo.CheckSkuBrandReviewRulesReqBO");
        invokeInfo.setVersion(this.hsfVersion);
        invokeInfo.setGroup(this.hsfGroup);
        invokeInfo.setClientTimeout(Integer.valueOf(this.hsfClientTimeout));
        invokeInfo.setRegisterType("2");
        JSONObject rule = TKGenericServiceUtils.genericServiceInvoke((String)JSONObject.toJSONString((Object)param), null, (InvokeInfo)invokeInfo);
        logger.debug("\u8fdb\u884c\u6cdb\u5316\u8c03\u7528\u8fd4\u56de\u503c" + rule);
        if (!CollectionUtils.isEmpty((Collection)rule.getJSONArray("brandBOList"))) {
            RuleRespBo bo = null;
            JSONArray brandBOList = rule.getJSONArray("brandBOList");
            logger.debug("\u8981\u8d27\u89c4\u5219\u5546\u54c1\u6570=" + brandBOList.size());
            for (int i = 0; i < brandBOList.size(); ++i) {
                JSONObject item = brandBOList.getJSONObject(i);
                if (!StringUtils.isNotEmpty((String)item.getString("brandName"))) continue;
                bo = new RuleRespBo();
                bo.setBrandCode(item.getString("brandCode"));
                bo.setBrandName(item.getString("brandName"));
                bo.setIsExistRule(item.getString("isExistRule"));
                ruleRespBos.add(bo);
            }
        }
        logger.debug(((RuleRespBo)ruleRespBos.get(0)).toString());
        return ruleRespBos;
    }

    public String check(int rowNum, String materialId, String barcode, String province, Jedis jedis) {
        if (StringUtils.isBlank((String)materialId)) {
            ImportFaildBO fbo = new ImportFaildBO();
            logger.debug("\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
            fbo.setDesc("\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
            fbo.setRowNum(Integer.valueOf(rowNum + 1));
            this.faild.add(fbo);
            return "\u7269\u6599\u7f16\u7801\u4e3a\u7a7a";
        }
        logger.debug("\u6821\u9a8c\u5165\u53c2");
        String key = "IMPORT_PROVINCE_GOODS" + province;
        if (jedis.sismember(key, materialId).booleanValue()) {
            ImportFaildBO fbo = new ImportFaildBO();
            logger.debug("\u8be5\u7269\u6599\u540c\u6b65\u4e2d");
            fbo.setDesc(materialId + "\u8be5\u7269\u6599\u540c\u6b65\u4e2d");
            fbo.setRowNum(Integer.valueOf(rowNum + 1));
            this.faild.add(fbo);
            return "\u8be5\u7269\u6599\u540c\u6b65\u4e2d";
        }
        jedis.sadd(key, new String[]{materialId});
        logger.debug("\u5b58\u5165redis");
        if (StringUtils.isBlank((String)barcode)) {
            ImportFaildBO fbo = new ImportFaildBO();
            logger.debug("\u6761\u5f62\u7801");
            fbo.setDesc("\u6761\u5f62\u7801\u4e3a\u7a7a");
            fbo.setRowNum(Integer.valueOf(rowNum + 1));
            this.faild.add(fbo);
            return "\u6761\u5f62\u7801\u4e3a\u7a7a";
        }
        return null;
    }

    public String check(int rowNum, String erpGoodsType, String hasSerialNumber, String purchaseType, String isAfterInput, String allowNegativeStock, String isSendScmStock, String isSendScmSale, String isScmDistribute, String goodsLongName, String goodsModel, String supNo, String materialId, String brandName, String province, Jedis jedis, String whetherInvoice, String taxTypeCode, String invoiceTaxRate) {
        if (StringUtils.isBlank((String)materialId)) {
            ImportFaildBO fbo = new ImportFaildBO();
            logger.debug("\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
            fbo.setDesc("\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
            fbo.setRowNum(Integer.valueOf(rowNum + 1));
            this.faild.add(fbo);
            return "\u7269\u6599\u7f16\u7801\u4e3a\u7a7a";
        }
        logger.debug("\u6821\u9a8c\u5165\u53c2");
        String key = "IMPORT_PROVINCE_GOODS" + province;
        if (jedis.sismember(key, materialId).booleanValue()) {
            ImportFaildBO fbo = new ImportFaildBO();
            logger.debug("\u8be5\u7269\u6599\u540c\u6b65\u4e2d");
            fbo.setDesc(materialId + "\u8be5\u7269\u6599\u540c\u6b65\u4e2d");
            fbo.setRowNum(Integer.valueOf(rowNum + 1));
            this.faild.add(fbo);
            return "\u8be5\u7269\u6599\u540c\u6b65\u4e2d";
        }
        jedis.sadd(key, new String[]{materialId});
        logger.debug("\u5b58\u5165redis");
        if (StringUtils.isBlank((String)goodsModel)) {
            ImportFaildBO fbo = new ImportFaildBO();
            logger.debug("\u5546\u54c1\u578b\u53f7\u4e3a\u7a7a");
            fbo.setDesc("\u5546\u54c1\u578b\u53f7\u4e3a\u7a7a");
            fbo.setRowNum(Integer.valueOf(rowNum + 1));
            this.faild.add(fbo);
            return "\u5546\u54c1\u578b\u53f7\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)whetherInvoice)) {
            ImportFaildBO fbo = new ImportFaildBO();
            logger.debug("\u662f\u5426\u5f00\u53d1\u7968\u4e3a\u7a7a");
            fbo.setDesc("\u662f\u5426\u5f00\u53d1\u7968\u4e3a\u7a7a");
            fbo.setRowNum(Integer.valueOf(rowNum + 1));
            this.faild.add(fbo);
            return "\u662f\u5426\u5f00\u53d1\u7968\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)isSendScmStock)) {
            ImportFaildBO fbo = new ImportFaildBO();
            logger.debug("\u662f\u5426\u540c\u6b65SCM\u5e93\u5b58\u4e3a\u7a7a");
            fbo.setDesc("\u662f\u5426\u540c\u6b65SCM\u5e93\u5b58\u4e3a\u7a7a");
            fbo.setRowNum(Integer.valueOf(rowNum + 1));
            this.faild.add(fbo);
            return "\u662f\u5426\u540c\u6b65SCM\u5e93\u5b58\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)isSendScmSale)) {
            ImportFaildBO fbo = new ImportFaildBO();
            logger.debug("\u662f\u5426\u53d1\u9001SCM\u9500\u5355\u4e3a\u7a7a");
            fbo.setDesc("\u662f\u5426\u53d1\u9001SCM\u9500\u5355\u4e3a\u7a7a");
            fbo.setRowNum(Integer.valueOf(rowNum + 1));
            this.faild.add(fbo);
            return "\u662f\u5426\u53d1\u9001SCM\u9500\u5355\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)isScmDistribute)) {
            ImportFaildBO fbo = new ImportFaildBO();
            logger.debug("\u662f\u5426SCM\u81ea\u52a8\u94fa\u8d27\u4e3a\u7a7a");
            fbo.setDesc("\u662f\u5426SCM\u81ea\u52a8\u94fa\u8d27\u4e3a\u7a7a");
            fbo.setRowNum(Integer.valueOf(rowNum + 1));
            this.faild.add(fbo);
            return "\u662f\u5426SCM\u81ea\u52a8\u94fa\u8d27\u4e3a\u7a7a";
        }
        if (Objects.equals(whetherInvoice, "\u662f") && StringUtils.isBlank((String)invoiceTaxRate)) {
            ImportFaildBO fbo = new ImportFaildBO();
            logger.debug("\u662f\u5426\u5f00\u53d1\u7968\u4e3a \u662f \u65f6\uff0c\u7a0e\u7387\u4e3a\u7a7a");
            fbo.setDesc("\u662f\u5426\u5f00\u53d1\u7968\u4e3a \u662f \u65f6\uff0c\u7a0e\u7387\u4e3a\u7a7a");
            fbo.setRowNum(Integer.valueOf(rowNum + 1));
            this.faild.add(fbo);
            return "\u662f\u5426\u5f00\u53d1\u7968\u4e3a\u662f\u65f6\uff0c\u7a0e\u7387\u4e3a\u7a7a";
        }
        if (whetherInvoice.equals("\u662f") && ("200000".equals(province) || "280000".equals(province)) && StringUtils.isBlank((String)taxTypeCode)) {
            ImportFaildBO fbo = new ImportFaildBO();
            logger.debug("\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e3a\u7a7a");
            fbo.setDesc("\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e3a\u7a7a");
            fbo.setRowNum(Integer.valueOf(rowNum + 1));
            this.faild.add(fbo);
            return "\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)allowNegativeStock)) {
            ImportFaildBO fbo = new ImportFaildBO();
            logger.debug("\u5141\u8bb8\u8d1f\u5e93\u5b58\u4e3a\u7a7a");
            fbo.setDesc("\u5141\u8bb8\u8d1f\u5e93\u5b58\u4e3a\u7a7a");
            fbo.setRowNum(Integer.valueOf(rowNum + 1));
            this.faild.add(fbo);
            return "\u5141\u8bb8\u8d1f\u5e93\u5b58\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)brandName)) {
            ImportFaildBO fbo = new ImportFaildBO();
            logger.debug("\u54c1\u724c\u4e3a\u7a7a");
            fbo.setDesc("\u54c1\u724c\u4e3a\u7a7a");
            fbo.setRowNum(Integer.valueOf(rowNum + 1));
            this.faild.add(fbo);
            return "\u54c1\u724c\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)supNo)) {
            ImportFaildBO fbo = new ImportFaildBO();
            logger.debug("\u4f9b\u5e94\u5546\u4e3a\u7a7a");
            fbo.setDesc("\u4f9b\u5e94\u5546\u4e3a\u7a7a");
            fbo.setRowNum(Integer.valueOf(rowNum + 1));
            this.faild.add(fbo);
            return "\u4f9b\u5e94\u5546\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)goodsLongName)) {
            ImportFaildBO fbo = new ImportFaildBO();
            logger.debug("\u5546\u54c1\u540d\u79f0\u4e3a\u7a7a");
            fbo.setDesc("\u5546\u54c1\u540d\u79f0\u4e3a\u7a7a");
            fbo.setRowNum(Integer.valueOf(rowNum + 1));
            this.faild.add(fbo);
            return "\u5546\u54c1\u540d\u79f0\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)erpGoodsType)) {
            ImportFaildBO fbo = new ImportFaildBO();
            logger.debug("\u5546\u54c1\u5206\u7c7b\u4e3a\u7a7a");
            fbo.setDesc("\u5546\u54c1\u5206\u7c7b\u4e3a\u7a7a");
            fbo.setRowNum(Integer.valueOf(rowNum + 1));
            this.faild.add(fbo);
            return "\u5546\u54c1\u5206\u7c7b\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)hasSerialNumber)) {
            ImportFaildBO fbo = new ImportFaildBO();
            logger.debug("\u662f\u5426\u6709\u4e32\u53f7\u4e3a\u7a7a");
            fbo.setDesc("\u662f\u5426\u6709\u4e32\u53f7\u4e3a\u7a7a");
            fbo.setRowNum(Integer.valueOf(rowNum + 1));
            this.faild.add(fbo);
            return "\u662f\u5426\u6709\u4e32\u53f7\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)purchaseType)) {
            ImportFaildBO fbo = new ImportFaildBO();
            logger.debug("\u91c7\u8d2d\u7c7b\u578b\u4e3a\u7a7a");
            fbo.setDesc("\u91c7\u8d2d\u7c7b\u578b\u4e3a\u7a7a");
            fbo.setRowNum(Integer.valueOf(rowNum + 1));
            this.faild.add(fbo);
            return "\u91c7\u8d2d\u7c7b\u578b\u4e3a\u7a7a";
        }
        if (!goodsType.contains(erpGoodsType)) {
            ImportFaildBO fbo = new ImportFaildBO();
            logger.debug("\u4e0d\u5b58\u5728\u7684\u5546\u54c1\u5206\u7c7b" + erpGoodsType);
            fbo.setDesc("\u4e0d\u5b58\u5728\u7684\u5546\u54c1\u5206\u7c7b" + erpGoodsType);
            fbo.setRowNum(Integer.valueOf(rowNum + 1));
            this.faild.add(fbo);
            return "\u4e0d\u5b58\u5728\u7684\u5546\u54c1\u5206\u7c7b" + erpGoodsType;
        }
        switch (purchaseType) {
            case "\u81ea\u6709": {
                break;
            }
            case "\u53d7\u6258": {
                break;
            }
            case "1": {
                break;
            }
            case "2": {
                break;
            }
            default: {
                ImportFaildBO fbo = new ImportFaildBO();
                logger.debug("\u4e0d\u5b58\u5728\u7684\u91c7\u8d2d\u7c7b\u578b" + purchaseType);
                fbo.setDesc("\u4e0d\u5b58\u5728\u7684\u91c7\u8d2d\u7c7b\u578b" + purchaseType);
                fbo.setRowNum(Integer.valueOf(rowNum + 1));
                this.faild.add(fbo);
                return "\u4e0d\u5b58\u5728\u7684\u91c7\u8d2d\u7c7b\u578b" + purchaseType;
            }
        }
        return null;
    }

    public Map<String, SupplierBO> getSupplier(List<SupplierBO> supList, String provCode) throws Exception {
        HashMap<String, SupplierBO> map = new HashMap<String, SupplierBO>();
        JSONObject param = new JSONObject();
        param.put("supplierReqList", supList);
        param.put("provinceCode", (Object)provCode);
        logger.debug(param.toString());
        String comeBack = TkHttpRequestUtils.conn(null, param.toString(), null, this.suppilerUrl, null, null);
        logger.debug(comeBack);
        JSONObject prov = JSONObject.parseObject((String)comeBack);
        if (!CollectionUtils.isEmpty((Collection)prov.getJSONArray("supplierList"))) {
            SupplierBO bo = null;
            JSONArray orgTreeBOList = prov.getJSONArray("supplierList");
            for (int i = 0; i < orgTreeBOList.size(); ++i) {
                JSONObject item = orgTreeBOList.getJSONObject(i);
                if (!StringUtils.isNotEmpty((String)item.getString("supplierId"))) continue;
                bo = new SupplierBO();
                bo.setCityCode(item.getString("cityCode"));
                bo.setProvinceCode(item.getString("provinceCode"));
                bo.setSupplierName(item.getString("supplierName"));
                bo.setSupplierId(item.getString("supplierId"));
                map.put(item.getString("supplierName"), bo);
            }
        }
        return map;
    }

    public Map<String, String> getEscape() {
        HashMap<String, String> map = new HashMap<String, String>();
        Map<String, String> typeMap = this.sysParamsAtomService.selectByParentCode("ERP_GOODS_TYPE");
        for (Map.Entry<String, String> bo : typeMap.entrySet()) {
            if (map.containsKey(bo.getKey())) continue;
            map.put(bo.getValue(), bo.getKey());
        }
        return map;
    }

    public Map<String, ProvGoodsPO> getGoodsNo(List<String> goodsNos, String provCode) {
        HashMap<String, ProvGoodsPO> map = new HashMap<String, ProvGoodsPO>();
        List<ProvGoodsPO> list = this.provGoodsDAO.selectByGoodsNo(goodsNos, provCode);
        if (!CollectionUtils.isEmpty(list)) {
            for (ProvGoodsPO po : list) {
                if (map.containsKey(po.getGoodsNo())) continue;
                map.put(po.getGoodsNo(), po);
            }
        }
        return map;
    }

    public Map<String, ProvGoodsPO> getMaterial(String province, List<String> materialIds) {
        HashMap<String, ProvGoodsPO> map = new HashMap<String, ProvGoodsPO>();
        if (!CollectionUtils.isEmpty(materialIds)) {
            List<ProvGoodsPO> poList = this.provGoodsDAO.selectByProvAndMaterial(province, materialIds);
            for (ProvGoodsPO po : poList) {
                if (map.containsKey(po.getMaterialId())) continue;
                map.put(po.getMaterialId(), po);
            }
        }
        return map;
    }

    public Map<String, MaterialPO> getScm(List<String> materialIds) {
        HashMap<String, MaterialPO> map = new HashMap<String, MaterialPO>();
        if (!CollectionUtils.isEmpty(materialIds)) {
            List<MaterialPO> poList = this.materialDAO.selectScmMaterials(materialIds);
            for (MaterialPO po : poList) {
                if (map.containsKey(po.getMaterialId())) continue;
                map.put(po.getMaterialId(), po);
            }
        }
        return map;
    }

    public Map<String, String> getCgType(List<ImportSuccessBO> rows) {
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<String> materialIds = new ArrayList<String>();
        for (ImportSuccessBO bo : rows) {
            materialIds.add(bo.getMaterialId());
        }
        List<Object> list = new ArrayList();
        if (!CollectionUtils.isEmpty(materialIds)) {
            ProvGoodsAndSupplierPO record = new ProvGoodsAndSupplierPO();
            record.setMaterialIds(materialIds);
            list = this.provGoodsDAO.selectByProvGroup(record);
        }
        if (!CollectionUtils.isEmpty(list)) {
            for (ProvGoodsAndSupplierPO po : list) {
                map.put(po.getMaterialId(), po.getCgType());
            }
        }
        return map;
    }

    public void updateBarCode(List<ImportBarCodeSuccessBO> rows) {
        this.provGoodsDAO.updateBarCodeList(rows);
    }

    public BaseRspBO delRedis(ImportProvGoodsReqBO reqBO) {
        BaseRspBO result = new BaseRspBO();
        RedisUtil.del("IMPORT_PROVINCE_GOODS" + reqBO.getProvinceCode());
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    public Set<String> getRedis(ImportProvGoodsReqBO reqBO) {
        Set<String> set = new HashSet<String>();
        try {
            set = RedisUtil.sMembers("IMPORT_PROVINCE_GOODS" + reqBO.getProvinceCode());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return set;
    }

    public String changeCellToStringDouble(Cell cell, Boolean isDecimal) {
        String returnValue = "";
        if (null != cell) {
            switch (cell.getCellType()) {
                case 0: {
                    String whatYourWant;
                    if (isDecimal.booleanValue()) {
                        String whatYourWant2;
                        DecimalFormat df = new DecimalFormat("0.0000");
                        returnValue = whatYourWant2 = df.format(cell.getNumericCellValue());
                        break;
                    }
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        Date date = cell.getDateCellValue();
                        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        returnValue = formater.format(date);
                        break;
                    }
                    DecimalFormat df = new DecimalFormat("0");
                    returnValue = whatYourWant = df.format(cell.getNumericCellValue());
                    break;
                }
                case 1: {
                    returnValue = cell.getStringCellValue();
                    break;
                }
                case 2: {
                    returnValue = cell.getCellFormula();
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    Boolean booleanValue = cell.getBooleanCellValue();
                    returnValue = booleanValue.toString();
                    break;
                }
                default: {
                    logger.error("\u672a\u77e5\u7c7b\u578b");
                }
            }
        }
        return returnValue;
    }
}

