/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.commodity.dao.SkuPriceMapper;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.toolkit.bo.InvokeInfo;
import com.tydic.newretail.toolkit.util.TKGenericServiceUtils;
import com.xls.commodity.atom.sku.DPriceSheetManageService;
import com.xls.commodity.atom.sku.XlsSkuPriceManageService;
import com.xls.commodity.busi.sku.PriceSheetChectService;
import com.xls.commodity.busi.sku.bo.DPriceSheetCheckBO;
import com.xls.commodity.busi.sku.bo.DPriceSheetCheckReqBO;
import com.xls.commodity.busi.sku.bo.PriceBO;
import com.xls.commodity.busi.sku.bo.PriceGetItemBO;
import com.xls.commodity.busi.sku.bo.PriceSheetBO;
import com.xls.commodity.busi.sku.bo.PriceSheetTakeEffectReqBO;
import com.xls.commodity.dao.PriceSheetCheckDAO;
import com.xls.commodity.dao.PriceSheetDAO;
import com.xls.commodity.dao.PriceSheetItemDAO;
import com.xls.commodity.dao.PriceSheetOrgDAO;
import com.xls.commodity.dao.ProvGoodsDAO;
import com.xls.commodity.dao.XlsSkuMapper;
import com.xls.commodity.dao.po.PriceSheetCheckPO;
import com.xls.commodity.dao.po.PriceSheetItemPO;
import com.xls.commodity.dao.po.PriceSheetOrgPO;
import com.xls.commodity.dao.po.PriceSheetPO;
import com.xls.commodity.dao.po.ProvGoodsPO;
import com.xls.commodity.dao.po.Sku;
import com.xls.commodity.intfce.sku.bo.BaseRspBO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

public class PriceSheetChectServiceImpl
implements PriceSheetChectService {
    private static final Logger logger = LoggerFactory.getLogger(PriceSheetChectServiceImpl.class);
    @Autowired
    private PriceSheetCheckDAO priceSheetCheckDAO;
    @Autowired
    private PriceSheetItemDAO priceSheetItemDAO;
    @Autowired
    private XlsSkuMapper xlsSkuMapper;
    @Autowired
    private SkuPriceMapper skuPriceMapper;
    @Autowired
    private XlsSkuPriceManageService xlsSkuPriceManageService;
    @Autowired
    private PriceSheetDAO priceSheetDAO;
    @Autowired
    private PriceSheetOrgDAO priceSheetOrgDAO;
    @Autowired
    private ProvGoodsDAO provGoodsDAO;
    @Autowired
    private DPriceSheetManageService dPriceSheetManageService;
    private Set<String> faild;
    @Value(value="${hsf.version}")
    private String hsfVersion;
    @Value(value="${hsf.group}")
    private String hsfGroup;
    @Value(value="${hsf.clientTimeout}")
    private String hsfClientTimeout;

    public BaseRspBO priceSheetChect(DPriceSheetCheckReqBO reqBO) {
        BaseRspBO result = new BaseRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getdPriceSheetCheckBO())) {
            logger.debug("\u62a5\u4ef7\u5355\u5ba1\u6838\u63a5\u53e3 \u5165\u53c2\u4e3a\u7a7a");
            result.setRespCode("8888");
            result.setRespDesc("\u62a5\u4ef7\u5355\u5ba1\u6838\u63a5\u53e3 \u5165\u53c2\u4e3a\u7a7a");
            return result;
        }
        for (DPriceSheetCheckBO dPriceSheetCheckBO : reqBO.getdPriceSheetCheckBO()) {
            if (dPriceSheetCheckBO.getSheetId() != null && !StringUtils.isEmpty((String)dPriceSheetCheckBO.getCheckStatus())) continue;
            logger.debug("\u62a5\u4ef7\u5355ID\u4e3a\u7a7a\u6216\u5ba1\u6838\u72b6\u6001\u4e3a\u7a7a");
            result.setRespCode("8888");
            result.setRespDesc("\u62a5\u4ef7\u5355ID\u4e3a\u7a7a\u6216\u5ba1\u6838\u72b6\u6001\u4e3a\u7a7a");
            return result;
        }
        ArrayList<Long> sheetIds = new ArrayList<Long>();
        try {
            boolean flag = false;
            if ("02".equals(((DPriceSheetCheckBO)reqBO.getdPriceSheetCheckBO().get(0)).getCheckStatus())) {
                flag = true;
            }
            ArrayList<PriceSheetCheckPO> priceSheetCheckPO = new ArrayList<PriceSheetCheckPO>();
            Object po = null;
            ArrayList<PriceSheetPO> priceSheetPOList = new ArrayList<PriceSheetPO>();
            PriceSheetPO priceSheetPO = null;
            for (DPriceSheetCheckBO dPriceSheetCheckBO : reqBO.getdPriceSheetCheckBO()) {
                priceSheetPO = new PriceSheetPO();
                priceSheetPO.setSheetId(dPriceSheetCheckBO.getSheetId());
                priceSheetPO.setUpdateTime(new Date());
                priceSheetPO.setCheckStatus(dPriceSheetCheckBO.getCheckStatus());
                priceSheetPOList.add(priceSheetPO);
                sheetIds.add(dPriceSheetCheckBO.getSheetId());
                po = new PriceSheetCheckPO();
                BeanUtils.copyProperties((Object)dPriceSheetCheckBO, (Object)po);
                ((PriceSheetCheckPO)po).setCheckTime(new Date());
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                ((PriceSheetCheckPO)po).setCreateTime(dateFormat.format(new Date()));
                priceSheetCheckPO.add((PriceSheetCheckPO)po);
            }
            this.add(priceSheetCheckPO);
            this.priceSheetDAO.updateList(priceSheetPOList);
            if (flag) {
                result.setRespCode("0000");
                result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
                return result;
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5ba1\u6838\u63d2\u5165\u62a5\u9519");
            throw new BusinessException("9999", "\u67e5\u8be2\u5ba1\u6838\u63d2\u5165\u62a5\u9519" + e.getMessage());
        }
        List priceSheetBOS = this.dPriceSheetManageService.selectBySheetId(sheetIds);
        if (CollectionUtils.isEmpty((Collection)priceSheetBOS)) {
            logger.debug("\u8be5\u62a5\u4ef7\u5355id\u6ca1\u6709\u62a5\u4ef7\u5355\u4fe1\u606f");
            result.setRespCode("8888");
            result.setRespDesc("\u8be5\u62a5\u4ef7\u5355id\u6ca1\u6709\u62a5\u4ef7\u5355\u4fe1\u606f");
            return result;
        }
        List<Long> isEffectTimeSheetId = this.getIsEffectTimeSheetId(priceSheetBOS);
        try {
            if (!CollectionUtils.isEmpty(isEffectTimeSheetId)) {
                for (Long s : isEffectTimeSheetId) {
                    ArrayList<Long> sheetID = new ArrayList<Long>();
                    sheetID.add(s);
                    this.check(sheetID);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u62a5\u4ef7\u62a5\u9519");
            throw new BusinessException("9999", "\u4fee\u6539\u62a5\u4ef7\u62a5\u9519\u62a5\u9519" + e.getMessage());
        }
        result.setRespCode("0000");
        if (CollectionUtils.isEmpty(this.faild)) {
            result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        } else {
            result.setRespDesc(this.faild.toString());
        }
        return result;
    }

    public BaseRspBO priceSheetTakeEffect(PriceSheetTakeEffectReqBO reqBO) {
        BaseRspBO result = new BaseRspBO();
        logger.debug("\u5165\u53c2date\uff1a" + JSON.toJSONString((Object)reqBO));
        Date startTime = null;
        try {
            if (StringUtils.isBlank((String)reqBO.getDate())) {
                Date date = new Date();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                String text = simpleDateFormat.format(date);
                startTime = simpleDateFormat.parse(text);
            } else {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                startTime = simpleDateFormat.parse(reqBO.getDate());
            }
        }
        catch (ParseException e) {
            logger.error("\u65f6\u95f4\u8f6c\u5316\u9519\u8bef" + e.getMessage());
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            return result;
        }
        logger.debug("\u5f00\u59cb\u65f6\u95f4" + JSON.toJSONString((Object)startTime));
        if (startTime == null) {
            logger.error("\u5165\u53c2\u65f6\u95f4\u4e3a\u7a7a");
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            return result;
        }
        ArrayList sheetIds = new ArrayList();
        try {
            List<PriceSheetPO> priceSheetPOS = this.priceSheetDAO.selectByEffectTime(startTime);
            priceSheetPOS.stream().forEach(str -> sheetIds.add(str.getSheetId()));
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u62a5\u4ef7\u5355\u4fe1\u606f\u51fa\u9519" + e.getMessage());
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            return result;
        }
        logger.debug("\u62a5\u4ef7\u5355id\uff1a" + JSON.toJSONString(sheetIds));
        try {
            if (!CollectionUtils.isEmpty(sheetIds)) {
                sheetIds.stream().forEach(str -> {
                    ArrayList<Long> sheetId = new ArrayList<Long>();
                    sheetId.add((Long)str);
                    this.check(sheetId);
                });
            }
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u62a5\u4ef7\u62a5\u9519" + e.getMessage());
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            return result;
        }
        result.setRespCode("0000");
        if (CollectionUtils.isEmpty(this.faild)) {
            result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        } else {
            result.setRespDesc(this.faild.toString());
        }
        return result;
    }

    public void check(List<Long> sheetIds) {
        ArrayList<PriceSheetItemPO> item = new ArrayList();
        ArrayList<PriceSheetOrgPO> org = new ArrayList();
        try {
            logger.debug("\u67e5\u8be2\u62a5\u4ef7\u5355\u8be6\u60c5" + sheetIds);
            item = this.priceSheetItemDAO.selectBySheetIds(sheetIds);
            org = this.priceSheetOrgDAO.selectBySheetIds(sheetIds);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u62a5\u4ef7\u5355\u8be6\u60c5\u62a5\u9519");
            throw new BusinessException("9999", "\u67e5\u8be2\u62a5\u4ef7\u5355\u8be6\u60c5\u62a5\u9519" + e.getMessage());
        }
        HashMap<String, PriceSheetItemPO> itemMap = new HashMap<String, PriceSheetItemPO>();
        logger.debug("\u533a\u5206\u662f\u5426\u5168\u8986\u76d6");
        ArrayList<PriceSheetItemPO> coverChangeList = new ArrayList<PriceSheetItemPO>();
        ArrayList<PriceSheetItemPO> noCoverChangeList = new ArrayList<PriceSheetItemPO>();
        ArrayList<PriceSheetItemPO> coverNoChangeList = new ArrayList<PriceSheetItemPO>();
        ArrayList<PriceSheetItemPO> noCoverNoChangeList = new ArrayList<PriceSheetItemPO>();
        Map<String, String> provGoodsMap = this.getIsChange(item, org);
        for (PriceSheetItemPO ite : item) {
            if ("1".equals(ite.getIsCover())) {
                if ("1".equals(provGoodsMap.get(ite.getMaterialId()))) {
                    coverChangeList.add(ite);
                } else if ("0".equals(provGoodsMap.get(ite.getMaterialId()))) {
                    coverNoChangeList.add(ite);
                }
            } else if ("1".equals(provGoodsMap.get(ite.getMaterialId()))) {
                noCoverChangeList.add(ite);
            } else if ("0".equals(provGoodsMap.get(ite.getMaterialId()))) {
                noCoverNoChangeList.add(ite);
            }
            if (itemMap.containsKey(ite.getMaterialId().trim())) continue;
            itemMap.put(ite.getMaterialId().trim(), ite);
        }
        this.faild = new HashSet<String>();
        try {
            if (!CollectionUtils.isEmpty(coverChangeList)) {
                this.method(coverChangeList, itemMap, 1, org);
            }
            if (!CollectionUtils.isEmpty(noCoverChangeList)) {
                this.method(noCoverChangeList, itemMap, 3, org);
            }
            if (!CollectionUtils.isEmpty(coverNoChangeList)) {
                this.method(coverNoChangeList, itemMap, 4, org);
            }
            if (!CollectionUtils.isEmpty(noCoverNoChangeList)) {
                this.method(noCoverNoChangeList, itemMap, 2, org);
            }
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u62a5\u4ef7\u62a5\u9519");
            throw new BusinessException("9999", "\u4fee\u6539\u62a5\u4ef7\u62a5\u9519\u62a5\u9519" + e.getMessage());
        }
    }

    public void add(List<PriceSheetCheckPO> po) throws Exception {
        this.priceSheetCheckDAO.insertList(po);
    }

    public void getPrice(List<Sku> param, int flag, Map<String, PriceSheetItemPO> itemMap, String provinceCode) {
        ArrayList<Sku> skus = new ArrayList<Sku>();
        ArrayList<Object> priceBOs = new ArrayList<PriceBO>();
        ExecutorService service = Executors.newFixedThreadPool(9);
        for (Sku sk : param) {
            try {
                PriceSheetItemPO priceSheetItemPO = itemMap.get(sk.getMaterialId());
                switch (flag) {
                    case 1: {
                        if (sk.getSkuStatus() == 5) {
                            sk.setSkuStatus(2);
                        } else if (sk.getSkuStatus() == 4) {
                            sk.setSkuStatus(1);
                        }
                        sk.setSkuPrice(priceSheetItemPO.getSalePrice());
                        sk.setUpdateTime(new Date());
                        sk.setProvinceCode(provinceCode);
                        skus.add(sk);
                        PriceBO priceBO = this.buildPrice(sk, priceSheetItemPO, provinceCode);
                        priceBOs.add(priceBO);
                        break;
                    }
                    case 2: {
                        this.faild.add(sk.getMaterialId() + "\uff1a\u7269\u6599\u4e0d\u53ef\u4fee\u6539\uff0c\u4e0d\u5168\u8986\u76d6");
                        break;
                    }
                    case 3: {
                        if (!"1".equals(sk.getHasPriceSheet())) {
                            if (sk.getSkuStatus() == 5) {
                                sk.setSkuStatus(2);
                            } else if (sk.getSkuStatus() == 4) {
                                sk.setSkuStatus(1);
                            }
                            sk.setSkuPrice(priceSheetItemPO.getSalePrice());
                            sk.setUpdateTime(new Date());
                            sk.setProvinceCode(provinceCode);
                            skus.add(sk);
                            PriceBO priceBO2 = this.buildPrice(sk, priceSheetItemPO, provinceCode);
                            priceBOs.add(priceBO2);
                            break;
                        }
                        this.faild.add(sk.getMaterialId() + "\uff1a\u7269\u6599\u5df2\u5b58\u5728\u62a5\u4ef7\u5355\uff0c\u4e14\u4e0d\u5168\u8986\u76d6");
                        break;
                    }
                    case 4: {
                        PriceBO priceBO3;
                        if (!"1".equals(sk.getHasPriceSheet())) {
                            if (sk.getSkuStatus() == 5) {
                                sk.setSkuStatus(2);
                            } else if (sk.getSkuStatus() == 4) {
                                sk.setSkuStatus(1);
                            }
                            sk.setSkuPrice(priceSheetItemPO.getSalePrice());
                            sk.setUpdateTime(new Date());
                            sk.setProvinceCode(provinceCode);
                            skus.add(sk);
                            priceBO3 = this.buildPrice(sk, priceSheetItemPO, provinceCode);
                            priceBOs.add(priceBO3);
                            break;
                        }
                        if ("1".equals(sk.getHasPriceSheet())) {
                            if (!"1".equals(sk.getSheetLevel())) {
                                if (sk.getSkuStatus() == 5) {
                                    sk.setSkuStatus(2);
                                } else if (sk.getSkuStatus() == 4) {
                                    sk.setSkuStatus(1);
                                }
                                sk.setSkuPrice(priceSheetItemPO.getSalePrice());
                                sk.setUpdateTime(new Date());
                                sk.setProvinceCode(provinceCode);
                                skus.add(sk);
                                PriceBO priceBO4 = this.buildPrice(sk, priceSheetItemPO, provinceCode);
                                priceBOs.add(priceBO4);
                                break;
                            }
                            this.faild.add(sk.getMaterialId() + "\uff1a\u7269\u6599\u5df2\u5b58\u5728\u603b\u90e8\u62a5\u4ef7\u5355\uff0c\u4e14\u4e0d\u53ef\u4fee\u6539");
                            break;
                        }
                        if (sk.getSkuStatus() == 5) {
                            sk.setSkuStatus(2);
                        } else if (sk.getSkuStatus() == 4) {
                            sk.setSkuStatus(1);
                        }
                        sk.setSkuPrice(priceSheetItemPO.getSalePrice());
                        sk.setUpdateTime(new Date());
                        sk.setProvinceCode(provinceCode);
                        skus.add(sk);
                        priceBO3 = this.buildPrice(sk, priceSheetItemPO, provinceCode);
                        priceBOs.add(priceBO3);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(e.getMessage());
                logger.debug("\u83b7\u53d6\u4ef7\u683c\u62a5\u9519");
                throw new BusinessException("9999", "\u83b7\u53d6\u4ef7\u683c\u62a5\u9519" + e.getMessage());
            }
            if (skus.size() < 50000 || priceBOs.size() < 50000) continue;
            try {
                this.updatePrice(skus, priceBOs, service);
            }
            catch (Exception e) {
                service.shutdown();
                logger.error("\u4fee\u6539\u5546\u54c1\u4ef7\u683c\u5931\u8d25\uff01" + e.getMessage());
                throw new BusinessException("9999", "\u4fee\u6539\u5546\u54c1\u4ef7\u683c\u5931\u8d25" + e.getMessage());
            }
            skus = new ArrayList();
            priceBOs = new ArrayList();
        }
        if (!CollectionUtils.isEmpty(skus) && !CollectionUtils.isEmpty(priceBOs)) {
            try {
                this.updatePrice(skus, priceBOs, service);
            }
            catch (Exception e) {
                service.shutdown();
                logger.error("\u4fee\u6539\u5546\u54c1\u4ef7\u683c\u5931\u8d25\uff01" + e.getMessage());
                throw new BusinessException("9999", "\u4fee\u6539\u5546\u54c1\u4ef7\u683c\u5931\u8d25" + e.getMessage());
            }
            finally {
                service.shutdown();
            }
        } else {
            service.shutdown();
        }
    }

    public List<Sku> getSku(List<Long> supplierIds, List<PriceSheetItemPO> item, String orgType, String provinceCode) throws Exception {
        logger.debug("\u83b7\u53d6sku");
        ArrayList<String> materialIds = new ArrayList<String>();
        for (PriceSheetItemPO material : item) {
            materialIds.add(material.getMaterialId());
        }
        List<Sku> poList = new ArrayList<Sku>();
        if (StringUtils.isNotEmpty((String)orgType) && StringUtils.isNotEmpty((String)provinceCode)) {
            logger.debug("\u6839\u636e\u7701\u4efd\u52a0\u7269\u6599\u67e5\u8be2sku" + provinceCode);
            Sku sku = new Sku();
            sku.setMaterialIds(materialIds);
            sku.setProvinceCode(provinceCode);
            poList = this.xlsSkuMapper.selectSkuListForBackgroundPart(sku);
        } else if (!CollectionUtils.isEmpty(materialIds) && !CollectionUtils.isEmpty(supplierIds)) {
            logger.debug("\u95e8\u5e97\u6570\u91cf" + supplierIds.size());
            poList = this.xlsSkuMapper.queryXlsSkuByMaterialsAndShopListPart(supplierIds, materialIds);
        }
        logger.debug("\u83b7\u53d6\u7684sku\u6570\u91cf=" + poList.size());
        return poList;
    }

    public List<Long> getShopIdLidt(Map<String, List<String>> map) throws Exception {
        List<String> provCode = map.get("orgTreePath");
        ArrayList<Long> shopCode = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty(provCode)) {
            List<Long> provShop = this.getProvCode(provCode);
            for (Long shop : provShop) {
                shopCode.add(shop);
            }
        }
        return shopCode;
    }

    public PriceGetItemBO getItem(List<PriceSheetOrgPO> item) throws Exception {
        PriceGetItemBO priceGetItemBO = new PriceGetItemBO();
        String orgType = null;
        String provinceCode = null;
        HashMap map = new HashMap();
        ArrayList<String> orgTreePath = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(item)) {
            for (PriceSheetOrgPO po : item) {
                provinceCode = po.getProvinceCode();
                if ("2".equals(po.getOrgLevel())) {
                    orgType = po.getOrgLevel();
                    logger.debug("\u516c\u53f8\u8303\u56f4\u91cc\u9762\u6709=" + provinceCode);
                    break;
                }
                orgTreePath.add(po.getOrgTreePath());
            }
            map.put("orgTreePath", orgTreePath);
            logger.debug(((Object)map).toString());
        }
        priceGetItemBO.setOrgType(orgType);
        priceGetItemBO.setProvinceCode(provinceCode);
        priceGetItemBO.setMap(map);
        return priceGetItemBO;
    }

    public Map<String, String> getIsChange(List<PriceSheetItemPO> items, List<PriceSheetOrgPO> orgs) {
        ArrayList<String> materialIds = new ArrayList<String>();
        ArrayList<String> provCodes = new ArrayList<String>();
        for (PriceSheetItemPO item : items) {
            materialIds.add(item.getMaterialId());
        }
        for (PriceSheetOrgPO org : orgs) {
            provCodes.add(org.getProvinceCode());
        }
        HashMap<String, String> map = new HashMap<String, String>();
        List<ProvGoodsPO> poList = this.provGoodsDAO.selectByProvAndMaterial((String)provCodes.get(0), materialIds);
        for (ProvGoodsPO po : poList) {
            if ("1".equals(po.getReservedField3()) || StringUtils.isBlank((String)po.getReservedField3())) {
                map.put(po.getMaterialId(), "1");
                continue;
            }
            map.put(po.getMaterialId(), "0");
        }
        return map;
    }

    public void updatePrice(List<Sku> skus, List<PriceBO> priceBOs, ExecutorService service) throws Exception {
        logger.debug("\u4fee\u6539sku\u4ef7\u683c" + skus.size());
        logger.debug("\u4fee\u6539\u4ef7\u683c" + priceBOs.size());
        this.updateXlsSkuMapper(skus, service);
        logger.debug("\u4fee\u6539sku\u4ef7\u683c\u5b8c\u6210");
        this.updateXlsSkuPriceManage(priceBOs, service);
        logger.debug("\u4fee\u6539sku\u4ef7\u683c\u5b8c\u6210");
    }

    public PriceBO buildPrice(Sku sk, PriceSheetItemPO priceSheetItemPO, String provinceCode) {
        PriceBO priceBO = new PriceBO();
        priceBO.setSkuId(sk.getSkuId());
        if (!"1".equals(sk.getSheetLevel())) {
            priceBO.setAgreementPrice(priceSheetItemPO.getAgreementPrice());
        }
        priceBO.setPurchaseFloorPrice(priceSheetItemPO.getPurchaseFloorPrice());
        priceBO.setRetailAgreementPrice(priceSheetItemPO.getRetailAgreementPrice());
        priceBO.setCitiesLockPrice(priceSheetItemPO.getCitiesLockPrice());
        priceBO.setTheCostDownPrice(priceSheetItemPO.getTheCostDownPrice());
        priceBO.setAssessmentPrice(priceSheetItemPO.getAssessmentPrice());
        priceBO.setCgType(sk.getCgType());
        priceBO.setCostPrice(priceSheetItemPO.getCostPrice());
        priceBO.setLastPurchasePrice(priceSheetItemPO.getLastPurchasePrice());
        priceBO.setMarketPrice(priceSheetItemPO.getSalePrice());
        priceBO.setMemberLadderPrice1(priceSheetItemPO.getMemberLadderPrice1());
        priceBO.setMemberLadderPrice2(priceSheetItemPO.getMemberLadderPrice2());
        priceBO.setMemberLadderPrice3(priceSheetItemPO.getMemberLadderPrice3());
        priceBO.setMemberLadderPrice4(priceSheetItemPO.getMemberLadderPrice4());
        priceBO.setMemberLadderPrice5(priceSheetItemPO.getMemberLadderPrice5());
        priceBO.setMemberPrice(priceSheetItemPO.getMemberPrice());
        priceBO.setSparePrice1(priceSheetItemPO.getPurchasePrice());
        priceBO.setFixedRoyalty(priceSheetItemPO.getFixedRoyalty());
        priceBO.setGroupRoyalty(priceSheetItemPO.getGroupRoyalty());
        priceBO.setProfitRoyalty(priceSheetItemPO.getProfitRoyalty());
        priceBO.setRoyaltyRatio(priceSheetItemPO.getRoyaltyRatio());
        priceBO.setScore(priceSheetItemPO.getScore());
        priceBO.setSalePrice(priceSheetItemPO.getSalePrice());
        priceBO.setSheetLevel(priceSheetItemPO.getSheetLevel());
        priceBO.setSheetId(priceSheetItemPO.getSheetId());
        priceBO.setSparePrice2(priceSheetItemPO.getSparePrice2());
        priceBO.setSparePrice3(priceSheetItemPO.getSparePrice3());
        priceBO.setSparePrice4(priceSheetItemPO.getSparePrice4());
        priceBO.setSparePrice5(priceSheetItemPO.getSparePrice5());
        priceBO.setTradePrice(priceSheetItemPO.getTradePrice());
        priceBO.setProvAgreePrice(priceSheetItemPO.getProvAgreePrice());
        priceBO.setUpdateTime(new Date());
        priceBO.setHasPriceSheet("1");
        priceBO.setProvinceCode(provinceCode);
        return priceBO;
    }

    private void updateXlsSkuPriceManage(List<PriceBO> priceBOList, ExecutorService service) {
        logger.debug("\u4fee\u6539sku" + priceBOList.size());
        int pointsDataLimit = 5000;
        Integer size = priceBOList.size();
        int part = size / pointsDataLimit;
        int len = size % pointsDataLimit == 0 ? part : part + 1;
        logger.debug("\u4fee\u6539skuPrice" + size + "\u6761\u6570\u636e\u3002\u5206" + len + "\u6b21\u6267\u884c");
        for (int i = 0; i < len; ++i) {
            logger.debug("\u7b2c" + i + "\u6279\u6570\u636e");
            int start = i * pointsDataLimit;
            int end = start + pointsDataLimit;
            if (end > size) {
                end = size;
            }
            logger.debug("\u5f00\u59cb\u7ed3\u675f=" + start + "+" + end);
            final List<PriceBO> rows = priceBOList.subList(start, end);
            service.execute(new Runnable(){

                @Override
                public void run() {
                    PriceSheetChectServiceImpl.this.xlsSkuPriceManageService.batchUpdateSkuPrice(rows);
                }
            });
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        priceBOList = null;
    }

    private void updateXlsSkuMapper(List<Sku> price, ExecutorService service) {
        logger.debug("\u4fee\u6539skuPrice" + price.size());
        int pointsDataLimit = 5000;
        Integer size = price.size();
        int part = size / pointsDataLimit;
        int len = size % pointsDataLimit == 0 ? part : part + 1;
        logger.debug("\u4fee\u6539sku\u5546\u54c1\u5171" + size + "\u6761\u6570\u636e\u3002\u5206" + len + "\u6b21\u6267\u884c");
        for (int i = 0; i < len; ++i) {
            logger.debug("\u7b2c" + i + "\u6279\u6570\u636e");
            int start = i * pointsDataLimit;
            int end = start + pointsDataLimit;
            if (end > size) {
                end = size;
            }
            logger.debug("\u5f00\u59cb\u7ed3\u675f=" + start + "+" + end);
            final List<Sku> rows = price.subList(start, end);
            service.execute(new Runnable(){

                @Override
                public void run() {
                    PriceSheetChectServiceImpl.this.xlsSkuMapper.batchUpdateBySkuId(rows);
                }
            });
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        price = null;
    }

    public void method(List<PriceSheetItemPO> item, Map<String, PriceSheetItemPO> itemMap, int flag, List<PriceSheetOrgPO> org) {
        logger.debug("\u53ef\u4fee\u6539");
        PriceGetItemBO priceGetItemBO = new PriceGetItemBO();
        try {
            priceGetItemBO = this.getItem(org);
            logger.debug("priceGetItemBO=" + JSON.toJSONString((Object)priceGetItemBO));
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            logger.debug("\u83b7\u53d6\u7701\u4efd\u7f16\u7801\u7269\u6599\u7f16\u7801\u62a5\u9519");
            throw new BusinessException("9999", "\u4fee\u6539\u62a5\u4ef7\u62a5\u9519\u62a5\u9519" + e.getMessage());
        }
        List<Long> supplierIds = new ArrayList<Long>();
        if (StringUtils.isEmpty((String)priceGetItemBO.getOrgType())) {
            try {
                Map map = priceGetItemBO.getMap();
                if (!CollectionUtils.isEmpty((Map)map)) {
                    supplierIds = this.getShopIdLidt(map);
                    logger.debug("\u6ca1\u6709\u7701\u4efd\u67e5\u8be2\u7684\u95e8\u5e97\u5217\u8868=" + supplierIds.size());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(e.getMessage());
                logger.debug("\u83b7\u53d6\u95e8\u5e97\u62a5\u9519");
                throw new BusinessException("9999", "\u4fee\u6539\u62a5\u4ef7\u62a5\u9519\u62a5\u9519" + e.getMessage());
            }
        }
        ArrayList<Sku> record = new ArrayList();
        try {
            record = this.getSku(supplierIds, item, priceGetItemBO.getOrgType(), priceGetItemBO.getProvinceCode());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            logger.debug("\u83b7\u53d6\u95e8\u5e97\u7269\u6599\u5bf9\u5e94sku\u62a5\u9519");
            throw new BusinessException("9999", "\u4fee\u6539\u62a5\u4ef7\u62a5\u9519\u62a5\u9519" + e.getMessage());
        }
        if (!CollectionUtils.isEmpty(record)) {
            this.getPrice(record, flag, itemMap, priceGetItemBO.getProvinceCode());
        }
    }

    public List<Long> getProvCode(List<String> provCodes) throws Exception {
        ArrayList<Long> list = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty(provCodes)) {
            for (String orgTreePath : provCodes) {
                JSONObject param = new JSONObject();
                param.put("orgTreePath", (Object)orgTreePath);
                param.put("queryType", (Object)4);
                param.put("isCutoverFlag", (Object)1);
                param.put("isFilteStoreId", (Object)0);
                param.put("allStatus", (Object)1);
                InvokeInfo invokeInfo = new InvokeInfo("com.ohaotian.authority.organisation.service.SelectOrgTreeService", "selectOrgTree", "com.ohaotian.authority.organisation.bo.SelectOrgTreeReqBO");
                invokeInfo.setVersion(this.hsfVersion);
                invokeInfo.setGroup(this.hsfGroup);
                invokeInfo.setClientTimeout(Integer.valueOf(this.hsfClientTimeout));
                invokeInfo.setRegisterType("2");
                JSONObject prov = TKGenericServiceUtils.genericServiceInvoke((String)JSONObject.toJSONString((Object)param), null, (InvokeInfo)invokeInfo);
                if (CollectionUtils.isEmpty((Collection)prov.getJSONArray("orgTreeBOList"))) continue;
                JSONArray orgTreeBOList = prov.getJSONArray("orgTreeBOList");
                for (int i = 0; i < orgTreeBOList.size(); ++i) {
                    JSONObject item = orgTreeBOList.getJSONObject(i);
                    if (!StringUtils.isNotEmpty((String)item.getString("storeId"))) continue;
                    list.add(Long.parseLong(item.getString("storeId")));
                }
            }
        }
        return list;
    }

    public List<Long> getIsEffectTimeSheetId(List<PriceSheetBO> priceSheetBOS) {
        BaseRspBO result = new BaseRspBO();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String date = sdf.format(new Date());
        ArrayList<Long> sheetId = new ArrayList<Long>();
        for (PriceSheetBO priceSheetBO : priceSheetBOS) {
            if (StringUtils.isNotEmpty((String)priceSheetBO.getEffectTime())) {
                String effectTime = priceSheetBO.getEffectTime();
                String substringEffectTime = effectTime.substring(0, 10);
                try {
                    if (sdf.parse(date).compareTo(sdf.parse(substringEffectTime)) < 0) continue;
                    sheetId.add(priceSheetBO.getSheetId());
                }
                catch (ParseException e) {
                    logger.error("busi\u5c42\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38");
                    e.printStackTrace();
                }
                continue;
            }
            sheetId.add(priceSheetBO.getSheetId());
        }
        return sheetId;
    }
}

