/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.xls.commodity.atom.sku.SysParamsAtomService;
import com.xls.commodity.busi.sku.ProvGoodsQueryService;
import com.xls.commodity.busi.sku.QueryDMaterialDefineService;
import com.xls.commodity.busi.sku.QuerySkuListByMaterialsAndShopIdService;
import com.xls.commodity.busi.sku.bo.DMaterialDefineBO;
import com.xls.commodity.busi.sku.bo.ProvGoodsBO;
import com.xls.commodity.busi.sku.bo.ProvGoodsQueryReqBO;
import com.xls.commodity.busi.sku.bo.ProvGoodsSupRelationBO;
import com.xls.commodity.busi.sku.bo.QueryProvGoodsAndSupplierResBO;
import com.xls.commodity.busi.sku.bo.QuerySkuListByMaterialsAndShopIdReqBO;
import com.xls.commodity.busi.sku.bo.QuerySkuListByMaterialsResBO;
import com.xls.commodity.busi.sku.bo.SelectByBossColorAndBoseCodeListReqBO;
import com.xls.commodity.busi.sku.bo.SkuAndPriceAndSpecBO;
import com.xls.commodity.busi.sku.bo.SupplierBO;
import com.xls.commodity.busi.sku.bo.SysParamTransBusiBO;
import com.xls.commodity.dao.ProvGoodsDAO;
import com.xls.commodity.dao.ProvGoodsSupRelationDAO;
import com.xls.commodity.dao.XlsSkuMapper;
import com.xls.commodity.dao.po.ProvGoodsAndSupplierPO;
import com.xls.commodity.dao.po.ProvGoodsPO;
import com.xls.commodity.dao.po.ProvGoodsSupRelationPO;
import com.xls.commodity.dao.po.Sku;
import com.xls.commodity.intfce.sku.bo.BaseRspBO;
import com.xls.commodity.intfce.sku.bo.RspInfoListBO;
import com.xls.commodity.intfce.sku.bo.RspPageBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProvGoodsQueryServiceImpl
implements ProvGoodsQueryService {
    private static final Logger logger = LoggerFactory.getLogger(ProvGoodsQueryServiceImpl.class);
    @Autowired
    private ProvGoodsDAO provGoodsDAO;
    @Autowired
    private SysParamsAtomService sysParamsAtomService;
    @Autowired
    private ProvGoodsSupRelationDAO provGoodsSupRelationDAO;
    @Autowired
    private QueryDMaterialDefineService queryDMaterialDefineService;
    @Autowired
    private QuerySkuListByMaterialsAndShopIdService querySkuListByMaterialsAndShopIdService;
    @Autowired
    private XlsSkuMapper xlsSkuMapper;

    public RspPageBO<ProvGoodsBO> queryProvGoodsByPage(ProvGoodsQueryReqBO reqBO) {
        logger.debug("\u8c03\u7528\u7701\u4efd\u5546\u54c1\u5206\u9875\u67e5\u8be2\uff08\u7269\u6599\u7f16\u7801\u5165\u53c2\u4e3alist\uff09\u7684\u63a5\u53e3\uff1a" + JSON.toJSONString((Object)reqBO) + "null");
        RspPageBO result = new RspPageBO();
        ProvGoodsAndSupplierPO record = new ProvGoodsAndSupplierPO();
        record.setMaterialId(reqBO.getMaterialId());
        record.setMaterialIds(reqBO.getMaterialIds());
        record.setBrandId(reqBO.getBrandId());
        record.setGoodsLongName(reqBO.getGoodsLongName());
        record.setGoodsNo(reqBO.getGoodsNo());
        record.setGoodsSource(reqBO.getGoodsSource());
        record.setSupNo(reqBO.getSupNo());
        record.setGoodsType(reqBO.getGoodsType());
        record.setErpGoodsType(reqBO.getErpGoodsType());
        record.setCgType(reqBO.getCgType());
        record.setGoodsModel(reqBO.getGoodsModel());
        record.setColorName(reqBO.getColorName());
        record.setBrandName(reqBO.getBrandName());
        record.setGoodsStatus(reqBO.getGoodsStatus());
        record.setProvinceCode(reqBO.getmProvince());
        Page page = new Page();
        page.setPageSize(reqBO.getPageSize());
        page.setPageNo(reqBO.getCurrent());
        ArrayList<ProvGoodsBO> rows = new ArrayList<ProvGoodsBO>();
        try {
            List<ProvGoodsAndSupplierPO> poList = this.provGoodsDAO.queryProvGoodsByMaterialIDList(record, (Page<ProvGoodsAndSupplierPO>)page);
            if (!CollectionUtils.isEmpty(poList)) {
                Map<String, DMaterialDefineBO> define = this.getGoodsType();
                logger.debug("\u67e5\u8be2\u7801\u8868");
                Map<String, Map<String, String>> escaMap = this.getEscape();
                for (ProvGoodsAndSupplierPO po : poList) {
                    ProvGoodsBO bo = new ProvGoodsBO();
                    BeanUtils.copyProperties((Object)po, (Object)bo);
                    bo.setDescribe(po.getProvDescribe());
                    bo.setGoodsTypeStr(define.get(po.getGoodsType()) == null ? null : define.get(po.getGoodsType()).getDataName());
                    if (StringUtils.isNotEmpty((String)po.getBossCode())) {
                        bo.setBossCode(po.getBossCode().substring(1, po.getBossCode().length() - 1));
                    }
                    bo.setReservedField2Str(ObjectUtils.equals((Object)po.getReservedField2(), (Object)"1") ? "\u662f" : "\u5426");
                    rows.add(this.transferredMeaning(escaMap, bo));
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u7701\u4efd\u5546\u54c1\u5206\u9875\u67e5\u8be2\u63a5\u53e3\u62a5\u9519");
            throw new BusinessException("9999", "\u8c03\u7528\u7701\u4efd\u5546\u54c1\u5206\u9875\u67e5\u8be2\u63a5\u53e3\u62a5\u9519" + e.getMessage());
        }
        result.setRecordsTotal(page.getTotalCount());
        result.setTotal(page.getTotalPages());
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        result.setRows(rows);
        return result;
    }

    public QueryProvGoodsAndSupplierResBO queryByProvGoodsId(ProvGoodsQueryReqBO reqBO) {
        QueryProvGoodsAndSupplierResBO result = new QueryProvGoodsAndSupplierResBO();
        logger.debug("\u6839\u636e\u7701\u4efd\u5546\u54c1id\u67e5\u8be2\u8be6\u60c5\uff1a");
        if (reqBO.getProvGoodsId() == null) {
            result.setRespCode("9999");
            result.setRespDesc("\u7cfb\u7edf\u5f02\u5e38");
            return result;
        }
        ProvGoodsBO bo = null;
        ArrayList<ProvGoodsSupRelationBO> rows = new ArrayList<ProvGoodsSupRelationBO>();
        logger.debug("\u67e5\u8be2\u7801\u8868");
        Map<String, Map<String, String>> escaMap = this.getEscape();
        try {
            logger.debug("\u67e5\u8be2\u7701\u4efd\u5546\u54c1");
            ProvGoodsPO po = this.provGoodsDAO.selectByPrimaryKey(reqBO.getProvGoodsId());
            bo = new ProvGoodsBO();
            BeanUtils.copyProperties((Object)po, (Object)bo);
            if (StringUtils.isNotEmpty((String)po.getBossCode())) {
                bo.setBossCode(po.getBossCode().substring(1, po.getBossCode().length() - 1));
            }
            bo.setReservedField2Str(ObjectUtils.equals((Object)po.getReservedField2(), (Object)"1") ? "\u662f" : "\u5426");
            bo = this.transferredMeaning(escaMap, bo);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7701\u4efd\u5546\u54c1\u62a5\u9519");
            throw new BusinessException("9999", "\u67e5\u8be2\u7701\u4efd\u5546\u54c1\u62a5\u9519" + e.getMessage());
        }
        try {
            logger.debug("\u67e5\u8be2\u4f9b\u5e94\u5546");
            List<ProvGoodsSupRelationPO> poList = this.provGoodsSupRelationDAO.selectByProvGoodsId(reqBO.getProvGoodsId());
            if (!CollectionUtils.isEmpty(poList)) {
                ProvGoodsSupRelationBO row = null;
                for (ProvGoodsSupRelationPO po : poList) {
                    row = new ProvGoodsSupRelationBO();
                    BeanUtils.copyProperties((Object)po, (Object)row);
                    row.setIsDefaultStr(escaMap.get("PROV_GOODS_IS_OR_NO").get(po.getIsDefault()));
                    rows.add(row);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u4f9b\u5e94\u5546\u62a5\u9519");
            throw new BusinessException("9999", "\u67e5\u8be2\u4f9b\u5e94\u5546\u62a5\u9519" + e.getMessage());
        }
        result.setProvGoodsBO(bo);
        result.setProvGoodsSupRelationList(rows);
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    public Map<String, Map<String, String>> getEscape() {
        List<SysParamTransBusiBO> escaList = this.sysParamsAtomService.selectAll();
        HashMap<String, Map<String, String>> escaMap = new HashMap<String, Map<String, String>>();
        if (!CollectionUtils.isEmpty(escaList)) {
            for (SysParamTransBusiBO es : escaList) {
                if (escaMap.containsKey(es.getParentCode())) {
                    ((Map)escaMap.get(es.getParentCode())).put(es.getCode(), es.getCodeTitle());
                    continue;
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(es.getCode(), es.getCodeTitle());
                escaMap.put(es.getParentCode(), map);
            }
        }
        return escaMap;
    }

    public Map<String, DMaterialDefineBO> getGoodsType() throws Exception {
        HashMap<String, DMaterialDefineBO> map = new HashMap<String, DMaterialDefineBO>();
        DMaterialDefineBO reqBo = new DMaterialDefineBO();
        reqBo.setDataType("1");
        logger.debug("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u7269\u6599\u7f16\u7801\u5b9a\u4e49\u67e5\u8be2\u5217\u8868\uff1a" + JSONObject.toJSONString((Object)reqBo));
        RspInfoListBO res = this.queryDMaterialDefineService.queryMaterialDefineByType(reqBo);
        logger.debug("\u63a5\u53e3\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)res));
        List list = res.getRows();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (DMaterialDefineBO bo : list) {
                if (map.containsKey(bo.getDataCode())) continue;
                map.put(bo.getDataCode(), bo);
            }
        }
        return map;
    }

    public RspInfoListBO<ProvGoodsBO> selectByMaterials(ProvGoodsQueryReqBO reqBO) {
        RspInfoListBO result = new RspInfoListBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getMaterialIds())) {
            result.setRespCode("9999");
            result.setRespDesc("\u7cfb\u7edf\u5f02\u5e38");
            return result;
        }
        ArrayList<ProvGoodsBO> rows = new ArrayList<ProvGoodsBO>();
        try {
            ArrayList<String> provMate = new ArrayList<String>();
            List<ProvGoodsPO> poList = this.provGoodsDAO.selectByMaterials(reqBO.getMaterialIds(), null);
            if (!CollectionUtils.isEmpty(poList)) {
                ProvGoodsBO bo = null;
                for (ProvGoodsPO provGoodsPO : poList) {
                    bo = new ProvGoodsBO();
                    provMate.add(provGoodsPO.getMaterialId());
                    BeanUtils.copyProperties((Object)provGoodsPO, (Object)bo);
                    rows.add(bo);
                }
                ArrayList<String> skMa = new ArrayList<String>();
                for (String pro : reqBO.getMaterialIds()) {
                    if (provMate.contains(pro)) continue;
                    skMa.add(pro);
                }
                if (!CollectionUtils.isEmpty(skMa)) {
                    List<ProvGoodsBO> list = this.getSku(skMa);
                    rows.addAll(list);
                }
            } else {
                List<ProvGoodsBO> goods = this.getSku(reqBO.getMaterialIds());
                rows.addAll(goods);
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u4f9b\u5e94\u5546\u62a5\u9519");
            throw new BusinessException("9999", "\u67e5\u8be2\u4f9b\u5e94\u5546\u62a5\u9519" + e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        result.setRows(rows);
        return result;
    }

    public List<ProvGoodsBO> getSku(List<String> materialIds) {
        ArrayList<ProvGoodsBO> list = new ArrayList<ProvGoodsBO>();
        QuerySkuListByMaterialsAndShopIdReqBO reqBO = new QuerySkuListByMaterialsAndShopIdReqBO();
        reqBO.setMaterialIds(materialIds);
        QuerySkuListByMaterialsResBO back = this.querySkuListByMaterialsAndShopIdService.querySkuListByMaterials(reqBO);
        List rows = back.getRows();
        ProvGoodsBO goods = null;
        for (SkuAndPriceAndSpecBO bo : rows) {
            goods = new ProvGoodsBO();
            goods.setColorName(bo.getColor());
            goods.setMemoryName(bo.getNc());
            goods.setGoodsModel(bo.getXh());
            goods.setGoodsLongName(bo.getSkuLongName());
            goods.setGoodsName(bo.getSkuName());
            goods.setBrandName(bo.getBrandName());
            goods.setMaterialId(bo.getMaterialId());
            list.add(goods);
        }
        return list;
    }

    public BaseRspBO checkGoodsNo(ProvGoodsQueryReqBO reqBO) {
        BaseRspBO result = new BaseRspBO();
        List<Object> list = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getGoodsNos())) {
            list = this.provGoodsDAO.selectByGoodsNo(reqBO.getGoodsNos(), reqBO.getmProvince());
        }
        if (!CollectionUtils.isEmpty(list)) {
            result.setRespCode("9999");
            result.setRespDesc("\u8be5\u52a9\u8bb0\u7801\u5df2\u5b58\u5728");
            return result;
        }
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    public RspInfoListBO<ProvGoodsBO> selectByBossColorAndBoseCodeList(SelectByBossColorAndBoseCodeListReqBO reqBO) {
        RspInfoListBO result = new RspInfoListBO();
        logger.debug("\u6839\u636eboss\u4fe1\u606f\u67e5\u8be2\u7701\u4efd\u5546\u54c1\u4fe1\u606f");
        if (CollectionUtils.isEmpty((Collection)reqBO.getBossCodeList())) {
            result.setRespCode("9999");
            result.setRespDesc("BOSS\u7f16\u7801\u5217\u8868 \u5165\u53c2\u4e3a\u7a7a");
            return result;
        }
        List<Object> poList = new ArrayList();
        StringBuffer stringBuffer = new StringBuffer();
        for (String s : reqBO.getBossCodeList()) {
            stringBuffer.append("," + s + ",|");
        }
        String BoosCode = stringBuffer.substring(0, stringBuffer.length() - 1);
        stringBuffer = new StringBuffer();
        for (int i = 0; i < BoosCode.length(); ++i) {
            if (Objects.equals(Character.valueOf(BoosCode.charAt(i)), Character.valueOf('+'))) {
                stringBuffer.append("\\\\+");
                continue;
            }
            stringBuffer.append(BoosCode.charAt(i));
        }
        BoosCode = "'" + stringBuffer + "'";
        try {
            logger.debug("\u67e5\u8be2");
            logger.debug("Boos\u7f16\u7801\u5217\u8868\uff1a{},\u7701\u4efd\u7f16\u7801\uff1a{}", (Object)reqBO.getBossCodeList(), (Object)reqBO.getProvinceCode());
            logger.debug("\u7ec4\u88c5BoosCode:{}", (Object)BoosCode);
            poList = this.provGoodsDAO.selectByBossColorAndBoseCodeList(BoosCode, reqBO.getProvinceCode());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7701\u4efd\u5546\u54c1\u4fe1\u606f\u62a5\u9519");
            throw new BusinessException("9999", "\u67e5\u8be2\u7701\u4efd\u5546\u54c1\u4fe1\u606f\u62a5\u9519" + e.getMessage());
        }
        logger.debug("\u67e5\u8be2\u7801\u8868");
        Map<String, Map<String, String>> escaMap = this.getEscape();
        ArrayList<ProvGoodsBO> rows = new ArrayList<ProvGoodsBO>();
        if (!CollectionUtils.isEmpty(poList)) {
            ProvGoodsBO bo = null;
            for (ProvGoodsPO provGoodsPO : poList) {
                bo = new ProvGoodsBO();
                BeanUtils.copyProperties((Object)provGoodsPO, (Object)bo);
                if (StringUtils.isNotEmpty((String)provGoodsPO.getBossCode())) {
                    bo.setBossCode(provGoodsPO.getBossCode().substring(1, provGoodsPO.getBossCode().length() - 1));
                }
                rows.add(this.transferredMeaning(escaMap, bo));
            }
        }
        result.setRows(rows);
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    public RspInfoListBO<ProvGoodsBO> queryProvGoods(ProvGoodsQueryReqBO reqBO) {
        logger.debug("\u8c03\u7528\u7701\u4efd\u5546\u54c1\u5206\u9875\u67e5\u8be2\u63a5\u53e3\uff1a" + JSONObject.toJSONString((Object)reqBO));
        RspInfoListBO result = new RspInfoListBO();
        ProvGoodsAndSupplierPO record = new ProvGoodsAndSupplierPO();
        record.setMaterialId(reqBO.getMaterialId());
        record.setBrandId(reqBO.getBrandId());
        record.setGoodsLongName(reqBO.getGoodsLongName());
        record.setGoodsNo(reqBO.getGoodsNo());
        record.setGoodsSource(reqBO.getGoodsSource());
        record.setSupNo(reqBO.getSupNo());
        record.setGoodsType(reqBO.getGoodsType());
        record.setErpGoodsType(reqBO.getErpGoodsType());
        record.setCgType(reqBO.getCgType());
        record.setGoodsModel(reqBO.getGoodsModel());
        record.setColorName(reqBO.getColorName());
        record.setBrandName(reqBO.getBrandName());
        record.setGoodsStatus(reqBO.getGoodsStatus());
        if (!"2".equals(reqBO.getmUserLevel()) || !StringUtils.isNotBlank((String)reqBO.getmProvince())) {
            logger.error("\u7701\u4efd\u5546\u54c1\u67e5\u8be2\u7528\u6237\u6743\u9650\u4e0d\u8db3");
            result.setRespCode("9999");
            result.setRespDesc("\u7701\u4efd\u5546\u54c1\u67e5\u8be2\u7528\u6237\u6743\u9650\u4e0d\u8db3");
            return result;
        }
        record.setProvinceCode(reqBO.getmProvince());
        ArrayList<ProvGoodsBO> rows = new ArrayList<ProvGoodsBO>();
        logger.debug("\u67e5\u8be2\u7801\u8868");
        try {
            List<ProvGoodsAndSupplierPO> poList = this.provGoodsDAO.queryProvGoods(record);
            if (!CollectionUtils.isEmpty(poList)) {
                ProvGoodsBO bo = null;
                Map<String, DMaterialDefineBO> define = this.getGoodsType();
                logger.debug("\u67e5\u8be2\u7801\u8868");
                Map<String, Map<String, String>> escaMap = this.getEscape();
                for (ProvGoodsAndSupplierPO po : poList) {
                    bo = new ProvGoodsBO();
                    BeanUtils.copyProperties((Object)po, (Object)bo);
                    bo.setDescribe(po.getProvDescribe());
                    bo.setGoodsTypeStr(define.get(po.getGoodsType()) == null ? null : define.get(po.getGoodsType()).getDataName());
                    if (StringUtils.isNotEmpty((String)po.getBossCode())) {
                        bo.setBossCode(po.getBossCode().substring(1, po.getBossCode().length() - 1));
                    }
                    bo.setReservedField2Str(ObjectUtils.equals((Object)po.getReservedField2(), (Object)"1") ? "\u662f" : "\u5426");
                    rows.add(this.transferredMeaning(escaMap, bo));
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u7701\u4efd\u5546\u54c1\u5206\u9875\u67e5\u8be2\u63a5\u53e3\u62a5\u9519");
            throw new BusinessException("9999", "\u8c03\u7528\u7701\u4efd\u5546\u54c1\u5206\u9875\u67e5\u8be2\u63a5\u53e3\u62a5\u9519" + e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        result.setRows(rows);
        return result;
    }

    public RspInfoListBO<ProvGoodsBO> selectByMaterialsAndProv(ProvGoodsQueryReqBO reqBO) {
        RspInfoListBO result = new RspInfoListBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getMaterialIds())) {
            result.setRespCode("9999");
            result.setRespDesc("\u7cfb\u7edf\u5f02\u5e38");
            return result;
        }
        ArrayList<ProvGoodsBO> rows = new ArrayList<ProvGoodsBO>();
        try {
            logger.debug("\u67e5\u8be2\u7801\u8868");
            ArrayList<Long> provGoodsIds = new ArrayList<Long>();
            List<ProvGoodsPO> poList = this.provGoodsDAO.selectByMaterials(reqBO.getMaterialIds(), reqBO.getProvinceCode());
            if (!CollectionUtils.isEmpty(poList)) {
                ProvGoodsBO bo = null;
                for (ProvGoodsPO po : poList) {
                    provGoodsIds.add(po.getProvGoodsId());
                }
                Map<Long, List<SupplierBO>> supplierMap = this.getSupplier(provGoodsIds);
                logger.debug("\u67e5\u8be2\u7801\u8868");
                Map<String, Map<String, String>> escaMap = this.getEscape();
                for (ProvGoodsPO po : poList) {
                    bo = new ProvGoodsBO();
                    BeanUtils.copyProperties((Object)po, (Object)bo);
                    bo.setSupplierBO(supplierMap.get(po.getProvGoodsId()));
                    bo.setDescribe(po.getProvDescribe());
                    rows.add(this.transferredMeaning(escaMap, bo));
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u7701\u4efd\u5546\u54c1\u5206\u9875\u67e5\u8be2\u63a5\u53e3\u62a5\u9519");
            throw new BusinessException("9999", "\u8c03\u7528\u7701\u4efd\u5546\u54c1\u5206\u9875\u67e5\u8be2\u63a5\u53e3\u62a5\u9519" + e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        result.setRows(rows);
        return result;
    }

    public Map<Long, List<SupplierBO>> getSupplier(List<Long> provGoodsIds) {
        logger.debug("\u67e5\u8be2\u4f9b\u5e94\u5546");
        HashMap<Long, List<SupplierBO>> map = new HashMap<Long, List<SupplierBO>>();
        List<ProvGoodsSupRelationPO> list = this.provGoodsSupRelationDAO.selectByProvGoodsIds(provGoodsIds);
        if (!CollectionUtils.isEmpty(list)) {
            for (ProvGoodsSupRelationPO po : list) {
                if (map.containsKey(po.getProvGoodsId())) {
                    SupplierBO bo = new SupplierBO();
                    bo.setSupplierId(po.getSupplierId().toString());
                    bo.setSupplierName(po.getSupplierName());
                    bo.setProvinceCode(po.getProvinceCode());
                    ((List)map.get(po.getProvGoodsId())).add(bo);
                    continue;
                }
                ArrayList<SupplierBO> poList = new ArrayList<SupplierBO>();
                SupplierBO bo = new SupplierBO();
                bo.setSupplierId(po.getSupplierId().toString());
                bo.setSupplierName(po.getSupplierName());
                bo.setProvinceCode(po.getProvinceCode());
                poList.add(bo);
                map.put(po.getProvGoodsId(), poList);
            }
        }
        return map;
    }

    public RspPageBO<ProvGoodsBO> queryProvGoodsByGroupPage(ProvGoodsQueryReqBO reqBO) {
        logger.debug("\u8c03\u7528\u7701\u4efd\u5546\u54c1\u5206\u9875\u67e5\u8be2\u63a5\u53e3\uff1a" + JSONObject.toJSONString((Object)reqBO));
        RspPageBO result = new RspPageBO();
        ProvGoodsAndSupplierPO record = new ProvGoodsAndSupplierPO();
        record.setMaterialId(reqBO.getMaterialId());
        record.setBrandId(reqBO.getBrandId());
        record.setGoodsLongName(reqBO.getGoodsLongName());
        record.setGoodsNo(reqBO.getGoodsNo());
        record.setGoodsSource(reqBO.getGoodsSource());
        record.setSupNo(reqBO.getSupNo());
        record.setGoodsType(reqBO.getGoodsType());
        record.setErpGoodsType(reqBO.getErpGoodsType());
        record.setCgType(reqBO.getCgType());
        record.setGoodsModel(reqBO.getGoodsModel());
        record.setColorName(reqBO.getColorName());
        record.setBrandName(reqBO.getBrandName());
        record.setGoodsStatus(reqBO.getGoodsStatus());
        Page page = new Page();
        page.setPageSize(reqBO.getPageSize());
        page.setPageNo(reqBO.getCurrent());
        ArrayList<ProvGoodsBO> rows = new ArrayList<ProvGoodsBO>();
        logger.debug("\u67e5\u8be2\u7801\u8868");
        try {
            List<ProvGoodsAndSupplierPO> poList = this.provGoodsDAO.selectByProvGroup(record, (Page<ProvGoodsAndSupplierPO>)page);
            if (!CollectionUtils.isEmpty(poList)) {
                ProvGoodsBO bo = null;
                Map<String, DMaterialDefineBO> define = this.getGoodsType();
                logger.debug("\u67e5\u8be2\u7801\u8868");
                Map<String, Map<String, String>> escaMap = this.getEscape();
                for (ProvGoodsAndSupplierPO po : poList) {
                    bo = new ProvGoodsBO();
                    BeanUtils.copyProperties((Object)po, (Object)bo);
                    bo.setDescribe(po.getProvDescribe());
                    bo.setGoodsTypeStr(define.get(po.getGoodsType()) == null ? null : define.get(po.getGoodsType()).getDataName());
                    rows.add(this.transferredMeaning(escaMap, bo));
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u7701\u4efd\u5546\u54c1\u5206\u9875\u67e5\u8be2\u63a5\u53e3\u62a5\u9519");
            throw new BusinessException("9999", "\u8c03\u7528\u7701\u4efd\u5546\u54c1\u5206\u9875\u67e5\u8be2\u63a5\u53e3\u62a5\u9519" + e.getMessage());
        }
        result.setRecordsTotal(page.getTotalCount());
        result.setTotal(page.getTotalPages());
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        result.setRows(rows);
        return result;
    }

    public BaseRspBO updateCgType(ProvGoodsQueryReqBO reqBO) {
        BaseRspBO result = new BaseRspBO();
        try {
            logger.debug("\u4fee\u6539\u7701\u4efd\u5546\u54c1\u4e70\u624b\u56e2\u72b6\u6001");
            ProvGoodsPO record = new ProvGoodsPO();
            if ("1".equals(reqBO.getCzType())) {
                logger.debug("\u4fee\u6539\u4e70\u624b\u56e2");
                record.setMaterialId(reqBO.getMaterialId());
                record.setCgType(reqBO.getCgType());
                if ("601".equals(reqBO.getCgType())) {
                    record.setReservedField3("0");
                }
            } else if ("2".equals(reqBO.getCzType())) {
                logger.debug("\u4fee\u6539\u662f\u5426\u5141\u8bb8\u7701\u4efd\u6539\u4ef7");
                record.setMaterialId(reqBO.getMaterialId());
                record.setReservedField3(reqBO.getReservedField3());
            }
            this.provGoodsDAO.updateByMaterialSelective(record);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u7701\u4efd\u5546\u54c1\u4e70\u624b\u56e2\u72b6\u6001" + e.getMessage());
            throw new BusinessException("9999", "\u4fee\u6539\u7701\u4efd\u5546\u54c1\u4e70\u624b\u56e2\u72b6\u6001" + e.getMessage());
        }
        try {
            logger.debug("\u4fee\u6539sku\u4e70\u624b\u4e70\u624b\u56e2\u72b6\u6001");
            Sku sku = new Sku();
            sku.setMaterialId(reqBO.getMaterialId());
            sku.setCgType(reqBO.getCgType());
            if ("1".equals(reqBO.getCzType())) {
                this.xlsSkuMapper.updateByMaterial(sku);
            }
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539sku\u4e70\u624b\u4e70\u624b\u56e2\u72b6\u6001" + e.getMessage());
            throw new BusinessException("9999", "\u4fee\u6539sku\u4e70\u624b\u4e70\u624b\u56e2\u72b6\u6001" + e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    public RspInfoListBO<ProvGoodsBO> selectProvGoodsByProvinceCodeAndMaterialId(ProvGoodsQueryReqBO reqBO) {
        RspInfoListBO result = new RspInfoListBO();
        if (StringUtils.isEmpty((String)reqBO.getProvinceCode())) {
            result.setRespCode("8888");
            result.setRespDesc("\u7cfb\u7edf\u5f02\u5e38:\u5165\u53c2 \u7701\u4efd\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
            return result;
        }
        if (StringUtils.isEmpty((String)reqBO.getMaterialId())) {
            result.setRespCode("8888");
            result.setRespDesc("\u7cfb\u7edf\u5f02\u5e38:\u5165\u53c2 \u7269\u6599\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
            return result;
        }
        ArrayList<ProvGoodsBO> provGoodsBOS = new ArrayList<ProvGoodsBO>();
        try {
            logger.debug("\u8c03\u7528\u6839\u636e\u7701\u4efdcode\u548c\u7269\u6599\u7f16\u7801\u67e5\u8be2\u7701\u4efd\u5546\u54c1\u4fe1\u606f");
            List<ProvGoodsPO> provGoodsPOS = this.provGoodsDAO.selectProvGoodsByProvinceCodeAndMaterialId(reqBO.getProvinceCode(), reqBO.getMaterialId());
            for (ProvGoodsPO provGoodsPO : provGoodsPOS) {
                ProvGoodsBO provGoodsBO = new ProvGoodsBO();
                BeanUtils.copyProperties((Object)provGoodsPO, (Object)provGoodsBO);
                provGoodsBOS.add(provGoodsBO);
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u6839\u636e\u7701\u4efdcode\u548c\u7269\u6599\u7f16\u7801\u67e5\u8be2\u7701\u4efd\u5546\u54c1\u4fe1\u606f\u9519\u8bef" + e.getMessage());
            throw new BusinessException("9999", "\u8c03\u7528\u6839\u636e\u7701\u4efdcode\u548c\u7269\u6599\u7f16\u7801\u67e5\u8be2\u7701\u4efd\u5546\u54c1\u4fe1\u606f\u9519\u8bef" + e.getMessage());
        }
        result.setRows(provGoodsBOS);
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    public ProvGoodsBO transferredMeaning(Map<String, Map<String, String>> escaMap, ProvGoodsBO bo) {
        bo.setAllowNegativeStockStr(escaMap.get("ALLOW_NEGATIVE_STOCK_STR").get(bo.getAllowNegativeStock()));
        bo.setCgTypeStr(escaMap.get("CGTYPE_STR").get(bo.getCgType()));
        bo.setGoodsSourceStr(escaMap.get("GOODS_SOURCE_STR").get(bo.getGoodsSource()));
        bo.setGoodsStallsStr(escaMap.get("GOODS_STALLS_STR").get(bo.getGoodsStalls()));
        bo.setGoodsStatusStr(escaMap.get("GOODS_STATUS_STR").get(bo.getGoodsStatus()));
        bo.setHasPriceStr(escaMap.get("PROV_GOODS_IS_OR_NO").get(bo.getHasPrice()));
        bo.setHasSerialNumberStr(escaMap.get("HAS_SERIAL_NUMBER_STR").get(bo.getHasSerialNumber()));
        bo.setIsAfterInputSte(escaMap.get("IS_AFTER_INPUT_STE").get(bo.getIsAfterInput()));
        bo.setIsScmDistributeStr(escaMap.get("PROV_GOODS_IS_OR_NO").get(bo.getIsScmDistribute()));
        bo.setIsSendScmSaleStr(escaMap.get("PROV_GOODS_IS_OR_NO").get(bo.getIsSendScmSale()));
        bo.setIsSendScmStockStr(escaMap.get("PROV_GOODS_IS_OR_NO").get(bo.getIsSendScmStock()));
        bo.setIsValidStr(escaMap.get("IS_VALID_STR").get(bo.getIsValid()));
        bo.setPurchaseTypeStr(escaMap.get("PURCHASE_TYPE_STR").get(bo.getPurchaseType()));
        bo.setStandardSystemStr(escaMap.get("STANDARD_SYSTEM_STR").get(bo.getStandardSystem()));
        bo.setErpGoodsTypeStr(escaMap.get("ERP_GOODS_TYPE").get(bo.getErpGoodsType()));
        bo.setIsAppstoreAbleStr(escaMap.get("IS_APPSTORE_ABLE").get(bo.getIsAppstoreAble()));
        bo.setScreenTypeStr(escaMap.get("SCREEN_TYPE").get(bo.getScreenType()));
        return bo;
    }
}

