/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.toolkit.bo.InvokeInfo;
import com.tydic.newretail.toolkit.util.TKGenericServiceUtils;
import com.xls.commodity.atom.sku.XlsSkuManageService;
import com.xls.commodity.busi.sku.BatchCreateSkuService;
import com.xls.commodity.busi.sku.ProvUpdateService;
import com.xls.commodity.busi.sku.bo.BatchCreateSkuReqBO;
import com.xls.commodity.busi.sku.bo.CreateSkuReqBO;
import com.xls.commodity.busi.sku.bo.DPriceSheetBO;
import com.xls.commodity.busi.sku.bo.ProvAndCityCodeBO;
import com.xls.commodity.busi.sku.bo.ProvGoodsBO;
import com.xls.commodity.busi.sku.bo.SupplierBO;
import com.xls.commodity.constants.SysParamConstant;
import com.xls.commodity.dao.ProvGoodsDAO;
import com.xls.commodity.dao.ProvGoodsSupRelationDAO;
import com.xls.commodity.dao.XlsSkuMapper;
import com.xls.commodity.dao.po.ProvGoodsPO;
import com.xls.commodity.dao.po.ProvGoodsSupRelationPO;
import com.xls.commodity.dao.po.Sku;
import com.xls.commodity.intfce.sku.DPriceSheetService;
import com.xls.commodity.intfce.sku.bo.BaseRspBO;
import com.xls.commodity.intfce.sku.bo.ProvinceMaterialBO;
import com.xls.commodity.intfce.sku.bo.SkuBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProvUpdateServiceImpl
implements ProvUpdateService {
    private static final Logger logger = LoggerFactory.getLogger(ProvUpdateServiceImpl.class);
    @Autowired
    private ProvGoodsDAO provGoodsDAO;
    @Autowired
    private XlsSkuMapper xlsSkuMapper;
    @Autowired
    private ProvGoodsSupRelationDAO provGoodsSupRelationDAO;
    @Autowired
    private XlsSkuManageService xlsSkuManageService;
    @Autowired
    private BatchCreateSkuService batchCreateSkuService;
    @Autowired
    private DPriceSheetService dPriceSheetService;
    @Value(value="${hsf.version}")
    private String hsfVersion;
    @Value(value="${hsf.group}")
    private String hsfGroup;
    @Value(value="${hsf.clientTimeout}")
    private String hsfClientTimeout;

    @Deprecated
    public BaseRspBO provUpdate(ProvGoodsBO reqBO) {
        BaseRspBO result = new BaseRspBO();
        if (reqBO.getProvGoodsId() == null) {
            logger.debug("\u5165\u53c2\u4e3a\u7a7a");
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            return result;
        }
        ProvGoodsPO provPO = new ProvGoodsPO();
        logger.debug("\u67e5\u8be2\u7701\u4efd\u5546\u54c1\u72b6\u6001");
        try {
            provPO = this.provGoodsDAO.selectByPrimaryKey(reqBO.getProvGoodsId());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7701\u4efd\u5546\u54c1\u72b6\u6001\u62a5\u9519");
            throw new BusinessException("9999", "\u67e5\u8be2\u7701\u4efd\u5546\u54c1\u72b6\u6001\u62a5\u9519" + e.getMessage());
        }
        logger.debug("\u66f4\u65b0\u7701\u4efd\u5546\u54c1" + JSON.toJSONString((Object)reqBO));
        try {
            ProvGoodsPO record = new ProvGoodsPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)record);
            record.setProvDescribe(reqBO.getDescribe());
            if ("01".equals(provPO.getGoodsSource())) {
                record.setMaterialId(null);
                record.setVersionName(null);
                record.setGoodsType(null);
                record.setColorName(null);
                record.setGoodsSource(null);
                record.setUpdateTime(new Date());
            }
            record.setUpdateTime(new Date());
            if (StringUtils.isNotEmpty((String)reqBO.getBossCode())) {
                record.setBossCode("," + reqBO.getBossCode() + ",");
            }
            if (record.getInvoiceTaxRate() == null) {
                record.setInvoiceTaxRate(SysParamConstant.INVOICE_TAX_RATE_DEFAULT);
            }
            this.provGoodsDAO.updateByPrimaryKeySelective(record);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u7701\u4efd\u5546\u54c1\u62a5\u9519");
            throw new BusinessException("9999", "\u66f4\u65b0\u7701\u4efd\u5546\u54c1\u62a5\u9519" + e.getMessage());
        }
        try {
            if ("03".equals(reqBO.getGoodsStatus())) {
                String material = reqBO.getMaterialId();
                String provCode = reqBO.getProvinceCode();
                ArrayList<String> materialIds = new ArrayList<String>();
                materialIds.add(material);
                final ArrayList<SkuBO> updateList = new ArrayList<SkuBO>();
                ProvinceMaterialBO provinceMaterialBO = new ProvinceMaterialBO();
                provinceMaterialBO.setProvinceCode(provCode);
                provinceMaterialBO.setMaterialId(materialIds);
                Map priceSheet = this.dPriceSheetService.findDPriceSheet(provinceMaterialBO);
                final ArrayList<CreateSkuReqBO> createList = new ArrayList<CreateSkuReqBO>();
                Map<String, ProvAndCityCodeBO> shopIds = this.getProvCode(provCode, reqBO.getmOrgPath());
                Map<String, Sku> skuMap = this.getSku(reqBO);
                for (Map.Entry<String, ProvAndCityCodeBO> shop : shopIds.entrySet()) {
                    if (!CollectionUtils.isEmpty(skuMap) && skuMap.containsKey(material + shop.getKey().trim())) {
                        SkuBO update = this.toUpdate(reqBO, provPO, shop.getValue(), skuMap.get(material + shop.getKey().trim()));
                        updateList.add(update);
                        continue;
                    }
                    CreateSkuReqBO craete = this.toCreate(reqBO, shop.getValue(), priceSheet);
                    createList.add(craete);
                }
                final BatchCreateSkuReqBO batchCreateSkuReqBO = new BatchCreateSkuReqBO();
                batchCreateSkuReqBO.setCreateSkuReqBOs(createList);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (!CollectionUtils.isEmpty((Collection)createList)) {
                            ProvUpdateServiceImpl.this.batchCreateSkuService.batchCreateSku(batchCreateSkuReqBO);
                        }
                        if (!CollectionUtils.isEmpty((Collection)updateList)) {
                            ProvUpdateServiceImpl.this.xlsSkuManageService.batchUpdate(updateList);
                        }
                    }
                }).start();
            }
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0sku\u62a5\u9519");
            throw new BusinessException("9999", "\u66f4\u65b0sku\u62a5\u9519" + e.getMessage());
        }
        ArrayList<Long> provId = new ArrayList<Long>();
        provId.add(reqBO.getProvGoodsId());
        try {
            ArrayList<ProvGoodsSupRelationPO> relationPO = new ArrayList<ProvGoodsSupRelationPO>();
            ProvGoodsSupRelationPO po = null;
            for (SupplierBO subo : reqBO.getSupplierBO()) {
                po = new ProvGoodsSupRelationPO();
                po.setProvGoodsId(reqBO.getProvGoodsId());
                po.setProvinceCode(subo.getProvinceCode());
                po.setSupplierId(Long.parseLong(subo.getSupplierId()));
                po.setCreateTime(new Date());
                po.setSupplierName(subo.getSupplierName());
                relationPO.add(po);
            }
            this.provGoodsSupRelationDAO.deleteByProvId(provId);
            this.provGoodsSupRelationDAO.insertList(relationPO);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u4f9b\u5e94\u5546\u62a5\u9519");
            throw new BusinessException("9999", "\u66f4\u65b0\u4f9b\u5e94\u5546\u62a5\u9519" + e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    public BaseRspBO newProvUpdate(ProvGoodsBO reqBO) {
        ProvGoodsPO provPO;
        BaseRspBO result = new BaseRspBO();
        if (reqBO.getProvGoodsId() == null) {
            logger.debug("\u5165\u53c2\u4e3a\u7a7a");
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            return result;
        }
        logger.debug("\u67e5\u8be2\u7701\u4efd\u5546\u54c1\u72b6\u6001");
        try {
            provPO = this.provGoodsDAO.selectByPrimaryKey(reqBO.getProvGoodsId());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7701\u4efd\u5546\u54c1\u72b6\u6001\u62a5\u9519" + e.getMessage());
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            return result;
        }
        logger.debug("\u66f4\u65b0\u7701\u4efd\u5546\u54c1" + JSON.toJSONString((Object)reqBO));
        try {
            ProvGoodsPO record = new ProvGoodsPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)record);
            record.setProvDescribe(reqBO.getDescribe());
            if ("01".equals(provPO.getGoodsSource())) {
                record.setMaterialId(null);
                record.setVersionName(null);
                record.setGoodsType(null);
                record.setGoodsSource(null);
                record.setUpdateTime(new Date());
            }
            record.setUpdateTime(new Date());
            if (StringUtils.isNotEmpty((String)reqBO.getBossCode())) {
                record.setBossCode("," + reqBO.getBossCode() + ",");
            }
            if (record.getInvoiceTaxRate() == null) {
                record.setInvoiceTaxRate(SysParamConstant.INVOICE_TAX_RATE_DEFAULT);
            }
            this.provGoodsDAO.updateByPrimaryKeySelective(record);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u7701\u4efd\u5546\u54c1\u62a5\u9519" + e.getMessage());
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            return result;
        }
        try {
            final SkuBO updateSku = this.toUpdateSku(reqBO);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ProvUpdateServiceImpl.this.xlsSkuManageService.batchUpdateSku(updateSku);
                }
            }).start();
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0sku\u62a5\u9519---\u7701\u4efd\u7f16\u7801\u4e3a\u7a7a\u6216\u7269\u6599\u7f16\u7801\u4e3a\u7a7a" + e.getMessage());
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            return result;
        }
        ArrayList<Long> provId = new ArrayList<Long>();
        provId.add(reqBO.getProvGoodsId());
        try {
            ArrayList<ProvGoodsSupRelationPO> relationPO = new ArrayList<ProvGoodsSupRelationPO>();
            for (SupplierBO subo : reqBO.getSupplierBO()) {
                ProvGoodsSupRelationPO po = new ProvGoodsSupRelationPO();
                po.setProvGoodsId(reqBO.getProvGoodsId());
                po.setProvinceCode(subo.getProvinceCode());
                po.setSupplierId(Long.parseLong(subo.getSupplierId()));
                po.setCreateTime(new Date());
                po.setSupplierName(subo.getSupplierName());
                relationPO.add(po);
            }
            this.provGoodsSupRelationDAO.deleteByProvId(provId);
            if (CollectionUtils.isEmpty(relationPO)) {
                logger.error("\u521b\u5efa\u7701\u4efd\u5546\u54c1\u4e0e\u4f9b\u5e94\u5546\u5173\u8054\u5173\u7cfb\u8868  \u5165\u53c2\u4e3a\u7a7a");
                result.setRespCode("8888");
                result.setRespDesc("\u521b\u5efa\u7701\u4efd\u5546\u54c1\u4e0e\u4f9b\u5e94\u5546\u5173\u8054\u5173\u7cfb\u8868  \u5165\u53c2\u4e3a\u7a7a");
                return result;
            }
            this.provGoodsSupRelationDAO.insertList(relationPO);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u7701\u4efd\u5546\u54c1\u4e0e\u4f9b\u5e94\u5546\u5173\u8054\u5173\u7cfb\u8868\u62a5\u9519" + e.getMessage());
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            return result;
        }
        result.setRespCode("0000");
        result.setRespDesc("\u66f4\u65b0\u7701\u4efd\u5546\u54c1\u6210\u529f");
        return result;
    }

    public String getId(List<SupplierBO> relation) {
        String id = "";
        if (!CollectionUtils.isEmpty(relation)) {
            for (SupplierBO po : relation) {
                id = id + po.getSupplierId() + ",";
            }
        }
        return id;
    }

    public String getName(List<SupplierBO> relation) {
        String name = "";
        if (!CollectionUtils.isEmpty(relation)) {
            for (SupplierBO po : relation) {
                name = name + po.getSupplierName() + ",";
            }
        }
        return name;
    }

    public Map<String, Sku> getSku(ProvGoodsBO reqBO) throws Exception {
        HashMap<String, Sku> skuMap = new HashMap<String, Sku>();
        Map<String, ProvAndCityCodeBO> shopIds = this.getProvCode(reqBO.getProvinceCode(), reqBO.getmOrgPath());
        List<Object> skus = new ArrayList();
        if (!CollectionUtils.isEmpty(shopIds)) {
            ArrayList<String> materialIds = new ArrayList<String>();
            ArrayList<Long> supplierIds = new ArrayList<Long>();
            for (Map.Entry<String, ProvAndCityCodeBO> shop : shopIds.entrySet()) {
                supplierIds.add(Long.parseLong(shop.getKey()));
            }
            materialIds.add(reqBO.getMaterialId());
            skus = this.xlsSkuMapper.queryXlsSkuByMaterialsAndShopListEnable(supplierIds, materialIds);
        }
        if (!CollectionUtils.isEmpty(skus)) {
            for (Sku sk : skus) {
                sk.setProvinceCode(shopIds.get(sk.getSupplierId().toString()).getProvinceCode());
                sk.setCityCode(shopIds.get(sk.getSupplierId().toString()).getCityCode());
                if (skuMap.containsKey(sk.getMaterialId() + sk.getSupplierId())) continue;
                skuMap.put(sk.getMaterialId() + sk.getSupplierId(), sk);
            }
        }
        return skuMap;
    }

    public Map<String, ProvAndCityCodeBO> getProvCode(String provinceCode, String orgPath) throws Exception {
        HashMap<String, ProvAndCityCodeBO> map = new HashMap<String, ProvAndCityCodeBO>();
        JSONObject param = new JSONObject();
        param.put("queryType", (Object)4);
        param.fluentPut("orgTreePath", (Object)orgPath);
        param.put("isCutoverFlag", (Object)1);
        param.put("isFilteStoreId", (Object)0);
        param.put("allStatus", (Object)1);
        logger.debug(param.toString());
        InvokeInfo invokeInfo = new InvokeInfo("com.ohaotian.authority.organisation.service.SelectOrgTreeService", "selectOrgTree", "com.ohaotian.authority.organisation.bo.SelectOrgTreeReqBO");
        invokeInfo.setVersion(this.hsfVersion);
        invokeInfo.setGroup(this.hsfGroup);
        invokeInfo.setClientTimeout(Integer.valueOf(this.hsfClientTimeout));
        invokeInfo.setRegisterType("2");
        JSONObject prov = TKGenericServiceUtils.genericServiceInvoke((String)JSONObject.toJSONString((Object)param), null, (InvokeInfo)invokeInfo);
        logger.debug("\u8fdb\u884c\u6cdb\u5316\u8c03\u7528\u8fd4\u56de\u503c" + prov);
        if (!CollectionUtils.isEmpty((Collection)prov.getJSONArray("orgTreeBOList"))) {
            ProvAndCityCodeBO bo = null;
            JSONArray orgTreeBOList = prov.getJSONArray("orgTreeBOList");
            logger.debug("\u67e5\u8be2\u95e8\u5e97\u8fd4\u56de\u6761\u6570=" + orgTreeBOList.size());
            for (int i = 0; i < orgTreeBOList.size(); ++i) {
                JSONObject item = orgTreeBOList.getJSONObject(i);
                if (!StringUtils.isNotEmpty((String)item.getString("storeId"))) continue;
                bo = new ProvAndCityCodeBO();
                bo.setCityCode(item.getString("cityCode"));
                bo.setSupplierId(item.getString("storeId"));
                bo.setProvinceCode(item.getString("provinceCode"));
                bo.setShopName(item.getString("orgName"));
                bo.setCountryCode(item.getString("districtCode"));
                map.put(item.getString("storeId"), bo);
            }
        }
        return map;
    }

    public CreateSkuReqBO toCreate(ProvGoodsBO bo, ProvAndCityCodeBO shop, Map<String, DPriceSheetBO> priceSheet) {
        CreateSkuReqBO cr = new CreateSkuReqBO();
        cr.setBrandId(bo.getBrandId());
        cr.setBrandName(bo.getBrandName());
        cr.setColor(bo.getColorName());
        cr.setBrand(bo.getBrandName());
        cr.setGoodsSource(bo.getGoodsSource());
        String key = bo.getMaterialId() + shop.getProvinceCode() + shop.getCityCode();
        DPriceSheetBO price = new DPriceSheetBO();
        if (!CollectionUtils.isEmpty(priceSheet)) {
            DPriceSheetBO dPriceSheetBO = price = priceSheet.get(key.trim()) == null ? priceSheet.get(bo.getMaterialId() + shop.getProvinceCode()) : priceSheet.get(key.trim());
        }
        if (price != null) {
            cr.setSaleSrice(price.getSalePrice());
            cr.setSheetId(price.getSheetId());
            cr.setSheetLevel(price.getSheetLevel());
            cr.setAssessmentPrice(price.getAssessmentPrice());
            cr.setSaleSrice(price.getSalePrice());
            cr.setPurchasePrice("1".equals(price.getSheetLevel()) ? price.getPurchasePrice() : null);
            cr.setAgreementPrice(price.getAgreementPrice());
            cr.setMemberPrice(price.getMemberPrice());
        }
        cr.setModel(bo.getGoodsModel());
        cr.setCgType(bo.getCgType());
        cr.setExtSkuId(bo.getExtGoodsNo());
        cr.setSkuCode(bo.getGoodsNo());
        cr.setRam(bo.getMemoryName());
        cr.setMeasureId(bo.getMeasureId());
        cr.setMeasureName(bo.getMeasureName());
        cr.setFullName(bo.getGoodsLongName());
        cr.setSupplierId(Long.valueOf(Long.parseLong(shop.getSupplierId())));
        cr.setSupplierName(shop.getShopName());
        cr.setProvinceCode(shop.getProvinceCode());
        cr.setCityCode(shop.getCityCode());
        cr.setCountyCode(shop.getCountryCode());
        cr.setName(bo.getGoodsModel());
        cr.setIsVirtualGood(bo.getAllowNegativeStock());
        cr.setMaterialId(bo.getMaterialId());
        cr.setProvGoodsId(bo.getProvGoodsId());
        cr.setProvinceCode(bo.getProvinceCode());
        String venId = "";
        for (SupplierBO su : bo.getSupplierBO()) {
            venId = venId + su.getSupplierId() + ",";
        }
        cr.setVendorId(StringUtils.isBlank((String)venId) ? null : venId.substring(0, venId.length() - 1));
        cr.setVendorName(bo.getSupNo());
        return cr;
    }

    public SkuBO toUpdate(ProvGoodsBO bo, ProvGoodsPO po, ProvAndCityCodeBO shopId, Sku sku) {
        SkuBO skuBO = new SkuBO();
        skuBO.setBrandId(bo.getBrandId());
        skuBO.setBrandName(bo.getBrandName());
        skuBO.setColor(bo.getColorName());
        skuBO.setBrand(bo.getBrandName());
        skuBO.setGoodsSource(bo.getGoodsSource());
        String venId = "";
        for (SupplierBO su : bo.getSupplierBO()) {
            venId = venId + su.getSupplierId() + ",";
        }
        skuBO.setModel(bo.getGoodsModel());
        skuBO.setVendorId(StringUtils.isBlank((String)venId) ? null : venId.substring(0, venId.length() - 1));
        skuBO.setVendorName(bo.getSupNo());
        skuBO.setSkuId(sku.getSkuId());
        skuBO.setRam(bo.getMemoryName());
        skuBO.setProvinceCode(shopId.getProvinceCode());
        skuBO.setCgType(bo.getCgType());
        skuBO.setCityCode(shopId.getCityCode());
        skuBO.setExtSkuId(bo.getExtGoodsNo());
        skuBO.setSkuCode(bo.getGoodsNo());
        skuBO.setSkuName(bo.getGoodsLongName());
        skuBO.setSkuLongName(bo.getGoodsLongName());
        skuBO.setErpLongName(bo.getGoodsLongName());
        skuBO.setSkuPriceTagName(bo.getGoodsLongName());
        skuBO.setCountyCode(shopId.getCountryCode());
        skuBO.setMfgSku(bo.getGoodsModel());
        skuBO.setIsVirtualGood(bo.getAllowNegativeStock());
        skuBO.setProvGoodsId(po.getProvGoodsId());
        skuBO.setSupplierId(sku.getSupplierId());
        skuBO.setIsDelete(Integer.valueOf(0));
        return skuBO;
    }

    public SkuBO toUpdateSku(ProvGoodsBO bo) {
        SkuBO skuBO = new SkuBO();
        skuBO.setBrandId(bo.getBrandId());
        skuBO.setBrandName(bo.getBrandName());
        skuBO.setColor(bo.getColorName());
        skuBO.setBrand(bo.getBrandName());
        skuBO.setGoodsSource(bo.getGoodsSource());
        String venId = "";
        for (SupplierBO su : bo.getSupplierBO()) {
            venId = venId + su.getSupplierId() + ",";
        }
        skuBO.setModel(bo.getGoodsModel());
        skuBO.setVendorId(StringUtils.isBlank((String)venId) ? null : venId.substring(0, venId.length() - 1));
        skuBO.setVendorName(bo.getSupNo());
        skuBO.setRam(bo.getMemoryName());
        skuBO.setProvinceCode(bo.getProvinceCode());
        skuBO.setCgType(bo.getCgType());
        skuBO.setCityCode(null);
        skuBO.setExtSkuId(bo.getExtGoodsNo());
        skuBO.setSkuCode(bo.getGoodsNo());
        skuBO.setSkuName(bo.getGoodsLongName());
        skuBO.setSkuLongName(bo.getGoodsLongName());
        skuBO.setErpLongName(bo.getGoodsLongName());
        skuBO.setSkuPriceTagName(bo.getGoodsLongName());
        skuBO.setCountyCode(null);
        skuBO.setMfgSku(bo.getGoodsModel());
        skuBO.setIsVirtualGood(bo.getAllowNegativeStock());
        skuBO.setProvGoodsId(null);
        if ("03".equals(bo.getGoodsStatus())) {
            skuBO.setIsDelete(Integer.valueOf(0));
        } else if ("04".equals(bo.getGoodsStatus())) {
            skuBO.setIsDelete(Integer.valueOf(1));
        }
        skuBO.setMaterialId(bo.getMaterialId());
        return skuBO;
    }
}

