/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.xls.commodity.atom.sku.DMaterialDefineManageService;
import com.xls.commodity.atom.sku.DMaterialManageService;
import com.xls.commodity.busi.sku.QueryDMaterialDefineService;
import com.xls.commodity.busi.sku.bo.DMaterialDefineBO;
import com.xls.commodity.busi.sku.bo.DMaterialDefineRspBO;
import com.xls.commodity.busi.sku.bo.DmaterialBO;
import com.xls.commodity.busi.sku.bo.MaterialReqBO;
import com.xls.commodity.busi.sku.bo.QueryMaterialByMaterialIdsReqBO;
import com.xls.commodity.dao.MaterialDAO;
import com.xls.commodity.dao.po.MaterialPO;
import com.xls.commodity.intfce.sku.bo.RspInfoListBO;
import com.xls.commodity.intfce.sku.bo.RspPageBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryDMaterialDefineServiceImpl
implements QueryDMaterialDefineService {
    private static final Logger logger = LoggerFactory.getLogger(QueryDMaterialDefineServiceImpl.class);
    @Autowired
    private DMaterialDefineManageService dMaterialDefineManageService;
    @Autowired
    private DMaterialManageService dMaterialManageService;
    @Autowired
    private MaterialDAO materialDao;

    public RspInfoListBO<DMaterialDefineBO> queryMaterialDefineByType(DMaterialDefineBO reqBo) {
        logger.info("\u5546\u54c1\u4e2d\u5fc3\u7269\u6599\u7f16\u7801\u5b9a\u4e49\u67e5\u8be2\u5217\u8868\u670d\u52a1\u5165\u53c2=" + reqBo.toString());
        RspInfoListBO rspInfoListBO = new RspInfoListBO();
        rspInfoListBO.setRespCode("0000");
        rspInfoListBO.setRespDesc("\u6210\u529f");
        if (StringUtils.isBlank((CharSequence)reqBo.getDataType()) && StringUtils.isBlank((CharSequence)reqBo.getProductTypeCode())) {
            logger.debug("\u5546\u54c1\u4e2d\u5fc3\u7269\u6599\u7f16\u7801\u5b9a\u4e49\u67e5\u8be2dataType\u548cproductTypeCode\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
            return rspInfoListBO;
        }
        DMaterialDefineBO bo = new DMaterialDefineBO();
        bo.setDataType(reqBo.getDataType());
        bo.setProductTypeCode(reqBo.getProductTypeCode());
        try {
            RspInfoListBO rspInfoList = this.dMaterialDefineManageService.selectMaterialDefineByBatch(bo);
            if (CollectionUtils.isNotEmpty((Collection)rspInfoList.getRows())) {
                rspInfoListBO.setRows(rspInfoList.getRows());
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7269\u6599\u7f16\u7801\u5b9a\u4e49\u5217\u8868\u670d\u52a1\u62a5\u9519");
            rspInfoListBO.setRespCode("8888");
            rspInfoListBO.setRespDesc("\u5931\u8d25");
            return rspInfoListBO;
        }
        return rspInfoListBO;
    }

    public DMaterialDefineRspBO queryMaterialDefineByCode(DMaterialDefineBO reqBo) {
        logger.info("\u5546\u54c1\u4e2d\u5fc3\u7269\u6599\u7f16\u7801\u5b9a\u4e49\u67e5\u8be2\u5217\u8868\u670d\u52a1\u5165\u53c2=" + reqBo.toString());
        DMaterialDefineRspBO rspInfoBO = new DMaterialDefineRspBO();
        rspInfoBO.setRespCode("0000");
        rspInfoBO.setRespDesc("\u6210\u529f");
        if (StringUtils.isBlank((CharSequence)reqBo.getDataType()) || StringUtils.isBlank((CharSequence)reqBo.getProductTypeCode()) || StringUtils.isBlank((CharSequence)reqBo.getDataCode())) {
            logger.debug("\u5546\u54c1\u4e2d\u5fc3\u7269\u6599\u7f16\u7801\u5b9a\u4e49\u67e5\u8be2dataType,DataCode\u548cproductTypeCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rspInfoBO;
        }
        DMaterialDefineBO bo = new DMaterialDefineBO();
        bo.setDataType(reqBo.getDataType());
        bo.setProductTypeCode(reqBo.getProductTypeCode());
        bo.setDataCode(reqBo.getDataCode());
        try {
            RspInfoListBO rspInfoList = this.dMaterialDefineManageService.selectMaterialDefineByBatch(bo);
            if (CollectionUtils.isNotEmpty((Collection)rspInfoList.getRows())) {
                bo = (DMaterialDefineBO)rspInfoList.getRows().get(0);
                rspInfoBO.setDataName(bo.getDataName());
                rspInfoBO.setDataCode(bo.getDataCode());
                rspInfoBO.setDataType(bo.getDataType());
                rspInfoBO.setProductTypeCode(bo.getProductTypeCode());
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7269\u6599\u7f16\u7801\u5b9a\u4e49\u5217\u8868\u670d\u52a1\u62a5\u9519");
            rspInfoBO.setRespCode("8888");
            rspInfoBO.setRespDesc("\u5931\u8d25");
            return rspInfoBO;
        }
        return rspInfoBO;
    }

    public RspInfoListBO<DmaterialBO> queryMaterialByFuzzyMaterial(DmaterialBO reqBO) {
        logger.info("\u6839\u636e\u7269\u6599\u7f16\u7801\u6a21\u7cca\u67e5\u8be2\u7269\u6599\u5546\u54c1\u5217\u8868\u670d\u52a1\u5165\u53c2=" + reqBO.toString());
        RspInfoListBO rspInfoListBO = new RspInfoListBO();
        rspInfoListBO.setRespCode("0000");
        rspInfoListBO.setRespDesc("\u6210\u529f");
        if (reqBO.getMaterialId() == null) {
            return rspInfoListBO;
        }
        try {
            RspInfoListBO infoListBO = this.dMaterialManageService.selectByFuzzyMaterial(reqBO.getMaterialId());
            rspInfoListBO.setRows(infoListBO.getRows());
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u7269\u6599\u7f16\u7801\u6a21\u7cca\u67e5\u8be2\u7269\u6599\u5546\u54c1\u5217\u8868\u670d\u52a1\u62a5\u9519");
            rspInfoListBO.setRespCode("8888");
            rspInfoListBO.setRespDesc("\u5931\u8d25");
            return rspInfoListBO;
        }
        return rspInfoListBO;
    }

    public RspPageBO<DmaterialBO> queryMaterial(MaterialReqBO reqBO) {
        RspPageBO result = new RspPageBO();
        logger.debug("\u67e5\u8be2\u7269\u6599\uff1a" + JSONObject.toJSONString((Object)reqBO));
        MaterialPO record = new MaterialPO();
        record.setMaterialId(reqBO.getMaterialId());
        record.setIsScm(reqBO.getIsScm());
        record.setMaterialDesc(reqBO.getMaterialDesc());
        Page page = new Page();
        page.setLimit(reqBO.getPageSize());
        page.setOffset(reqBO.getOffset());
        ArrayList<DmaterialBO> rows = new ArrayList<DmaterialBO>();
        try {
            List<MaterialPO> poList = this.materialDao.selectByRecord(record, (Page<MaterialPO>)page);
            if (!CollectionUtils.isEmpty(poList)) {
                DmaterialBO bo = null;
                for (MaterialPO po : poList) {
                    bo = new DmaterialBO();
                    BeanUtils.copyProperties((Object)po, (Object)bo);
                    rows.add(bo);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u7269\u6599\u7f16\u7801\u6a21\u7cca\u67e5\u8be2\u7269\u6599\u5546\u54c1\u5217\u8868\u670d\u52a1\u62a5\u9519");
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            return result;
        }
        result.setRecordsTotal(page.getTotalCount());
        result.setTotal(page.getTotalPages());
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        result.setRows(rows);
        return result;
    }

    public RspInfoListBO<DmaterialBO> queryByMaterialIds(QueryMaterialByMaterialIdsReqBO reqBO) {
        RspInfoListBO result = new RspInfoListBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getMaterialIds())) {
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            return result;
        }
        ArrayList<DmaterialBO> rows = new ArrayList<DmaterialBO>();
        try {
            List<MaterialPO> poList = this.materialDao.selectByMaterialIds(reqBO.getMaterialIds());
            if (!CollectionUtils.isEmpty(poList)) {
                DmaterialBO bo = null;
                for (MaterialPO po : poList) {
                    bo = new DmaterialBO();
                    BeanUtils.copyProperties((Object)po, (Object)bo);
                    rows.add(bo);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u7269\u6599\u7f16\u7801\u5217\u8868\u67e5\u8be2\u7269\u6599\u5546\u54c1\u5217\u8868\u670d\u52a1\u62a5\u9519");
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            return result;
        }
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        result.setRows(rows);
        return null;
    }
}

