/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.xls.commodity.atom.sku.SysParamsAtomService;
import com.xls.commodity.busi.sku.QuerySkuBasicDataService;
import com.xls.commodity.busi.sku.bo.QuerySkuBasicDataNoPageReqBO;
import com.xls.commodity.busi.sku.bo.QuerySkuBasicDataReqBO;
import com.xls.commodity.busi.sku.bo.QuerySkuBasicDataRspBO;
import com.xls.commodity.busi.sku.bo.SysParamTransBusiBO;
import com.xls.commodity.dao.XlsSkuMapper;
import com.xls.commodity.dao.po.Sku;
import com.xls.commodity.dao.po.SkuAndProvPO;
import com.xls.commodity.intfce.sku.bo.RspInfoListBO;
import com.xls.commodity.intfce.sku.bo.RspPageBO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuerySkuBasicDataServiceImpl
implements QuerySkuBasicDataService {
    private static final Logger logger = LoggerFactory.getLogger(QuerySkuBasicDataServiceImpl.class);
    @Autowired
    private XlsSkuMapper xlsSkuMapper;
    @Autowired
    private SysParamsAtomService sysParamsAtomService;

    public RspPageBO<QuerySkuBasicDataRspBO> querySkuBasicData(QuerySkuBasicDataReqBO querySkuBasicDataReqBO) {
        RspPageBO result = new RspPageBO();
        logger.debug("\u67e5\u8be2sku\u57fa\u7840\u4fe1\u606f\u670d\u52a1\u5165\u53c2=", (Object)JSON.toJSONString((Object)querySkuBasicDataReqBO));
        Page page = new Page();
        page.setLimit(querySkuBasicDataReqBO.getPageSize());
        page.setOffset(querySkuBasicDataReqBO.getOffset());
        String provinceCode = null;
        String cityCode = null;
        String countyCode = null;
        Long shopId = null;
        provinceCode = !StringUtils.isBlank((CharSequence)querySkuBasicDataReqBO.getProvinceCode()) ? querySkuBasicDataReqBO.getProvinceCode() : querySkuBasicDataReqBO.getmProvince();
        cityCode = !StringUtils.isBlank((CharSequence)querySkuBasicDataReqBO.getCityCode()) ? querySkuBasicDataReqBO.getCityCode() : querySkuBasicDataReqBO.getmCity();
        countyCode = !StringUtils.isBlank((CharSequence)querySkuBasicDataReqBO.getCountyCode()) ? querySkuBasicDataReqBO.getCountyCode() : querySkuBasicDataReqBO.getmDistrict();
        if (querySkuBasicDataReqBO.getShopId() != null) {
            shopId = querySkuBasicDataReqBO.getShopId();
        } else if (StringUtils.isNotBlank((CharSequence)querySkuBasicDataReqBO.getmShopId())) {
            shopId = Long.parseLong(querySkuBasicDataReqBO.getmShopId());
        }
        if (null != shopId) {
            provinceCode = null;
            cityCode = null;
            countyCode = null;
        }
        Sku sku = new Sku();
        sku.setSkuName(querySkuBasicDataReqBO.getSkuName());
        sku.setMaterialId(querySkuBasicDataReqBO.getMaterialId());
        sku.setVendorId(querySkuBasicDataReqBO.getSupplierId() == null ? null : querySkuBasicDataReqBO.getSupplierId().toString());
        sku.setSkuIds(querySkuBasicDataReqBO.getSkuIds());
        sku.setMaterialIds(querySkuBasicDataReqBO.getMaterialIds());
        sku.setProvinceCode(provinceCode);
        sku.setCityCode(cityCode);
        sku.setCountyCode(countyCode);
        sku.setBrandName(querySkuBasicDataReqBO.getBrandName());
        sku.setBrandId(querySkuBasicDataReqBO.getBrandId());
        sku.setSupplierId(shopId);
        List<SkuAndProvPO> skus = this.xlsSkuMapper.selectSkuListProvForBasicData(sku, (Page<Sku>)page);
        logger.debug("\u67e5\u8be2\u53c2\u6570" + JSONObject.toJSONString((Object)sku) + "\u67e5\u8be2\u7ed3\u679c" + skus.size());
        ArrayList<QuerySkuBasicDataRspBO> querySkuBasicDataRspBOList = new ArrayList<QuerySkuBasicDataRspBO>();
        if (CollectionUtils.isNotEmpty(skus)) {
            Map<String, Map<String, String>> escaMap = this.getEscape();
            for (SkuAndProvPO sku1 : skus) {
                QuerySkuBasicDataRspBO querySkuBasicDataRspBO = new QuerySkuBasicDataRspBO();
                BeanUtils.copyProperties((Object)sku1, (Object)querySkuBasicDataRspBO);
                if (StringUtils.isNotEmpty((CharSequence)sku1.getPurchaseType()) && escaMap.get("PURCHASE_TYPE_STR") != null) {
                    querySkuBasicDataRspBO.setPurchaseTypeStr(escaMap.get("PURCHASE_TYPE_STR").get(sku1.getPurchaseType()));
                }
                if (StringUtils.isNotEmpty((CharSequence)sku1.getAllowNegativeStock()) && escaMap.get("ALLOW_NEGATIVE_STOCK_STR") != null) {
                    querySkuBasicDataRspBO.setAllowNegativeStockStr(escaMap.get("ALLOW_NEGATIVE_STOCK_STR").get(sku1.getAllowNegativeStock()));
                }
                if (StringUtils.isNotEmpty((CharSequence)sku1.getHasSerialNumber()) && escaMap.get("HAS_SERIAL_NUMBER_STR") != null) {
                    querySkuBasicDataRspBO.setHasSerialNumberStr(escaMap.get("HAS_SERIAL_NUMBER_STR").get(sku1.getHasSerialNumber()));
                }
                if (StringUtils.isEmpty((CharSequence)sku1.getHasSerialNumber())) {
                    querySkuBasicDataRspBO.setHasSerialNumber("0");
                    querySkuBasicDataRspBO.setHasSerialNumberStr(escaMap.get("HAS_SERIAL_NUMBER_STR").get("0"));
                }
                querySkuBasicDataRspBOList.add(querySkuBasicDataRspBO);
            }
        }
        result.setRows(querySkuBasicDataRspBOList);
        result.setTotal(page.getTotalPages());
        result.setRecordsTotal(page.getTotalCount());
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    public RspInfoListBO<QuerySkuBasicDataRspBO> querySkuBasicDataNoPage(QuerySkuBasicDataNoPageReqBO querySkuBasicDataNoPageReqBO) {
        RspInfoListBO result = new RspInfoListBO();
        logger.debug("\u67e5\u8be2sku\u57fa\u7840\u4fe1\u606f\u670d\u52a1\u5165\u53c2=" + JSON.toJSONString((Object)querySkuBasicDataNoPageReqBO));
        String provinceCode = null;
        String cityCode = null;
        String countyCode = null;
        Long supplierId = null;
        provinceCode = StringUtils.isBlank((CharSequence)querySkuBasicDataNoPageReqBO.getProvinceCode()) ? querySkuBasicDataNoPageReqBO.getProvinceCode() : querySkuBasicDataNoPageReqBO.getmProvince();
        cityCode = StringUtils.isBlank((CharSequence)querySkuBasicDataNoPageReqBO.getCityCode()) ? querySkuBasicDataNoPageReqBO.getCityCode() : querySkuBasicDataNoPageReqBO.getmCity();
        countyCode = StringUtils.isBlank((CharSequence)querySkuBasicDataNoPageReqBO.getCountyCode()) ? querySkuBasicDataNoPageReqBO.getCountyCode() : querySkuBasicDataNoPageReqBO.getmDistrict();
        if (querySkuBasicDataNoPageReqBO.getSupplierId() != null) {
            supplierId = querySkuBasicDataNoPageReqBO.getSupplierId();
        } else if (StringUtils.isNotBlank((CharSequence)querySkuBasicDataNoPageReqBO.getmShopId())) {
            supplierId = Long.parseLong(querySkuBasicDataNoPageReqBO.getmShopId());
        }
        if (null != supplierId) {
            provinceCode = null;
            cityCode = null;
            countyCode = null;
        }
        Sku sku = new Sku();
        sku.setSkuName(querySkuBasicDataNoPageReqBO.getSkuName());
        sku.setMaterialId(querySkuBasicDataNoPageReqBO.getMaterialId());
        sku.setVendorId(querySkuBasicDataNoPageReqBO.getVendorId());
        sku.setSkuIds(querySkuBasicDataNoPageReqBO.getSkuIds());
        sku.setProvinceCode(provinceCode);
        sku.setCityCode(cityCode);
        sku.setBrandId(querySkuBasicDataNoPageReqBO.getBrandId());
        sku.setBrandName(querySkuBasicDataNoPageReqBO.getBrandName());
        sku.setCountyCode(countyCode);
        sku.setSupplierId(supplierId);
        sku.setMaterialIds(querySkuBasicDataNoPageReqBO.getMaterialIds());
        List<SkuAndProvPO> skus = this.xlsSkuMapper.selectSkuListProvForBasicData(sku);
        ArrayList<QuerySkuBasicDataRspBO> querySkuBasicDataRspBOList = new ArrayList<QuerySkuBasicDataRspBO>();
        if (CollectionUtils.isNotEmpty(skus)) {
            Map<String, Map<String, String>> escaMap = this.getEscape();
            for (SkuAndProvPO sku1 : skus) {
                QuerySkuBasicDataRspBO querySkuBasicDataRspBO = new QuerySkuBasicDataRspBO();
                BeanUtils.copyProperties((Object)sku1, (Object)querySkuBasicDataRspBO);
                if (StringUtils.isNotEmpty((CharSequence)sku1.getPurchaseType()) && escaMap.get("PURCHASE_TYPE_STR") != null) {
                    querySkuBasicDataRspBO.setPurchaseTypeStr(escaMap.get("PURCHASE_TYPE_STR").get(sku1.getPurchaseType()));
                }
                if (StringUtils.isNotEmpty((CharSequence)sku1.getAllowNegativeStock()) && escaMap.get("PROV_GOODS_IS_OR_NO") != null) {
                    querySkuBasicDataRspBO.setAllowNegativeStockStr(escaMap.get("PROV_GOODS_IS_OR_NO").get(sku1.getAllowNegativeStock()));
                }
                if (StringUtils.isNotEmpty((CharSequence)sku1.getHasSerialNumber()) && escaMap.get("PROV_GOODS_IS_OR_NO") != null) {
                    querySkuBasicDataRspBO.setHasSerialNumberStr(escaMap.get("PROV_GOODS_IS_OR_NO").get(sku1.getHasSerialNumber()));
                }
                if (StringUtils.isEmpty((CharSequence)sku1.getHasSerialNumber())) {
                    querySkuBasicDataRspBO.setHasSerialNumber("0");
                    querySkuBasicDataRspBO.setHasSerialNumberStr(escaMap.get("PROV_GOODS_IS_OR_NO").get("0"));
                }
                querySkuBasicDataRspBOList.add(querySkuBasicDataRspBO);
            }
        }
        result.setRows(querySkuBasicDataRspBOList);
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    public Map<String, Map<String, String>> getEscape() {
        List<SysParamTransBusiBO> escaList = this.sysParamsAtomService.selectAll();
        HashMap<String, Map<String, String>> escaMap = new HashMap<String, Map<String, String>>();
        if (!CollectionUtils.isEmpty(escaList)) {
            for (SysParamTransBusiBO es : escaList) {
                if (escaMap.containsKey(es.getParentCode())) {
                    ((Map)escaMap.get(es.getParentCode())).put(es.getCode(), es.getCodeTitle());
                    continue;
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(es.getCode(), es.getCodeTitle());
                escaMap.put(es.getParentCode(), map);
            }
        }
        return escaMap;
    }
}

