/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.ohaotian.commodity.busi.bo.SearchBarEsRspBO;
import com.ohaotian.commodity.busi.bo.SearchBarEsRspInfo;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.xls.commodity.atom.sku.DSkuPreferencesManageService;
import com.xls.commodity.atom.sku.DSkuRecommendManageService;
import com.xls.commodity.busi.sku.RecommendSkuService;
import com.xls.commodity.busi.sku.bo.DSkuIdAndTopPreferencesBO;
import com.xls.commodity.busi.sku.bo.DSkuRecommendBO;
import com.xls.commodity.busi.sku.bo.RecommendSkuReqBO;
import com.xls.commodity.busi.sku.bo.SelectTopSkuPreferencesReqBO;
import com.xls.commodity.busi.sku.bo.XlsCommodityBO;
import com.xls.commodity.busi.sku.bo.XlsCommodityResBO;
import com.xls.commodity.busi.sku.bo.XlsSearchBarEsRspBO;
import com.xls.commodity.dao.XlsCommodityDAO;
import com.xls.commodity.dao.po.XlsCommodityPO;
import com.xls.commodity.intfce.sku.QueryXlsEsBySkuIdsService;
import com.xls.commodity.intfce.sku.bo.QueryXlsEsByCommodityIdsServiceReqBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RecommendSkuServiceImpl
implements RecommendSkuService {
    @Autowired
    private XlsCommodityDAO xlsCommodityDAO;
    @Autowired
    private QueryXlsEsBySkuIdsService queryXlsEsBySkuIdsService;
    @Autowired
    private DSkuPreferencesManageService dSkuPreferencesManageService;
    @Autowired
    private DSkuRecommendManageService dSkuRecommendManageService;
    private static final Logger logger = LoggerFactory.getLogger(RecommendSkuServiceImpl.class);

    public XlsSearchBarEsRspBO recommendSku(RecommendSkuReqBO recommendSkuReqBO) {
        logger.info("\u4f1a\u5458\u4f60\u63a8\u8350\u670d\u52a1\u5165\u53c2=" + recommendSkuReqBO.toString());
        XlsSearchBarEsRspBO xlsSearchBarEsRspBO = new XlsSearchBarEsRspBO();
        ArrayList<SearchBarEsRspInfo> result = new ArrayList<SearchBarEsRspInfo>();
        ArrayList<Long> skuIds = new ArrayList<Long>();
        Long memberId = recommendSkuReqBO.getMemberId();
        if (memberId == null) {
            logger.debug("\u6ca1\u6709\u4f20\u4f1a\u5458ID");
            ArrayList<Long> commodityIds = new ArrayList<Long>();
            List<DSkuIdAndTopPreferencesBO> dSkuIdAndTopPreferencesBOs = this.queryTopSkuPreferences(20, commodityIds);
            if (CollectionUtils.isNotEmpty(dSkuIdAndTopPreferencesBOs)) {
                for (DSkuIdAndTopPreferencesBO dSkuIdAndTopPreferencesBO : dSkuIdAndTopPreferencesBOs) {
                    skuIds.add(dSkuIdAndTopPreferencesBO.getSkuId());
                }
            }
        } else {
            int top;
            List<DSkuIdAndTopPreferencesBO> dSkuIdAndTopPreferencesBOs;
            List dSkuRecommendBOs = null;
            try {
                dSkuRecommendBOs = this.dSkuRecommendManageService.selectDSkuRecommend(memberId);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u6839\u636e\u4f1a\u5458ID\u67e5\u8be2\u4f1a\u5458\u7684\u63a8\u8350\u5546\u54c1\u62a5\u9519");
            }
            if (CollectionUtils.isNotEmpty((Collection)dSkuRecommendBOs)) {
                for (DSkuRecommendBO dSkuRecommendBO : dSkuRecommendBOs) {
                    skuIds.add(dSkuRecommendBO.getSkuId());
                }
            }
            if (skuIds.size() < 20 && CollectionUtils.isNotEmpty(dSkuIdAndTopPreferencesBOs = this.queryTopSkuPreferences(top = 20 - skuIds.size(), skuIds))) {
                for (DSkuIdAndTopPreferencesBO dSkuIdAndTopPreferencesBO : dSkuIdAndTopPreferencesBOs) {
                    skuIds.add(dSkuIdAndTopPreferencesBO.getSkuId());
                }
            }
        }
        if (CollectionUtils.isNotEmpty(skuIds)) {
            HashMap<Long, SearchBarEsRspInfo> mapSearchBarEsRspInfo = new HashMap<Long, SearchBarEsRspInfo>();
            QueryXlsEsByCommodityIdsServiceReqBO queryXlsEsByCommodityIdsServiceReqBO = new QueryXlsEsByCommodityIdsServiceReqBO();
            queryXlsEsByCommodityIdsServiceReqBO.setCommodityIds(skuIds);
            try {
                SearchBarEsRspBO searchBarEsRspBO = this.queryXlsEsBySkuIdsService.queryAllXlsEsByCommodityIds(queryXlsEsByCommodityIdsServiceReqBO);
                List list = searchBarEsRspBO.getResult();
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    for (SearchBarEsRspInfo searchBarEsRspInfo : list) {
                        mapSearchBarEsRspInfo.put(searchBarEsRspInfo.getCommodityId(), searchBarEsRspInfo);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u6839\u636e\u591a\u4e2askuID\u67e5\u8be2es\u5355\u54c1\u4fe1\u606f\u62a5\u9519");
            }
            for (Long l : skuIds) {
                SearchBarEsRspInfo searchBarEsRspInfo = (SearchBarEsRspInfo)mapSearchBarEsRspInfo.get(l);
                if (searchBarEsRspInfo == null) continue;
                result.add(searchBarEsRspInfo);
            }
        }
        xlsSearchBarEsRspBO.setResult(result);
        return xlsSearchBarEsRspBO;
    }

    public XlsCommodityResBO queryProvGoods(RecommendSkuReqBO recommendSkuReqBO) {
        logger.info("\u4f1a\u5458\u4f60\u63a8\u8350\u670d\u52a1\u5165\u53c2=" + recommendSkuReqBO.toString());
        XlsCommodityResBO xlsCommodityResBO = new XlsCommodityResBO();
        ArrayList<XlsCommodityBO> rows = new ArrayList<XlsCommodityBO>();
        ArrayList<Long> skuIds = new ArrayList<Long>();
        Long memberId = recommendSkuReqBO.getMemberId();
        if (memberId == null) {
            logger.debug("\u6ca1\u6709\u4f20\u4f1a\u5458ID");
            ArrayList<Long> commodityIds = new ArrayList<Long>();
            List<DSkuIdAndTopPreferencesBO> dSkuIdAndTopPreferencesBOs = this.queryTopSkuPreferences(20, commodityIds);
            if (CollectionUtils.isNotEmpty(dSkuIdAndTopPreferencesBOs)) {
                for (DSkuIdAndTopPreferencesBO dSkuIdAndTopPreferencesBO : dSkuIdAndTopPreferencesBOs) {
                    skuIds.add(dSkuIdAndTopPreferencesBO.getSkuId());
                }
            }
        } else {
            int top;
            List<DSkuIdAndTopPreferencesBO> dSkuIdAndTopPreferencesBOs;
            List dSkuRecommendBOs = null;
            try {
                dSkuRecommendBOs = this.dSkuRecommendManageService.selectDSkuRecommend(memberId);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u6839\u636e\u4f1a\u5458ID\u67e5\u8be2\u4f1a\u5458\u7684\u63a8\u8350\u5546\u54c1\u62a5\u9519");
            }
            if (CollectionUtils.isNotEmpty((Collection)dSkuRecommendBOs)) {
                for (DSkuRecommendBO dSkuRecommendBO : dSkuRecommendBOs) {
                    skuIds.add(dSkuRecommendBO.getSkuId());
                }
            }
            if (skuIds.size() < 20 && CollectionUtils.isNotEmpty(dSkuIdAndTopPreferencesBOs = this.queryTopSkuPreferences(top = 20 - skuIds.size(), skuIds))) {
                for (DSkuIdAndTopPreferencesBO dSkuIdAndTopPreferencesBO : dSkuIdAndTopPreferencesBOs) {
                    skuIds.add(dSkuIdAndTopPreferencesBO.getSkuId());
                }
            }
        }
        if (CollectionUtils.isNotEmpty(skuIds)) {
            try {
                List<XlsCommodityPO> xlsCommodityPOS = this.xlsCommodityDAO.selectByCommodityIds(skuIds);
                if (!CollectionUtils.isEmpty(xlsCommodityPOS)) {
                    for (XlsCommodityPO xlsCommodityPO : xlsCommodityPOS) {
                        XlsCommodityBO bo = new XlsCommodityBO();
                        BeanUtils.copyProperties((Object)xlsCommodityPO, (Object)bo);
                        bo.setCommodityHighestPriceY(MoneyUtils.Long2BigDecimal((Long)xlsCommodityPO.getCommodityHighestPrice()));
                        bo.setCommodityLowestPriceY(MoneyUtils.Long2BigDecimal((Long)xlsCommodityPO.getCommodityLowestPrice()));
                        rows.add(bo);
                    }
                }
            }
            catch (Exception e) {
                logger.error("\u5546\u54c1\u67e5\u8be2\u62a5\u9519");
                throw new BusinessException("9999", "\u5546\u54c1\u67e5\u8be2\u62a5\u9519" + e.getMessage());
            }
        }
        xlsCommodityResBO.setRows(rows);
        return xlsCommodityResBO;
    }

    List<DSkuIdAndTopPreferencesBO> queryTopSkuPreferences(int top, List<Long> commodityIds) {
        ArrayList<DSkuIdAndTopPreferencesBO> dSkuIdAndTopPreferencesBOs = new ArrayList();
        SelectTopSkuPreferencesReqBO selectTopSkuPreferencesReqBO = new SelectTopSkuPreferencesReqBO();
        selectTopSkuPreferencesReqBO.setTop(top);
        selectTopSkuPreferencesReqBO.setCommodityIds(commodityIds);
        try {
            dSkuIdAndTopPreferencesBOs = this.dSkuPreferencesManageService.selectTopSkuPreferences(selectTopSkuPreferencesReqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6839\u636etop\u503c\u67e5\u8be2\u6bcf\u4e2askuId\u5e73\u5747\u5206\u7684\u524d\u51e0\u540d");
        }
        return dSkuIdAndTopPreferencesBOs;
    }
}

