/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.base.common.bo.RspInfoBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.xls.commodity.atom.sku.DPriceSheetItemManageService;
import com.xls.commodity.atom.sku.DPriceSheetOrgManageService;
import com.xls.commodity.atom.sku.SysParamsAtomService;
import com.xls.commodity.busi.sku.UpdateDPriceSheetService;
import com.xls.commodity.busi.sku.bo.DPriceSheetItemBO;
import com.xls.commodity.busi.sku.bo.PriceSheetBO;
import com.xls.commodity.busi.sku.bo.PriceSheetOrgBO;
import com.xls.commodity.busi.sku.bo.SysParamTransBusiBO;
import com.xls.commodity.busi.sku.bo.UpdateDPriceSheetReqBO;
import com.xls.commodity.dao.PriceSheetDAO;
import com.xls.commodity.dao.po.PriceSheetPO;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpdateDPriceSheetServiceImpl
implements UpdateDPriceSheetService {
    @Autowired
    private DPriceSheetOrgManageService dPriceSheetOrgManageService;
    @Autowired
    private DPriceSheetItemManageService dPriceSheetItemManageService;
    @Autowired
    private PriceSheetDAO priceSheetDAO;
    @Autowired
    private SysParamsAtomService sysParamsAtomService;
    private static final Logger logger = LoggerFactory.getLogger(UpdateDPriceSheetServiceImpl.class);

    public RspInfoBO editDPriceSheetDetail(UpdateDPriceSheetReqBO reqBO) {
        logger.debug("\u5546\u54c1\u4e2d\u5fc3\u4fee\u6539\u62a5\u4ef7\u5355:" + JSONObject.toJSONString((Object)reqBO));
        RspInfoBO rspInfoBO = new RspInfoBO();
        this.validateParams(reqBO);
        logger.error("\u5546\u54c1\u4e2d\u5fc3\u4fee\u6539\u62a5\u4ef7\u5355444444:" + JSONObject.toJSONString((Object)reqBO));
        PriceSheetBO sheetBO = reqBO.getPriceSheetBO();
        StringBuffer orgRange = new StringBuffer();
        for (Object priceSheetOrgBO : reqBO.getPriceSheetOrgBOList()) {
            orgRange.append(priceSheetOrgBO.getOrgName() + ",");
        }
        PriceSheetPO po = new PriceSheetPO();
        BeanUtils.copyProperties((Object)sheetBO, (Object)po);
        po.setCheckStatus("00");
        po.setUpdateTime(new Date());
        po.setOrgRange(orgRange.substring(0, orgRange.length() - 1));
        try {
            this.priceSheetDAO.updateByPrimaryKeySelective(po);
            this.dPriceSheetOrgManageService.deleteSheetOrgBySheetId(sheetBO.getSheetId());
            this.dPriceSheetItemManageService.deleteSheetItemBySheetId(sheetBO.getSheetId());
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getdPriceSheetItemBOList())) {
                for (DPriceSheetItemBO bo : reqBO.getdPriceSheetItemBOList()) {
                    bo.setSheetId(sheetBO.getSheetId());
                    bo.setSheetNo(sheetBO.getSheetNo());
                    bo.setIsRootControl("0");
                }
                logger.debug(JSONObject.toJSONString((Object)reqBO.getdPriceSheetItemBOList()));
                this.dPriceSheetItemManageService.insertSheetItemBatch(reqBO.getdPriceSheetItemBOList());
            }
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getPriceSheetOrgBOList())) {
                Map<String, Map<String, String>> escaMap = this.getEscape();
                for (PriceSheetOrgBO bo : reqBO.getPriceSheetOrgBOList()) {
                    bo.setOrgLevel(escaMap.get("ORG_TYPE").get(bo.getOrgLevel()));
                    bo.setSheetId(sheetBO.getSheetId());
                    bo.setSheetNo(sheetBO.getSheetNo());
                }
                logger.debug(JSONObject.toJSONString((Object)reqBO.getPriceSheetOrgBOList()));
                this.dPriceSheetOrgManageService.insertSheetOrgBatch(reqBO.getPriceSheetOrgBOList());
            }
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u4e2d\u5fc3\u4fee\u6539\u62a5\u4ef7\u5355\u51fa\u9519" + e);
            throw new BusinessException("8888", "\u5546\u54c1\u4e2d\u5fc3\u4fee\u6539\u62a5\u4ef7\u5355\u51fa\u9519!");
        }
        rspInfoBO.setRespCode("0000");
        rspInfoBO.setRespDesc("\u6210\u529f");
        return rspInfoBO;
    }

    private void validateParams(UpdateDPriceSheetReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("7777", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (reqBO.getPriceSheetBO() == null) {
            throw new BusinessException("7777", "\u5165\u53c2SheetBO\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getPriceSheetOrgBOList())) {
            throw new BusinessException("7777", "\u5165\u53c2\u9002\u7528\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (reqBO.getPriceSheetBO().getSheetId() == null) {
            throw new BusinessException("7777", "\u5165\u53c2SheetId\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }

    public Map<String, Map<String, String>> getEscape() {
        List<SysParamTransBusiBO> escaList = this.sysParamsAtomService.selectAll();
        HashMap<String, Map<String, String>> escaMap = new HashMap<String, Map<String, String>>();
        if (!CollectionUtils.isEmpty(escaList)) {
            for (SysParamTransBusiBO es : escaList) {
                if (escaMap.containsKey(es.getParentCode())) {
                    ((Map)escaMap.get(es.getParentCode())).put(es.getCode(), es.getCodeTitle());
                    continue;
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(es.getCode(), es.getCodeTitle());
                escaMap.put(es.getParentCode(), map);
            }
        }
        return escaMap;
    }
}

