/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.intfce.sku.impl;

import com.ohaotian.base.common.exception.BusinessException;
import com.ohaotian.commodity.busi.sku.bo.SkuPriceRspBO;
import com.ohaotian.commodity.busi.sku.bo.SkuSpecBO;
import com.ohaotian.commodity.dao.SkuPriceMapper;
import com.ohaotian.commodity.dao.SkuSpecMapper;
import com.ohaotian.commodity.dao.po.SkuPrice;
import com.ohaotian.commodity.dao.po.SkuSpec;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import com.xls.commodity.busi.sku.SysParamTransferBusiService;
import com.xls.commodity.dao.CommodityTypeDAO;
import com.xls.commodity.dao.ProvGoodsDAO;
import com.xls.commodity.dao.XlsSkuMapper;
import com.xls.commodity.dao.po.CommodityTypePO;
import com.xls.commodity.dao.po.Sku;
import com.xls.commodity.intfce.sku.QuerySkuListForBackgroundService;
import com.xls.commodity.intfce.sku.bo.QuerySkuDetailRspBO;
import com.xls.commodity.intfce.sku.bo.QuerySkuDetailRspListBO;
import com.xls.commodity.intfce.sku.bo.QuerySkuListForBackgroundReqBO;
import com.xls.commodity.intfce.sku.bo.RspPageBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class QuerySkuListForBackgroundServiceImpl
implements QuerySkuListForBackgroundService {
    private static final Logger logger = LoggerFactory.getLogger(QuerySkuListForBackgroundServiceImpl.class);
    @Autowired
    private XlsSkuMapper xlsSkuMapper;
    @Autowired
    private SysParamTransferBusiService sysParamTransferBusiService;
    @Autowired
    private CommodityTypeDAO commodityTypeDAO;
    @Autowired
    private SkuPriceMapper skuPriceMapper;
    @Autowired
    private SkuSpecMapper skuSpecMapper;
    @Autowired
    private ProvGoodsDAO provGoodsDAO;

    public RspPageBO<QuerySkuDetailRspBO> querySkuListForBackground(QuerySkuListForBackgroundReqBO querySkuListForBackgroundReqBO) {
        logger.info("QuerySkuListForBackgroundService\u5165\u53c2\uff1a" + querySkuListForBackgroundReqBO.toString());
        RspPageBO result = new RspPageBO();
        try {
            Page page = new Page();
            page.setPageSize(querySkuListForBackgroundReqBO.getPageSize());
            page.setPageNo(querySkuListForBackgroundReqBO.getCurrent());
            Sku skuPO = new Sku();
            if (null != querySkuListForBackgroundReqBO.getSupplierId()) {
                skuPO.setSupplierId(querySkuListForBackgroundReqBO.getSupplierId());
            }
            if (null != querySkuListForBackgroundReqBO.getMaterialId()) {
                skuPO.setMaterialId(querySkuListForBackgroundReqBO.getMaterialId());
            }
            if (null != querySkuListForBackgroundReqBO.getExtSkuId()) {
                skuPO.setExtSkuId(querySkuListForBackgroundReqBO.getExtSkuId());
            }
            if (null != querySkuListForBackgroundReqBO.getSkuStatus()) {
                skuPO.setSkuStatus(querySkuListForBackgroundReqBO.getSkuStatus());
            }
            if (null != querySkuListForBackgroundReqBO.getBrandName()) {
                skuPO.setBrandName(querySkuListForBackgroundReqBO.getBrandName());
            }
            if (null != querySkuListForBackgroundReqBO.getCommodityTypeId()) {
                skuPO.setCommodityTypeId(querySkuListForBackgroundReqBO.getCommodityTypeId());
            }
            if (null != querySkuListForBackgroundReqBO.getSkuName()) {
                skuPO.setSkuName(querySkuListForBackgroundReqBO.getSkuName());
            }
            if (StringUtils.isNotEmpty((CharSequence)querySkuListForBackgroundReqBO.getHasInteractive())) {
                skuPO.setHasInteractiveStr(querySkuListForBackgroundReqBO.getHasInteractive());
                skuPO.setHasInteractive(Integer.valueOf(querySkuListForBackgroundReqBO.getHasInteractive()));
            }
            if (StringUtils.isNotEmpty((CharSequence)querySkuListForBackgroundReqBO.getHasWisdom())) {
                skuPO.setHasWisdomStr(querySkuListForBackgroundReqBO.getHasWisdom());
                skuPO.setHasWisdom(Integer.valueOf(querySkuListForBackgroundReqBO.getHasWisdom()));
            }
            if (null != querySkuListForBackgroundReqBO.getMfgSku()) {
                skuPO.setMfgSku(querySkuListForBackgroundReqBO.getMfgSku());
            }
            if (CollectionUtils.isNotEmpty((Collection)querySkuListForBackgroundReqBO.getSkuIds())) {
                skuPO.setSkuIds(querySkuListForBackgroundReqBO.getSkuIds());
            }
            if (CollectionUtils.isNotEmpty((Collection)querySkuListForBackgroundReqBO.getSupplierIds())) {
                skuPO.setSupplierIds(querySkuListForBackgroundReqBO.getSupplierIds());
            }
            logger.info("po\u5165\u53c2\uff1a" + skuPO.toString());
            List<Sku> skus = this.xlsSkuMapper.selectSkuListProvList(skuPO, (Page<Sku>)page);
            ArrayList<QuerySkuDetailRspBO> listSkuDedail = new ArrayList<QuerySkuDetailRspBO>();
            ArrayList<Long> skuIds = new ArrayList<Long>();
            ArrayList<Long> commodityTypeIds = new ArrayList<Long>();
            if (CollectionUtils.isNotEmpty(skus)) {
                for (Sku sku : skus) {
                    skuIds.add(sku.getSkuId());
                    if (sku.getCommodityTypeId() != null) {
                        commodityTypeIds.add(sku.getCommodityTypeId());
                    }
                    QuerySkuDetailRspBO querySkuDetailRspBO = new QuerySkuDetailRspBO();
                    BeanUtils.copyProperties((Object)sku, (Object)querySkuDetailRspBO);
                    listSkuDedail.add(querySkuDetailRspBO);
                }
            }
            Map<String, String> statusMap = this.selectSkuStatusStr();
            Map<Long, CommodityTypePO> mapCommodityTypePO = this.selectCommodityTypeId(commodityTypeIds);
            Map<Long, SkuPriceRspBO> mapSkuPriceRspBO = this.selectSkuPrice(skuIds);
            if (CollectionUtils.isNotEmpty(listSkuDedail)) {
                for (QuerySkuDetailRspBO querySkuDetailRspBO : listSkuDedail) {
                    CommodityTypePO CommodityTypePO2;
                    if (null != querySkuDetailRspBO.getSkuStatus() && MapUtils.isNotEmpty(statusMap)) {
                        querySkuDetailRspBO.setSkuStatusStr(statusMap.get(String.valueOf(querySkuDetailRspBO.getSkuStatus())));
                    }
                    if (querySkuDetailRspBO.getCommodityTypeId() != null && MapUtils.isNotEmpty(mapCommodityTypePO) && (CommodityTypePO2 = mapCommodityTypePO.get(querySkuDetailRspBO.getCommodityTypeId())) != null) {
                        querySkuDetailRspBO.setCommodityTypeName(CommodityTypePO2.getCommodityTypeName());
                    }
                    if (!MapUtils.isNotEmpty(mapSkuPriceRspBO)) continue;
                    querySkuDetailRspBO.setPrice(mapSkuPriceRspBO.get(querySkuDetailRspBO.getSkuId()));
                }
            }
            result.setRespCode("0000");
            result.setRespDesc("\u6210\u529f");
            result.setRows(listSkuDedail);
            result.setTotal(page.getTotalPages());
            result.setRecordsTotal(page.getTotalCount());
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u5217\u8868\u67e5\u8be2\u670d\u52a1\u9519\u8bef" + e);
            result.setRespCode("8888");
            result.setRespDesc("\u5546\u54c1\u5217\u8868\u67e5\u8be2\u670d\u52a1\u9519\u8bef");
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5546\u54c1\u5217\u8868\u67e5\u8be2\u670d\u52a1\u9519\u8bef");
        }
        return result;
    }

    public QuerySkuDetailRspListBO querySkuListForNoPageBackground(QuerySkuListForBackgroundReqBO querySkuListForBackgroundReqBO) {
        logger.info("QuerySkuListForBackgroundService\u5165\u53c2\uff1a" + querySkuListForBackgroundReqBO.toString());
        QuerySkuDetailRspListBO result = new QuerySkuDetailRspListBO();
        try {
            Sku skuPO = new Sku();
            if (null != querySkuListForBackgroundReqBO.getSupplierId()) {
                skuPO.setSupplierId(querySkuListForBackgroundReqBO.getSupplierId());
            }
            if (null != querySkuListForBackgroundReqBO.getMaterialId()) {
                skuPO.setMaterialId(querySkuListForBackgroundReqBO.getMaterialId());
            }
            if (null != querySkuListForBackgroundReqBO.getExtSkuId()) {
                skuPO.setExtSkuId(querySkuListForBackgroundReqBO.getExtSkuId());
            }
            if (null != querySkuListForBackgroundReqBO.getSkuStatus()) {
                skuPO.setSkuStatus(querySkuListForBackgroundReqBO.getSkuStatus());
            }
            if (null != querySkuListForBackgroundReqBO.getBrandName()) {
                skuPO.setBrandName(querySkuListForBackgroundReqBO.getBrandName());
            }
            if (null != querySkuListForBackgroundReqBO.getCommodityTypeId()) {
                skuPO.setCommodityTypeId(querySkuListForBackgroundReqBO.getCommodityTypeId());
            }
            if (null != querySkuListForBackgroundReqBO.getSkuName()) {
                skuPO.setSkuName(querySkuListForBackgroundReqBO.getSkuName());
            }
            if (StringUtils.isNotEmpty((CharSequence)querySkuListForBackgroundReqBO.getHasInteractive())) {
                skuPO.setHasInteractiveStr(querySkuListForBackgroundReqBO.getHasInteractive());
                skuPO.setHasInteractive(Integer.valueOf(querySkuListForBackgroundReqBO.getHasInteractive()));
            }
            if (StringUtils.isNotEmpty((CharSequence)querySkuListForBackgroundReqBO.getHasWisdom())) {
                skuPO.setHasWisdomStr(querySkuListForBackgroundReqBO.getHasWisdom());
                skuPO.setHasWisdom(Integer.valueOf(querySkuListForBackgroundReqBO.getHasWisdom()));
            }
            if (null != querySkuListForBackgroundReqBO.getMfgSku()) {
                skuPO.setMfgSku(querySkuListForBackgroundReqBO.getMfgSku());
            }
            if (CollectionUtils.isNotEmpty((Collection)querySkuListForBackgroundReqBO.getSkuIds())) {
                skuPO.setSkuIds(querySkuListForBackgroundReqBO.getSkuIds());
            }
            if (CollectionUtils.isNotEmpty((Collection)querySkuListForBackgroundReqBO.getSupplierIds())) {
                skuPO.setSupplierIds(querySkuListForBackgroundReqBO.getSupplierIds());
            }
            if (CollectionUtils.isNotEmpty((Collection)querySkuListForBackgroundReqBO.getMaterialIds())) {
                skuPO.setMaterialIds(querySkuListForBackgroundReqBO.getMaterialIds());
            }
            logger.info("po\u5165\u53c2\uff1a" + skuPO.toString());
            List<Sku> skus = this.xlsSkuMapper.selectSkuListForBackground(skuPO);
            ArrayList<QuerySkuDetailRspBO> listSkuDedail = new ArrayList<QuerySkuDetailRspBO>();
            ArrayList<Long> skuIds = new ArrayList<Long>();
            ArrayList<Long> commodityTypeIds = new ArrayList<Long>();
            if (CollectionUtils.isNotEmpty(skus)) {
                for (Sku sku : skus) {
                    skuIds.add(sku.getSkuId());
                    if (sku.getCommodityTypeId() != null) {
                        commodityTypeIds.add(sku.getCommodityTypeId());
                    }
                    QuerySkuDetailRspBO querySkuDetailRspBO = new QuerySkuDetailRspBO();
                    BeanUtils.copyProperties((Object)sku, (Object)querySkuDetailRspBO);
                    listSkuDedail.add(querySkuDetailRspBO);
                }
            }
            Map<String, String> statusMap = this.selectSkuStatusStr();
            Map<Long, CommodityTypePO> mapCommodityTypePO = this.selectCommodityTypeId(commodityTypeIds);
            Map<Long, SkuPriceRspBO> mapSkuPriceRspBO = this.selectSkuPrice(skuIds);
            Map<Long, List<SkuSpecBO>> mapListSkuSpec = this.selectSkuSpecs(skuIds);
            if (CollectionUtils.isNotEmpty(listSkuDedail)) {
                for (QuerySkuDetailRspBO querySkuDetailRspBO : listSkuDedail) {
                    CommodityTypePO CommodityTypePO2;
                    if (null != querySkuDetailRspBO.getSkuStatus() && MapUtils.isNotEmpty(statusMap)) {
                        querySkuDetailRspBO.setSkuStatusStr(statusMap.get(String.valueOf(querySkuDetailRspBO.getSkuStatus())));
                    }
                    if (querySkuDetailRspBO.getCommodityTypeId() != null && MapUtils.isNotEmpty(mapCommodityTypePO) && (CommodityTypePO2 = mapCommodityTypePO.get(querySkuDetailRspBO.getCommodityTypeId())) != null) {
                        querySkuDetailRspBO.setCommodityTypeName(CommodityTypePO2.getCommodityTypeName());
                    }
                    if (MapUtils.isNotEmpty(mapSkuPriceRspBO)) {
                        querySkuDetailRspBO.setPrice(mapSkuPriceRspBO.get(querySkuDetailRspBO.getSkuId()));
                    }
                    if (!MapUtils.isNotEmpty(mapListSkuSpec)) continue;
                    List<SkuSpecBO> skuSpecs1 = mapListSkuSpec.get(querySkuDetailRspBO.getSkuId());
                    querySkuDetailRspBO.setSpecs(skuSpecs1);
                }
            }
            result.setRespCode("0000");
            result.setRespDesc("\u6210\u529f");
            result.setRows(listSkuDedail);
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u5217\u8868\u67e5\u8be2\u670d\u52a1\u9519\u8bef" + e);
            result.setRespCode("8888");
            result.setRespDesc("\u5546\u54c1\u5217\u8868\u67e5\u8be2\u670d\u52a1\u9519\u8bef");
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5546\u54c1\u5217\u8868\u67e5\u8be2\u670d\u52a1\u9519\u8bef");
        }
        return result;
    }

    Map<String, String> selectSkuStatusStr() {
        Map statusMap = this.sysParamTransferBusiService.sysParamTransferByParentCode("SYS_SKU_STSTUS");
        return statusMap;
    }

    Map<Long, CommodityTypePO> selectCommodityTypeId(List<Long> commodityTypeIds) {
        List<CommodityTypePO> commodityTypePOs;
        HashMap<Long, CommodityTypePO> mapCommodityTypePO = new HashMap<Long, CommodityTypePO>();
        if (CollectionUtils.isNotEmpty(commodityTypeIds) && CollectionUtils.isNotEmpty(commodityTypePOs = this.commodityTypeDAO.selectByCommodityTypeIds(commodityTypeIds))) {
            for (CommodityTypePO commodityTypePO : commodityTypePOs) {
                mapCommodityTypePO.put(commodityTypePO.getCommodityTypeId(), commodityTypePO);
            }
        }
        return mapCommodityTypePO;
    }

    Map<Long, SkuPriceRspBO> selectSkuPrice(List<Long> skuIds) {
        List skuPrices;
        HashMap<Long, SkuPriceRspBO> mapSkuPriceRspBO = new HashMap<Long, SkuPriceRspBO>();
        if (CollectionUtils.isNotEmpty(skuIds) && CollectionUtils.isNotEmpty((Collection)(skuPrices = this.skuPriceMapper.selectBySkuIds(skuIds)))) {
            for (SkuPrice skuPrice : skuPrices) {
                SkuPriceRspBO skuPriceRspBO = this.price2skuPriceBO(skuPrice);
                mapSkuPriceRspBO.put(skuPrice.getSkuId(), skuPriceRspBO);
            }
        }
        return mapSkuPriceRspBO;
    }

    Map<Long, List<SkuSpecBO>> selectSkuSpecs(List<Long> skuIds) {
        List skuSpecs;
        HashMap<Long, List<SkuSpecBO>> mapListSkuSpec = new HashMap<Long, List<SkuSpecBO>>();
        if (CollectionUtils.isNotEmpty(skuIds) && CollectionUtils.isNotEmpty((Collection)(skuSpecs = this.skuSpecMapper.selectSpecBySkuIds(skuIds)))) {
            for (SkuSpec skuSpec : skuSpecs) {
                SkuSpecBO skuSpecBO = new SkuSpecBO();
                BeanUtils.copyProperties((Object)skuSpec, (Object)skuSpecBO);
                ArrayList<SkuSpecBO> skuSpecs1 = (ArrayList<SkuSpecBO>)mapListSkuSpec.get(skuSpec.getSkuId());
                if (CollectionUtils.isNotEmpty((Collection)skuSpecs1)) {
                    skuSpecs1.add(skuSpecBO);
                    continue;
                }
                skuSpecs1 = new ArrayList<SkuSpecBO>();
                skuSpecs1.add(skuSpecBO);
                mapListSkuSpec.put(skuSpec.getSkuId(), skuSpecs1);
            }
        }
        return mapListSkuSpec;
    }

    SkuPriceRspBO price2skuPriceBO(SkuPrice price) {
        SkuPriceRspBO skuPriceRspBO = new SkuPriceRspBO();
        BeanUtils.copyProperties((Object)price, (Object)skuPriceRspBO);
        try {
            if (price.getMarketPrice() != null) {
                skuPriceRspBO.setMarketPrice(MoneyUtils.Long2BigDecimal((Long)price.getMarketPrice()));
            }
            if (price.getAgreementPrice() != null) {
                skuPriceRspBO.setAgreementPrice(MoneyUtils.Long2BigDecimal((Long)price.getAgreementPrice()));
            }
            if (price.getMemberPrice() != null) {
                skuPriceRspBO.setMemberPrice(MoneyUtils.Long2BigDecimal((Long)price.getMemberPrice()));
            }
            if (price.getSalePrice() != null) {
                skuPriceRspBO.setSalePriceL(price.getSalePrice());
                skuPriceRspBO.setSalePrice(MoneyUtils.Long2BigDecimal((Long)price.getSalePrice()));
            }
            if (price.getSparePrice1() != null) {
                skuPriceRspBO.setSparePrice1(MoneyUtils.Long2BigDecimal((Long)price.getSparePrice1()));
            }
            if (price.getSparePrice2() != null) {
                skuPriceRspBO.setSparePrice2(MoneyUtils.Long2BigDecimal((Long)price.getSparePrice2()));
            }
            if (price.getAssessmentPrice() != null) {
                skuPriceRspBO.setAssessmentPrice(MoneyUtils.Long2BigDecimal((Long)price.getAssessmentPrice()));
            }
            if (price.getPurchasePrice() != null) {
                skuPriceRspBO.setPurchasePriceL(price.getPurchasePrice());
                skuPriceRspBO.setPurchasePrice(MoneyUtils.Long2BigDecimal((Long)price.getPurchasePrice()));
            }
            if (price.getMemberLadderPrice1() != null) {
                skuPriceRspBO.setMemberLadderPrice1(MoneyUtils.Long2BigDecimal((Long)price.getMemberLadderPrice1()));
            }
            if (price.getMemberLadderPrice2() != null) {
                skuPriceRspBO.setMemberLadderPrice2(MoneyUtils.Long2BigDecimal((Long)price.getMemberLadderPrice2()));
            }
            if (price.getMemberLadderPrice3() != null) {
                skuPriceRspBO.setMemberLadderPrice3(MoneyUtils.Long2BigDecimal((Long)price.getMemberLadderPrice3()));
            }
            if (price.getMemberLadderPrice4() != null) {
                skuPriceRspBO.setMemberLadderPrice4(MoneyUtils.Long2BigDecimal((Long)price.getMemberLadderPrice4()));
            }
            if (price.getMemberLadderPrice5() != null) {
                skuPriceRspBO.setMemberLadderPrice5(MoneyUtils.Long2BigDecimal((Long)price.getMemberLadderPrice5()));
            }
        }
        catch (Exception e) {
            logger.error("\u91d1\u989d\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38" + e.getMessage());
        }
        return skuPriceRspBO;
    }
}

