/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.thread;

import com.ohaotian.base.common.util.MoneyUtil;
import com.xls.commodity.atom.sku.XlsSkuPriceManageService;
import com.xls.commodity.busi.sku.bo.PriceBO;
import com.xls.commodity.busi.sku.bo.PriceSheetItemBO;
import com.xls.commodity.dao.XlsSkuMapper;
import com.xls.commodity.dao.po.Sku;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangePriceThread
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ChangePriceThread.class);
    private Map<String, PriceSheetItemBO> priceMap;
    private List<Sku> skuList;
    private XlsSkuMapper xlsSkuMapper;
    private XlsSkuPriceManageService xlsSkuPriceManageService;
    private Long sheetId;

    public ChangePriceThread(Map<String, PriceSheetItemBO> priceMap, List<Sku> skuList, XlsSkuMapper xlsSkuMapper, XlsSkuPriceManageService xlsSkuPriceManageService, Long sheetId) {
        this.priceMap = priceMap;
        this.skuList = skuList;
        this.xlsSkuMapper = xlsSkuMapper;
        this.xlsSkuPriceManageService = xlsSkuPriceManageService;
        this.sheetId = sheetId;
    }

    @Override
    public void run() {
        ArrayList<Sku> price = new ArrayList<Sku>();
        ArrayList<PriceBO> priceBOList = new ArrayList<PriceBO>();
        Sku po = null;
        PriceBO priceBO = null;
        try {
            for (Sku sku : this.skuList) {
                po = new Sku();
                po.setSkuId(sku.getSkuId());
                po.setSkuPrice(MoneyUtil.BigDecimal2Long((BigDecimal)this.priceMap.get(sku.getMaterialId()).getSalePriceStr()));
                po.setProvinceCode(sku.getProvinceCode());
                price.add(po);
                priceBO = new PriceBO();
                priceBO.setSkuId(sku.getSkuId());
                priceBO.setAgreementPrice(MoneyUtil.BigDecimal2Long((BigDecimal)this.priceMap.get(sku.getMaterialId()).getAgreementPriceStr()));
                priceBO.setAssessmentPrice(MoneyUtil.BigDecimal2Long((BigDecimal)this.priceMap.get(sku.getMaterialId()).getAgreementPriceStr()));
                priceBO.setCgType(sku.getCgType());
                priceBO.setCostPrice(MoneyUtil.BigDecimal2Long((BigDecimal)this.priceMap.get(sku.getMaterialId()).getAgreementPriceStr()));
                priceBO.setLastPurchasePrice(MoneyUtil.BigDecimal2Long((BigDecimal)this.priceMap.get(sku.getMaterialId()).getAgreementPriceStr()));
                priceBO.setMarketPrice(MoneyUtil.BigDecimal2Long((BigDecimal)this.priceMap.get(sku.getMaterialId()).getAgreementPriceStr()));
                priceBO.setMemberLadderPrice1(MoneyUtil.BigDecimal2Long((BigDecimal)this.priceMap.get(sku.getMaterialId()).getAgreementPriceStr()));
                priceBO.setMemberLadderPrice2(MoneyUtil.BigDecimal2Long((BigDecimal)this.priceMap.get(sku.getMaterialId()).getAgreementPriceStr()));
                priceBO.setMemberLadderPrice3(MoneyUtil.BigDecimal2Long((BigDecimal)this.priceMap.get(sku.getMaterialId()).getAgreementPriceStr()));
                priceBO.setMemberLadderPrice4(MoneyUtil.BigDecimal2Long((BigDecimal)this.priceMap.get(sku.getMaterialId()).getAgreementPriceStr()));
                priceBO.setMemberLadderPrice5(MoneyUtil.BigDecimal2Long((BigDecimal)this.priceMap.get(sku.getMaterialId()).getAgreementPriceStr()));
                priceBO.setMemberPrice(MoneyUtil.BigDecimal2Long((BigDecimal)this.priceMap.get(sku.getMaterialId()).getAgreementPriceStr()));
                priceBO.setPurchasePrice(MoneyUtil.BigDecimal2Long((BigDecimal)this.priceMap.get(sku.getMaterialId()).getAgreementPriceStr()));
                priceBO.setSalePrice(MoneyUtil.BigDecimal2Long((BigDecimal)this.priceMap.get(sku.getMaterialId()).getAgreementPriceStr()));
                priceBO.setSheetLevel(this.priceMap.get(sku.getMaterialId()).getSheetLevel());
                priceBO.setSheetId(this.sheetId);
                priceBO.setSparePrice2(MoneyUtil.BigDecimal2Long((BigDecimal)this.priceMap.get(sku.getMaterialId()).getSparePrice2Str()));
                priceBO.setSparePrice3(this.priceMap.get(sku.getMaterialId()).getSparePrice3Str() == null ? null : MoneyUtil.BigDecimal2Long((BigDecimal)this.priceMap.get(sku.getMaterialId()).getSparePrice3Str()).toString());
                priceBO.setSparePrice4(this.priceMap.get(sku.getMaterialId()).getSparePrice4Str() == null ? null : MoneyUtil.BigDecimal2Long((BigDecimal)this.priceMap.get(sku.getMaterialId()).getSparePrice4Str()).toString());
                priceBO.setSparePrice5(this.priceMap.get(sku.getMaterialId()).getSparePrice5Str() == null ? null : MoneyUtil.BigDecimal2Long((BigDecimal)this.priceMap.get(sku.getMaterialId()).getSparePrice5Str()).toString());
                priceBO.setUpdateTime(new Date());
                priceBOList.add(priceBO);
            }
            this.xlsSkuMapper.batchUpdateBySkuId(price);
            logger.debug("\u4fee\u6539\u4ef7\u683c\u8868\u4ef7\u683c");
            this.xlsSkuPriceManageService.batchUpdateSkuPrice(priceBOList);
        }
        catch (Exception e) {
            logger.debug("\u4ef7\u683c\u4fee\u6539\u9519\u8bef");
        }
    }
}

