/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.thread;

import com.ohaotian.base.common.util.MoneyUtil;
import com.xls.commodity.atom.sku.XlsSkuPriceManageService;
import com.xls.commodity.busi.sku.bo.HeadquarterOfferAddReqBO;
import com.xls.commodity.busi.sku.bo.PriceBO;
import com.xls.commodity.busi.sku.bo.PriceSheetItemBO;
import com.xls.commodity.dao.XlsSkuMapper;
import com.xls.commodity.dao.po.Sku;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class PriceSheetAddThread
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(PriceSheetAddThread.class);
    private XlsSkuMapper xlsSkuMapper;
    private XlsSkuPriceManageService xlsSkuPriceManageService;
    private List<String> provCode;
    private List<String> matreialIds;
    private HeadquarterOfferAddReqBO reqBO;
    private Long sheetId;

    public PriceSheetAddThread(XlsSkuMapper xlsSkuMapper, XlsSkuPriceManageService xlsSkuPriceManageService, List<String> provCode, List<String> matreialIds, HeadquarterOfferAddReqBO reqBO, Long sheetId) {
        this.xlsSkuMapper = xlsSkuMapper;
        this.xlsSkuPriceManageService = xlsSkuPriceManageService;
        this.provCode = provCode;
        this.matreialIds = matreialIds;
        this.reqBO = reqBO;
        this.sheetId = sheetId;
    }

    @Override
    public void run() {
        try {
            for (String prov : this.provCode) {
                List<Object> skuList = new ArrayList();
                ArrayList<String> code = new ArrayList<String>();
                code.add(prov);
                logger.debug("sku\u5165\u53c2\u7269\u6599\u7684\u6570\u91cf\uff1a" + this.matreialIds.size());
                logger.debug("\u7701\u4efd\u7684\u6570\u91cf" + code.size());
                skuList = this.xlsSkuMapper.queryXlsSkuByProvCodesAndMaterialIds(code, this.matreialIds);
                logger.debug("\u5373\u5c06\u66f4\u65b0\u7684sku" + skuList.size());
                HashMap<String, PriceSheetItemBO> priceMap = new HashMap<String, PriceSheetItemBO>();
                for (PriceSheetItemBO price : this.reqBO.getPriceSheetItemBOList()) {
                    if (priceMap.containsKey(price.getMaterialId())) continue;
                    priceMap.put(price.getMaterialId(), price);
                }
                logger.debug("\u4fee\u6539sku\u4ef7\u683c");
                if (CollectionUtils.isEmpty(skuList)) continue;
                ArrayList<Sku> price = new ArrayList<Sku>();
                ArrayList<PriceBO> priceBOList = new ArrayList<PriceBO>();
                Sku po = null;
                PriceBO priceBO = null;
                for (Sku sku : skuList) {
                    po = new Sku();
                    po.setSkuId(sku.getSkuId());
                    if (sku.getSkuStatus() == 5) {
                        po.setSkuStatus(2);
                    } else if (sku.getSkuStatus() == 4) {
                        po.setSkuStatus(1);
                    }
                    po.setSkuPrice(MoneyUtil.BigDecimal2Long((BigDecimal)((PriceSheetItemBO)priceMap.get(sku.getMaterialId())).getSalePriceStr()));
                    po.setUpdateTime(new Date());
                    po.setProvinceCode(sku.getProvinceCode());
                    price.add(po);
                    priceBO = new PriceBO();
                    priceBO.setProvinceCode(sku.getProvinceCode());
                    priceBO.setSkuId(sku.getSkuId());
                    priceBO.setAgreementPrice(MoneyUtil.BigDecimal2Long((BigDecimal)((PriceSheetItemBO)priceMap.get(sku.getMaterialId())).getAgreementPriceStr()));
                    priceBO.setAssessmentPrice(MoneyUtil.BigDecimal2Long((BigDecimal)((PriceSheetItemBO)priceMap.get(sku.getMaterialId())).getAssessmentPriceStr()));
                    priceBO.setPurchaseFloorPrice(MoneyUtil.BigDecimal2Long((BigDecimal)((PriceSheetItemBO)priceMap.get(sku.getMaterialId())).getPurchaseFloorPriceStr()));
                    priceBO.setRetailAgreementPrice(MoneyUtil.BigDecimal2Long((BigDecimal)((PriceSheetItemBO)priceMap.get(sku.getMaterialId())).getRetailAgreementPriceStr()));
                    priceBO.setCitiesLockPrice(MoneyUtil.BigDecimal2Long((BigDecimal)((PriceSheetItemBO)priceMap.get(sku.getMaterialId())).getCitiesLockPriceStr()));
                    priceBO.setTheCostDownPrice(MoneyUtil.BigDecimal2Long((BigDecimal)((PriceSheetItemBO)priceMap.get(sku.getMaterialId())).getTheCostDownPriceStr()));
                    priceBO.setCgType(sku.getCgType());
                    priceBO.setMemberLadderPrice1(MoneyUtil.BigDecimal2Long((BigDecimal)((PriceSheetItemBO)priceMap.get(sku.getMaterialId())).getMemberLadderPrice1Str()));
                    priceBO.setMemberLadderPrice2(MoneyUtil.BigDecimal2Long((BigDecimal)((PriceSheetItemBO)priceMap.get(sku.getMaterialId())).getMemberLadderPrice2Str()));
                    priceBO.setMemberLadderPrice3(MoneyUtil.BigDecimal2Long((BigDecimal)((PriceSheetItemBO)priceMap.get(sku.getMaterialId())).getMemberLadderPrice3Str()));
                    priceBO.setMemberLadderPrice4(MoneyUtil.BigDecimal2Long((BigDecimal)((PriceSheetItemBO)priceMap.get(sku.getMaterialId())).getMemberLadderPrice4Str()));
                    priceBO.setMemberLadderPrice5(MoneyUtil.BigDecimal2Long((BigDecimal)((PriceSheetItemBO)priceMap.get(sku.getMaterialId())).getMemberLadderPrice5Str()));
                    priceBO.setMemberPrice(MoneyUtil.BigDecimal2Long((BigDecimal)((PriceSheetItemBO)priceMap.get(sku.getMaterialId())).getMemberPriceStr()));
                    priceBO.setPurchasePrice(MoneyUtil.BigDecimal2Long((BigDecimal)((PriceSheetItemBO)priceMap.get(sku.getMaterialId())).getPurchasePriceStr()));
                    priceBO.setSalePrice(MoneyUtil.BigDecimal2Long((BigDecimal)((PriceSheetItemBO)priceMap.get(sku.getMaterialId())).getSalePriceStr()));
                    priceBO.setSheetLevel("1");
                    priceBO.setSheetId(this.sheetId);
                    priceBO.setFixedRoyalty(((PriceSheetItemBO)priceMap.get(sku.getMaterialId())).getFixedRoyalty());
                    priceBO.setGroupRoyalty(((PriceSheetItemBO)priceMap.get(sku.getMaterialId())).getGroupRoyalty());
                    priceBO.setProfitRoyalty(((PriceSheetItemBO)priceMap.get(sku.getMaterialId())).getProfitRoyalty());
                    priceBO.setRoyaltyRatio(((PriceSheetItemBO)priceMap.get(sku.getMaterialId())).getRoyaltyRatio());
                    priceBO.setScore(((PriceSheetItemBO)priceMap.get(sku.getMaterialId())).getScore());
                    priceBO.setSparePrice2(MoneyUtil.BigDecimal2Long((BigDecimal)((PriceSheetItemBO)priceMap.get(sku.getMaterialId())).getSparePrice2Str()));
                    priceBO.setSparePrice3(((PriceSheetItemBO)priceMap.get(sku.getMaterialId())).getSparePrice3Str() == null ? null : MoneyUtil.BigDecimal2Long((BigDecimal)((PriceSheetItemBO)priceMap.get(sku.getMaterialId())).getSparePrice3Str()).toString());
                    priceBO.setSparePrice4(((PriceSheetItemBO)priceMap.get(sku.getMaterialId())).getSparePrice4Str() == null ? null : MoneyUtil.BigDecimal2Long((BigDecimal)((PriceSheetItemBO)priceMap.get(sku.getMaterialId())).getSparePrice4Str()).toString());
                    priceBO.setSparePrice5(((PriceSheetItemBO)priceMap.get(sku.getMaterialId())).getSparePrice5Str() == null ? null : MoneyUtil.BigDecimal2Long((BigDecimal)((PriceSheetItemBO)priceMap.get(sku.getMaterialId())).getSparePrice5Str()).toString());
                    priceBO.setUpdateTime(new Date());
                    priceBO.setHasPriceSheet("1");
                    priceBO.setTradePrice(MoneyUtil.BigDecimal2Long((BigDecimal)((PriceSheetItemBO)priceMap.get(sku.getMaterialId())).getTradePriceStr()));
                    priceBO.setProvAgreePrice(MoneyUtil.BigDecimal2Long((BigDecimal)((PriceSheetItemBO)priceMap.get(sku.getMaterialId())).getProvAgreePriceStr()));
                    priceBO.setLastPurchasePrice(MoneyUtil.BigDecimal2Long((BigDecimal)((PriceSheetItemBO)priceMap.get(sku.getMaterialId())).getLastPurchasePriceStr()));
                    priceBO.setCostPrice(MoneyUtil.BigDecimal2Long((BigDecimal)((PriceSheetItemBO)priceMap.get(sku.getMaterialId())).getCostPriceStr()));
                    priceBOList.add(priceBO);
                }
                this.updateXlsSkuMapper(price);
                this.updateXlsSkuPriceManage(priceBOList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.debug("\u66f4\u65b0\u4ef7\u683c\u62a5\u9519");
        }
    }

    private void updateXlsSkuPriceManage(List<PriceBO> priceBOList) {
        logger.debug("\u4fee\u6539skuPrice" + priceBOList.size());
        int pointsDataLimit = 2000;
        Integer size = priceBOList.size();
        int part = size / pointsDataLimit;
        int len = size % pointsDataLimit == 0 ? part : part + 1;
        logger.debug("\u4fee\u6539skuPrice" + size + "\u6761\u6570\u636e\u3002\u5206" + len + "\u6b21\u6267\u884c");
        ExecutorService service = Executors.newFixedThreadPool(9);
        for (int i = 0; i < len; ++i) {
            logger.debug("\u7b2c" + i + "\u6279\u6570\u636e");
            int start = i * pointsDataLimit;
            int end = start + pointsDataLimit;
            if (end > size) {
                end = size;
            }
            logger.debug("\u5f00\u59cb\u7ed3\u675f=" + start + "+" + end);
            final List<PriceBO> rows = priceBOList.subList(start, end);
            service.execute(new Runnable(){

                @Override
                public void run() {
                    PriceSheetAddThread.this.xlsSkuPriceManageService.batchUpdateSkuPrice(rows);
                }
            });
            try {
                Thread.sleep(300L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        service.shutdown();
        priceBOList = null;
    }

    private void updateXlsSkuMapper(List<Sku> price) {
        logger.debug("\u4fee\u6539sku" + price.size());
        int pointsDataLimit = 2000;
        Integer size = price.size();
        int part = size / pointsDataLimit;
        int len = size % pointsDataLimit == 0 ? part : part + 1;
        logger.debug("\u4fee\u6539sku\u5546\u54c1\u5171" + size + "\u6761\u6570\u636e\u3002\u5206" + len + "\u6b21\u6267\u884c");
        ExecutorService service = Executors.newFixedThreadPool(9);
        for (int i = 0; i < len; ++i) {
            int start = i * pointsDataLimit;
            int end = start + pointsDataLimit;
            if (end > size) {
                end = size;
            }
            final List<Sku> rows = price.subList(start, end);
            service.execute(new Runnable(){

                @Override
                public void run() {
                    PriceSheetAddThread.this.xlsSkuMapper.batchUpdateBySkuId(rows);
                }
            });
            try {
                Thread.sleep(300L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        service.shutdown();
        price = null;
    }
}

