/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.thread;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.xls.commodity.busi.sku.SortCommodityPriceService;
import com.xls.commodity.busi.sku.XlsElectronicPricePushBusiService;
import com.xls.commodity.busi.sku.bo.XlsQuerySkuAndPriceReqBO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushPriceTagAndSortCommodityPriceThread
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(PushPriceTagAndSortCommodityPriceThread.class);
    private SortCommodityPriceService sortCommodityPriceService;
    private XlsElectronicPricePushBusiService xlsElectronicPricePushBusiService;
    private List<Long> skuIds;
    private List<Long> commodityIds;

    public PushPriceTagAndSortCommodityPriceThread(SortCommodityPriceService sortCommodityPriceService, XlsElectronicPricePushBusiService xlsElectronicPricePushBusiService, List<Long> skuIds, List<Long> commodityIds) {
        this.sortCommodityPriceService = sortCommodityPriceService;
        this.xlsElectronicPricePushBusiService = xlsElectronicPricePushBusiService;
        this.skuIds = skuIds;
        this.commodityIds = commodityIds;
    }

    @Override
    public void run() {
        if (CollectionUtils.isNotEmpty(this.commodityIds)) {
            try {
                this.sortCommodityPriceService.sortCommodityPrice(this.commodityIds);
            }
            catch (Exception e) {
                logger.error("\u4fee\u6539\u5bf9\u5e94\u5546\u54c1\u7684\u6700\u9ad8\u4ef7\u548c\u6700\u4f4e\u4ef7\u62a5\u9519" + e);
            }
        }
        if (CollectionUtils.isNotEmpty(this.skuIds)) {
            try {
                XlsQuerySkuAndPriceReqBO pushReq = new XlsQuerySkuAndPriceReqBO();
                pushReq.setSkuIds(this.skuIds);
                this.xlsElectronicPricePushBusiService.xlsPuhSku(pushReq);
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u51fa\u9519" + e);
            }
        }
    }
}

