/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.external.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.external.bo.BusiQrySKUYanbaoReqBO;
import com.tydic.commodity.external.bo.BusiQrySKUYanbaoRspBO;
import com.tydic.commodity.external.service.QrySKUYanbaoFromInterService;
import com.tydic.commodity.external.util.ESBParamUtil;
import com.tydic.commodity.external.util.JsonUtils;
import com.tydic.commodity.external.util.http.HSHttpHelper;
import com.tydic.commodity.external.util.http.HSNHttpHeader;
import com.tydic.commodity.external.util.http.HttpRetBean;
import com.tydic.commodity.external.vo.BusiQrySKUYanbaoRspVO;
import com.tydic.commodity.external.vo.SKUYanbaoRspVO;
import com.tydic.commodity.external.vo.YanBaoDeatilRspVO;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="qrySKUYanbaoFromInterService")
public class QrySKUYanbaoFromInterServiceImpl
implements QrySKUYanbaoFromInterService {
    private static final Logger logger = LoggerFactory.getLogger(QrySKUYanbaoFromInterServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();

    public BusiQrySKUYanbaoRspBO qrySKUYanbao(BusiQrySKUYanbaoReqBO busiQrySKUYanbaoReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u670d\u52a1\u5165\u53c2\uff1a" + busiQrySKUYanbaoReqBO.toString());
        }
        BusiQrySKUYanbaoRspBO busiQrySKUYanbaoRspBO = new BusiQrySKUYanbaoRspBO();
        if (busiQrySKUYanbaoReqBO.getSkuIds().size() > 50) {
            throw new BusinessException("8888", "\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u670d\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u6700\u591a\u652f\u630150\u79cd\u5546\u54c1");
        }
        try {
            String reqStr = this.initReqStr(busiQrySKUYanbaoReqBO);
            String hsn = busiQrySKUYanbaoReqBO.getSupplierCode();
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(busiQrySKUYanbaoReqBO.getUrl()), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.toString().getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                logger.error("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u7cfb\u7edf\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + busiQrySKUYanbaoReqBO.getUrl() + "]");
                busiQrySKUYanbaoRspBO.setRespCode(null);
                busiQrySKUYanbaoRspBO.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u7cfb\u7edf\u5931\u8d25");
                return busiQrySKUYanbaoRspBO;
            }
            String returnString = httpRetBean.getStr();
            if (this.isDebugEnabled) {
                logger.debug("\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u670d\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u54cd\u5e94\u62a5\u6587\uff1a" + returnString);
            }
            if (StringUtils.isEmpty((Object)returnString)) {
                busiQrySKUYanbaoRspBO.setRespCode("8888");
                busiQrySKUYanbaoRspBO.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
                return busiQrySKUYanbaoRspBO;
            }
            busiQrySKUYanbaoRspBO = this.resolveRspMsg(returnString, busiQrySKUYanbaoReqBO.getSupplierId());
            busiQrySKUYanbaoRspBO.setRespCode("0000");
            busiQrySKUYanbaoRspBO.setRespDesc("\u6210\u529f");
            return busiQrySKUYanbaoRspBO;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u670d\u52a1\u5931\u8d25" + e);
            busiQrySKUYanbaoRspBO.setRespCode("8888");
            busiQrySKUYanbaoRspBO.setRespDesc("\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u670d\u52a1\u5931\u8d25");
            return busiQrySKUYanbaoRspBO;
        }
    }

    private String initReqStr(BusiQrySKUYanbaoReqBO busiQrySKUYanbaoReqBO) {
        ArrayList<String> reqSkuIds = new ArrayList<String>();
        for (Long skuIds : busiQrySKUYanbaoReqBO.getSkuIds()) {
            reqSkuIds.add('\"' + skuIds.toString() + '\"');
        }
        StringBuffer sb = new StringBuffer();
        sb.append("{").append("\"skuIds\":").append(reqSkuIds).append(",").append("\"province\":").append(busiQrySKUYanbaoReqBO.getProvince()).append(",").append("\"city\":").append(busiQrySKUYanbaoReqBO.getCity()).append(",").append("\"county\":").append(busiQrySKUYanbaoReqBO.getCounty()).append(",").append("\"town\":").append(busiQrySKUYanbaoReqBO.getTown()).append("}");
        return sb.toString();
    }

    private BusiQrySKUYanbaoRspBO resolveRspMsg(String rspStr, Long supplierId) {
        JSONObject jsonObject = JSONObject.parseObject((String)rspStr);
        List resultList = (List)jsonObject.get((Object)"result");
        ArrayList resultBusiQrySKUYanbaoRspVOs = new ArrayList();
        BusiQrySKUYanbaoRspBO busiQrySKUYanbaoRspBO = new BusiQrySKUYanbaoRspBO();
        if (((Boolean)jsonObject.get((Object)"success")).booleanValue() && null != resultList) {
            if (!resultList.isEmpty()) {
                try {
                    BusiQrySKUYanbaoRspVO[] busiQrySKUYanbaoRspVOArr = JsonUtils.jsonStringToJavaBean(JSONObject.toJSONString((Object)jsonObject.get((Object)"result")), BusiQrySKUYanbaoRspVO[].class);
                    List<BusiQrySKUYanbaoRspVO> busiQrySKUYanbaoRspVOs = Arrays.asList(busiQrySKUYanbaoRspVOArr);
                    ArrayList<BusiQrySKUYanbaoRspVO> busiQrySKUYanbaoRsps = new ArrayList<BusiQrySKUYanbaoRspVO>();
                    for (BusiQrySKUYanbaoRspVO busiQrySKUYanbaoRspVO : busiQrySKUYanbaoRspVOs) {
                        BusiQrySKUYanbaoRspVO busiQrySKUYanbaoRsp = new BusiQrySKUYanbaoRspVO();
                        if (null != busiQrySKUYanbaoRspVO.getYanBao()) {
                            this.calcYanbaoPrice(busiQrySKUYanbaoRspVO.getYanBao(), supplierId);
                        }
                        busiQrySKUYanbaoRsp.setSkuId(busiQrySKUYanbaoRspVO.getSkuId());
                        busiQrySKUYanbaoRsp.setYanBao(busiQrySKUYanbaoRspVO.getYanBao());
                        busiQrySKUYanbaoRsps.add(busiQrySKUYanbaoRsp);
                    }
                    resultBusiQrySKUYanbaoRspVOs.addAll(busiQrySKUYanbaoRsps);
                    busiQrySKUYanbaoRspBO.setSkuYanbaos(resultBusiQrySKUYanbaoRspVOs);
                    return busiQrySKUYanbaoRspBO;
                }
                catch (Exception e) {
                    logger.error("\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u670d\u52a1\u89e3\u6790\u54cd\u5e94\u6570\u636e\u5931\u8d25" + e);
                    busiQrySKUYanbaoRspBO.setRespCode(null);
                    busiQrySKUYanbaoRspBO.setRespDesc("\u89e3\u6790\u54cd\u5e94\u6570\u636e\u5931\u8d25");
                    return busiQrySKUYanbaoRspBO;
                }
            }
            logger.info("\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u670d\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u6570\u636e\u4e3a\u7a7a");
            busiQrySKUYanbaoRspBO.setRespCode(null);
            busiQrySKUYanbaoRspBO.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u6570\u636e\u4e3a\u7a7a");
            return busiQrySKUYanbaoRspBO;
        }
        return busiQrySKUYanbaoRspBO;
    }

    private void calcYanbaoPrice(List<SKUYanbaoRspVO> yanBao, Long supplierId) {
        for (SKUYanbaoRspVO sKUYanbaoRspVO : yanBao) {
            List yanBaoDeatilList = sKUYanbaoRspVO.getFuwuSkuDetailList();
            for (YanBaoDeatilRspVO yanBaoDeatilRspVO : yanBaoDeatilList) {
                yanBaoDeatilRspVO.setSalePrice(yanBaoDeatilRspVO.getPrice());
                if (1L == supplierId) {
                    yanBaoDeatilRspVO.setPrice(yanBaoDeatilRspVO.getPrice().multiply(new BigDecimal(1.04)).setScale(2, 1));
                    continue;
                }
                yanBaoDeatilRspVO.setPrice(yanBaoDeatilRspVO.getPrice().multiply(new BigDecimal(1.04)).setScale(2, 1));
            }
        }
    }
}

