/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.external.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.external.bo.AreaAvailableCommdBO;
import com.tydic.commodity.external.bo.UccAreaAvailableQryReqBO;
import com.tydic.commodity.external.bo.UccAreaAvailableQryRspBO;
import com.tydic.commodity.external.service.UccAreaAvailableQryService;
import com.tydic.commodity.external.util.ESBParamUtil;
import com.tydic.commodity.external.util.PropertiesUtil;
import com.tydic.commodity.external.util.http.HSHttpHelper;
import com.tydic.commodity.external.util.http.HSNHttpHeader;
import com.tydic.commodity.external.util.http.HttpRetBean;
import java.net.URI;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="uccAreaAvailableQryService")
public class UccAreaAvailableQryServiceImpl
implements UccAreaAvailableQryService {
    private static final Log LOG = LogFactory.getLog(UccAreaAvailableQryServiceImpl.class);

    public UccAreaAvailableQryRspBO qryAreaAvailableCommd(UccAreaAvailableQryReqBO reqBO) {
        try {
            String reqStr = this.initReqStr(reqBO);
            String hsn = reqBO.getSupplierCode();
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(PropertiesUtil.getProperty("ESB_QRY_AREA_LIMIT_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                LOG.error((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("ESB_QRY_AREA_LIMIT_URL") + "]" + reqEsbStr));
                UccAreaAvailableQryRspBO rspBO = new UccAreaAvailableQryRspBO();
                rspBO.setResultCode("8888");
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u533a\u57df\u8d2d\u4e70\u9650\u5236\u5f02\u5e38");
                return rspBO;
            }
            LOG.info((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr()));
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            UccAreaAvailableQryRspBO resolveRsp = this.resolveRsp(returnString);
            if (resolveRsp != null) {
                LOG.info((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u89e3\u6790\u54cd\u5e94\u6570\u636e\uff1a" + resolveRsp.toString()));
            }
            return resolveRsp;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage());
            UccAreaAvailableQryRspBO rspBO = new UccAreaAvailableQryRspBO();
            rspBO.setResultCode("8888");
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u533a\u57df\u8d2d\u4e70\u9650\u5236\u5f02\u5e38");
            return rspBO;
        }
    }

    private String initReqStr(UccAreaAvailableQryReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("skuIds", (Object)reqBO.getSkuIds());
        jsonObject.put("province", (Object)reqBO.getProvince());
        jsonObject.put("city", (Object)reqBO.getCity());
        jsonObject.put("county", (Object)reqBO.getCounty());
        jsonObject.put("town", (Object)reqBO.getTown());
        jsonObject.put("hsn", (Object)reqBO.getSupplierCode());
        return jsonObject.toString();
    }

    private UccAreaAvailableQryRspBO resolveRsp(String returnString) {
        UccAreaAvailableQryRspBO rspBO = new UccAreaAvailableQryRspBO();
        ArrayList<AreaAvailableCommdBO> list = new ArrayList<AreaAvailableCommdBO>();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            rspBO.setSuccess(((Boolean)rspJsonObject.get((Object)"success")).booleanValue());
            rspBO.setResultCode((String)rspJsonObject.get((Object)"resultCode"));
            rspBO.setResultMessage((String)rspJsonObject.get((Object)"resultMessage"));
            String respCode = (String)rspJsonObject.get((Object)"resultCode");
            if (!"0000".equals(respCode)) {
                if ("2007".equals(respCode)) {
                    rspBO.setResultMessage("token\u5df2\u8fc7\u671f,\u8bf7\u91cd\u65b0\u5237\u65b0\u6216\u8005\u83b7\u53d6token");
                }
                rspBO.setResultCode("8888");
                return rspBO;
            }
            JSONArray object = rspJsonObject.getJSONArray("result");
            LOG.info((Object)("\u533a\u57df\u9650\u5236\uff1a" + JSON.toJSONString((Object)object)));
            if (null != object) {
                for (int i = 0; i < object.size(); ++i) {
                    JSONObject obj = (JSONObject)object.get(i);
                    String jsonStr = JSONObject.toJSONString((Object)obj);
                    if (StringUtils.isEmpty((Object)jsonStr)) continue;
                    AreaAvailableCommdBO jsonStringToJavaBean = (AreaAvailableCommdBO)JSON.parseObject((String)jsonStr, AreaAvailableCommdBO.class);
                    jsonStringToJavaBean.setAreaRestrict(((Boolean)obj.get((Object)"isAreaRestrict")).booleanValue());
                    LOG.info((Object)("\u533a\u57df\u9650\u5236\uff1a" + JSON.toJSONString((Object)jsonStringToJavaBean)));
                    list.add(jsonStringToJavaBean);
                }
                rspBO.setResult(list);
            }
            return rspBO;
        }
        catch (Exception var10) {
            LOG.error((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10));
            throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
        }
    }
}

