/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.external.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.external.bo.AvailableCommdBO;
import com.tydic.commodity.external.bo.UccAvailableCommdQryReqBO;
import com.tydic.commodity.external.bo.UccAvailableCommdQryRspBO;
import com.tydic.commodity.external.service.UccAvailableCommdQryService;
import com.tydic.commodity.external.util.ESBParamUtil;
import com.tydic.commodity.external.util.PropertiesUtil;
import com.tydic.commodity.external.util.http.HSHttpHelper;
import com.tydic.commodity.external.util.http.HSNHttpHeader;
import com.tydic.commodity.external.util.http.HttpRetBean;
import java.net.URI;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="uccAvailableCommdQryService")
public class UccAvailableCommdQryServiceImpl
implements UccAvailableCommdQryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccAvailableCommdQryServiceImpl.class);

    public UccAvailableCommdQryRspBO qryAvailableCommd(UccAvailableCommdQryReqBO reqBO) {
        try {
            String reqStr = this.initReqStr(reqBO);
            String hsn = reqBO.getSupplierCode();
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(PropertiesUtil.getProperty("ESB_CHECK_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                LOGGER.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("ESB_CHECK_URL") + "]" + reqEsbStr);
                UccAvailableCommdQryRspBO rspBO = new UccAvailableCommdQryRspBO();
                rspBO.setResultCode("8888");
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u7535\u5b50\u8d85\u5e02\u53ef\u552e\u5546\u54c1 \u5f02\u5e38");
                return rspBO;
            }
            LOGGER.info("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            UccAvailableCommdQryRspBO resolveRsp = this.resolveRsp(returnString);
            if (resolveRsp != null) {
                LOGGER.info("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u89e3\u6790\u54cd\u5e94\u6570\u636e\uff1a" + resolveRsp.toString());
            }
            return resolveRsp;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            UccAvailableCommdQryRspBO rspBO = new UccAvailableCommdQryRspBO();
            rspBO.setResultCode("8888");
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u7535\u5b50\u8d85\u5e02\u53ef\u552e\u5546\u54c1 \u5f02\u5e38");
            return rspBO;
        }
    }

    private String initReqStr(UccAvailableCommdQryReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("skuIds", (Object)reqBO.getSkuIds());
        return jsonObject.toString();
    }

    private UccAvailableCommdQryRspBO resolveRsp(String returnString) {
        UccAvailableCommdQryRspBO rspBO = new UccAvailableCommdQryRspBO();
        ArrayList<AvailableCommdBO> list = new ArrayList<AvailableCommdBO>();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            rspBO.setSuccess(((Boolean)rspJsonObject.get((Object)"success")).booleanValue());
            rspBO.setResultCode((String)rspJsonObject.get((Object)"resultCode"));
            rspBO.setResultMessage((String)rspJsonObject.get((Object)"resultMessage"));
            String respCode = (String)rspJsonObject.get((Object)"resultCode");
            if (!"0000".equals(respCode)) {
                if ("2007".equals(respCode)) {
                    rspBO.setResultMessage("token\u5df2\u8fc7\u671f,\u8bf7\u91cd\u65b0\u5237\u65b0\u6216\u8005\u83b7\u53d6token");
                }
                rspBO.setResultCode("8888");
                return rspBO;
            }
            JSONArray object = rspJsonObject.getJSONArray("result");
            if (null != object) {
                for (int i = 0; i < object.size(); ++i) {
                    JSONObject obj = (JSONObject)object.get(i);
                    String jsonStr = JSONObject.toJSONString((Object)obj);
                    if (StringUtils.isEmpty((Object)jsonStr)) continue;
                    AvailableCommdBO jsonStringToJavaBean = (AvailableCommdBO)JSON.parseObject((String)jsonStr, AvailableCommdBO.class);
                    list.add(jsonStringToJavaBean);
                }
                rspBO.setResult(list);
            }
            return rspBO;
        }
        catch (Exception var10) {
            LOGGER.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
            throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
        }
    }
}

