/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.external.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.external.bo.UccExpectDeliveryTimeQueryReqBo;
import com.tydic.commodity.external.bo.UccExpectDeliveryTimeQueryRspBo;
import com.tydic.commodity.external.service.UccExpectDeliveryTimeQueryService;
import com.tydic.commodity.external.util.ESBParamUtil;
import com.tydic.commodity.external.util.http.HSHttpHelper;
import com.tydic.commodity.external.util.http.HSNHttpHeader;
import com.tydic.commodity.external.util.http.HttpRetBean;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UccExpectDeliveryTimeQueryServiceImpl
implements UccExpectDeliveryTimeQueryService {
    private static final Logger log = LoggerFactory.getLogger(UccExpectDeliveryTimeQueryServiceImpl.class);

    public UccExpectDeliveryTimeQueryRspBo getPromiseTips(UccExpectDeliveryTimeQueryReqBo reqBo) {
        HttpRetBean httpRetBean;
        String reqEsbStr;
        UccExpectDeliveryTimeQueryRspBo rspBo = new UccExpectDeliveryTimeQueryRspBo();
        String reqJson = this.initReqStr(reqBo);
        try {
            reqEsbStr = ESBParamUtil.getEsbReqStr(reqJson, reqBo.getSupplierCode(), "BUSINESS_COMMODITY");
            log.info("\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4\u5165\u53c2\uff1a" + reqEsbStr);
            httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(reqBo.getUrl()), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes("UTF-8"), "UTF-8", false);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
        if (httpRetBean.getStatus() != 200) {
            log.error("\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4\u5931\u8d25\uff1a" + reqEsbStr);
            throw new RuntimeException("\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4\u5931\u8d25");
        }
        log.info("\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4-\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
        String returnString = httpRetBean.getStr();
        if (StringUtils.isEmpty((CharSequence)returnString)) {
            throw new RuntimeException("\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        rspBo = this.resolveRsp(returnString);
        if (!rspBo.isSuccess()) {
            throw new BusinessException(rspBo.getResultCode(), rspBo.getResultMessage());
        }
        return rspBo;
    }

    private String initReqStr(UccExpectDeliveryTimeQueryReqBo reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("skuId", (Object)reqBO.getSkuId());
        jsonObject.put("num", (Object)reqBO.getNum());
        jsonObject.put("province", (Object)reqBO.getProvince());
        jsonObject.put("city", (Object)reqBO.getCity());
        jsonObject.put("county", (Object)reqBO.getCounty());
        jsonObject.put("town", (Object)reqBO.getTown());
        return jsonObject.toString();
    }

    private UccExpectDeliveryTimeQueryRspBo resolveRsp(String returnString) {
        UccExpectDeliveryTimeQueryRspBo rspBo = new UccExpectDeliveryTimeQueryRspBo();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            rspBo.setSuccess(((Boolean)rspJsonObject.get((Object)"success")).booleanValue());
            rspBo.setResultCode(String.valueOf(rspJsonObject.get((Object)"resultCode")));
            rspBo.setResultMessage((String)rspJsonObject.get((Object)"resultMessage"));
            rspBo.setResult((String)rspJsonObject.get((Object)"result"));
            return rspBo;
        }
        catch (Exception var10) {
            log.error("\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
            throw new RuntimeException("\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
        }
    }
}

