/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.external.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.external.bo.FreightBO;
import com.tydic.commodity.external.bo.UccFreightQryReqBO;
import com.tydic.commodity.external.bo.UccFreightQryRspBO;
import com.tydic.commodity.external.service.UccFreightQryService;
import com.tydic.commodity.external.service.impl.UccQryMsgFromInterServiceImpl;
import com.tydic.commodity.external.util.ESBParamUtil;
import com.tydic.commodity.external.util.PropertiesUtil;
import com.tydic.commodity.external.util.http.HSHttpHelper;
import com.tydic.commodity.external.util.http.HSNHttpHeader;
import com.tydic.commodity.external.util.http.HttpRetBean;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="uccFreightQryService")
public class UccFreightQryServiceImpl
implements UccFreightQryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccQryMsgFromInterServiceImpl.class);

    public UccFreightQryRspBO qryFreight(UccFreightQryReqBO reqBO) {
        try {
            String reqStr = this.initReqStr(reqBO);
            String hsn = reqBO.getSupplierCode();
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(PropertiesUtil.getProperty("ESB_QRY_TRANS_FEE_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                LOGGER.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("ESB_QRY_TRANS_FEE_URL") + "]");
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u5931\u8d25");
            }
            LOGGER.info("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            UccFreightQryRspBO resolveRsp = this.resolveRsp(returnString);
            if (resolveRsp != null) {
                LOGGER.info("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u89e3\u6790\u54cd\u5e94\u6570\u636e\uff1a" + resolveRsp.toString());
            }
            return resolveRsp;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
    }

    private String initReqStr(UccFreightQryReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sku", (Object)reqBO.getSku());
        jsonObject.put("supplierCode", (Object)reqBO.getSupplierCode());
        jsonObject.put("province", (Object)reqBO.getProvince());
        jsonObject.put("city", (Object)reqBO.getCity());
        jsonObject.put("county", (Object)reqBO.getCounty());
        jsonObject.put("town", (Object)reqBO.getTown());
        if ("jd".equals(reqBO.getSupplierCode())) {
            jsonObject.put("paymentType ", (Object)reqBO.getPaymentType());
        }
        return jsonObject.toString();
    }

    private UccFreightQryRspBO resolveRsp(String returnString) {
        UccFreightQryRspBO rspBO = new UccFreightQryRspBO();
        try {
            JSONArray jsonArray;
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            rspBO.setRespCode((String)rspJsonObject.get((Object)"resultCode"));
            rspBO.setRespDesc((String)rspJsonObject.get((Object)"resultMessage"));
            String respCode = (String)rspJsonObject.get((Object)"resultCode");
            if (!"0000".equals(respCode)) {
                if ("2007".equals(respCode)) {
                    rspBO.setRespDesc("token\u5df2\u8fc7\u671f,\u8bf7\u91cd\u65b0\u5237\u65b0\u6216\u8005\u83b7\u53d6token");
                }
                rspBO.setRespCode("8888");
                return rspBO;
            }
            JSONObject object = (JSONObject)rspJsonObject.get((Object)"result");
            String freight = JSONObject.toJSONString((Object)object);
            FreightBO freightBO = (FreightBO)JSONObject.parseObject((String)freight, FreightBO.class);
            ArrayList<String> remoteSku = new ArrayList<String>();
            if (object != null && (jsonArray = object.getJSONArray("remoteSku")) != null && jsonArray.size() > 0) {
                for (int i = 0; i < jsonArray.size(); ++i) {
                    remoteSku.add((String)jsonArray.get(i));
                }
            }
            if (freightBO.getBaseFreight() == null) {
                freightBO.setBaseFreight(new BigDecimal(0));
            }
            if (freightBO.getFreight() == null) {
                freightBO.setFreight(new BigDecimal(0));
            }
            if (freightBO.getRemoteRegionFreight() == null) {
                freightBO.setRemoteRegionFreight(new BigDecimal(0));
            }
            freightBO.setRemoteSku(remoteSku);
            rspBO.setFreightBO(freightBO);
            return rspBO;
        }
        catch (Exception var10) {
            LOGGER.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
            throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
        }
    }
}

