/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.external.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.external.bo.MdmzzfpBO;
import com.tydic.commodity.external.bo.Splitpage;
import com.tydic.commodity.external.bo.UccCreateEgToMdmDataBO;
import com.tydic.commodity.external.bo.UccGateWayApplicationForMasterDataReqBO;
import com.tydic.commodity.external.bo.UccGateWayApplicationForMasterDataRspBO;
import com.tydic.commodity.external.service.UccGateWayApplicationForMasterDataMaterialOfChinaCoalService;
import com.tydic.commodity.external.util.http.HSHttpHelper;
import com.tydic.commodity.external.util.http.HttpRetBean;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="uccGateWayApplicationForMasterDataMaterialOfChinaCoalService")
public class UccGateWayApplicationForMasterDataMaterialOfChinaCoalServiceImpl
implements UccGateWayApplicationForMasterDataMaterialOfChinaCoalService {
    private static final Logger logger = LoggerFactory.getLogger(UccGateWayApplicationForMasterDataMaterialOfChinaCoalServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();

    public UccGateWayApplicationForMasterDataRspBO applicationForMasterData(UccGateWayApplicationForMasterDataReqBO reqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u4e2d\u7164\u7533\u8bf7\u4e3b\u6570\u636e\u7269\u6599\u8bf7\u6c42\u53c2\u6570\uff1a" + reqBO.toString());
        }
        UccGateWayApplicationForMasterDataRspBO rspBO = new UccGateWayApplicationForMasterDataRspBO();
        String reqStr = this.initReqStr(reqBO);
        HttpRetBean httpRetBean = null;
        Header[] headers = new Header[]{new BasicHeader("Content-Type", "application/json;charset=UTF-8"), new BasicHeader("usercode", reqBO.getAdmin()), new BasicHeader("password", reqBO.getPassword())};
        try {
            httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(reqBO.getUrl()), headers, reqStr.getBytes("UTF-8"), "UTF-8", false);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001http,\u4e2d\u7164\u7533\u8bf7\u4e3b\u6570\u636e\u7269\u6599\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u4e2d\u7164\u7533\u8bf7\u4e3b\u6570\u636e\u7269\u6599\u8bf7\u6c42\u5931\u8d25");
            return rspBO;
        }
        try {
            if (httpRetBean.getStatus() != 200) {
                logger.error("\u4e2d\u7164\u7533\u8bf7\u4e3b\u6570\u636e\u7269\u6599\u670d\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25,[http_status=" + httpRetBean.getStatus() + "], [http_url=" + reqBO.getUrl() + "]");
                throw new RuntimeException("\u7533\u8bf7\u4e3b\u6570\u636e\u7269\u6599\u670d\u52a1\u5931\u8d25");
            }
            logger.info("\u4e2d\u7164\u7533\u8bf7\u4e3b\u6570\u636e\u7269\u6599\u670d\u52a1-\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((CharSequence)returnString)) {
                throw new RuntimeException("\u4e2d\u7164\u7533\u8bf7\u4e3b\u6570\u636e\u7269\u6599\u670d\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            rspBO = this.resolveRsp(returnString);
            if (!rspBO.isSuccess()) {
                throw new BusinessException(rspBO.getRespCode(), rspBO.getRespDesc());
            }
            rspBO.setSuccess(true);
            return rspBO;
        }
        catch (BusinessException e) {
            logger.error("\u83b7\u53d6\u4e3b\u6570\u636e\u7269\u6599\u5217\u8868,\u54cd\u5e94\u8fd4\u56de\u9519\u8bef");
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.getMessage());
            return rspBO;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u4e3b\u6570\u636e\u7269\u6599\u5217\u8868\u5931\u8d25", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u83b7\u53d6\u4e3b\u6570\u636e\u7269\u6599\u5217\u8868\u5931\u8d25");
            return rspBO;
        }
    }

    private String initReqStr(UccGateWayApplicationForMasterDataReqBO reqBO) {
        ESBRspReturnObject esbCreateObject = new ESBRspReturnObject();
        ESB esb = new ESB();
        Datas datas = new Datas();
        esbCreateObject.setESB(esb);
        esbCreateObject.getESB().setDATA(datas);
        DataInfos dataInfos = new DataInfos();
        datas.setDATAINFOS(dataInfos);
        dataInfos.setDATAINFO(reqBO.getCreateEgToMdmDataBOS());
        dataInfos.setPUUID(UccGateWayApplicationForMasterDataMaterialOfChinaCoalServiceImpl.getUUIDString().toString());
        String jsonStr = JSON.toJSONString((Object)esbCreateObject);
        return jsonStr;
    }

    private static Integer getUUIDString() {
        Integer orderId = UUID.randomUUID().toString().hashCode();
        orderId = orderId < 0 ? -orderId.intValue() : orderId;
        return orderId;
    }

    private UccGateWayApplicationForMasterDataRspBO resolveRsp(String returnString) {
        UccGateWayApplicationForMasterDataRspBO rspBO = new UccGateWayApplicationForMasterDataRspBO();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            JSONObject esb = rspJsonObject.getJSONObject("ESB");
            String result = esb.getString("RESULT");
            String desc = esb.getString("DESC");
            if ("E".equals(result)) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(desc);
                return rspBO;
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            JSONObject data = esb.getJSONObject("DATA");
            JSONObject DATAINFOS = data.getJSONObject("DATAINFOS");
            JSONArray jsonArray = DATAINFOS.getJSONArray("DATAINFO");
            ArrayList<MdmzzfpBO> mdmzzfpBOS = new ArrayList<MdmzzfpBO>();
            int size = jsonArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                MdmzzfpBO mdmzzfpBO = new MdmzzfpBO();
                mdmzzfpBO.setUuid(jsonObject.getString("UUID"));
                mdmzzfpBO.setCode(jsonObject.getString("CODE"));
                mdmzzfpBO.setSynStatus(jsonObject.getString("SYNSTATUS"));
                mdmzzfpBO.setSynResult(jsonObject.getString("SYNRESULT"));
                mdmzzfpBO.setVersion(jsonObject.getString("VERSION"));
                if (!"0".equals(mdmzzfpBO.getSynStatus()) && !"4".equals(mdmzzfpBO.getSynStatus())) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc(mdmzzfpBO.getSynResult());
                    rspBO.setSuccess(false);
                    return rspBO;
                }
                mdmzzfpBOS.add(mdmzzfpBO);
            }
            rspBO.setSuccess(true);
            rspBO.setMdmzzfpBOList(mdmzzfpBOS);
            return rspBO;
        }
        catch (Exception var10) {
            logger.error("\u83b7\u53d6\u4e3b\u6570\u636e\u7269\u6599\u5217\u8868\u54cd\u5e94\u62a5\u6587\u5931\u8d25\uff1a" + var10);
            throw new RuntimeException("\u83b7\u53d6\u4e3b\u6570\u636e\u7269\u6599\u5217\u8868\u5931\u8d25\uff1a" + var10);
        }
    }

    public static void main(String[] args) {
        UccGateWayApplicationForMasterDataMaterialOfChinaCoalServiceImpl service = new UccGateWayApplicationForMasterDataMaterialOfChinaCoalServiceImpl();
        UccGateWayApplicationForMasterDataReqBO reqBO = new UccGateWayApplicationForMasterDataReqBO();
        UccCreateEgToMdmDataBO uccCreateEgToMdmDataBO = new UccCreateEgToMdmDataBO();
        ArrayList<UccCreateEgToMdmDataBO> uccCreateEgToMdmDataBOS = new ArrayList<UccCreateEgToMdmDataBO>();
        uccCreateEgToMdmDataBO.setCODE("125523");
        uccCreateEgToMdmDataBO.setDESC1("\u54c8\u54c8\u54c8");
        uccCreateEgToMdmDataBO.setDESC2("5158455");
        uccCreateEgToMdmDataBO.setDESC3("\u684c\u5b50");
        uccCreateEgToMdmDataBO.setDESC4("\u5927\u5385\u7684\u684c\u5b50");
        uccCreateEgToMdmDataBO.setDESC6("151535");
        uccCreateEgToMdmDataBO.setDESC7("1002521");
        uccCreateEgToMdmDataBO.setDESC18("\u9910\u996e\u7c7b");
        UccCreateEgToMdmDataBO createEgToMdmDataBO = new UccCreateEgToMdmDataBO();
        createEgToMdmDataBO.setCODE("125523");
        createEgToMdmDataBO.setDESC1("\u54c8\u54c8\u54c8");
        createEgToMdmDataBO.setDESC2("5158455");
        createEgToMdmDataBO.setDESC3("\u684c\u5b50");
        createEgToMdmDataBO.setDESC4("\u5927\u5385\u7684\u684c\u5b50");
        createEgToMdmDataBO.setDESC6("151535");
        createEgToMdmDataBO.setDESC7("1002521");
        createEgToMdmDataBO.setDESC18("\u9910\u996e\u7c7b");
        uccCreateEgToMdmDataBOS.add(createEgToMdmDataBO);
        uccCreateEgToMdmDataBOS.add(uccCreateEgToMdmDataBO);
        reqBO.setPassword("123");
        reqBO.setAdmin("admin");
        reqBO.setUrl("http://172.20.8.58/esbmule/chinacoal/services/receive/eg_to_mdm_zzfp");
        reqBO.setCreateEgToMdmDataBOS(uccCreateEgToMdmDataBOS);
        UccGateWayApplicationForMasterDataRspBO rspBO = service.applicationForMasterData(reqBO);
        System.out.println(JSON.toJSONString((Object)rspBO));
    }

    public class DataInfos {
        @JSONField(name="DATAINFO")
        public List<UccCreateEgToMdmDataBO> DATAINFO;
        @JSONField(name="PUUID")
        private String PUUID;

        public List<UccCreateEgToMdmDataBO> getDATAINFO() {
            return this.DATAINFO;
        }

        public void setDATAINFO(List<UccCreateEgToMdmDataBO> DATAINFO) {
            this.DATAINFO = DATAINFO;
        }

        public String getPUUID() {
            return this.PUUID;
        }

        public void setPUUID(String PUUID) {
            this.PUUID = PUUID;
        }
    }

    public class Datas {
        @JSONField(name="DATAINFOS")
        public DataInfos DATAINFOS;
        private Splitpage SPLITPAGE;

        public DataInfos getDATAINFOS() {
            return this.DATAINFOS;
        }

        public void setDATAINFOS(DataInfos DATAINFOS) {
            this.DATAINFOS = DATAINFOS;
        }

        public Splitpage getSPLITPAGE() {
            return this.SPLITPAGE;
        }

        public void setSPLITPAGE(Splitpage SPLITPAGE) {
            this.SPLITPAGE = SPLITPAGE;
        }
    }

    public class ESB {
        @JSONField(name="DATA")
        private Datas DATA;
        private String DESC;
        private String RESULT;

        public Datas getDATA() {
            return this.DATA;
        }

        public void setDATA(Datas DATA) {
            this.DATA = DATA;
        }

        public String getDESC() {
            return this.DESC;
        }

        public void setDESC(String DESC) {
            this.DESC = DESC;
        }

        public String getRESULT() {
            return this.RESULT;
        }

        public void setRESULT(String RESULT) {
            this.RESULT = RESULT;
        }
    }

    public class ESBRspReturnObject {
        @JSONField(name="ESB")
        private ESB ESB;

        public ESB getESB() {
            return this.ESB;
        }

        public void setESB(ESB ESB2) {
            this.ESB = ESB2;
        }
    }
}

