/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.external.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.external.bo.UccBusiQryMsgReqBO;
import com.tydic.commodity.external.bo.UccBusiQryMsgRspBO;
import com.tydic.commodity.external.service.UccQryMsgFromInterService;
import com.tydic.commodity.external.util.ESBParamUtil;
import com.tydic.commodity.external.util.PropertiesUtil;
import com.tydic.commodity.external.util.http.HSHttpHelper;
import com.tydic.commodity.external.util.http.HSNHttpHeader;
import com.tydic.commodity.external.util.http.HttpRetBean;
import com.tydic.commodity.external.vo.ResultVO;
import java.net.URI;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="uccQryMsgFromInterService")
public class UccQryMsgFromInterServiceImpl
implements UccQryMsgFromInterService {
    private static final Log LOG = LogFactory.getLog(UccQryMsgFromInterServiceImpl.class);

    public UccBusiQryMsgRspBO qryMsg(UccBusiQryMsgReqBO reqBo) {
        UccBusiQryMsgRspBO busiQryMsgRspBO = new UccBusiQryMsgRspBO();
        try {
            String reqStr = this.initReqStr(reqBo);
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, reqBo.getSupplierCode(), "BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(PropertiesUtil.getProperty("ESB_QRY_MSG_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.toString().getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                LOG.error((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("ESB_QRY_MSG_URL") + "]" + reqEsbStr));
                busiQryMsgRspBO.setRespCode("8888");
                busiQryMsgRspBO.setRespDesc("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u4e1a\u52a1\u5931\u8d25");
                return busiQryMsgRspBO;
            }
            LOG.info((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr()));
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            UccBusiQryMsgRspBO resolveRsp = this.resolveRsp(returnString);
            if (resolveRsp != null) {
                LOG.info((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u89e3\u6790\u54cd\u5e94\u6570\u636e\uff1a" + resolveRsp.toString()));
            }
            resolveRsp.setRespCode("0000");
            resolveRsp.setRespDesc("\u6210\u529f");
            return resolveRsp;
        }
        catch (Exception var9) {
            LOG.error((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u8c03\u7528\u5931\u8d25" + var9));
            busiQryMsgRspBO.setRespCode("8888");
            busiQryMsgRspBO.setRespDesc("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u4e1a\u52a1\u5931\u8d25");
            return busiQryMsgRspBO;
        }
    }

    private String initReqStr(UccBusiQryMsgReqBO busiQryMsgReqBO) {
        StringBuffer sb = new StringBuffer();
        sb.append("{").append("\"type\":" + busiQryMsgReqBO.getType()).append("}");
        return sb.toString();
    }

    private UccBusiQryMsgRspBO resolveRsp(String returnString) {
        UccBusiQryMsgRspBO busiQryMsgRspBO = new UccBusiQryMsgRspBO();
        ArrayList<ResultVO> list = new ArrayList<ResultVO>();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            busiQryMsgRspBO.setSuccess(((Boolean)rspJsonObject.get((Object)"success")).booleanValue());
            busiQryMsgRspBO.setResultCode(Integer.valueOf((String)rspJsonObject.get((Object)"resultCode")));
            busiQryMsgRspBO.setResultMessage((String)rspJsonObject.get((Object)"resultMessage"));
            JSONArray object = rspJsonObject.getJSONArray("result");
            if (null != object) {
                for (int i = 0; i < object.size(); ++i) {
                    JSONObject obj = (JSONObject)object.get(i);
                    String jsonStr = JSONObject.toJSONString((Object)obj);
                    if (StringUtils.isEmpty((Object)jsonStr)) continue;
                    Object result = null;
                    if (!StringUtils.isEmpty((Object)jsonStr)) {
                        // empty if block
                    }
                    ResultVO jsonStringToJavaBean = (ResultVO)JSON.parseObject((String)jsonStr, ResultVO.class);
                    list.add(jsonStringToJavaBean);
                }
                busiQryMsgRspBO.setResult(list);
            }
            return busiQryMsgRspBO;
        }
        catch (Exception var10) {
            LOG.error((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10));
            throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
        }
    }
}

