/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.tydic.commodity.ability.api.UccAreaAvailableQryAbilityService;
import com.tydic.commodity.ability.api.UccAreaAvailableQryBo;
import com.tydic.commodity.bo.ability.UccAreaAvailableQryAbilityReqBO;
import com.tydic.commodity.bo.ability.UccAreaAvailableQryAbilityRspBO;
import com.tydic.commodity.bo.busi.UccAreaAvailableQryBusiReqBO;
import com.tydic.commodity.bo.busi.UccAreaAvailableQryBusiRspBO;
import com.tydic.commodity.busi.api.UccAreaAvailableQryBusiService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

@Service(version="1.0.0", group="UCC_GROUP_PROD", interfaceClass=UccAreaAvailableQryAbilityService.class)
public class UccAreaAvailableQryAbilityServiceImpl
implements UccAreaAvailableQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccAreaAvailableQryAbilityServiceImpl.class);
    @Reference(interfaceClass=UccAreaAvailableQryBusiService.class, version="1.0.0", group="UCC_GROUP_PROD")
    private UccAreaAvailableQryBusiService uccAreaAvailableQryBusiService;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccAreaAvailableQryAbilityServiceImpl.class);

    public UccAreaAvailableQryAbilityRspBO qryAreaAvailable(UccAreaAvailableQryAbilityReqBO reqBO) {
        UccAreaAvailableQryAbilityRspBO rspBO = new UccAreaAvailableQryAbilityRspBO();
        Map<Long, UccAreaAvailableQryBusiReqBO> skuInfo = this.groupByShopid(reqBO);
        if (skuInfo == null || skuInfo.isEmpty()) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u5546\u54c1\u4fe1\u606f");
            return rspBO;
        }
        UccAreaAvailableQryBusiRspBO uccAreaAvailableQryBusiRspBO = null;
        try {
            ArrayList bo_busis = new ArrayList();
            for (Map.Entry<Long, UccAreaAvailableQryBusiReqBO> entry : skuInfo.entrySet()) {
                uccAreaAvailableQryBusiRspBO = this.uccAreaAvailableQryBusiService.qryUccAreaAvailable(entry.getValue());
                if ("0000".equals(uccAreaAvailableQryBusiRspBO.getRespCode())) {
                    bo_busis.addAll(uccAreaAvailableQryBusiRspBO.getAreaAvailableCommdInfos());
                    continue;
                }
                BeanUtils.copyProperties((Object)uccAreaAvailableQryBusiRspBO, (Object)rspBO);
                return rspBO;
            }
            rspBO.setAreaAvailableCommdInfos(bo_busis);
        }
        catch (Exception e) {
            LOGGER.error("\u6279\u91cf\u67e5\u8be2\u53ef\u552e\u4fe1\u606f\u9519\u8bef\uff1a {}->" + e.getMessage());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6279\u91cf\u67e5\u8be2\u53ef\u552e\u4fe1\u606f\u9519\u8bef");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private Map<Long, UccAreaAvailableQryBusiReqBO> groupByShopid(UccAreaAvailableQryAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getAreaAvailableSkuInfo())) {
            return null;
        }
        HashedMap result = new HashedMap();
        for (UccAreaAvailableQryBo each : reqBO.getAreaAvailableSkuInfo()) {
            if (result.containsKey(each.getSupplierShopId())) {
                ((UccAreaAvailableQryBusiReqBO)result.get(each.getSupplierShopId())).getSkuIds().add(each.getSkuId());
                continue;
            }
            UccAreaAvailableQryBusiReqBO bo = new UccAreaAvailableQryBusiReqBO();
            BeanUtils.copyProperties((Object)each, (Object)bo);
            bo.setSkuIds(new ArrayList<Long>(Arrays.asList(each.getSkuId())));
            result.put(each.getSupplierShopId(), bo);
        }
        return result;
    }
}

