/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.tydic.commodity.ability.api.UccCatalogOverviewAbilityService;
import com.tydic.commodity.atom.UccCatalogCommdNumQryAtomService;
import com.tydic.commodity.atom.bo.CatalogCommdNumBO;
import com.tydic.commodity.atom.bo.UccCatalogCommdNumQryReqBO;
import com.tydic.commodity.atom.bo.UccCatalogCommdNumQryRspBO;
import com.tydic.commodity.bo.ability.UccCatalogOverviewBO;
import com.tydic.commodity.bo.ability.UccCatalogOverviewReqBO;
import com.tydic.commodity.bo.ability.UccCatalogOverviewRspBO;
import com.tydic.commodity.bo.busi.CatalogNumBO;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccCatRCommdTypeMapper;
import com.tydic.commodity.dao.UccCatalogDealMapper;
import com.tydic.commodity.dao.po.UccCatalogDealPO;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.util.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_PROD", interfaceClass=UccCatalogOverviewAbilityService.class)
public class UccCatalogOverviewAbilityServiceImpl
implements UccCatalogOverviewAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccCatalogOverviewAbilityServiceImpl.class);
    @Autowired
    private UccCatalogCommdNumQryAtomService uccCatalogCommdNumQryAtomService;
    @Autowired
    private UccCatalogDealMapper uccCatalogDealMapper;
    @Autowired
    private UccCatRCommdTypeMapper uccCatRCommdTypeMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCatalogOverviewAbilityServiceImpl.class);

    public UccCatalogOverviewRspBO qryCatalogist(UccCatalogOverviewReqBO reqBO) {
        UccCatalogOverviewRspBO rspBO = new UccCatalogOverviewRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        if (reqBO.getOrgIdIn() == null) {
            throw new BusinessException("8888", "\u8bf7\u4f20\u5165\u673a\u6784ID");
        }
        try {
            UccCatalogDealPO uccCatalogDealPO = new UccCatalogDealPO();
            uccCatalogDealPO.setCatalogLevel(3);
            uccCatalogDealPO.setSupplierId(reqBO.getOrgIdIn());
            uccCatalogDealPO.setOrderStr("view_order");
            List<UccCatalogDealPO> uccCatalogDealPOList = this.uccCatalogDealMapper.selectCatPO(uccCatalogDealPO);
            if (CollectionUtils.isEmpty(uccCatalogDealPOList)) {
                return rspBO;
            }
            ArrayList<UccCatalogOverviewBO> uccCatalogOverviewBOS = new ArrayList<UccCatalogOverviewBO>();
            rspBO.setResult(uccCatalogOverviewBOS);
            for (UccCatalogDealPO uccCatalogDealPO1 : uccCatalogDealPOList) {
                UccCatalogOverviewBO uccCatalogOverviewBO = new UccCatalogOverviewBO();
                uccCatalogOverviewBOS.add(uccCatalogOverviewBO);
                uccCatalogOverviewBO.setCatalogId(uccCatalogDealPO1.getGuideCatalogId());
                uccCatalogOverviewBO.setCatalogName(uccCatalogDealPO1.getCatalogName());
                Date createTime = DateUtils.strToDate((String)uccCatalogDealPO1.getCreateTime());
                uccCatalogOverviewBO.setCreateTime(createTime);
                Date updateTime = DateUtils.strToDate((String)uccCatalogDealPO1.getUpdateTime());
                uccCatalogOverviewBO.setUpdateTime(updateTime);
                uccCatalogOverviewBO.setIconUrl(uccCatalogDealPO1.getCatalogIdLogo());
                uccCatalogOverviewBO.setSupplierId(uccCatalogDealPO1.getSupplierId());
                uccCatalogOverviewBO.setSupplierShopId(uccCatalogDealPO1.getSupplierShopId());
            }
            List<Long> catalogIds = uccCatalogDealPOList.stream().map(UccCatalogDealPO::getGuideCatalogId).collect(Collectors.toList());
            List<CatalogNumBO> catalogNumBOS = this.uccCatRCommdTypeMapper.qryCommodityTypeNums(catalogIds, reqBO.getOrgIdIn());
            for (UccCatalogOverviewBO uccCatalogOverviewBO : uccCatalogOverviewBOS) {
                uccCatalogOverviewBO.setSubCatCount(Long.valueOf(0L));
                for (CatalogNumBO catalogNumBO : catalogNumBOS) {
                    if (!uccCatalogOverviewBO.getCatalogId().equals(catalogNumBO.getCatalogId())) continue;
                    uccCatalogOverviewBO.setSubCatCount(catalogNumBO.getCount());
                }
            }
            UccCatalogCommdNumQryReqBO uccCatalogCommdNumQryReqBO = new UccCatalogCommdNumQryReqBO();
            uccCatalogCommdNumQryReqBO.setCatalogIds(catalogIds);
            uccCatalogCommdNumQryReqBO.setSupplierId(reqBO.getOrgIdIn());
            UccCatalogCommdNumQryRspBO uccCatalogCommdNumQryRspBO = this.uccCatalogCommdNumQryAtomService.qryCommdNum(uccCatalogCommdNumQryReqBO);
            if (!"0000".equals(uccCatalogCommdNumQryRspBO.getRespCode()) || CollectionUtils.isEmpty(uccCatalogCommdNumQryRspBO.getResult())) {
                BeanUtils.copyProperties((Object)((Object)uccCatalogCommdNumQryRspBO), (Object)rspBO);
                return rspBO;
            }
            for (UccCatalogOverviewBO uccCatalogOverviewBO : uccCatalogOverviewBOS) {
                for (CatalogCommdNumBO catalogCommdNumBO : uccCatalogCommdNumQryRspBO.getResult()) {
                    if (!catalogCommdNumBO.getCatalogId().equals(uccCatalogOverviewBO.getCatalogId())) continue;
                    uccCatalogOverviewBO.setTotalItemNum(catalogCommdNumBO.getCommodityNum());
                    uccCatalogOverviewBO.setNotStockCount(catalogCommdNumBO.getNotStockCount());
                    uccCatalogOverviewBO.setDepotItemNum(catalogCommdNumBO.getDepotItemNum());
                    uccCatalogOverviewBO.setSaleItemNum(catalogCommdNumBO.getSaleItemNum());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
        return rspBO;
    }
}

