/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.tydic.commodity.ability.api.UccFreightQryAbilityService;
import com.tydic.commodity.atom.impl.UccFreightQryAtomServiceImpl;
import com.tydic.commodity.bo.ability.UccFreightQryAbilityReqBO;
import com.tydic.commodity.bo.ability.UccFreightQryAbilityRspBO;
import com.tydic.commodity.bo.busi.FreightBO_busi;
import com.tydic.commodity.bo.busi.UccFreightQryBusiReqBO;
import com.tydic.commodity.bo.busi.UccFreightQryBusiRspBO;
import com.tydic.commodity.busi.api.UccFreightQryBusiService;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.exception.BusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_PROD", interfaceClass=UccFreightQryAbilityService.class)
public class UccFreightQryAbilityServiceImpl
implements UccFreightQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccFreightQryAbilityServiceImpl.class);
    @Reference(interfaceClass=UccFreightQryBusiService.class, version="1.0.0", group="UCC_GROUP_PROD")
    private UccFreightQryBusiService uccFreightQryBusiService;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccFreightQryAtomServiceImpl.class);
    @Autowired
    private SupplierShopMapper supplierShopMapper;

    public UccFreightQryAbilityRspBO qryFreightAbility(UccFreightQryAbilityReqBO reqBO) {
        UccFreightQryAbilityRspBO rspBO = new UccFreightQryAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        try {
            ArrayList<FreightBO_busi> freightBOList = new ArrayList<FreightBO_busi>();
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getFreightList())) {
                BigDecimal totalFreight = new BigDecimal(0L);
                BigDecimal totalBaseFreight = new BigDecimal(0L);
                BigDecimal totalRemoteRegionFreight = new BigDecimal(0L);
                ArrayList allRemoteSku = new ArrayList();
                for (UccFreightQryBusiReqBO uccFreightQryBusiReqBO : reqBO.getFreightList()) {
                    if (uccFreightQryBusiReqBO.getSupplierShopId() == null) continue;
                    SupplierShopPo supplierShopPo = this.supplierShopMapper.queryPoBySupplierShopId(uccFreightQryBusiReqBO.getSupplierShopId());
                    UccFreightQryBusiRspBO uccFreightQryBusiRspBO = this.uccFreightQryBusiService.qryFreightBusi(uccFreightQryBusiReqBO);
                    if ("0000".equals(uccFreightQryBusiRspBO.getRespCode()) && uccFreightQryBusiRspBO.getFreightBO() != null) {
                        FreightBO_busi freightBO_busi = new FreightBO_busi();
                        BeanUtils.copyProperties((Object)uccFreightQryBusiRspBO.getFreightBO(), (Object)freightBO_busi);
                        if (supplierShopPo != null) {
                            freightBO_busi.setSupplierName(supplierShopPo.getSupplierName());
                            freightBO_busi.setSupplierId(supplierShopPo.getSupplierId());
                        }
                        freightBOList.add(freightBO_busi);
                        totalFreight = totalFreight.add(freightBO_busi.getFreight());
                        totalBaseFreight = totalBaseFreight.add(freightBO_busi.getBaseFreight());
                        totalRemoteRegionFreight = totalRemoteRegionFreight.add(freightBO_busi.getRemoteRegionFreight());
                        allRemoteSku.addAll(freightBO_busi.getRemoteSku());
                        continue;
                    }
                    rspBO.setRespCode(uccFreightQryBusiRspBO.getRespCode());
                    rspBO.setRespDesc(uccFreightQryBusiRspBO.getRespDesc());
                    rspBO.setFreightBOList(new ArrayList());
                    rspBO.setAllRemoteSku(new ArrayList());
                    return rspBO;
                }
                rspBO.setTotalFreight(totalFreight);
                rspBO.setTotalBaseFreight(totalBaseFreight);
                rspBO.setTotalRemoteRegionFreight(totalRemoteRegionFreight);
                rspBO.setAllRemoteSku(allRemoteSku);
                rspBO.setFreightBOList(freightBOList);
            } else {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u8bf7\u4f20\u5165\u5165\u53c2\u4fe1\u606f");
            }
            return rspBO;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u8c03\u7528y\u4e1a\u52a1\u5c42\u9519\u8bef");
        }
    }
}

