/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.atom.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.atom.UccSkuUpLogAtomService;
import com.tydic.commodity.atom.bo.UccSkuUpLogReqBO;
import com.tydic.commodity.atom.bo.UccSkuUpLogRspBO;
import com.tydic.commodity.dao.UccSkuLogMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPutCirLogMapper;
import com.tydic.commodity.dao.UccSkuPutCirMapper;
import com.tydic.commodity.dao.po.UccSkuLogPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.dao.po.UccSkuPutCirLogPo;
import com.tydic.commodity.dao.po.UccSkuPutCirPo;
import com.tydic.commodity.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="uccSkuUpLogAtomService")
public class UccSkuUpLogAtomServiceImpl
implements UccSkuUpLogAtomService {
    @Autowired
    private UccSkuLogMapper skuLogMapper;
    @Autowired
    private UccSkuPutCirLogMapper skuPutCirLogMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();
    @Autowired
    private UccSkuPutCirMapper uccSkuPutCirMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    public static final Logger LOGGER = LoggerFactory.getLogger(UccSkuUpLogAtomServiceImpl.class);

    @Override
    public UccSkuUpLogRspBO dealSkuUpLog(UccSkuUpLogReqBO reqBO) {
        UccSkuUpLogRspBO judgeRspBo = this.judge(reqBO);
        if ("8888".equals(judgeRspBo.getRespCode())) {
            return judgeRspBo;
        }
        UccSkuUpLogRspBO rspBO = new UccSkuUpLogRspBO();
        List<Long> skuIds = reqBO.getSkuIds();
        ArrayList<UccSkuLogPo> skuLogPoList = new ArrayList<UccSkuLogPo>();
        ArrayList<UccSkuPutCirLogPo> uccSkuPutCirLogPoList = new ArrayList<UccSkuPutCirLogPo>();
        List<UccSkuPo> uccSkuPos = this.uccSkuMapper.batchQrySku(skuIds, reqBO.getSupplierShopId());
        if (CollectionUtils.isNotEmpty(uccSkuPos)) {
            try {
                for (UccSkuPo uccSkuPo1 : uccSkuPos) {
                    UccSkuLogPo uccSkuLogPo = new UccSkuLogPo();
                    BeanUtils.copyProperties((Object)uccSkuPo1, (Object)uccSkuLogPo);
                    Long batchId = this.uccBatchSequence.nextId();
                    uccSkuLogPo.setBatchId(batchId);
                    uccSkuLogPo.setRemark(reqBO.getReason());
                    skuLogPoList.add(uccSkuLogPo);
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new BusinessException("8888", "\u521b\u5efa\u5e8f\u5217\u5931\u8d25");
            }
        }
        UccSkuPutCirPo uccSkuPutCirPo = new UccSkuPutCirPo();
        uccSkuPutCirPo.setSupplierShopId(reqBO.getSupplierShopId());
        uccSkuPutCirPo.setState(1);
        List<UccSkuPutCirPo> uccSkuPutCirPos = this.uccSkuPutCirMapper.batchQryById(skuIds, uccSkuPutCirPo);
        if (CollectionUtils.isNotEmpty(uccSkuPutCirPos)) {
            try {
                for (UccSkuPutCirPo uccSkuPutCirPo1 : uccSkuPutCirPos) {
                    UccSkuPutCirLogPo uccSkuPutCirLogPo = new UccSkuPutCirLogPo();
                    BeanUtils.copyProperties((Object)uccSkuPutCirPo1, (Object)uccSkuPutCirLogPo);
                    Long batchId = this.uccBatchSequence.nextId();
                    uccSkuPutCirLogPo.setBatchId(batchId);
                    uccSkuPutCirLogPoList.add(uccSkuPutCirLogPo);
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new BusinessException("8888", "\u521b\u5efa\u5e8f\u5217\u5931\u8d25");
            }
        }
        try {
            if (CollectionUtils.isNotEmpty(skuLogPoList)) {
                this.skuLogMapper.addSkuLog(skuLogPoList);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u5355\u54c1\u65e5\u5fd7\u8868\u6570\u636e\u5e93\u6dfb\u52a0\u5f02\u5e38");
        }
        if (CollectionUtils.isNotEmpty(uccSkuPutCirLogPoList)) {
            try {
                this.skuPutCirLogMapper.addSkuPutCirLog(uccSkuPutCirLogPoList);
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u6570\u636e\u5e93\u6dfb\u52a0\u5f02\u5e38");
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6dfb\u52a0\u65e5\u5fd7\u6210\u529f");
        return rspBO;
    }

    public UccSkuUpLogRspBO judge(UccSkuUpLogReqBO reqBO) {
        UccSkuUpLogRspBO rspBO = new UccSkuUpLogRspBO();
        if (reqBO != null) {
            if (reqBO.getSkuIds().size() == 0) {
                rspBO.setRespDesc("\u5355\u54c1ID\u96c6\u5408\u4e3a\u7a7a");
                rspBO.setRespCode("8888");
                return rspBO;
            }
            if (reqBO.getSupplierShopId() == null) {
                rspBO.setRespDesc("\u5e97\u94faID\u4e3a\u7a7a");
                rspBO.setRespCode("8888");
                return rspBO;
            }
        } else {
            rspBO.setRespDesc("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            rspBO.setRespCode("8888");
        }
        return rspBO;
    }
}

