/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.bo.RspUccPageBo;
import com.tydic.commodity.bo.busi.AccessoryTemplateReqBO;
import com.tydic.commodity.bo.busi.AccessoryTemplateRspBO;
import com.tydic.commodity.bo.busi.AddAccessoryTemplateReqBO;
import com.tydic.commodity.bo.busi.AddAccessoryTemplateRspBO;
import com.tydic.commodity.bo.busi.DelAccessoryTemplateReqBO;
import com.tydic.commodity.bo.busi.DelAccessoryTemplateRspBO;
import com.tydic.commodity.busi.api.UccAccessoryTemplateService;
import com.tydic.commodity.dao.AccessoryTemplateMapper;
import com.tydic.commodity.dao.po.AccessoryTemplate;
import com.tydic.commodity.exception.BusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(version="1.0.0", group="UCC_GROUP_PROD", interfaceClass=UccAccessoryTemplateService.class)
public class UccAccessoryTemplateServiceImpl
implements UccAccessoryTemplateService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccAccessoryTemplateServiceImpl.class);
    @Autowired
    private AccessoryTemplateMapper accessoryTemplateMapper;

    public RspUccPageBo qryAccessoryTemplateList(AccessoryTemplateReqBO reqBO) {
        RspUccPageBo rspPageBO = new RspUccPageBo();
        ArrayList<AccessoryTemplateRspBO> rows = new ArrayList<AccessoryTemplateRspBO>();
        Page page = new Page(reqBO.getPageNo() < 1 ? 1 : reqBO.getPageNo(), reqBO.getPageSize() < 1 ? 10 : reqBO.getPageSize());
        AccessoryTemplate accessoryTemplate = new AccessoryTemplate();
        BeanUtils.copyProperties((Object)reqBO, (Object)accessoryTemplate);
        List<AccessoryTemplate> templatelist = this.accessoryTemplateMapper.getListPage((Page<Map<String, Object>>)page, accessoryTemplate);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(templatelist)) {
            for (AccessoryTemplate po : templatelist) {
                AccessoryTemplateRspBO row = new AccessoryTemplateRspBO();
                BeanUtils.copyProperties((Object)po, (Object)row);
                rows.add(row);
            }
        }
        rspPageBO.setRespCode("0000");
        rspPageBO.setRespDesc("\u6a21\u677f\u4e0b\u8f7d_\u6a21\u677f\u5217\u8868\u67e5\u8be2\u6210\u529f");
        rspPageBO.setRows(rows);
        rspPageBO.setRecordsTotal(page.getTotalCount());
        rspPageBO.setTotal(page.getTotalPages());
        rspPageBO.setPageNo(page.getPageNo());
        return rspPageBO;
    }

    public AddAccessoryTemplateRspBO addAccessoryTemplate(AddAccessoryTemplateReqBO reqBO) {
        int delResult;
        if (reqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getAccessoryCode())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u3010\u9644\u4ef6\u7f16\u7801\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getAccessoryName())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u3010\u9644\u4ef6\u540d\u79f0\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getAccessoryUrl())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u3010\u9644\u4ef6URL\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AccessoryTemplate qryPO = new AccessoryTemplate();
        qryPO.setAccessoryCode(reqBO.getAccessoryCode());
        List<AccessoryTemplate> qryList = this.accessoryTemplateMapper.getList(qryPO);
        if (!CollectionUtils.isEmpty(qryList) && (delResult = this.accessoryTemplateMapper.deleteByCode(qryPO)) < 1) {
            throw new BusinessException("BUSI_ACCESSORY_INSERT_EXCEPTION", "\u65b0\u589e\u9644\u4ef6\u5931\u8d25\uff0c\u5220\u9664\u539f\u6709\u7684\u5220\u9664\u5931\u8d25\uff01");
        }
        AccessoryTemplate accessoryTemplate = new AccessoryTemplate();
        BeanUtils.copyProperties((Object)reqBO, (Object)accessoryTemplate);
        accessoryTemplate.setCreateOperId(reqBO.getUserId() == null ? "" : String.valueOf(reqBO.getUserId()));
        accessoryTemplate.setCreateTime(new Date());
        int result = this.accessoryTemplateMapper.insert(accessoryTemplate);
        if (result < 1) {
            throw new BusinessException("BUSI_ACCESSORY_INSERT_EXCEPTION", "\u65b0\u589e\u9644\u4ef6\u5931\u8d25");
        }
        AddAccessoryTemplateRspBO rspBO = new AddAccessoryTemplateRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u65b0\u589e\u9644\u4ef6\u6210\u529f");
        return rspBO;
    }

    public DelAccessoryTemplateRspBO deleteAccessoryTemplate(DelAccessoryTemplateReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getAccessoryCode())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u3010\u9644\u4ef6\u7f16\u7801\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AccessoryTemplate accessoryTemplate = new AccessoryTemplate();
        accessoryTemplate.setAccessoryCode(reqBO.getAccessoryCode());
        int result = this.accessoryTemplateMapper.deleteByCode(accessoryTemplate);
        if (result < 1) {
            throw new BusinessException("BUSI_ACCESSORY_DEL_EXCEPTION", "\u5220\u9664\u9644\u4ef6\u5931\u8d25");
        }
        DelAccessoryTemplateRspBO rspBO = new DelAccessoryTemplateRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5220\u9664\u9644\u4ef6\u6210\u529f");
        return rspBO;
    }
}

