/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.bo.busi.UccAddAttrValueReqBO;
import com.tydic.commodity.bo.busi.UccAddAttrValueRspBO;
import com.tydic.commodity.busi.api.UccAddAttrValueBusiService;
import com.tydic.commodity.dao.UccCommodityPropDefMapper;
import com.tydic.commodity.dao.UccPropValueListMapper;
import com.tydic.commodity.dao.po.UccCommdPropDefPo;
import com.tydic.commodity.dao.po.UccPropValueListPo;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@Service(version="1.0.0", group="UCC_GROUP_PROD", interfaceClass=UccAddAttrValueBusiService.class)
public class UccAddAttrValueBusiServiceImpl
implements UccAddAttrValueBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccAddAttrValueBusiServiceImpl.class);
    private Sequence uccBrandSequence = Sequence.getInstance();
    @Autowired
    private UccPropValueListMapper uccPropValueListMapper;
    @Autowired
    private UccCommodityPropDefMapper uccCommodityPropDefMapper;

    public UccAddAttrValueRspBO addAttrValue(UccAddAttrValueReqBO reqBO) {
        UccAddAttrValueRspBO rspBO = new UccAddAttrValueRspBO();
        if (StringUtils.isEmpty((Object)reqBO.getCommodityPropDefId())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5c5e\u6027ID \u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        UccCommdPropDefPo uccCommdPropDefPo = new UccCommdPropDefPo();
        uccCommdPropDefPo.setCommodityPropDefId(reqBO.getCommodityPropDefId());
        uccCommdPropDefPo = this.uccCommodityPropDefMapper.queryBycommodityPropDefId(uccCommdPropDefPo);
        if (uccCommdPropDefPo == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u5c5e\u6027ID");
            return rspBO;
        }
        UccPropValueListPo uccPropValueListPo = new UccPropValueListPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)uccPropValueListPo);
        int cout = 0;
        try {
            uccPropValueListPo.setPropValueListId(this.uccBrandSequence.nextId());
            cout = this.uccPropValueListMapper.addAttrValues(uccPropValueListPo);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5c5e\u6027\u503c\u65b0\u589e\u5931\u8d25");
            return rspBO;
        }
        if (cout > 0) {
            rspBO.setPropValueListId(uccPropValueListPo.getPropValueListId());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5c5e\u6027\u503c\u65b0\u589e\u6210\u529f");
        } else {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5c5e\u6027\u503c\u65b0\u589e\u5931\u8d25");
        }
        return rspBO;
    }
}

