/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.bo.UmcStationWebBO;
import com.tydic.commodity.bo.busi.ApprovalAuthorCheckReqBO;
import com.tydic.commodity.bo.busi.ApprovalAuthorCheckRspBO;
import com.tydic.commodity.bo.busi.ApprovalCommoAuthor;
import com.tydic.commodity.bo.busi.UccZoneGoodsAuditNotifyMessageBO;
import com.tydic.commodity.busi.api.ApprovalCommoAuthorService;
import com.tydic.commodity.busi.api.UccApprovalAuthorCheckService;
import com.tydic.commodity.dao.UccApprovalConfigMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.ApprovalConfigPO;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.enumType.ApprovalCommoAuthDetailEnum;
import com.tydic.commodity.enumType.ApprovalTypeEnum;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.uac.config.ProperticeVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_PROD", interfaceClass=UccApprovalAuthorCheckService.class)
public class UccApprovalAuthorCheckServiceImpl
implements UccApprovalAuthorCheckService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccApprovalAuthorCheckServiceImpl.class);
    @Resource(name="zoneGoodsAuditMQ")
    private ProxyMessageProducer zoneGoodsAuditMQ;
    @Autowired
    ProperticeVo properticeVo;
    @Reference(interfaceClass=ApprovalCommoAuthorService.class, version="1.0.0", group="UCC_GROUP_PROD")
    private ApprovalCommoAuthorService approvalCommoAuthorService;
    @Autowired
    private UccApprovalConfigMapper approvalConfigMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Resource(name="approvalObjInfoMQ")
    private ProxyMessageProducer approvalObjInfoMQ;

    public ApprovalAuthorCheckRspBO approvalAuthorCheck(ApprovalAuthorCheckReqBO reqBO) {
        ApprovalAuthorCheckRspBO approvalAuthorCheckRspBO = new ApprovalAuthorCheckRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getUmcStationsListWebExt())) {
            approvalAuthorCheckRspBO.setRespCode("0000");
            approvalAuthorCheckRspBO.setCheckFlag(Boolean.valueOf(false));
            approvalAuthorCheckRspBO.setRespDesc("\u8be5\u64cd\u4f5c\u5458\u65e0\u4efb\u4f55\u6743\u9650\uff0c\u4e0d\u80fd\u64cd\u4f5c");
            return approvalAuthorCheckRspBO;
        }
        List authString = null;
        ArrayList code = Lists.newArrayList();
        try {
            Map authMap;
            ApprovalCommoAuthor approvalCommoAuthor;
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getUmcStationsListWebExt())) {
                List params = JSON.parseArray((String)JSON.toJSONString((Object)reqBO.getUmcStationsListWebExt()), UmcStationWebBO.class);
                for (UmcStationWebBO umcStationWebBO : params) {
                    code.add(umcStationWebBO.getStationCode());
                }
            }
            if ((approvalCommoAuthor = this.approvalCommoAuthorService.getApprovalRoleAuth((List)code)) != null && null != (authMap = approvalCommoAuthor.getMap()).get(ApprovalCommoAuthDetailEnum.APPROVAL_LEVEL.code())) {
                authString = (List)authMap.get(ApprovalCommoAuthDetailEnum.APPROVAL_LEVEL.code());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u6570\u636e\u5b57\u5178\u5f02\u5e38:" + e);
            throw new BusinessException("8888", "\u67e5\u8be2\u6570\u636e\u5b57\u5178\u5f02\u5e38");
        }
        if (CollectionUtils.isNotEmpty(authString)) {
            for (String approvalStatus : authString) {
                if (!approvalStatus.equals(ApprovalTypeEnum.APPROVAL_PASS_ZRO.getStep())) continue;
                approvalAuthorCheckRspBO.setRespCode("0000");
                approvalAuthorCheckRspBO.setRespDesc("\u6210\u529f");
                return approvalAuthorCheckRspBO;
            }
        }
        approvalAuthorCheckRspBO.setRespCode("0000");
        approvalAuthorCheckRspBO.setCheckFlag(Boolean.valueOf(false));
        approvalAuthorCheckRspBO.setRespDesc("\u8be5\u7ea7\u5ba1\u6838\u5458\u4e0d\u80fd\u64cd\u4f5c");
        return approvalAuthorCheckRspBO;
    }

    public ApprovalAuthorCheckRspBO zoneApprovalAuthCheck(ApprovalAuthorCheckReqBO reqBO) {
        ApprovalAuthorCheckRspBO rspBO = new ApprovalAuthorCheckRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        ApprovalConfigPO approvalConfigPO = new ApprovalConfigPO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getUmcStationsListWebExt())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5c97\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        List<UccSkuPo> uccSkuPos = this.uccSkuMapper.qeryBatchSkus(reqBO.getSkuIds());
        List<Long> commodityId = uccSkuPos.stream().map(UccSkuPo::getCommodityId).collect(Collectors.toList());
        approvalConfigPO.setSkuIds(commodityId);
        boolean flage = false;
        List<Object> reduceList = new ArrayList();
        for (UmcStationWebBO umcStationWebBO : reqBO.getUmcStationsListWebExt()) {
            approvalConfigPO.setApprovalPost(umcStationWebBO.getStationCode());
            List<Long> skuList = this.approvalConfigMapper.selectZoneApprovalAuthCheck(approvalConfigPO);
            if (!CollectionUtils.isNotEmpty(skuList) || !CollectionUtils.isEmpty(reduceList = reqBO.getSkuIds().stream().filter(item -> !skuList.contains(item)).collect(Collectors.toList()))) continue;
            flage = true;
        }
        if (!flage) {
            if (CollectionUtils.isEmpty(reduceList)) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u65e0\u5ba1\u6279\u6743\u9650");
            } else {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5176\u4e2d\u5546\u54c1ID[" + ((Object)reduceList).toString() + "]\u65e0\u5ba1\u6279\u6743\u9650");
            }
            return rspBO;
        }
        rspBO.setRespCode("8888");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public void audit() {
        try {
            UccZoneGoodsAuditNotifyMessageBO zoneGoodsAuditNotifyMessageBO = new UccZoneGoodsAuditNotifyMessageBO();
            zoneGoodsAuditNotifyMessageBO.setAgreementId("1213");
            zoneGoodsAuditNotifyMessageBO.setAuditStatus("1");
            this.zoneGoodsAuditMQ.send(new ProxyMessage(this.properticeVo.getProperty("UCC_AUDIT_NOTIFY_TOPIC"), "*", JSONObject.toJSONString((Object)zoneGoodsAuditNotifyMessageBO)));
        }
        catch (Exception var16) {
            LOGGER.error("\u53d1\u9001\u5931\u8d25:" + var16);
            throw new com.tydic.uac.exception.BusinessException("6001", "\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u5ba1\u6279\u53d1\u9001\u6d88\u606f\u961f\u5217MQ\u6570\u636e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + var16.getMessage());
        }
    }

    public void uccAudit() {
        this.uccSkuMapper.selectByAgreementDetailId(null, 396769159888871400L);
    }
}

