/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.atom.UccDictionaryAtomService;
import com.tydic.commodity.bo.busi.UccChannelDateBO;
import com.tydic.commodity.bo.busi.UccChannelSortOrderQueryReqBO;
import com.tydic.commodity.bo.busi.UccChannelSortOrderQueryRspBO;
import com.tydic.commodity.busi.api.UccChannelSortOrderQueryBusiService;
import com.tydic.commodity.dao.UccChannelDealMapper;
import com.tydic.commodity.dao.po.DicDictionaryPo;
import com.tydic.commodity.dao.po.UccChannelDealPO;
import com.tydic.commodity.enumType.Channel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_PROD", interfaceClass=UccChannelSortOrderQueryBusiService.class)
public class UccChannelSortOrderQueryBusiServiceImpl
implements UccChannelSortOrderQueryBusiService {
    @Autowired
    private UccChannelDealMapper uccChannelDealMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;

    public UccChannelSortOrderQueryRspBO sortOrderQuery(UccChannelSortOrderQueryReqBO reqBO) {
        UccChannelSortOrderQueryRspBO rspBO = new UccChannelSortOrderQueryRspBO();
        String s = this.judge(reqBO);
        if (!"".equals(s)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(s);
            return rspBO;
        }
        UccChannelDealPO channelDealPO = new UccChannelDealPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)channelDealPO);
        channelDealPO.setOrderBy("view_order");
        channelDealPO.setOrderType("asc");
        Page page = new Page();
        page.setPageSize(reqBO.getPageSize());
        page.setPageNo(reqBO.getPageNo());
        List<UccChannelDealPO> uccChannelDealPOS = this.uccChannelDealMapper.sortOrderQuery(channelDealPO, page);
        ArrayList<UccChannelDateBO> dataList = new ArrayList<UccChannelDateBO>();
        if (CollectionUtils.isNotEmpty(uccChannelDealPOS)) {
            for (UccChannelDealPO po : uccChannelDealPOS) {
                UccChannelDateBO result1 = new UccChannelDateBO();
                BeanUtils.copyProperties((Object)po, (Object)result1);
                DicDictionaryPo dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(po.getChannelStatus()), Channel.CHANNEL_STATUS.toString());
                if (dicDictionaryPo != null) {
                    result1.setChannelStatusTranslation(dicDictionaryPo.getTitle());
                }
                dataList.add(result1);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRows(dataList);
        return rspBO;
    }

    public String judge(UccChannelSortOrderQueryReqBO reqBO) {
        Map<String, String> map;
        String s = "";
        if (reqBO.getChannelStatus() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(Channel.CHANNEL_STATUS.toString())).containsKey(String.valueOf(reqBO.getChannelStatus()))) {
            s = "\u8bf7\u8f93\u5165\u6b63\u786e\u72b6\u6001";
        }
        return s;
    }
}

