/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.tydic.commodity.bo.busi.UccCommdOverViewAmountQryReqBO;
import com.tydic.commodity.bo.busi.UccCommdOverViewAmountQryRspBO;
import com.tydic.commodity.busi.api.UccCommdOverViewAmountQryBusiService;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccCommdStatusCountPo;
import com.tydic.commodity.exception.BusinessException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_PROD", interfaceClass=UccCommdOverViewAmountQryBusiService.class)
public class UccCommdOverViewAmountQryBusiServiceImpl
implements UccCommdOverViewAmountQryBusiService {
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCommdOverViewAmountQryBusiServiceImpl.class);

    public UccCommdOverViewAmountQryRspBO queryCommdAmount(UccCommdOverViewAmountQryReqBO reqBO) {
        UccCommdOverViewAmountQryRspBO rspBO = new UccCommdOverViewAmountQryRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        if (reqBO.getOrgIdIn() == null) {
            throw new BusinessException("8888", "\u8bf7\u8f93\u5165\u673a\u6784ID");
        }
        List<SupplierShopPo> supplierShopPos = this.supplierShopMapper.selectSupplierShopBySupplierId(reqBO.getOrgIdIn());
        if (CollectionUtils.isEmpty(supplierShopPos)) {
            rspBO.setRespDesc("\u5546\u6237\u4e0b\u65e0\u5e97\u94fa\u4fe1\u606f");
            return rspBO;
        }
        List supplierShopIds = supplierShopPos.stream().map(SupplierShopPo::getSupplierShopId).collect(Collectors.toList());
        List<UccCommdStatusCountPo> poList = this.uccSkuMapper.qryCommdCountGourpBySkuStaus(reqBO.getOrgIdIn());
        rspBO.setDepotItemNum(Long.valueOf(0L));
        rspBO.setSaleNum(Long.valueOf(0L));
        if (poList.size() == 0) {
            return rspBO;
        }
        Long count = 0L;
        for (UccCommdStatusCountPo each : poList) {
            if (each.getSkuStatus() == 3) {
                rspBO.setSaleNum(each.getCount());
                continue;
            }
            if (each.getSkuStatus() == 6) continue;
            count = count + each.getCount();
        }
        rspBO.setDepotItemNum(count);
        return rspBO;
    }
}

