/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.atom.UccDictionaryAtomService;
import com.tydic.commodity.bo.busi.UccCommdDateBO;
import com.tydic.commodity.bo.busi.UccCommdQueryReqBO;
import com.tydic.commodity.bo.busi.UccCommdQueryRspBO;
import com.tydic.commodity.busi.api.UccCommdQueryBusiService;
import com.tydic.commodity.dao.UccCommdQueryDealMapper;
import com.tydic.commodity.dao.po.DicDictionaryPo;
import com.tydic.commodity.dao.po.UccCommdQueryPO;
import com.tydic.commodity.enumType.CommodityEnum;
import com.tydic.commodity.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_PROD", interfaceClass=UccCommdQueryBusiService.class)
public class UccCommdQueryBusiServiceImpl
implements UccCommdQueryBusiService {
    @Autowired
    private UccCommdQueryDealMapper commdMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    UccCommdQueryRspBO rspBO = new UccCommdQueryRspBO();

    public UccCommdQueryRspBO queryCommdByShopId(UccCommdQueryReqBO reqBO) {
        if (!this.judge(reqBO)) {
            this.rspBO.setRespCode("8888");
            this.rspBO.setRows(null);
            return this.rspBO;
        }
        this.rspBO = new UccCommdQueryRspBO();
        UccCommdQueryPO po = new UccCommdQueryPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        List<Object> poList = new ArrayList();
        Page page = new Page();
        page.setPageNo(reqBO.getPageNo());
        page.setPageSize(reqBO.getPageSize());
        try {
            poList = this.commdMapper.selectCommdByShopId(po, page);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u67e5\u8be2\u5546\u54c1\u5f02\u5e38");
        }
        ArrayList<UccCommdDateBO> result = new ArrayList<UccCommdDateBO>();
        if (poList != null && poList.size() > 0) {
            UccCommdDateBO dateBO = new UccCommdDateBO();
            DicDictionaryPo dicDictionaryPo = null;
            for (UccCommdQueryPO uccCommdQueryPO : poList) {
                dateBO = new UccCommdDateBO();
                BeanUtils.copyProperties((Object)uccCommdQueryPO, (Object)dateBO);
                dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(uccCommdQueryPO.getCommoditySource()), CommodityEnum.COMMODITY_SOURCE.toString());
                if (dicDictionaryPo != null) {
                    dateBO.setCommoditySourceTranslation(dicDictionaryPo.getTitle());
                }
                if ((dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(uccCommdQueryPO.getCommodityStatus()), CommodityEnum.COMMODITY_STATUS.toString())) != null) {
                    dateBO.setCommodityStatusTranslation(dicDictionaryPo.getTitle());
                }
                result.add(dateBO);
            }
        }
        this.rspBO.setRows(result);
        this.rspBO.setPageNo(page.getPageNo());
        this.rspBO.setRecordsTotal(page.getTotalCount());
        this.rspBO.setTotal(page.getTotalPages());
        this.rspBO.setRespCode("0000");
        this.rspBO.setRespDesc("\u67e5\u8be2\u4fe1\u606f\u6210\u529f");
        return this.rspBO;
    }

    public boolean judge(UccCommdQueryReqBO reqBO) {
        if (reqBO.getSupplierShopId() == null) {
            this.rspBO.setRespDesc("\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        return true;
    }
}

