/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.bo.busi.UccCommodityAndSkuStatusReqBO;
import com.tydic.commodity.bo.busi.UccCommodityAndSkuStatusRspBO;
import com.tydic.commodity.busi.api.UccCommodityAndSkuStatusService;
import com.tydic.commodity.dao.UccCommodityLogMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuLogMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.UccCommodityLogPO;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.dao.po.UccSkuLogPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.util.ListCloneUtils;
import com.tydic.commodity.validate.ValidatorUtil;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_PROD", interfaceClass=UccCommodityAndSkuStatusService.class)
public class UccCommodityAndSkuStatusServiceImpl
implements UccCommodityAndSkuStatusService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCommodityAndSkuStatusServiceImpl.class);
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSkuMapper skuMapper;
    @Autowired
    private UccCommodityLogMapper uccCommodityLogMapper;
    @Autowired
    private UccSkuLogMapper skuLogMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();

    public UccCommodityAndSkuStatusRspBO updateCommodityAndSkuStatus(UccCommodityAndSkuStatusReqBO reqBO) {
        List poList;
        ValidatorUtil.validator((Object)reqBO);
        UccCommodityPo uccCommodityPo = this.uccCommodityMapper.getCommodityById(reqBO.getCommodityId());
        if (null == uccCommodityPo) {
            throw new BusinessException("8888", "\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        UccCommodityLogPO uccCommodityLogPO = new UccCommodityLogPO();
        BeanUtils.copyProperties((Object)uccCommodityPo, (Object)uccCommodityLogPO);
        Long batch = this.uccBatchSequence.nextId();
        uccCommodityLogPO.setBatchId(batch);
        this.uccCommodityLogMapper.insert(uccCommodityLogPO);
        uccCommodityPo.setCommodityStatus(0);
        this.uccCommodityMapper.updateCommodity(uccCommodityPo);
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setCommodityId(reqBO.getCommodityId());
        List<UccSkuPo> uccSkuPos = this.skuMapper.qerySku(uccSkuPo);
        try {
            poList = ListCloneUtils.clonePOListToBOListNotDate(uccSkuPos, UccSkuLogPo.class);
        }
        catch (Exception e) {
            LOGGER.error("\u5546\u54c1\u5355\u54c1\u72b6\u6001\u53d8\u66f4\uff0c\u6570\u636e\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("8888", "\u5546\u54c1\u5355\u54c1\u72b6\u6001\u53d8\u66f4\u5931\u8d25");
        }
        if (CollectionUtils.isNotEmpty((Collection)poList)) {
            for (UccSkuLogPo uccSkuLogPo : poList) {
                uccSkuLogPo.setBatchId(this.uccBatchSequence.nextId());
            }
            this.skuLogMapper.addSkuLog(poList);
        }
        this.skuMapper.batchUpdateSkuStatusReject(uccSkuPos, uccCommodityPo.getSupplierShopId(), reqBO.getStatus());
        UccCommodityAndSkuStatusRspBO uccCommodityAndSkuStatusRspBO = new UccCommodityAndSkuStatusRspBO();
        uccCommodityAndSkuStatusRspBO.setRespCode("0000");
        uccCommodityAndSkuStatusRspBO.setRespDesc("\u6210\u529f");
        return uccCommodityAndSkuStatusRspBO;
    }
}

