/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.tydic.commodity.bo.busi.UccCreateApprovalLevelReqBO;
import com.tydic.commodity.bo.busi.UccCreateApprovalLevelRspBO;
import com.tydic.commodity.busi.api.UccCreateApprovalLevelBusiService;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.dao.ApprovalLevelMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccUpperCatalogDealMapper;
import com.tydic.commodity.dao.po.ApprovalLevelPO;
import com.tydic.commodity.dao.po.UccCommodityTypePo;
import com.tydic.commodity.dao.po.UccUpperCatalogDealPO;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.util.ListCloneUtils;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_PROD", interfaceClass=UccCreateApprovalLevelBusiService.class)
public class UccCreateApprovalLevelBusiServiceImpl
implements UccCreateApprovalLevelBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCreateApprovalLevelBusiServiceImpl.class);
    @Autowired
    private UccUpperCatalogDealMapper typeDealMapper;
    @Autowired
    private UccCommodityTypeMapper commodityTypeMapper;
    @Autowired
    private ApprovalLevelMapper approvalLevelMapper;
    private static final Integer CATALOG_LEVEL_ONE = 1;
    private static final Integer CATALOG_LEVEL_TWO = 2;
    private static final Integer CATALOG_LEVEL_THREE = 3;

    public UccCreateApprovalLevelRspBO createApprovalLevel(UccCreateApprovalLevelReqBO reqBO) {
        List<UccUpperCatalogDealPO> connectCommdTypeDealPOS = this.cloneApprovalLevelReqBo(reqBO);
        this.batchCreateApprovalLevel(connectCommdTypeDealPOS);
        UccCreateApprovalLevelRspBO uccCreateApprovalLevelRspBO = new UccCreateApprovalLevelRspBO();
        uccCreateApprovalLevelRspBO.setRespCode("0000");
        uccCreateApprovalLevelRspBO.setRespDesc("\u6210\u529f");
        return uccCreateApprovalLevelRspBO;
    }

    private void batchCreateApprovalLevel(List<UccUpperCatalogDealPO> connectCommdTypeDealPOS) {
        for (UccUpperCatalogDealPO uccUpperCatalogDealPO : connectCommdTypeDealPOS) {
            List<UccUpperCatalogDealPO> uccUpperCatalogDealPOS = this.typeDealMapper.selectAllPrentLevelByguideCatalogId(uccUpperCatalogDealPO);
            this.processCatalogDeal(uccUpperCatalogDealPOS, uccUpperCatalogDealPO.getCommodityTypeId());
        }
    }

    private void processCatalogDeal(List<UccUpperCatalogDealPO> uccUpperCatalogDealPOS, Long commodityTypeId) {
        ApprovalLevelPO approvalLevelPO = new ApprovalLevelPO();
        UccCommodityTypePo uccCommodityTypePo = this.commodityTypeMapper.queryPoByCommodityTypeId(commodityTypeId);
        approvalLevelPO.setId(UUID.randomUUID().getLeastSignificantBits());
        approvalLevelPO.setCommodityTypeName(uccCommodityTypePo.getCommodityTypeName());
        approvalLevelPO.setCommodityTypeId(uccCommodityTypePo.getCommodityTypeId());
        approvalLevelPO.setApprovalLevel(ModelRuleConstant.APPROVAL_LEVEL_FOCUS);
        approvalLevelPO.setCreateTime(new Date());
        for (UccUpperCatalogDealPO uccUpperCatalogDealPO : uccUpperCatalogDealPOS) {
            if (uccUpperCatalogDealPO.getCatalogLevel() == CATALOG_LEVEL_ONE) {
                approvalLevelPO.setCatalogName1(uccUpperCatalogDealPO.getCatalogName());
                approvalLevelPO.setGuideCatalogId1(uccUpperCatalogDealPO.getGuideCatalogId());
                continue;
            }
            if (uccUpperCatalogDealPO.getCatalogLevel() == CATALOG_LEVEL_TWO) {
                approvalLevelPO.setCatalogName2(uccUpperCatalogDealPO.getCatalogName());
                approvalLevelPO.setGuideCatalogId2(uccUpperCatalogDealPO.getGuideCatalogId());
                continue;
            }
            if (uccUpperCatalogDealPO.getCatalogLevel() != CATALOG_LEVEL_THREE) continue;
            approvalLevelPO.setCatalogName3(uccUpperCatalogDealPO.getCatalogName());
            approvalLevelPO.setGuideCatalogId3(uccUpperCatalogDealPO.getGuideCatalogId());
        }
        this.approvalLevelMapper.insertSelective(approvalLevelPO);
    }

    private List<UccUpperCatalogDealPO> cloneApprovalLevelReqBo(UccCreateApprovalLevelReqBO reqBO) {
        try {
            List uccUpperCatalogDealPOS = ListCloneUtils.clonePOListToBOList((List)reqBO.getCreateApprovalLevelBOS(), UccUpperCatalogDealPO.class);
            return uccUpperCatalogDealPOS;
        }
        catch (Exception e) {
            LOGGER.error("\u514b\u9686\u5546\u54c1\u7c7b\u578b\u5ba1\u6838\u7b49\u7ea7\u6570\u636e\u9519\u8bef", (Throwable)e);
            throw new BusinessException("8888", "\u5546\u54c1\u7c7b\u578b\u5ba1\u6838\u7b49\u7ea7\u6570\u636e\u9519\u8bef");
        }
    }
}

