/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.atom.UccDictionaryAtomService;
import com.tydic.commodity.bo.busi.UccModifyAttributesReqBO;
import com.tydic.commodity.bo.busi.UccModifyAttributesRspBO;
import com.tydic.commodity.busi.api.UccModifyAttributesBusiService;
import com.tydic.commodity.dao.UccCommodityPropDefMapper;
import com.tydic.commodity.dao.po.UccCommdPropDefPo;
import com.tydic.commodity.enumType.CommodityPropDefEnum;
import java.util.Map;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_PROD", interfaceClass=UccModifyAttributesBusiService.class)
public class UccModifyAttributesBusiServiceImpl
implements UccModifyAttributesBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccModifyAttributesBusiServiceImpl.class);
    @Autowired
    private UccCommodityPropDefMapper uccCommodityPropDefMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;

    public UccModifyAttributesRspBO modifyAttributes(UccModifyAttributesReqBO reqBO) {
        UccModifyAttributesRspBO rspBO = new UccModifyAttributesRspBO();
        String errMsg = this.verify(reqBO);
        if (!"".equals(errMsg)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(errMsg);
            return rspBO;
        }
        UccCommdPropDefPo po = new UccCommdPropDefPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        int count = 0;
        try {
            count = this.uccCommodityPropDefMapper.modifyCoomdProp(po);
        }
        catch (Exception e) {
            LOGGER.error("\u5c5e\u6027\u4fee\u6539\u5931\u8d25\uff1a" + e.getMessage());
            throw new ZTBusinessException("\u5c5e\u6027\u4fee\u6539\u5931\u8d25");
        }
        if (count < 1) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5c5e\u6027\u4fee\u6539\u5931\u8d25");
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5c5e\u6027\u4fee\u6539\u6210\u529f");
        }
        return rspBO;
    }

    private String verify(UccModifyAttributesReqBO reqBO) {
        String errMsg = "";
        if (reqBO.getCommodityPropDefId() == null || reqBO.getCommodityPropDefId() == 0L) {
            return "\u5c5e\u6027ID \u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!this.isExit(reqBO)) {
            return "\u5c5e\u6027ID: " + reqBO.getCommodityPropDefId() + "\u4e0d\u5b58\u5728";
        }
        errMsg = this.enumVerify(reqBO);
        return errMsg;
    }

    private boolean isExit(UccModifyAttributesReqBO reqBO) {
        UccCommdPropDefPo po = new UccCommdPropDefPo();
        po.setCommodityPropDefId(reqBO.getCommodityPropDefId());
        po = this.uccCommodityPropDefMapper.queryBycommodityPropDefId(po);
        return po != null;
    }

    private String enumVerify(UccModifyAttributesReqBO reqBO) {
        String errMsg = "";
        Map<String, String> map = null;
        if (reqBO.getPropTag() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityPropDefEnum.COMMODITY_PROP_DEF_PROP_TAG.toString())).containsKey(reqBO.getPropTag().toString())) {
            errMsg = "\u8bf7\u8f93\u5165\u6b63\u786e\u7684 propTag\u503c";
        }
        if (reqBO.getPropType() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityPropDefEnum.COMMODITY_PROP_DEF_PROP_TYPE.toString())).containsKey(reqBO.getPropType().toString())) {
            errMsg = "\u8bf7\u8f93\u5165\u6b63\u786e\u7684 propType";
        }
        if (reqBO.getInputType() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityPropDefEnum.COMMODITY_PROP_DEF_INPUT_TYPE.toString())).containsKey(reqBO.getInputType().toString())) {
            errMsg = "\u8bf7\u8f93\u5165\u6b63\u786e\u7684 inputType";
        }
        if (reqBO.getFilterFlag() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityPropDefEnum.COMMODITY_PROP_DEF_FILTER_FLAG.toString())).containsKey(reqBO.getFilterFlag().toString())) {
            errMsg = "\u8bf7\u8f93\u5165\u6b63\u786e\u7684 filterFlag\u503c";
        }
        if (reqBO.getRequiredFlag() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityPropDefEnum.COMMODITY_PROP_DEF_REQUIRED_FLAG.toString())).containsKey(reqBO.getRequiredFlag().toString())) {
            errMsg = "\u8bf7\u8f93\u5165\u6b63\u786e\u7684 requiredFlag \u503c";
        }
        if (reqBO.getMultiFlag() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityPropDefEnum.COMMODITY_PROP_DEF_MULTI_FLAG.toString())).containsKey(reqBO.getMultiFlag().toString())) {
            errMsg = "\u8bf7\u8f93\u5165\u6b63\u786e\u7684 multiFlag \u503c";
        }
        if (reqBO.getPropertyLink() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityPropDefEnum.COMMODITY_PROP_DEF_PROPERTY_LINK.toString())).containsKey(reqBO.getPropertyLink().toString())) {
            errMsg = "\u8bf7\u8f93\u5165\u6b63\u786e\u7684 propertyLink \u503c";
        }
        return errMsg;
    }
}

