/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.aliyun.oss.OSSClient;
import com.tydic.commodity.bo.busi.OssFileDeleteBO;
import com.tydic.commodity.bo.busi.UccOssFileDeleteReqBO;
import com.tydic.commodity.bo.busi.UccOssFileDeleteRspBO;
import com.tydic.commodity.busi.api.UccOssFileDeleteService;
import com.tydic.commodity.exception.BusinessException;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

@Service(version="1.0.0", group="UCC_GROUP_PROD", interfaceClass=UccOssFileDeleteService.class)
public class UccOssDeleteFileServiceImpl
implements UccOssFileDeleteService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccOssDeleteFileServiceImpl.class);
    @Value(value="${oss.endpoint}")
    private String endpoint;
    @Value(value="${oss.accesskey}")
    private String accessKeyId;
    @Value(value="${oss.accessKeySecret}")
    private String accessKeySecret;
    @Value(value="${oss.bucketName}")
    private String bucketName;

    public UccOssFileDeleteRspBO deleteOSSFile(UccOssFileDeleteReqBO ossFileDeleteReqBO) {
        UccOssFileDeleteRspBO uccOssFileDeleteRspBO = new UccOssFileDeleteRspBO();
        OSSClient ossClient = new OSSClient(this.endpoint, this.accessKeyId, this.accessKeySecret);
        try {
            for (OssFileDeleteBO ossFileDeleteBO : ossFileDeleteReqBO.getOssFileDeleteBOS()) {
                ossClient.deleteObject(this.bucketName, ossFileDeleteBO.getOssKey());
                if (ossFileDeleteBO.getOssKeyPreview() == null || "".equals(ossFileDeleteBO.getOssKeyPreview())) continue;
                ossClient.deleteObject(this.bucketName, ossFileDeleteBO.getOssKeyPreview());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u6587\u4ef6\u5931\u8d25,\u539f\u56e0:{}", (Throwable)e);
            throw new BusinessException("8888", "\u5220\u9664\u6587\u4ef6\u5931\u8d25");
        }
        finally {
            ossClient.shutdown();
        }
        uccOssFileDeleteRspBO.setRespCode("0000");
        uccOssFileDeleteRspBO.setRespDesc("\u6210\u529f");
        return uccOssFileDeleteRspBO;
    }
}

