/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.atom.UccDictionaryAtomService;
import com.tydic.commodity.bo.busi.CommdPropDefBO;
import com.tydic.commodity.bo.busi.UccQueryAttributesReqBO;
import com.tydic.commodity.bo.busi.UccQueryAttributesRspBO;
import com.tydic.commodity.busi.api.UccQueryAttributesBusiService;
import com.tydic.commodity.busi.impl.UccAddAttributesBusiServiceImpl;
import com.tydic.commodity.dao.UccCommodityPropDefMapper;
import com.tydic.commodity.dao.po.DicDictionaryPo;
import com.tydic.commodity.dao.po.UccCommdPropDefPo;
import com.tydic.commodity.enumType.CommodityPropDefEnum;
import com.tydic.commodity.util.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_PROD", interfaceClass=UccQueryAttributesBusiService.class)
public class UccQueryAttributesBusiServiceImpl
implements UccQueryAttributesBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccAddAttributesBusiServiceImpl.class);
    @Autowired
    private UccCommodityPropDefMapper uccCommodityPropDefMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;

    public UccQueryAttributesRspBO queryAttributes(UccQueryAttributesReqBO reqBO) {
        UccQueryAttributesRspBO rspBO = new UccQueryAttributesRspBO();
        String errMsg = this.enumVerify(reqBO);
        if (!"".equals(errMsg)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(errMsg);
        }
        Page pagePo = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        UccCommdPropDefPo po = new UccCommdPropDefPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        List<UccCommdPropDefPo> polist = this.uccCommodityPropDefMapper.queryPoToPage((Page<UccCommdPropDefPo>)pagePo, po);
        if (polist == null || polist.size() == 0) {
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setTotal(0);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        ArrayList<CommdPropDefBO> boList = new ArrayList<CommdPropDefBO>();
        CommdPropDefBO bo = null;
        DicDictionaryPo dicDictionaryPo = null;
        for (UccCommdPropDefPo each : polist) {
            bo = new CommdPropDefBO();
            BeanUtils.copyProperties((Object)each, (Object)bo);
            if (each.getCreateTime() != null) {
                bo.setCreateTime(DateUtils.dateToStr((Date)each.getCreateTime()));
            }
            if (each.getUpdateTime() != null) {
                bo.setUpdateTime(DateUtils.dateToStr((Date)each.getUpdateTime()));
            }
            if ((dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getPropTag().toString(), CommodityPropDefEnum.COMMODITY_PROP_DEF_PROP_TAG.toString())) != null) {
                bo.setPropTagTranslation(dicDictionaryPo.getTitle());
            }
            if ((dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(each.getPropType()), CommodityPropDefEnum.COMMODITY_PROP_DEF_PROP_TYPE.toString())) != null) {
                bo.setPropTypeTranslation(dicDictionaryPo.getTitle());
            }
            if ((dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(each.getInputType()), CommodityPropDefEnum.COMMODITY_PROP_DEF_INPUT_TYPE.toString())) != null) {
                bo.setInputTypeTranslation(dicDictionaryPo.getTitle());
            }
            if ((dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getFilterFlag().toString(), CommodityPropDefEnum.COMMODITY_PROP_DEF_FILTER_FLAG.toString())) != null) {
                bo.setFilterFlagTranslation(dicDictionaryPo.getTitle());
            }
            if ((dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(each.getRequiredFlag()), CommodityPropDefEnum.COMMODITY_PROP_DEF_REQUIRED_FLAG.toString())) != null) {
                bo.setRequiredFlagTranslation(dicDictionaryPo.getTitle());
            }
            if ((dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(each.getMultiFlag()), CommodityPropDefEnum.COMMODITY_PROP_DEF_MULTI_FLAG.toString())) != null) {
                bo.setMultiFlagTranslation(dicDictionaryPo.getTitle());
            }
            if ((dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(each.getPropertyLink()), CommodityPropDefEnum.COMMODITY_PROP_DEF_PROPERTY_LINK.toString())) != null) {
                bo.setPropertyLinkTranslation(dicDictionaryPo.getTitle());
            }
            boList.add(bo);
        }
        rspBO.setRows(boList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setPageNo(pagePo.getPageNo());
        rspBO.setRecordsTotal(pagePo.getTotalCount());
        rspBO.setTotal(pagePo.getTotalPages());
        return rspBO;
    }

    private String enumVerify(UccQueryAttributesReqBO reqBO) {
        String errMsg = "";
        Map<String, String> map = null;
        if (reqBO.getFilterFlag() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityPropDefEnum.COMMODITY_PROP_DEF_FILTER_FLAG.toString())).containsKey(reqBO.getFilterFlag().toString())) {
            errMsg = "\u8bf7\u8f93\u5165\u6b63\u786e\u7684 filterFlag\u503c";
        }
        if (reqBO.getPropTag() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityPropDefEnum.COMMODITY_PROP_DEF_PROP_TAG.toString())).containsKey(reqBO.getPropTag().toString())) {
            errMsg = "\u8bf7\u8f93\u5165\u6b63\u786e\u7684 propTag\u503c";
        }
        return errMsg;
    }
}

