/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.tydic.commodity.bo.busi.UccSupplierPwdVerifyReqBO;
import com.tydic.commodity.bo.busi.UccSupplierPwdVerifyRspBO;
import com.tydic.commodity.busi.api.UccSupplierPwdVerifyBusiService;
import com.tydic.commodity.dao.SupplierMapper;
import com.tydic.commodity.dao.po.SupplierBusiPo;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.util.MD5Utils;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@Service(version="1.0.0", group="UCC_GROUP_PROD", interfaceClass=UccSupplierPwdVerifyBusiService.class)
public class UccSupplierPwdVerifyBusiServiceImpl
implements UccSupplierPwdVerifyBusiService {
    @Autowired
    private SupplierMapper supplierMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccSupplierPwdVerifyBusiServiceImpl.class);

    public UccSupplierPwdVerifyRspBO verifySupplierPwd(UccSupplierPwdVerifyReqBO reqBO) {
        UccSupplierPwdVerifyRspBO rspBO = new UccSupplierPwdVerifyRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5bc6\u7801\u6b63\u786e");
        if (reqBO.getSupplierId() == null) {
            throw new BusinessException("8888", "\u5546\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getServicePassword())) {
            throw new BusinessException("8888", "\u670d\u52a1\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String pwd = "";
        try {
            SupplierBusiPo supplierBusiPo = this.supplierMapper.selectSupplierById(reqBO.getSupplierId());
            if (supplierBusiPo == null) {
                rspBO.setRespCode("8888");
                rspBO.setVerify(false);
                rspBO.setRespDesc("\u5bc6\u7801\u9519\u8bef");
                return rspBO;
            }
            pwd = supplierBusiPo.getServicePassword();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u67e5\u8be2\u5931\u8d25");
        }
        String getMd5Pwd = MD5Utils.getMD5Str((String)reqBO.getServicePassword());
        if (!StringUtils.isEmpty((Object)pwd) && pwd.equals(getMd5Pwd)) {
            rspBO.setVerify(true);
        } else {
            rspBO.setVerify(false);
            rspBO.setRespDesc("\u5bc6\u7801\u9519\u8bef");
        }
        return rspBO;
    }
}

