/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.atom.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.atom.BO.UccDealCommodityReqBO;
import com.tydic.commodity.atom.BO.UccDealCommodityRespBO;
import com.tydic.commodity.atom.UccDealCommodityAtomService;
import com.tydic.commodity.busi.impl.UccDealAddBySkuBusiServiceImpl;
import com.tydic.commodity.util.CacheMap;
import com.tydic.commodity.utils.MoneyUtil;
import com.tydic.commodity.utils.PageUtil;
import com.tydic.commodity.utils.SequenceUtil;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="uccDealCommodityAtomService")
public class UccDealCommodityAtomServiceImpl
implements UccDealCommodityAtomService {
    private static final Logger LOG = LoggerFactory.getLogger(UccDealAddBySkuBusiServiceImpl.class);
    private CacheMap cacheMap = CacheMap.getInstance();

    @Override
    public UccDealCommodityRespBO dealCommodity(UccDealCommodityReqBO uccDealCommodityReqBO) {
        JdbcTemplate jdbcTemplate = uccDealCommodityReqBO.getJdbcTemplate();
        String supplierCode = uccDealCommodityReqBO.getSupplierCode();
        Integer supplierSource = uccDealCommodityReqBO.getSupplierSource();
        Long aLong = (Long)jdbcTemplate.queryForObject("select SUPPLIER_ID from ucc_supplier where SUPPLIER_CODE=? and SUPPLIER_SOURCE=?", Long.class, new Object[]{supplierCode, supplierSource});
        Long supplierShopId = (Long)jdbcTemplate.queryForObject("select SUPPLIER_SHOP_ID from ucc_supplier_shop where SUPPLIER_ID=?", Long.class, new Object[]{aLong});
        SequenceUtil sequenceCom = new SequenceUtil(jdbcTemplate, "SEQ_UCC_COMMODITY");
        SequenceUtil sequenceSku = new SequenceUtil(jdbcTemplate, "SEQ_UCC_SKU");
        Sequence sequenceUtil = Sequence.getInstance();
        List maps = jdbcTemplate.queryForList("select t1.CATALOG_ID,t1.COMMODITY_TYPE_ID,t2.CATALOG_ID as IN_CATALOG_ID from UCC_ECOMMERCE_CATALOG t1,ucc_commodity_type t2 where t1.COMMODITY_TYPE_ID=t2.COMMODITY_TYPE_ID and t2.COMMODITY_TYPE_STATUS = 1 and t1.SUPPLIER_ID=? and t1.CATALOG_ID in(select distinct SKU_CATE4 from external_sku_detail where sku_source=1 and SKU in(" + uccDealCommodityReqBO.getSkuListStr() + "))", new Object[]{aLong});
        if (CollectionUtils.isEmpty((Collection)maps)) {
            maps = jdbcTemplate.queryForList("select t1.CATALOG_ID,t1.COMMODITY_TYPE_ID,t2.CATALOG_ID as IN_CATALOG_ID from ucc_commodity_type t1, ucc_e_mdm_catalog t2 where t1.CATALOG_ID = t2.CATALOG_ID and t1.COMMODITY_TYPE_STATUS = 1 and t2.is_delete = 0 and t2.CATALOG_ID in (select distinct SKU_CATE4 from external_sku_detail where sku_source=1 and SKU in(" + uccDealCommodityReqBO.getSkuListStr() + "))");
        }
        if (!CollectionUtils.isEmpty((Collection)maps)) {
            Map vendorInfo = jdbcTemplate.queryForMap("select ID,VENDOR_ID from ucc_vendor where VENDOR_ID = ?", new Object[]{aLong});
            for (Map next : maps) {
                String typeId = next.get("COMMODITY_TYPE_ID").toString();
                String cataLogId = next.get("CATALOG_ID").toString();
                String inCataLogId = next.get("IN_CATALOG_ID").toString();
                List maps2 = jdbcTemplate.queryForList("select sku from EXTERNAL_SKU_DETAIL where SKU_CATE4=? and sku_source=1 and SUPPLIER_CODE = ? and SKU in(" + uccDealCommodityReqBO.getSkuListStr() + ")", new Object[]{cataLogId, supplierCode});
                if (CollectionUtils.isEmpty((Collection)maps2)) continue;
                LOG.info("\u5904\u7406\u54c1\u724c\u4fe1\u606f\u5f00\u59cb,cataLogId={}", (Object)cataLogId);
                List maps3 = jdbcTemplate.queryForList("select distinct brand_name from EXTERNAL_SKU_DETAIL where SKU_CATE4=? and sku_source=1 and SUPPLIER_CODE = ? and SKU in(" + uccDealCommodityReqBO.getSkuListStr() + ")", new Object[]{cataLogId, supplierCode});
                if (!CollectionUtils.isEmpty((Collection)maps3)) {
                    ArrayList<Object[]> bandList = new ArrayList<Object[]>();
                    Iterator iterator1 = maps3.iterator();
                    SimpleDateFormat sf = new SimpleDateFormat("yyyy-mm-dd");
                    Date parse = null;
                    try {
                        parse = sf.parse("2099-12-31");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    while (iterator1.hasNext()) {
                        Map next1 = (Map)iterator1.next();
                        List brand_name = jdbcTemplate.queryForList("select brand_name from UCC_BRAND where BRAND_NAME=? and REMARK=?", new Object[]{next1.get("brand_name"), typeId});
                        if (!CollectionUtils.isEmpty((Collection)brand_name)) continue;
                        Object[] bandParm = new Object[]{sequenceUtil.nextId(), "brand_code", null, next1.get("brand_name"), null, new Date(), parse, 1, null, null, null, null, "sys", new Date(), typeId};
                        bandList.add(bandParm);
                    }
                    jdbcTemplate.batchUpdate("insert into UCC_BRAND(BRAND_ID,BRAND_CODE,BRAND_EN_NAME,BRAND_NAME,BRAND_LOGO,EFF_TIME,                             EXP_TIME,BRAND_STATUS,BRAND_DESC,TRADEMARK_NUM,BRAND_OWNER,TRADEMARK_CARD,                             CREATE_OPER_ID,CREATE_TIME,REMARK) value (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)                              on duplicate key update update_time = now()", bandList);
                }
                LOG.info("\u5904\u7406\u54c1\u724c\u4fe1\u606f\u7ed3\u675f");
                String sqlCommodity = "select 'COMMODITY_CODE' as COMMODITY_CODE,name,d.COMMODITY_TYPE_ID,b.SUPPLIER_SHOP_ID,b.SHOP_NAME,c.BRAND_ID,c.BRAND_NAME,a.introduction,a.sku,a.upc from EXTERNAL_SKU_DETAIL a,ucc_supplier_shop b,ucc_brand c,ucc_commodity_type d where a.sku_source=1 and b.SUPPLIER_SHOP_ID =? and a.BRAND_NAME = c.BRAND_NAME and c.REMARK in  (select concat(COMMODITY_TYPE_ID,'') from ucc_commodity_type where CATALOG_ID = ? and COMMODITY_TYPE_STATUS = 1)      and d.COMMODITY_TYPE_ID in (select COMMODITY_TYPE_ID from ucc_commodity_type where CATALOG_ID = ? and COMMODITY_TYPE_STATUS = 1)  and a.SUPPLIER_CODE=? and a.SKU_CATE4=? and a.SKU in(" + uccDealCommodityReqBO.getSkuListStr() + ")";
                Integer pageCount = PageUtil.getPageCount(jdbcTemplate, sqlCommodity, supplierShopId, inCataLogId, inCataLogId, supplierCode, cataLogId);
                Long commodityId = this.getCacheId(0, sequenceCom);
                for (int i = 1; i <= pageCount; ++i) {
                    LOG.info("\u5904\u7406\u5546\u54c1\u4fe1\u606f\u7b2c{}\u9875\u5f00\u59cb", (Object)i);
                    List<Map<String, Object>> pageRecord = PageUtil.getPageRecord(jdbcTemplate, sqlCommodity, i, supplierShopId, inCataLogId, inCataLogId, supplierCode, cataLogId);
                    if (!CollectionUtils.isEmpty(pageRecord)) {
                        Iterator<Map<String, Object>> iterator1 = pageRecord.iterator();
                        ArrayList<Object[]> commodityParm = new ArrayList<Object[]>();
                        while (iterator1.hasNext()) {
                            Map<String, Object> next1 = iterator1.next();
                            Object[] parm = new Object[]{commodityId, next1.get("COMMODITY_CODE"), next1.get("name"), next1.get("COMMODITY_TYPE_ID"), 2, 0, next1.get("SUPPLIER_SHOP_ID"), next1.get("SHOP_NAME"), null, null, null, next1.get("BRAND_ID"), next1.get("BRAND_NAME"), null, 1, next1.get("introduction"), next1.get("introduction"), null, null, null, next1.get("sku"), next1.get("upc"), 2, "sys", new Date(), supplierCode, vendorInfo.get("VENDOR_ID"), vendorInfo.get("ID")};
                            commodityParm.add(parm);
                        }
                        jdbcTemplate.batchUpdate("insert into ucc_commodity(COMMODITY_ID,COMMODITY_CODE,COMMODITY_NAME,COMMODITY_TYPE_ID,COMMODITY_SOURCE,COMMODITY_STATUS,SUPPLIER_SHOP_ID,  SHOP_NAME,COMMODITY_BANNER,COMMODITY_LINK_CHAR,COMMODITY_LINK_URL,BRAND_ID,BRAND_NAME,AGREEMENT_ID,SERVEN_REJECT_ALLOW,COMMODITY_PC_DETAIL_URL,  COMMODITY_PC_DETAIL_CHAR,COMMODITY_PHONE_DETAIL_URL,COMMODITY_PHONE_DETAIL_CHAR,MATERIAL_ID,EXT_SKU_ID,UPC_CODE,STORE_GET_TYPE,  CREATE_OPER_ID,CREATE_TIME,REMARK,VENDOR_ID,VENDOR_SHOP_ID) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", commodityParm);
                    }
                    LOG.info("\u5904\u7406\u5546\u54c1\u4fe1\u606f\u7b2c{}\u9875\u7ed3\u675f", (Object)i);
                }
                LOG.info("\u5904\u7406\u5546\u54c1\u4fe1\u606f\u7ed3\u675f");
                LOG.info("\u5904\u7406\u5355\u54c1\u4fe1\u606f:supplierCode={},cataLogId={}", (Object)supplierCode, (Object)cataLogId);
                String sqlSku = "select a.COMMODITY_ID,a.SUPPLIER_SHOP_ID,a.SHOP_NAME,a.COMMODITY_TYPE_ID,'sku_code' as sku_code,a.COMMODITY_NAME,a.COMMODITY_PC_DETAIL_URL,a.COMMODITY_PC_DETAIL_CHAR,a.COMMODITY_PHONE_DETAIL_URL,a.COMMODITY_PHONE_DETAIL_CHAR,a.BRAND_ID,a.BRAND_NAME,a.EXT_SKU_ID,a.UPC_CODE,c.MEASURE_ID,c.MEASURE_NAME,b.MOQ from ucc_commodity a INNER JOIN external_sku_detail b ON a.EXT_SKU_ID = b.SKU  INNER JOIN ucc_commodity_measure c ON b.SALE_UNIT = c.MEASURE_NAME where a.COMMODITY_TYPE_ID in (select COMMODITY_TYPE_ID from ucc_commodity_type where CATALOG_ID = ? and COMMODITY_TYPE_STATUS = 1) AND a.COMMODITY_ID = ?";
                Integer pageCountSku = PageUtil.getPageCount(jdbcTemplate, sqlSku, inCataLogId, commodityId);
                for (int i = 1; i <= pageCountSku; ++i) {
                    List<Map<String, Object>> pageRecord = PageUtil.getPageRecord(jdbcTemplate, sqlSku, i, inCataLogId, commodityId);
                    if (CollectionUtils.isEmpty(pageRecord)) continue;
                    ArrayList<Object[]> skuParm = new ArrayList<Object[]>();
                    ArrayList<Object[]> skuSale = new ArrayList<Object[]>();
                    for (Map<String, Object> next1 : pageRecord) {
                        Long skuId = this.getCacheId(1, sequenceSku);
                        Object[] skuP = new Object[]{skuId, next1.get("COMMODITY_ID"), next1.get("SUPPLIER_SHOP_ID"), next1.get("SHOP_NAME"), next1.get("COMMODITY_TYPE_ID"), 0, next1.get("sku_code"), 2, next1.get("COMMODITY_NAME"), next1.get("COMMODITY_NAME"), next1.get("COMMODITY_PC_DETAIL_URL"), next1.get("COMMODITY_PC_DETAIL_CHAR"), next1.get("COMMODITY_PHONE_DETAIL_URL"), next1.get("COMMODITY_PHONE_DETAIL_CHAR"), 0, 0, next1.get("BRAND_ID"), next1.get("BRAND_NAME"), null, next1.get("MEASURE_ID"), next1.get("MEASURE_NAME"), next1.get("MOQ"), null, 0, null, next1.get("EXT_SKU_ID"), next1.get("UPC_CODE"), new Date(), 1, 0, "sys", new Date(), supplierCode};
                        skuParm.add(skuP);
                        Object[] skuSaleP = new Object[]{sequenceUtil.nextId(), skuId, next1.get("SUPPLIER_SHOP_ID"), 0, "sys", new Date()};
                        skuSale.add(skuSaleP);
                    }
                    jdbcTemplate.batchUpdate("insert into ucc_sku(SKU_ID,COMMODITY_ID,SUPPLIER_SHOP_ID,SHOP_NAME,COMMODITY_TYPE_ID,  SKU_PRICE,SKU_CODE,SKU_SOURCE,SKU_NAME,SKU_LONG_NAME,SKU_PC_DETAIL_URL,SKU_PC_DETAIL_CHAR,SKU_PHONE_DETAIL_URL,  SKU_PHONE_DETAIL_CHAR,SKU_STATUS,PRE_DELIVER_DAY,BRAND_ID,BRAND_NAME,AGREEMENT_ID,MEASURE_ID,MEASURE_NAME,MOQ,  MFGSKU,IS_SUPPLIER_AGREEMENT,MATERIAL_ID,EXT_SKU_ID,UPC_CODE,  ON_SHELVE_TIME,ON_SHELVE_WAY,PRE_ON_SHELVE_DAY,CREATE_OPER_ID,CREATE_TIME,REMARK) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", skuParm);
                    jdbcTemplate.batchUpdate("insert into ucc_sale_num(sale_id,sku_id,supplier_shop_id,sold_number,create_oper_id,create_time) values(?,?,?,?,?,?)", skuSale);
                }
                LOG.info("\u5904\u7406\u5355\u54c1\u4fe1\u606f\u7ed3\u675f");
                LOG.info("\u5904\u7406\u4ef7\u683c\u5f00\u59cb");
                List maps1 = jdbcTemplate.queryForList("select ADD_COEFFICIENT from UCC_ADD_COEFFICIENT where SUPPLIER_ID=? and CATALOG_ID=?", new Object[]{aLong, inCataLogId});
                Iterator iterator2 = maps1.iterator();
                BigDecimal addCoefficient = new BigDecimal(1.0);
                while (iterator2.hasNext()) {
                    Map next1 = (Map)iterator2.next();
                    Object add_coefficient = next1.get("ADD_COEFFICIENT");
                    if (add_coefficient == null) continue;
                    addCoefficient = (BigDecimal)add_coefficient;
                    addCoefficient = addCoefficient.divide(new BigDecimal(100));
                    addCoefficient = addCoefficient.add(BigDecimal.ONE);
                }
                String sqlSkuPrice = "select b.SKU_ID,b.SUPPLIER_SHOP_ID,a.EXTERNAL_PRICE,a.CON_PRICE,b.COMMODITY_TYPE_ID,b.EXT_SKU_ID from external_price a,ucc_sku b where a.sku_source=1 and a.sku = b.EXT_SKU_ID and COMMODITY_TYPE_ID in (select COMMODITY_TYPE_ID from ucc_commodity_type where CATALOG_ID = ? and COMMODITY_TYPE_STATUS = 1) and a.SUPPLIER_CODE=? and a.SKU in(" + uccDealCommodityReqBO.getSkuListStr() + ")";
                Integer pageCountSkuPrice = PageUtil.getPageCount(jdbcTemplate, sqlSkuPrice, inCataLogId, supplierCode);
                for (int i = 1; i <= pageCountSkuPrice; ++i) {
                    List<Map<String, Object>> pageRecord = PageUtil.getPageRecord(jdbcTemplate, sqlSkuPrice, i, inCataLogId, supplierCode);
                    if (CollectionUtils.isEmpty(pageRecord)) continue;
                    Iterator<Map<String, Object>> iterator1 = pageRecord.iterator();
                    ArrayList<Object[]> skuPriceParm = new ArrayList<Object[]>();
                    while (iterator1.hasNext()) {
                        Map<String, Object> next1 = iterator1.next();
                        Object salePriceObj = next1.get("CON_PRICE");
                        Long salePrice = 0L;
                        Long addSalePrice = 0L;
                        if (salePriceObj != null) {
                            BigDecimal salePriceObj1 = (BigDecimal)salePriceObj;
                            BigDecimal multiply = salePriceObj1.multiply(addCoefficient);
                            multiply = multiply.setScale(2, 4);
                            try {
                                salePrice = MoneyUtil.BigDecimal2Long(salePriceObj1);
                                addSalePrice = MoneyUtil.BigDecimal2Long(multiply);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        Object externalPriceObj = next1.get("EXTERNAL_PRICE");
                        Long externalPrice = 0L;
                        Long marketPrice = 0L;
                        if (externalPriceObj != null) {
                            BigDecimal externalPriceObj1 = (BigDecimal)externalPriceObj;
                            try {
                                externalPrice = MoneyUtil.BigDecimal2Long(externalPriceObj1);
                                marketPrice = MoneyUtil.BigDecimal2Long(externalPriceObj1);
                            }
                            catch (Exception e) {
                                LOG.error("\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
                                e.printStackTrace();
                            }
                        }
                        Object[] priceP = new Object[]{sequenceUtil.nextId(), next1.get("SKU_ID"), next1.get("SUPPLIER_SHOP_ID"), marketPrice, salePrice, addSalePrice, externalPrice, externalPrice, externalPrice, externalPrice, externalPrice, 0, "sys", new Date(), next1.get("COMMODITY_TYPE_ID")};
                        skuPriceParm.add(priceP);
                        String ext_sku_id = (String)jdbcTemplate.queryForObject("select MFG_SKU from external_sku_detail where SUPPLIER_CODE=? and SKU=?", String.class, new Object[]{supplierCode, next1.get("EXT_SKU_ID")});
                        jdbcTemplate.update("update ucc_sku set SKU_PRICE=?,MFGSKU=? where EXT_SKU_ID=?", new Object[]{salePrice, ext_sku_id, next1.get("EXT_SKU_ID")});
                    }
                    jdbcTemplate.batchUpdate("insert into ucc_sku_price(SKU_PRICE_ID, SKU_ID,SUPPLIER_SHOP_ID,MARKET_PRICE,AGREEMENT_PRICE,SALE_PRICE,MEMBER_PRICE1,MEMBER_PRICE2,MEMBER_PRICE3,MEMBER_PRICE4,MEMBER_PRICE5,CURRENCY_TYPE,CREATE_OPER_ID,CREATE_TIME,REMARK) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", skuPriceParm);
                }
            }
        } else {
            LOG.info("\u672a\u67e5\u8be2\u5230\u9700\u5904\u7406\u7684\u5546\u54c1\u7c7b\u76ee");
        }
        List maps1 = jdbcTemplate.queryForList(" select distinct a.SKU_CATE4,a.SKU,b.COMMODITY_ID,b.SUPPLIER_SHOP_ID,b.COMMODITY_TYPE_ID from external_sku_detail a,ucc_commodity b where a.sku_source=1 and A.SKU = B.EXT_SKU_ID AND a.SUPPLIER_CODE=? and a.SKU in(" + uccDealCommodityReqBO.getSkuListStr() + ")", new Object[]{supplierCode});
        if (!CollectionUtils.isEmpty((Collection)maps1)) {
            for (Map next : maps1) {
                String extSku = next.get("SKU").toString();
                String catalogId = next.get("SKU_CATE4").toString();
                LOG.info("\u5904\u7406\u5546\u54c1:" + extSku);
                List propRelList = jdbcTemplate.queryForList("select distinct PROP_VALUE_LIST_ID from UCC_SKU_PROP_LIST_REL where SKU=?", new Object[]{extSku});
                if (CollectionUtils.isEmpty((Collection)propRelList)) continue;
                ArrayList<Object[]> spuSpecParm = new ArrayList<Object[]>();
                for (Map propRelNext : propRelList) {
                    Long propValueListId = (Long)propRelNext.get("PROP_VALUE_LIST_ID");
                    List valuerListMap = jdbcTemplate.queryForList("select prop_value_list_id,COMMODITY_PROP_DEF_ID, prop_value_list_code,prop_value,prov_value_desc from ucc_prop_value_list where prop_value_list_id=?", new Object[]{propValueListId});
                    if (CollectionUtils.isEmpty((Collection)valuerListMap)) continue;
                    for (Map valuerListNext : valuerListMap) {
                        List propDefMaps = jdbcTemplate.queryForList("select PROP_NAME,SHOW_NAME from UCC_COMMODITY_PROP_DEf where COMMODITY_PROP_DEF_ID=?", new Object[]{valuerListNext.get("COMMODITY_PROP_DEF_ID")});
                        String PROP_NAME = null;
                        String SHOW_NAME = null;
                        if (!CollectionUtils.isEmpty((Collection)propDefMaps)) {
                            for (Map propDefNext : propDefMaps) {
                                PROP_NAME = propDefNext.get("PROP_NAME").toString();
                                SHOW_NAME = propDefNext.get("SHOW_NAME").toString();
                            }
                        }
                        Long COMMODITY_PROP_GRP_ID = (Long)jdbcTemplate.queryForObject("select COMMODITY_PROP_GRP_ID from UCC_REL_PROP_GRP_PROP where COMMODITY_PROP_DEF_ID=? and REMARK=?", Long.class, new Object[]{valuerListNext.get("COMMODITY_PROP_DEF_ID"), catalogId});
                        String COMMODITY_PROP_GRP_NAME = (String)jdbcTemplate.queryForObject("select COMMODITY_PROP_GRP_NAME from UCC_COMMODITY_PROP_GRP where COMMODITY_PROP_GRP_ID=?", String.class, new Object[]{COMMODITY_PROP_GRP_ID});
                        Object[] spuSpec = new Object[]{sequenceUtil.nextId(), next.get("COMMODITY_ID"), next.get("SUPPLIER_SHOP_ID"), COMMODITY_PROP_GRP_ID, COMMODITY_PROP_GRP_NAME, valuerListNext.get("COMMODITY_PROP_DEF_ID"), PROP_NAME, SHOW_NAME, valuerListNext.get("prop_value_list_id"), valuerListNext.get("prop_value"), "sys", new Date(), valuerListNext.get("COMMODITY_TYPE_ID")};
                        spuSpecParm.add(spuSpec);
                    }
                }
                jdbcTemplate.batchUpdate("insert into UCC_SPU_SPEC(COMMODITY_SPEC_ID, COMMODITY_ID,SUPPLIER_SHOP_ID,COMMODITY_PROP_GRP_ID,COMMODITY_PROP_GRP_NAME,COMMODITY_PROP_DEF_ID,                                PROP_NAME,PROP_SHOW_NAME,PROP_VALUE_LIST_ID,PROP_VALUE,CREATE_OPER_ID,CREATE_TIME,REMARK) values(?,?,?,?,?,?,?,?,?,?,?,?,?)", spuSpecParm);
            }
        }
        String sqlCommodityPic = "select b.COMMODITY_ID,1,a.IMAGE_PATH,b.SUPPLIER_SHOP_ID from EXTERNAL_SKU_DETAIL a,ucc_commodity b where a.sku_source=1 and a.sku = b.EXT_SKU_ID and a.SUPPLIER_CODE=? and SKU in(" + uccDealCommodityReqBO.getSkuListStr() + ")";
        Integer pageCommodityPic = PageUtil.getPageCount(jdbcTemplate, sqlCommodityPic, supplierCode);
        for (int i = 1; i <= pageCommodityPic; ++i) {
            List<Map<String, Object>> pageRecord = PageUtil.getPageRecord(jdbcTemplate, sqlCommodityPic, i, supplierCode);
            if (CollectionUtils.isEmpty(pageRecord)) continue;
            ArrayList<Object[]> spuSpecParm = new ArrayList<Object[]>();
            ArrayList<Object[]> spuSpecParm2 = new ArrayList<Object[]>();
            for (Map<String, Object> next : pageRecord) {
                String imagePath = (String)next.get("IMAGE_PATH");
                if (StringUtils.isEmpty((Object)imagePath) || "empty".equals(imagePath)) continue;
                Object[] picParm = new Object[]{sequenceUtil.nextId(), next.get("COMMODITY_ID"), 1, imagePath, next.get("SUPPLIER_SHOP_ID"), "sys", new Date(), supplierCode};
                Object[] picParm2 = new Object[]{sequenceUtil.nextId(), next.get("COMMODITY_ID"), 2, imagePath, next.get("SUPPLIER_SHOP_ID"), "sys", new Date(), supplierCode};
                spuSpecParm.add(picParm);
                spuSpecParm2.add(picParm2);
            }
            if (!CollectionUtils.isEmpty(spuSpecParm)) {
                jdbcTemplate.batchUpdate("insert into ucc_commodity_pic(COMMODITY_PIC_ID, COMMODITY_ID,COMMODITY_PIC_TYPE,COMMODITY_PIC_URL,SUPPLIER_SHOP_ID,CREATE_OPER_ID,CREATE_TIME,REMARK) values (?,?,?,?,?,?,?,?)", spuSpecParm);
            }
            if (CollectionUtils.isEmpty(spuSpecParm2)) continue;
            jdbcTemplate.batchUpdate("insert into ucc_commodity_pic(COMMODITY_PIC_ID,COMMODITY_ID,COMMODITY_PIC_TYPE,COMMODITY_PIC_URL,SUPPLIER_SHOP_ID,CREATE_OPER_ID,CREATE_TIME,REMARK) values (?,?,?,?,?,?,?,?)", spuSpecParm2);
        }
        String sqlCommodityPackage = "select b.COMMODITY_ID,b.SUPPLIER_SHOP_ID,a.WARE_QD from EXTERNAL_SKU_DETAIL a,ucc_commodity b where a.sku_source=1 and a.sku = b.EXT_SKU_ID and a.SUPPLIER_CODE=? and SKU in(" + uccDealCommodityReqBO.getSkuListStr() + ")";
        Integer pageCommodityPackage = PageUtil.getPageCount(jdbcTemplate, sqlCommodityPackage, supplierCode);
        for (int i = 1; i <= pageCommodityPackage; ++i) {
            List<Map<String, Object>> pageRecord = PageUtil.getPageRecord(jdbcTemplate, sqlCommodityPackage, i, supplierCode);
            if (CollectionUtils.isEmpty(pageRecord)) continue;
            Iterator<Map<String, Object>> iterator = pageRecord.iterator();
            ArrayList<Object[]> packageParm = new ArrayList<Object[]>();
            while (iterator.hasNext()) {
                long l = 0L;
                try {
                    l = sequenceUtil.nextId();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Map<String, Object> next = iterator.next();
                Object[] pack = new Object[]{l, next.get("COMMODITY_ID"), next.get("SUPPLIER_SHOP_ID"), next.get("WARE_QD"), 0, 2, "\u91cd\u5e86", 1, 1, "sys", new Date(), supplierCode};
                packageParm.add(pack);
            }
            jdbcTemplate.batchUpdate("insert into UCC_COMMODITY_PACKAGE(PACKAGE_ID,COMMODITY_ID,SUPPLIER_SHOP_ID,PACK_PARAM,AFTER_SERVICE,INSTALMENT_FLAG,PLACE_DELIVERY,  FREIGHT_TEMPLATE_ID,INVOICE_TYPE,CREATE_OPER_ID,CREATE_TIME,REMARK) values (?,?,?,?,?,?,?,?,?,?,?,?)", packageParm);
        }
        List maps2 = jdbcTemplate.queryForList("select t1.SALE_UNIT,t2.SKU_ID from external_sku_detail t1, ucc_sku t2 where t1.sku_source = 1 and t1.SKU = t2.EXT_SKU_ID and t1.SUPPLIER_CODE=? and t1.SKU in(" + uccDealCommodityReqBO.getSkuListStr() + ")", new Object[]{supplierCode});
        if (!CollectionUtils.isEmpty((Collection)maps2)) {
            for (Map next : maps2) {
                String saleUnit = next.get("SALE_UNIT").toString();
                List maps3 = jdbcTemplate.queryForList("select  measure_id, measure_name from ucc_commodity_measure where MEASURE_NAME=?", new Object[]{saleUnit});
                if (CollectionUtils.isEmpty((Collection)maps3)) continue;
                Long skuId = (Long)next.get("SKU_ID");
                Map map = (Map)maps3.get(0);
                Long measureId = (Long)map.get("measure_id");
                String measureName = map.get("measure_name").toString();
                jdbcTemplate.update("update ucc_sku set MEASURE_ID=?,MEASURE_NAME=? where SKU_ID=?", new Object[]{measureId, measureName, skuId});
            }
        }
        UccDealCommodityRespBO uccDealCommodityRespBO = new UccDealCommodityRespBO();
        uccDealCommodityRespBO.setRespCode("0000");
        uccDealCommodityRespBO.setRespDesc("\u6210\u529f");
        return uccDealCommodityRespBO;
    }

    private Long getCacheId(Integer type, SequenceUtil sequence) {
        try {
            if (0 == type) {
                List value = (List)this.cacheMap.getValueByKey(Thread.currentThread().getId() + "_commodity_id");
                if (!CollectionUtils.isEmpty((Collection)value)) {
                    Long id = (Long)value.remove(0);
                    this.cacheMap.putValue(Thread.currentThread().getId() + "_commodity_id", (Object)value);
                    return id;
                }
                return sequence.nextId();
            }
            List value = (List)this.cacheMap.getValueByKey(Thread.currentThread().getId() + "_sku_id");
            if (!CollectionUtils.isEmpty((Collection)value)) {
                Long id = (Long)value.remove(0);
                this.cacheMap.putValue(Thread.currentThread().getId() + "_sku_id", (Object)value);
                return id;
            }
            return sequence.nextId();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0L;
        }
    }
}

