/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.batchimp.initialize.req.processor.eshy;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.tydic.commodity.batchimp.initialize.req.model.ehsy.EshyGetSellPriceReq;
import com.tydic.commodity.batchimp.initialize.req.processor.eshy.EshyApiGetSellPrice;
import com.tydic.commodity.batchimp.initialize.resp.model.deli.DeliToken;
import com.tydic.commodity.batchimp.initialize.utils.HttpRequest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class EshyApiGetStateProc
implements Runnable {
    private String apiuri = "http://sp.eshy.com/mall/skuState";
    private JdbcTemplate jdbcTemplate;
    private DeliToken token;
    private int channel_id;
    private int total;
    private static final Logger log = LoggerFactory.getLogger(EshyApiGetSellPrice.class);

    public EshyApiGetStateProc(JdbcTemplate jdbcTemplate, DeliToken token, int channel_id, int total) {
        this.jdbcTemplate = jdbcTemplate;
        this.token = token;
        this.channel_id = channel_id;
        this.total = total;
    }

    @Override
    public void run() {
        List rows = this.jdbcTemplate.queryForList("select a.sku from EXTERNAL_SKU_SET a where mod(a.id,?) = ?  and sku  in ('AHW811','AHW810','AHW809','AHW808','AHW807','AHW806','AHW811','AHW810','AHW809','AHW808','AHW807','AHW806','RLE874','AHW811','RLE873','AFN355','AFV537','AJH121','AJH120','AJH119','AJH118','EFV309','EFV267','EFV266','AAN158','AAN158','SCN732','AFM988','AFE146','AFE144','AFC356','AFA480','AFA479','SDC972','LSE257','EGA662','SDC972','LSE257','AJG760','AJG759','AJG758','AJG757','AJG756','AJG755','AJG754','AJG753','AGP017','AGP016','AFT593','AEZ897','AEZ896','AEW951','AEW664','AEW663','AEW662','AJG760','AJG759','AJG758','AJG757','AJG756','AJG755','AJG754','AJG753','AGP017','AGP016','AFT593','AEZ897','AEZ896','AEW951','AEW664','AEW663','AEW662','RFN673','AJJ584','AJJ582','MYL288','AJJ607','SBN232','AHT350','AHG095','AHG094','AEZ105','AEZ104','AEZ103','AEZ102','AEZ101','AEZ100','AEZ099','AEZ098','AEZ097','AES989','AES988','AES987','AES986','AES985','AES984','AES983','AES982','AES981','AEQ772') ", new Object[]{this.total, this.channel_id});
        Iterator it = rows.iterator();
        HttpRequest http = new HttpRequest();
        while (it.hasNext()) {
            Map map = (Map)it.next();
            String sku = map.get("sku").toString();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String timestamp = df.format(new Date());
            ArrayList<String> skulist = new ArrayList<String>();
            skulist.add(sku);
            EshyGetSellPriceReq eshyGetSellPriceReq = new EshyGetSellPriceReq();
            eshyGetSellPriceReq.setSku(skulist);
            eshyGetSellPriceReq.setToken(this.token.getAccess_token());
            eshyGetSellPriceReq.setTimestamp(timestamp);
            String org_info = "";
            try {
                Gson gson = new Gson();
                log.info("org_req = " + gson.toJson((Object)eshyGetSellPriceReq));
                org_info = http.sendPostJsoneshy(this.apiuri, gson.toJson((Object)eshyGetSellPriceReq));
                log.info("org_info = " + org_info);
                JsonParser parser = new JsonParser();
                if (parser.parse(org_info).getAsJsonObject().get("result").getAsJsonArray().get(0).getAsJsonObject().isJsonNull()) continue;
                JsonObject json_result = parser.parse(org_info).getAsJsonObject().get("result").getAsJsonArray().get(0).getAsJsonObject();
                this.jdbcTemplate.update("INSERT INTO EXTERNAL_SKU_STATE (sku,state) VALUES (?,?)", new Object[]{sku, json_result.get("state").getAsInt()});
                log.info("sku + attr in db = " + eshyGetSellPriceReq.getSku());
            }
            catch (Exception e) {
                log.info(e.toString() + "error_sku:" + sku);
                log.info(e.toString() + " error_json: " + org_info);
                System.out.println(e.toString());
            }
        }
    }
}

