/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.batchimp.initialize.req.processor.jd;

import com.google.gson.JsonParser;
import com.tydic.commodity.batchimp.initialize.utils.HttpRequest;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class JDApiPriceReplaceLoopProc {
    private String token;
    private String apiuri1;
    private String apiuri2;
    private String apiuri3;
    private JdbcTemplate jdbcTemplate;
    private int channel_id;
    private int channel_count;
    private static final Logger log = LoggerFactory.getLogger(JDApiPriceReplaceLoopProc.class);

    public JDApiPriceReplaceLoopProc(String token, JdbcTemplate jdbcTemplate, int channel_id, int channel_count) {
        this.token = token;
        this.apiuri1 = "https://bizapi.jd.com/api/price/getJdPrice";
        this.apiuri2 = "https://bizapi.jd.com/api/price/getPrice";
        this.apiuri3 = "https://bizapi.jd.com/api/price/getSellPrice";
        this.jdbcTemplate = jdbcTemplate;
        this.channel_id = channel_id;
        this.channel_count = channel_count;
    }

    public void run() {
        log.info("channel_id = [" + this.channel_id + "] start");
        String sku_param = "3429825,5285834,3544666";
        ArrayList<Long> rows = new ArrayList<Long>();
        for (int s = 0; s < sku_param.split(",").length; ++s) {
            rows.add(Long.parseLong(sku_param.split(",")[s]));
            log.info("List add " + sku_param.split(",")[s]);
        }
        ArrayList<Object[]> sku_detail_list_obj = new ArrayList<Object[]>();
        JsonParser parse = new JsonParser();
        String org_json1 = null;
        String org_json2 = null;
        String org_json3 = null;
        int batch_count = 0;
        log.info(" DELETE jd_price ", (Object)sku_param);
        this.jdbcTemplate.execute("delete from jd_price where sku in(" + sku_param + ")");
        for (Long map : rows) {
            long sku = map;
            try {
                org_json1 = HttpRequest.sendPost(this.apiuri1, "token=" + this.token + "&sku=" + sku);
                org_json2 = HttpRequest.sendPost(this.apiuri2, "token=" + this.token + "&sku=" + sku);
                org_json3 = HttpRequest.sendPost(this.apiuri3, "token=" + this.token + "&sku=" + sku);
                log.info("JDPRICE = " + org_json1);
                log.info("CONPRICE = " + org_json2);
                log.info("SELLPRICE = " + org_json3);
                float jdprice = -1.0f;
                float conprice = -1.0f;
                float sellprice = -1.0f;
                if (org_json1.indexOf("html") == -1 && parse.parse(org_json1).getAsJsonObject().get("result") != null && parse.parse(org_json1).getAsJsonObject().get("result").getAsJsonArray().size() > 0) {
                    jdprice = parse.parse(org_json1).getAsJsonObject().get("result").getAsJsonArray().get(0).getAsJsonObject().get("jdPrice").getAsFloat();
                }
                if (org_json2.indexOf("html") == -1 && parse.parse(org_json2).getAsJsonObject().get("result") != null && parse.parse(org_json2).getAsJsonObject().get("result").getAsJsonArray().size() > 0) {
                    conprice = parse.parse(org_json2).getAsJsonObject().get("result").getAsJsonArray().get(0).getAsJsonObject().get("price").getAsFloat();
                }
                if (org_json3.indexOf("html") == -1 && parse.parse(org_json3).getAsJsonObject().get("result") != null && parse.parse(org_json3).getAsJsonObject().get("result").getAsJsonArray().size() > 0) {
                    sellprice = parse.parse(org_json3).getAsJsonObject().get("result").getAsJsonArray().get(0).getAsJsonObject().get("price").getAsFloat();
                }
                Object[] obj = new Object[]{sku, Float.valueOf(jdprice), Float.valueOf(conprice), Float.valueOf(sellprice)};
                sku_detail_list_obj.add(obj);
                if (batch_count == 100) {
                    this.jdbcTemplate.batchUpdate("INSERT INTO jd_price (sku,jdprice,conprice,sellprice,datetime) VALUES (?,?,?,?,sysdate())", sku_detail_list_obj);
                    log.info("batch commit 500 :" + sku_detail_list_obj.size());
                    sku_detail_list_obj.clear();
                    batch_count = 0;
                }
                ++batch_count;
            }
            catch (Exception e) {
                log.info(e.toString() + "error_sku:" + sku);
                log.info(e.toString() + " error_json: " + org_json1);
                log.info(e.toString() + " error_json: " + org_json1);
                log.info(e.toString() + " error_json: " + org_json1);
                System.out.println(e.toString());
            }
        }
        this.jdbcTemplate.batchUpdate("INSERT INTO jd_price (sku,jdprice,conprice,sellprice,datetime) VALUES (?,?,?,?,sysdate())", sku_detail_list_obj);
        this.jdbcTemplate.execute("delete from D_SKU_PRICE where sku_id in (select sku_id from D_SKU where ext_sku_id in (" + sku_param + ")) ");
        log.info("DELETE D_SKU_PRICE " + sku_param);
        this.jdbcTemplate.execute("insert into D_SKU_PRICE(AGREEMENT_ID,SKU_ID,SUPPLIER_ID,+,AGREEMENT_PRICE,MEMBER_PRICE,SALE_PRICE,create_login_id,is_delete) select 0,a.sku_id,1,case b.jdprice when -1 then 0 + b.jdprice * 10000 end,case b.conprice when -1 then 0 else  b.conprice * 10000 end,case b.conprice when -1 then 0 else b.conprice *10000 *1.04 end,case b.conprice when -1 then 0 else b.conprice * 10000 *1.04 end,999999999,0 from d_sku a,jd_price b where a.ext_sku_id = b.sku  and b.sku in (" + sku_param + ")");
        log.info("INSERT INTO D_SKU_PRICE " + sku_param);
        sku_detail_list_obj.clear();
        log.info("channel_id = [" + this.channel_id + "] end");
    }
}

