/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.batchimp.initialize.req.processor.qst;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.batchimp.initialize.req.model.qst.QstPageNumReq;
import com.tydic.commodity.batchimp.initialize.resp.model.deli.DeliPageNum;
import com.tydic.commodity.batchimp.initialize.resp.model.deli.DeliToken;
import com.tydic.commodity.batchimp.initialize.utils.HttpRequest;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class QstApiGetPageNumProc
implements Runnable {
    private String token;
    private String apiuri;
    private JdbcTemplate jdbcTemplate;
    private String clientId;
    private String supplierCode;
    private static final Logger log = LoggerFactory.getLogger(QstApiGetPageNumProc.class);

    public QstApiGetPageNumProc(JdbcTemplate jdbcTemplate, DeliToken token, String supplierCode) {
        this.token = token.getAccess_token();
        this.apiuri = "http://60.191.15.50:8014/getPageNum";
        this.jdbcTemplate = jdbcTemplate;
        this.clientId = token.getClientId();
        this.supplierCode = supplierCode;
    }

    @Override
    public void run() {
        HttpRequest http = new HttpRequest();
        log.info(this.apiuri + this.token);
        QstPageNumReq eshyPageNumReq = new QstPageNumReq();
        eshyPageNumReq.setToken(this.token);
        Gson gson = new Gson();
        log.info(gson.toJson((Object)eshyPageNumReq));
        log.info("\u8bf7\u6c42\u5730\u5740====" + this.apiuri + "        PARAM " + gson.toJson((Object)eshyPageNumReq));
        String org_json = http.sendPostJsoneshy(this.apiuri, gson.toJson((Object)eshyPageNumReq));
        log.info(org_json);
        JsonParser parse = new JsonParser();
        ArrayList<Object[]> skupoollist = new ArrayList<Object[]>();
        JsonArray jsonArray = parse.parse(org_json).getAsJsonObject().get("result").getAsJsonArray();
        for (JsonElement elem : jsonArray) {
            DeliPageNum sp = new DeliPageNum();
            sp.setName(elem.getAsJsonObject().get("name").getAsString());
            sp.setPage_num(elem.getAsJsonObject().get("page_num").getAsString());
            Object[] obj = new Object[]{Sequence.getInstance().nextId(), sp.getName(), sp.getPage_num(), this.supplierCode};
            skupoollist.add(obj);
        }
        this.jdbcTemplate.batchUpdate("INSERT INTO UCC_COMMODITY_PAGE_NUM(id, name, page_num,SUPPLIER_CODE) VALUES (?,?,?,?)", skupoollist);
        this.jdbcTemplate.update("UPDATE UCC_COMMODITY_PAGE_NUM SET curr_page_no = 0,flag = 0,total_page_count = 1 where SUPPLIER_CODE = ?", new Object[]{this.supplierCode});
    }
}

