/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.batchimp.initialize.req.processor.jd;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.batchimp.initialize.req.model.ehsy.EshyGetSkuByPageReq;
import com.tydic.commodity.batchimp.initialize.resp.model.deli.DeliPageNum;
import com.tydic.commodity.batchimp.initialize.utils.HttpRequest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.StringUtils;

public class JDApiGetSkuPageProc
implements Runnable {
    private String apiuri = "https://bizapi.jd.com/api/product/getSkuByPage";
    private JdbcTemplate jdbcTemplate;
    private String token;
    private DeliPageNum deliPageNum;
    private int channel_count;
    private int channel_id;
    private String pageNumber;
    private String supplierCode;
    private static final Logger log = LoggerFactory.getLogger(JDApiGetSkuPageProc.class);

    public JDApiGetSkuPageProc(JdbcTemplate jdbcTemplate, String token, int channel_id, int channel_count, String pageNumber, String supplierCode) {
        this.jdbcTemplate = jdbcTemplate;
        this.token = token;
        this.deliPageNum = this.deliPageNum;
        this.channel_count = channel_count;
        this.channel_id = channel_id;
        this.pageNumber = pageNumber;
        this.supplierCode = supplierCode;
    }

    @Override
    public void run() {
        List rows = StringUtils.isEmpty((Object)this.pageNumber) ? this.jdbcTemplate.queryForList("select id,name,page_num,curr_page_no,total_page_count from UCC_COMMODITY_PAGE_NUM where mod(id,?) = ? and flag = 0 and SUPPLIER_CODE=?", new Object[]{this.channel_count, this.channel_id, this.supplierCode}) : this.jdbcTemplate.queryForList("select id,name,page_num,curr_page_no,total_page_count from UCC_COMMODITY_PAGE_NUM where mod(id,?) = ? and flag = 0 and SUPPLIER_CODE=? and PAGE_NUM=?", new Object[]{this.channel_count, this.channel_id, this.supplierCode, this.pageNumber});
        for (Map map : rows) {
            DeliPageNum deliPageNum = new DeliPageNum();
            deliPageNum.setName(map.get("name").toString());
            deliPageNum.setPage_num(map.get("page_num").toString());
            int pagecount = Integer.parseInt(map.get("total_page_count").toString());
            int curr_page_no = Integer.parseInt(map.get("curr_page_no").toString());
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (int i = curr_page_no + 1; i <= pagecount; ++i) {
                ArrayList<Object[]> sku_set_list = new ArrayList<Object[]>();
                Gson gson = new Gson();
                EshyGetSkuByPageReq eshyGetSkuByPageReq = new EshyGetSkuByPageReq();
                eshyGetSkuByPageReq.setPageNum(deliPageNum.getPage_num());
                eshyGetSkuByPageReq.setPageNo(i);
                eshyGetSkuByPageReq.setToken(this.token);
                long wait = this.channel_id * 1000 + i;
                try {
                    Thread.sleep(wait);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                log.info("\u8bf7\u6c42\u5730\u5740:" + this.apiuri + "?token=" + this.token + "&pageNum=" + eshyGetSkuByPageReq.getPageNum() + "&pageNo=" + eshyGetSkuByPageReq.getPageNo());
                String org_info = HttpRequest.sendPost(this.apiuri, "token=" + this.token + "&pageNum=" + eshyGetSkuByPageReq.getPageNum() + "&pageNo=" + eshyGetSkuByPageReq.getPageNo());
                log.info("\u8fd4\u56de\u7ed3\u679c:" + org_info);
                JsonParser parse = new JsonParser();
                if (parse.parse(org_info).getAsJsonObject().get("result") != null && !parse.parse(org_info).getAsJsonObject().get("result").isJsonNull()) {
                    JsonObject jsonObject = parse.parse(org_info).getAsJsonObject().get("result").getAsJsonObject();
                    pagecount = jsonObject.get("pageCount").getAsInt();
                    for (JsonElement str : jsonObject.get("skuIds").getAsJsonArray()) {
                        Object[] obj = new Object[]{Sequence.getInstance().nextId(), deliPageNum.getPage_num(), str.getAsString(), i, this.supplierCode};
                        sku_set_list.add(obj);
                    }
                    if (sku_set_list.size() > 0) {
                        this.jdbcTemplate.batchUpdate("INSERT INTO EXTERNAL_SKU_SET (id,page_num,sku,page_no,SUPPLIER_CODE) VALUES (?,?,?,?,?)", sku_set_list);
                        this.jdbcTemplate.update("update UCC_COMMODITY_PAGE_NUM set curr_page_no = ?,total_page_count = ? where id = ?", new Object[]{i, pagecount, Long.parseLong(map.get("id").toString())});
                    }
                }
                sku_set_list.clear();
            }
            this.jdbcTemplate.update("update UCC_COMMODITY_PAGE_NUM set flag = 1 where id = ?", new Object[]{Long.parseLong(map.get("id").toString())});
        }
        this.jdbcTemplate.update("UPDATE UCC_COMMODITY_PAGE_NUM SET curr_page_no = 0,flag = 0,total_page_count = 1 where SUPPLIER_CODE=?", new Object[]{this.supplierCode});
    }
}

