/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.batchimp.initialize.req.processor.jd;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.tydic.commodity.batchimp.initialize.utils.HttpRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class JDApiSkuYBProc
implements Runnable {
    private String token;
    private String apiuri1;
    private JdbcTemplate jdbcTemplate;
    private int channel_id;
    private int channel_count;
    private static final Logger log = LoggerFactory.getLogger(JDApiSkuYBProc.class);

    public JDApiSkuYBProc(String token, JdbcTemplate jdbcTemplate, int channel_id, int channel_count) {
        this.token = token;
        this.apiuri1 = "https://bizapi.jd.com/api/product/getYanbaoSku";
        this.jdbcTemplate = jdbcTemplate;
        this.channel_id = channel_id;
        this.channel_count = channel_count;
    }

    @Override
    public void run() {
        log.info("channel_id = [" + this.channel_id + "] start");
        List rows = this.jdbcTemplate.queryForList("select name,page_num,sku from jd_sku_set where mod(sku,?) = ?  ", new Object[]{this.channel_count, this.channel_id});
        ArrayList<Object[]> sku_detail_list_obj = new ArrayList<Object[]>();
        JsonParser parse = new JsonParser();
        String org_json1 = null;
        for (Map map : rows) {
            long sku = Long.parseLong(map.get("sku").toString());
            try {
                org_json1 = HttpRequest.sendPost(this.apiuri1, "token=" + this.token + "&skuIds=" + sku + "&province=0&city=0&county=0&town=0");
                log.info("sku  " + sku + "  YANBAO_INFO = " + org_json1);
                if (parse.parse(org_json1).getAsJsonObject().get("result") != null && !parse.parse(org_json1).getAsJsonObject().get("result").isJsonNull()) {
                    String imgUrl = "";
                    String detailUrl = "";
                    int displayNo = 0;
                    String categoryCode = "";
                    String displayName = "";
                    long bindSkuId = 0L;
                    String bindSkuName = "";
                    int sortIndex = 0;
                    float price = 0.0f;
                    String tip = "";
                    String favor = "";
                    JsonObject jsonObj = parse.parse(org_json1).getAsJsonObject().get("result").getAsJsonObject().get(String.valueOf(sku)).getAsJsonArray().get(0).getAsJsonObject();
                    for (JsonElement je : jsonObj.get("fuwuSkuDetailList").getAsJsonArray()) {
                        imgUrl = jsonObj.get("imgUrl").getAsString();
                        detailUrl = jsonObj.get("detailUrl").getAsString();
                        displayNo = jsonObj.get("displayNo").getAsInt();
                        categoryCode = jsonObj.get("categoryCode").getAsString();
                        displayName = jsonObj.get("displayName").getAsString();
                        bindSkuId = je.getAsJsonObject().get("bindSkuId").getAsInt();
                        bindSkuName = je.getAsJsonObject().get("bindSkuName").getAsString();
                        sortIndex = je.getAsJsonObject().get("sortIndex").getAsInt();
                        price = je.getAsJsonObject().get("price").getAsFloat();
                        tip = je.getAsJsonObject().get("tip").getAsString();
                        favor = String.valueOf(je.getAsJsonObject().get("favor").getAsBoolean());
                        Object[] obj = new Object[]{sku, imgUrl, detailUrl, displayNo, categoryCode, displayName, bindSkuId, bindSkuName, sortIndex, Float.valueOf(price), tip, favor};
                        log.info("==================================================================");
                        sku_detail_list_obj.add(obj);
                    }
                }
                if (sku_detail_list_obj.size() <= 100) continue;
                this.jdbcTemplate.batchUpdate("INSERT INTO jd_sku_yb (mainSkuId,imgUrl,detailUrl,displayNo,categoryCode,displayName,bindSkuId,bindSkuName,sortIndex,price,tip,favor) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)", sku_detail_list_obj);
                log.info("batch commit 100 :" + sku_detail_list_obj.size());
                sku_detail_list_obj.clear();
            }
            catch (Exception e) {
                log.info(e.toString() + "error_sku:" + sku);
                log.info(e.toString() + " error_json: " + org_json1);
                log.info(e.toString() + " error_json: " + org_json1);
                log.info(e.toString() + " error_json: " + org_json1);
                System.out.println(e.toString());
            }
        }
        this.jdbcTemplate.batchUpdate("INSERT INTO jd_sku_yb (mainSkuId,imgUrl,detailUrl,displayNo,categoryCode,displayName,bindSkuId,bindSkuName,sortIndex,price,tip,favor) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)", sku_detail_list_obj);
        log.info("batch commit rest :" + sku_detail_list_obj.size());
        sku_detail_list_obj.clear();
        log.info("channel_id = [" + this.channel_id + "] end");
    }
}

