/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.utils;

import com.tydic.commodity.utils.SupplierInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.CollectionUtils;

public class DBUtils {
    private static final Integer BATCH_UPDATE_SIZE = 300;

    public static void batchUpdateWithPageation(JdbcTemplate jdbcTemplate, String sql, List<Object[]> parmList) {
        if (!CollectionUtils.isEmpty(parmList)) {
            List<List<Object[]>> lists = DBUtils.averageAssign(parmList, BATCH_UPDATE_SIZE);
            for (List<Object[]> splitParmList : lists) {
                jdbcTemplate.batchUpdate(sql, splitParmList);
            }
        }
    }

    public static <T> List<List<T>> averageAssign(List<T> source, int splitItemNum) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        if (source != null && source.size() > 0 && splitItemNum > 0) {
            if (source.size() <= splitItemNum) {
                result.add(source);
            } else {
                int splitNum = source.size() % splitItemNum == 0 ? source.size() / splitItemNum : source.size() / splitItemNum + 1;
                List<T> value = null;
                for (int i = 0; i < splitNum; ++i) {
                    value = i < splitNum - 1 ? source.subList(i * splitItemNum, (i + 1) * splitItemNum) : source.subList(i * splitItemNum, source.size());
                    result.add(value);
                }
            }
        }
        return result;
    }

    public static SupplierInfo getSupplierInfo(JdbcTemplate jdbcTemplate, Long supplierShopId) {
        Map map = jdbcTemplate.queryForMap("select t1.SUPPLIER_ID,t1.SUPPLIER_NAME,t1.SUPPLIER_CODE,t2.SUPPLIER_SHOP_ID,t2.SHOP_NAME from UCC_SUPPLIER t1,UCC_SUPPLIER_SHOP t2 \n  where t1.SUPPLIER_ID = t2.SUPPLIER_ID and t2.SUPPLIER_SHOP_ID=?", new Object[]{supplierShopId});
        SupplierInfo supplierInfo = new SupplierInfo();
        supplierInfo.setSupplierId(Long.parseLong(map.get("SUPPLIER_ID") + ""));
        supplierInfo.setSupplierShopId(Long.parseLong(map.get("SUPPLIER_SHOP_ID") + ""));
        supplierInfo.setShopName(map.get("SHOP_NAME").toString());
        supplierInfo.setSupplierName(map.get("SUPPLIER_NAME").toString());
        supplierInfo.setSupplierCode(map.get("SUPPLIER_CODE").toString());
        return supplierInfo;
    }
}

