/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.service.maintenance.busi.impl;

import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.contract.api.maintenance.bo.ContractSupplierLadderReqBO;
import com.tydic.contract.api.maintenance.bo.ContractSupplierLadderRspBO;
import com.tydic.contract.api.maintenance.service.QryContractSupplierLadderService;
import com.tydic.contract.constant.Constant;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractSupplierLadderMapper;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.ContractSupplierLadderPO;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.api.maintenance.service.QryContractSupplierLadderService"})
public class QryContractSupplierLadderServiceImpl
implements QryContractSupplierLadderService {
    private static final Logger log = LoggerFactory.getLogger(QryContractSupplierLadderServiceImpl.class);
    @Autowired
    private ContractSupplierLadderMapper contractSupplierLadderMapper;
    @Autowired
    private ContractInfoMapper contractInfoMapper;

    @PostMapping(value={"selectContractSupplierLadderList"})
    public RspPage<ContractSupplierLadderRspBO> selectContractSupplierLadderList(@RequestBody ContractSupplierLadderReqBO contractSupplierLadderReqBO) {
        RspPage rspPage = new RspPage();
        try {
            ContractSupplierLadderPO contractSupplierLadderPO = new ContractSupplierLadderPO();
            BeanUtils.copyProperties((Object)contractSupplierLadderReqBO, (Object)contractSupplierLadderPO);
            Page page = new Page(contractSupplierLadderReqBO.getPageNo(), contractSupplierLadderReqBO.getPageSize());
            List<ContractSupplierLadderPO> contractSupplierLadderPOs = this.contractSupplierLadderMapper.selectPageListBySelective(contractSupplierLadderPO, (Page<ContractSupplierLadderPO>)page);
            List contractSupplierLadderRspBOs = contractSupplierLadderPOs.stream().map(contractSupplierLadder -> {
                ContractSupplierLadderRspBO contractSupplierLadderRspBO = new ContractSupplierLadderRspBO();
                BeanUtils.copyProperties((Object)contractSupplierLadder, (Object)contractSupplierLadderRspBO);
                Integer rateFee = contractSupplierLadder.getRateFee();
                DecimalFormat df = new DecimalFormat("0.00");
                String rateFeeS = df.format((float)rateFee.intValue() / 100.0f);
                contractSupplierLadderRspBO.setRateFee(new BigDecimal(rateFeeS));
                return contractSupplierLadderRspBO;
            }).collect(Collectors.toList());
            rspPage.setPageNo(page.getPageNo());
            rspPage.setRows(contractSupplierLadderRspBOs);
            rspPage.setTotal(page.getTotalPages());
            rspPage.setRecordsTotal(page.getTotalCount());
            rspPage.setCode("0000");
            rspPage.setMessage("\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5e74\u7ec8\u8d39\u7387\u5217\u8868\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u67e5\u8be2\u5e74\u7ec8\u8d39\u7387\u5217\u8868\u5931\u8d25");
        }
        return rspPage;
    }

    @PostMapping(value={"selectContractSupplierLadderListByEnterPurchaserId"})
    public RspPage<ContractSupplierLadderRspBO> selectContractSupplierLadderListByEnterPurchaserId(@RequestBody ContractSupplierLadderReqBO contractSupplierLadderReqBO) {
        RspPage rspPage = new RspPage();
        try {
            if (contractSupplierLadderReqBO.getEnterPurchaserId() == null) {
                throw new ZTBusinessException("\u5165\u9a7b\u5355\u4f4did\u4e0d\u53ef\u4e3a\u7a7a");
            }
            if (contractSupplierLadderReqBO.getCategoryType() == null) {
                throw new ZTBusinessException("\u7c7b\u76ee\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a");
            }
            ContractInfoPO po = new ContractInfoPO();
            BeanUtils.copyProperties((Object)contractSupplierLadderReqBO, (Object)po);
            po.setValidStatus(Constant.VALID_STATUS_YES);
            ContractInfoPO poo = this.contractInfoMapper.selectByEnterPurchaserId(po);
            Long contratcId = null;
            if (poo == null) {
                return rspPage;
            }
            contratcId = poo.getContractId();
            contractSupplierLadderReqBO.setContractId(contratcId);
            ContractSupplierLadderPO contractSupplierLadderPO = new ContractSupplierLadderPO();
            BeanUtils.copyProperties((Object)contractSupplierLadderReqBO, (Object)contractSupplierLadderPO);
            Page page = new Page(contractSupplierLadderReqBO.getPageNo(), contractSupplierLadderReqBO.getPageSize());
            List<ContractSupplierLadderPO> contractSupplierLadderPOs = this.contractSupplierLadderMapper.selectPageListBySelective(contractSupplierLadderPO, (Page<ContractSupplierLadderPO>)page);
            List contractSupplierLadderRspBOs = contractSupplierLadderPOs.stream().map(contractSupplierLadder -> {
                ContractSupplierLadderRspBO contractSupplierLadderRspBO = new ContractSupplierLadderRspBO();
                BeanUtils.copyProperties((Object)contractSupplierLadder, (Object)contractSupplierLadderRspBO);
                Integer rateFee = contractSupplierLadder.getRateFee();
                DecimalFormat df = new DecimalFormat("0.00");
                String rateFeeS = df.format((float)rateFee.intValue() / 100.0f);
                contractSupplierLadderRspBO.setRateFee(new BigDecimal(rateFeeS));
                return contractSupplierLadderRspBO;
            }).collect(Collectors.toList());
            rspPage.setPageNo(page.getPageNo());
            rspPage.setRows(contractSupplierLadderRspBOs);
            rspPage.setTotal(page.getTotalPages());
            rspPage.setRecordsTotal(page.getTotalCount());
            rspPage.setCode("0000");
            rspPage.setMessage("\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5e74\u7ec8\u8d39\u7387\u5217\u8868\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u67e5\u8be2\u5e74\u7ec8\u8d39\u7387\u5217\u8868\u5931\u8d25");
        }
        return rspPage;
    }
}

