/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.service.supplier.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.api.order.bo.ContractAccessoryReqBO;
import com.tydic.contract.api.supplier.bo.ContractSupplierCreateReqBO;
import com.tydic.contract.api.supplier.bo.ContractSupplierCreateRspBO;
import com.tydic.contract.api.supplier.bo.ContractSupplierLadderListReqBO;
import com.tydic.contract.api.supplier.bo.ContractSupplierSaleListReqBO;
import com.tydic.contract.api.supplier.service.ContractSupplierCreateService;
import com.tydic.contract.constant.Constant;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractSupplierLadderMapper;
import com.tydic.contract.dao.ContractSupplierSaleMapper;
import com.tydic.contract.dao.ContractTaskHisMapper;
import com.tydic.contract.dao.ContractTermsMapper;
import com.tydic.contract.po.ContractAccessoryPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.ContractSupplierLadderPO;
import com.tydic.contract.po.ContractSupplierSalePO;
import com.tydic.contract.po.ContractTaskHisPO;
import com.tydic.contract.po.ContractTermsPO;
import java.math.BigDecimal;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.api.supplier.service.ContractSupplierCreateService"})
public class ContractSupplierCreateServiceImpl
implements ContractSupplierCreateService {
    private static final Logger log = LoggerFactory.getLogger(ContractSupplierCreateServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractAccessoryMapper contractAccessoryMapper;
    @Autowired
    private ContractSupplierSaleMapper contractSupplierSaleMapper;
    @Autowired
    private ContractSupplierLadderMapper contractSupplierLadderMapper;
    @Autowired
    private ContractTermsMapper contractTermsMapper;
    @Autowired
    private ContractTaskHisMapper contractTaskHisMapper;

    @PostMapping(value={"contractSupplierCreate"})
    public ContractSupplierCreateRspBO contractSupplierCreate(@RequestBody ContractSupplierCreateReqBO contractSupplierCreateReqBO) {
        String contractCode;
        ContractSupplierCreateRspBO contractSupplierCreateRspBO = new ContractSupplierCreateRspBO();
        if (contractSupplierCreateReqBO.getContractId() == null && contractSupplierCreateReqBO.getSaveOrSubmit() == Constant.CONTRACT_SAVE) {
            ContractInfoPO contractInfoPO = new ContractInfoPO();
            contractInfoPO.setValidStatus(Constant.VALID_STATUS_YES);
            contractInfoPO.setSignApplicationCode(contractSupplierCreateReqBO.getSignApplicationCode());
            contractInfoPO.setContractType(contractSupplierCreateReqBO.getContractType());
            int check = this.contractInfoMapper.getCheckBy(contractInfoPO);
            if (check > 1) {
                contractSupplierCreateRspBO.setCode("8888");
                contractSupplierCreateRspBO.setMessage("\u9500\u552e\u5408\u540c\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u521b\u5efa");
                return contractSupplierCreateRspBO;
            }
        }
        if ((contractCode = contractSupplierCreateReqBO.getContractCodeRule() + "-" + contractSupplierCreateReqBO.getContractCodeVar()) != null) {
            ContractInfoPO contractInfoPO = new ContractInfoPO();
            contractInfoPO.setValidStatus(Constant.VALID_STATUS_YES);
            contractInfoPO.setContractCode(contractCode);
            int check = this.contractInfoMapper.getCheckBy(contractInfoPO);
            if (check > 1) {
                contractSupplierCreateRspBO.setCode("7777");
                contractSupplierCreateRspBO.setMessage("\u5165\u9a7b\u5408\u540c\u7f16\u53f7\u5df2\u5b58\u5728");
                return contractSupplierCreateRspBO;
            }
        }
        Long contrantId = Sequence.getInstance().nextId();
        if (contractSupplierCreateReqBO.getSaveOrSubmit() == Constant.CONTRACT_SAVE) {
            ContractInfoPO contractInfoPO = new ContractInfoPO();
            BeanUtils.copyProperties((Object)contractSupplierCreateReqBO, (Object)contractInfoPO);
            contractInfoPO.setContractCode(contractCode);
            contractInfoPO.setContractStatus(Constant.CONTRACT_DRAFT_STATUS);
            contractInfoPO.setValidStatus(Constant.VALID_STATUS_YES);
            contractInfoPO.setCreateTime(new Date());
            log.error("\u5408\u540cId" + contrantId);
            contractInfoPO.setContractId(contrantId);
            contractInfoPO.setSignDate(contractSupplierCreateReqBO.getSignDate());
            contractInfoPO.setEffTime(contractSupplierCreateReqBO.getEffTime());
            ContractTermsPO contractTermsPO = this.contractTermsMapper.selectByPrimaryKey(contractSupplierCreateReqBO.getContractTermId());
            if (contractTermsPO != null) {
                contractInfoPO.setContractTermText(contractTermsPO.getTermText());
            }
            this.contractInfoMapper.insertSelective(contractInfoPO);
            if (contractSupplierCreateReqBO.getContractAccessoryList() != null && contractSupplierCreateReqBO.getContractAccessoryList().size() > 0) {
                for (ContractAccessoryReqBO contractAccessoryReqBO : contractSupplierCreateReqBO.getContractAccessoryList()) {
                    ContractAccessoryPO contractAccessoryPO = new ContractAccessoryPO();
                    contractAccessoryPO.setAcceessoryName(contractAccessoryReqBO.getAcceessoryName());
                    contractAccessoryPO.setAcceessoryUrl(contractAccessoryReqBO.getAcceessoryUrl());
                    contractAccessoryPO.setContractId(contrantId);
                    contractAccessoryPO.setContractType(contractSupplierCreateReqBO.getContractType());
                    contractAccessoryPO.setCreateTime(new Date());
                    contractAccessoryPO.setValidStatus(Constant.VALID_STATUS_YES);
                    this.contractAccessoryMapper.insertSelective(contractAccessoryPO);
                }
            }
            if (contractSupplierCreateReqBO.getContractSupplierSaleReqBO() != null && contractSupplierCreateReqBO.getContractSupplierSaleReqBO().getContractSupplierSaleListReqBOList() != null && contractSupplierCreateReqBO.getContractSupplierSaleReqBO().getContractSupplierSaleListReqBOList().size() > 0) {
                for (ContractSupplierSaleListReqBO contractSupplierSaleListReqBO : contractSupplierCreateReqBO.getContractSupplierSaleReqBO().getContractSupplierSaleListReqBOList()) {
                    ContractSupplierSalePO contractSupplierSalePO = new ContractSupplierSalePO();
                    BeanUtils.copyProperties((Object)contractSupplierSaleListReqBO, (Object)contractSupplierSalePO);
                    if (contractSupplierSaleListReqBO.getRateFee() != null) {
                        contractSupplierSalePO.setRateFee(contractSupplierSaleListReqBO.getRateFee().multiply(new BigDecimal(100)).intValue());
                    }
                    contractSupplierSalePO.setIsServiceFee(contractSupplierCreateReqBO.getContractSupplierSaleReqBO().getIsServiceFee());
                    contractSupplierSalePO.setValidStatus(Constant.VALID_STATUS_YES);
                    contractSupplierSalePO.setContractId(contrantId);
                    this.contractSupplierSaleMapper.insertSelective(contractSupplierSalePO);
                }
            }
            if (contractSupplierCreateReqBO.getContractSupplierLadderReqBO() != null && contractSupplierCreateReqBO.getContractSupplierLadderReqBO().getContractSupplierLadderListReqBOList() != null && contractSupplierCreateReqBO.getContractSupplierLadderReqBO().getContractSupplierLadderListReqBOList().size() > 0) {
                for (ContractSupplierLadderListReqBO contractSupplierLadderListReqBO : contractSupplierCreateReqBO.getContractSupplierLadderReqBO().getContractSupplierLadderListReqBOList()) {
                    ContractSupplierLadderPO contractSupplierLadderPO = new ContractSupplierLadderPO();
                    BeanUtils.copyProperties((Object)contractSupplierLadderListReqBO, (Object)contractSupplierLadderPO);
                    if (contractSupplierLadderListReqBO.getRateFee() != null) {
                        contractSupplierLadderPO.setRateFee(contractSupplierLadderListReqBO.getRateFee().multiply(new BigDecimal(100)).intValue());
                    }
                    contractSupplierLadderPO.setIsServiceFee(contractSupplierCreateReqBO.getContractSupplierLadderReqBO().getIsServiceFee());
                    contractSupplierLadderPO.setValidStatus(Constant.VALID_STATUS_YES);
                    contractSupplierLadderPO.setContractId(contrantId);
                    this.contractSupplierLadderMapper.insertSelective(contractSupplierLadderPO);
                }
            }
            ContractTaskHisPO contractTaskHisPO = new ContractTaskHisPO();
            contractTaskHisPO.setContractId(contrantId);
            contractTaskHisPO.setOperName(contractSupplierCreateReqBO.getUsername());
            contractTaskHisPO.setOperId(contractSupplierCreateReqBO.getUserId());
            contractTaskHisPO.setArrivalTime(new Date());
            contractTaskHisPO.setOperateTime(new Date());
            contractTaskHisPO.setBusiStep(Constant.CONTRACT_STEP_CREATE);
            contractTaskHisPO.setBusiStepName("\u521b\u5efa\u8349\u7a3f");
            contractTaskHisPO.setOperateBehavior("\u521b\u5efa\u8349\u7a3f");
            contractTaskHisPO.setRoleName(contractSupplierCreateReqBO.getName());
            contractTaskHisPO.setOperOrgName(contractSupplierCreateReqBO.getOrgName());
            this.contractTaskHisMapper.insertSelective(contractTaskHisPO);
        } else if (contractSupplierCreateReqBO.getSaveOrSubmit() == Constant.CONTRACT_SUBMIT) {
            // empty if block
        }
        contractSupplierCreateRspBO.setContractId(contrantId);
        contractSupplierCreateRspBO.setContractCode(contractCode);
        contractSupplierCreateRspBO.setCode("0000");
        contractSupplierCreateRspBO.setMessage("0000");
        return contractSupplierCreateRspBO;
    }
}

