/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.service.order.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.api.agreement.bo.ContractOrderInfoItemReqBO;
import com.tydic.contract.api.order.bo.ContractAccessoryReqBO;
import com.tydic.contract.api.order.bo.ContractOrderCreateReqBO;
import com.tydic.contract.api.order.bo.ContractOrderCreateRspBO;
import com.tydic.contract.api.order.service.ContractOrderCreateService;
import com.tydic.contract.constant.Constant;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractTaskHisMapper;
import com.tydic.contract.dao.ContractTermsMapper;
import com.tydic.contract.po.ContractAccessoryPO;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.ContractTaskHisPO;
import com.tydic.contract.po.ContractTermsPO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.api.order.service.ContractOrderCreateService"})
public class ContractOrderCreateServiceImpl
implements ContractOrderCreateService {
    private static final Logger log = LoggerFactory.getLogger(ContractOrderCreateServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractAccessoryMapper contractAccessoryMapper;
    @Autowired
    private ContractTermsMapper contractTermsMapper;
    @Autowired
    private ContractTaskHisMapper contractTaskHisMapper;
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;

    @PostMapping(value={"contractOrderCreate"})
    public ContractOrderCreateRspBO contractOrderCreate(@RequestBody ContractOrderCreateReqBO contractOrderCreateReqBO) {
        String contractCode;
        ContractOrderCreateRspBO contractOrderCreateRspBO = new ContractOrderCreateRspBO();
        if (contractOrderCreateReqBO.getContractId() == null && contractOrderCreateReqBO.getSaveOrSubmit() == Constant.CONTRACT_SAVE) {
            ContractInfoPO contractInfoPO = new ContractInfoPO();
            contractInfoPO.setSaleOrderId(contractOrderCreateReqBO.getSaleOrderId());
            contractInfoPO.setValidStatus(Constant.VALID_STATUS_YES);
            contractInfoPO.setContractType(contractOrderCreateReqBO.getContractType());
            int check = this.contractInfoMapper.getCheckBy(contractInfoPO);
            if (check > 0) {
                contractOrderCreateRspBO.setCode("8888");
                contractOrderCreateRspBO.setMessage("\u9500\u552e\u5408\u540c\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u521b\u5efa");
                return contractOrderCreateRspBO;
            }
        }
        if ((contractCode = contractOrderCreateReqBO.getContractCodeRule() + "-" + contractOrderCreateReqBO.getContractCodeVar()) != null) {
            ContractInfoPO contractInfoPO = new ContractInfoPO();
            contractInfoPO.setValidStatus(Constant.VALID_STATUS_YES);
            contractInfoPO.setContractCode(contractCode);
            int check = this.contractInfoMapper.getCheckBy(contractInfoPO);
            if (check > 1) {
                contractOrderCreateRspBO.setCode("7777");
                contractOrderCreateRspBO.setMessage("\u91c7\u8d2d\u8ba2\u5355\u5408\u540c\u7f16\u53f7\u5df2\u5b58\u5728");
                return contractOrderCreateRspBO;
            }
        }
        Long contrantId = Sequence.getInstance().nextId();
        if (contractOrderCreateReqBO.getSaveOrSubmit() == Constant.CONTRACT_SAVE) {
            ContractInfoPO contractInfoPO = new ContractInfoPO();
            BeanUtils.copyProperties((Object)contractOrderCreateReqBO, (Object)contractInfoPO);
            contractInfoPO.setContractCode(contractCode);
            contractInfoPO.setSaleOrderCode(contractOrderCreateReqBO.getSaleOrderCode());
            contractInfoPO.setContractStatus(Constant.CONTRACT_DRAFT_STATUS);
            contractInfoPO.setValidStatus(Constant.VALID_STATUS_YES);
            contractInfoPO.setCreateTime(new Date());
            log.error("\u5408\u540cId" + contrantId);
            contractInfoPO.setContractId(contrantId);
            contractInfoPO.setSupplierId(Long.parseLong(contractOrderCreateReqBO.getSupplierId()));
            contractInfoPO.setUpdateTime(new Date());
            contractInfoPO.setUpdateUserId(contractOrderCreateReqBO.getUserId());
            contractInfoPO.setUpdateUserName(contractOrderCreateReqBO.getName());
            ContractTermsPO contractTermsPO = this.contractTermsMapper.selectByPrimaryKey(contractOrderCreateReqBO.getContractTermId());
            if (contractTermsPO != null) {
                contractInfoPO.setContractTermText(contractTermsPO.getTermText());
            }
            this.contractInfoMapper.insertSelective(contractInfoPO);
            for (ContractOrderInfoItemReqBO contractOrderInfoItem : contractOrderCreateReqBO.getContractOrderItemList()) {
                ContractInfoItemPO contractInfoItemPO = new ContractInfoItemPO();
                BeanUtils.copyProperties((Object)contractOrderInfoItem, (Object)contractInfoItemPO);
                contractInfoItemPO.setContractCode(contractCode);
                contractInfoItemPO.setCreateTime(new Date());
                contractInfoItemPO.setValidDate(Constant.VALID_STATUS_YES);
                contractInfoItemPO.setContractId(contrantId);
                this.contractInfoItemMapper.insertSelective(contractInfoItemPO);
            }
            for (ContractAccessoryReqBO contractAccessoryReqBO : contractOrderCreateReqBO.getContractAccessoryList()) {
                ContractAccessoryPO contractAccessoryPO = new ContractAccessoryPO();
                contractAccessoryPO.setAcceessoryName(contractAccessoryReqBO.getAcceessoryName());
                contractAccessoryPO.setContractId(contrantId);
                contractAccessoryPO.setContractType(contractOrderCreateReqBO.getContractType());
                contractAccessoryPO.setCreateTime(new Date());
                contractAccessoryPO.setAcceessoryUrl(contractAccessoryReqBO.getAcceessoryUrl());
                contractAccessoryPO.setValidStatus(Constant.VALID_STATUS_YES);
                this.contractAccessoryMapper.insertSelective(contractAccessoryPO);
            }
            ContractTaskHisPO contractTaskHisPO = new ContractTaskHisPO();
            contractTaskHisPO.setContractId(contractOrderCreateReqBO.getContractId());
            contractTaskHisPO.setOperName(contractOrderCreateReqBO.getName());
            contractTaskHisPO.setOperId(contractOrderCreateReqBO.getUserId());
            contractTaskHisPO.setOperOrgName(contractOrderCreateReqBO.getOrgName());
            contractTaskHisPO.setOperOrgId(contractOrderCreateReqBO.getOrgId());
            contractTaskHisPO.setArrivalTime(new Date());
            contractTaskHisPO.setOperateTime(new Date());
            contractTaskHisPO.setBusiStep(Constant.CONTRACT_STEP_CREATE);
            contractTaskHisPO.setBusiStepName("\u521b\u5efa\u8349\u7a3f");
            contractTaskHisPO.setRemark(contractOrderCreateReqBO.getRemark());
            contractTaskHisPO.setOperateBehavior("\u521b\u5efa\u8349\u7a3f");
            contractTaskHisPO.setRoleName("\u5408\u540c\u7ba1\u7406");
            this.contractTaskHisMapper.insertSelective(contractTaskHisPO);
        } else if (contractOrderCreateReqBO.getSaveOrSubmit() == Constant.CONTRACT_SUBMIT) {
            // empty if block
        }
        contractOrderCreateRspBO.setContractId(contrantId);
        contractOrderCreateRspBO.setContractCode(contractCode);
        contractOrderCreateRspBO.setCode("0000");
        contractOrderCreateRspBO.setMessage("0000");
        return contractOrderCreateRspBO;
    }
}

