/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.service.supplier.busi.impl;

import com.tydic.contract.api.supplier.bo.CategoryListBO;
import com.tydic.contract.api.supplier.bo.QueryCategoryIdReqBO;
import com.tydic.contract.api.supplier.bo.QueryCategoryIdRspBO;
import com.tydic.contract.api.supplier.bo.SupplierIdListBO;
import com.tydic.contract.api.supplier.service.QueryCategoryIdService;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractSupplierSaleMapper;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.ContractSupplierSalePO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.api.supplier.service.QueryCategoryIdService"})
public class QueryCategoryIdServiceImpl
implements QueryCategoryIdService {
    private static final Logger log = LoggerFactory.getLogger(QueryCategoryIdServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractSupplierSaleMapper contractSupplierSaleMapper;

    @PostMapping(value={"QueryCategoryId"})
    public QueryCategoryIdRspBO QueryCategoryId(@RequestBody QueryCategoryIdReqBO queryCategoryIdReqBO) {
        QueryCategoryIdRspBO rspBO = new QueryCategoryIdRspBO();
        ArrayList<ContractInfoPO> contractInfoPOS = new ArrayList<ContractInfoPO>();
        for (Object supplierIdListBO : queryCategoryIdReqBO.getSupplierIdListBO()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("enterPurchaserId", supplierIdListBO.getEnterPurchaserId());
            map.put("isStaffWelfare", supplierIdListBO.getIsStaffWelfare());
            List<ContractInfoPO> contractInfoPOList = this.contractInfoMapper.queryContractId(map);
            if (!CollectionUtils.isNotEmpty(contractInfoPOList)) continue;
            for (ContractInfoPO po : contractInfoPOList) {
                contractInfoPOS.add(po);
            }
        }
        if (CollectionUtils.isNotEmpty(contractInfoPOS)) {
            ArrayList<Long> contractIdList = new ArrayList<Long>();
            for (ContractInfoPO contractInfoPO : contractInfoPOS) {
                contractIdList.add(contractInfoPO.getContractId());
            }
            List<ContractSupplierSalePO> contractSupplierSalePOList = this.contractSupplierSaleMapper.queryByContractId(contractIdList);
            if (CollectionUtils.isNotEmpty(contractSupplierSalePOList)) {
                ArrayList<CategoryListBO> categoryListBOList = new ArrayList<CategoryListBO>();
                CategoryListBO categoryListBO = new CategoryListBO();
                ArrayList<SupplierIdListBO> listBOS = new ArrayList<SupplierIdListBO>();
                for (SupplierIdListBO listBO : queryCategoryIdReqBO.getSupplierIdListBO()) {
                    SupplierIdListBO supplierIdListBO = new SupplierIdListBO();
                    BeanUtils.copyProperties((Object)listBO, (Object)supplierIdListBO);
                    listBOS.add(supplierIdListBO);
                }
                for (ContractSupplierSalePO salePO : contractSupplierSalePOList) {
                    BeanUtils.copyProperties((Object)salePO, (Object)categoryListBO);
                    categoryListBO.setSupplierIdlList(listBOS);
                    categoryListBOList.add(categoryListBO);
                }
                rspBO.setCategoryList(categoryListBOList);
            }
        }
        rspBO.setCode("0000");
        rspBO.setMessage("\u6210\u529f");
        return rspBO;
    }
}

