/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.service.template.busi.impl;

import com.tydic.contract.api.template.bo.ContractTermsDetailRspBO;
import com.tydic.contract.api.template.bo.ContractTermsReqBO;
import com.tydic.contract.api.template.service.QueryContractTermsDetailService;
import com.tydic.contract.dao.ContractTermVarsMapper;
import com.tydic.contract.dao.ContractTermsMapper;
import com.tydic.contract.po.ContractTermVarsPO;
import com.tydic.contract.po.ContractTermsPO;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.api.template.service.QueryContractTermsDetailService"})
public class QueryContractTermsDetailServiceImpl
implements QueryContractTermsDetailService {
    private static final Logger log = LoggerFactory.getLogger(QueryContractTermsDetailServiceImpl.class);
    @Resource
    private ContractTermsMapper contractTermsMapper;
    @Resource
    private ContractTermVarsMapper contractTermVarsMapper;

    @PostMapping(value={"queryTermsDetail"})
    public ContractTermsDetailRspBO queryTermsDetail(@RequestBody ContractTermsReqBO reqBO) {
        ContractTermsDetailRspBO rspBO = new ContractTermsDetailRspBO();
        try {
            ContractTermsPO po = this.contractTermsMapper.selectByPrimaryKey(reqBO.getContractTermId());
            if (null != po) {
                Pattern p;
                BeanUtils.copyProperties((Object)po, (Object)rspBO);
                String termText = po.getTermText();
                ArrayList<String> varCodes = new ArrayList<String>();
                if (termText != null && (p = Pattern.compile("\\$\\{(.*?)}")) != null) {
                    Matcher matcher = p.matcher(termText);
                    while (matcher.find()) {
                        String varCode = matcher.group();
                        varCodes.add(varCode);
                    }
                }
                ArrayList<String> varNames = new ArrayList<String>();
                if (null != varCodes && varCodes.size() > 0) {
                    ContractTermVarsPO record = new ContractTermVarsPO();
                    Integer termType = po.getTermType();
                    if (null != termType) {
                        record.setTermType(termType);
                    }
                    for (String varCode : varCodes) {
                        record.setVarCode(varCode);
                        List<ContractTermVarsPO> list = this.contractTermVarsMapper.select(record);
                        if (null == list || list.size() <= 0) continue;
                        String varName = null;
                        for (ContractTermVarsPO po1 : list) {
                            varName = po1.getVarName();
                            if (null == varName) continue;
                            varNames.add(varName);
                        }
                    }
                }
                rspBO.setVarNames(varNames);
                rspBO.setVarCodes(varCodes);
                rspBO.setCode("0000");
                rspBO.setMessage("\u67e5\u8be2\u5408\u540c\u6a21\u677f\u8be6\u60c5\u6210\u529f\uff01");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            rspBO.setCode("8888");
            rspBO.setMessage("\u67e5\u8be2\u5408\u540c\u6a21\u677f\u8be6\u60c5\u5931\u8d25\uff01");
        }
        return rspBO;
    }
}

